/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.bullet;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import omaloon.entities.bullet.FallingBulletType;

public class HailStoneBulletType
extends FallingBulletType {
    public TextureRegion[] variantsRegion;
    public int variants;

    public HailStoneBulletType(String sprite, int variants) {
        super(sprite);
        this.variants = variants;
        this.lightRadius = 0.0f;
        this.layer = 115.0f;
    }

    @Override
    public void init(Bullet b) {
        super.init(b);
        b.data = new HailStoneData(this.getRegion(b), this.fallTime);
    }

    @Override
    public void load() {
        this.variantsRegion = new TextureRegion[this.variants];
        for (int i = 0; i < this.variants; ++i) {
            this.variantsRegion[i] = Core.atlas.find(this.sprite + "-" + i);
        }
    }

    @Override
    public void draw(Bullet b) {
        Draw.alpha((float)255.0f);
        this.drawTrail(b);
        Object object = b.data;
        if (object instanceof HailStoneData) {
            HailStoneData data = (HailStoneData)object;
            this.drawFalling(b, data.region, this.regionColor);
        }
    }

    public void despawned(Bullet b) {
        if (this.despawnHit) {
            this.hit(b);
        } else {
            this.createUnits(b, b.x, b.y);
        }
        if (!this.fragOnHit) {
            this.createFrags(b, b.x, b.y);
        }
        if (!b.absorbed) {
            this.despawnEffect.at(b.x, b.y, b.rotation(), this.hitColor, b.data);
        }
        if (!b.absorbed) {
            this.despawnSound.at((Position)b);
        }
        Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
    }

    public TextureRegion getRegion(Bullet b) {
        return this.variantsRegion[Mathf.floor((float)(Mathf.randomSeed((long)b.id) * (float)(this.variants - 1)))];
    }

    public void hit(Bullet b, float x, float y) {
        if (!b.absorbed) {
            this.hitEffect.at(x, y, b.rotation(), this.hitColor);
        }
        if (!b.absorbed) {
            this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        }
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (this.fragOnHit) {
            this.createFrags(b, x, y);
        }
        this.createPuddles(b, x, y);
        this.createIncend(b, x, y);
        this.createUnits(b, x, y);
        if (this.suppressionRange > 0.0f) {
            Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
        }
        this.createSplashDamage(b, x, y);
        for (int i = 0; i < this.lightning; ++i) {
            Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
        }
    }

    public static class HailStoneData {
        public TextureRegion region;
        public float fallTime;

        public HailStoneData(TextureRegion region, float fallTime) {
            this.region = region;
            this.fallTime = fallTime;
        }
    }
}

