/*
 * Decompiled with CFR 0.152.
 */
package omaloon.entities.abilities;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.util.concurrent.atomic.AtomicBoolean;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import omaloon.OmaloonMod;

public class HailShieldAbility
extends Ability {
    public float x;
    public float y;
    public float radius = -1.0f;
    public float regen = 0.1f;
    public float regenBroken = 1.0f;
    public float maxHealth = 100.0f;
    public boolean parentizeEffect = true;
    public float layerOffset = 0.0f;
    public Effect hitEffect = Fx.none;
    public Effect breakEffect = Fx.none;
    public Effect regenEffect = Fx.none;
    public Sound hitSound = Sounds.none;
    public float hitSoundVolume = 1.0f;
    public Color barColor = Pal.heal;
    public Color hitColor = Color.white;
    protected float shieldVisibleTime = 0.0f;
    public float shieldVisibleDuration = 10.0f;
    protected float damage;
    protected boolean broken;

    public void addStats(Table t) {
        t.add((CharSequence)("[lightgray]" + Stat.health.localized() + ": [white]" + Math.round(this.maxHealth))).row();
        t.add((CharSequence)("[lightgray]" + Stat.range.localized() + ": [white]" + Strings.autoFixed((float)(this.radius / 8.0f), (int)2) + " " + StatUnit.blocks.localized())).row();
        t.add((CharSequence)("[lightgray]" + Stat.repairSpeed.localized() + ": [white]" + Strings.autoFixed((float)(this.regen * 60.0f), (int)2) + StatUnit.perSecond.localized())).row();
        t.add((CharSequence)("[lightgray]" + Stat.cooldownTime.localized() + ": [white]" + Strings.autoFixed((float)(this.maxHealth / this.regenBroken / 60.0f), (int)2) + " " + StatUnit.seconds.localized())).row();
    }

    public void displayBars(Unit unit, Table bars) {
        bars.add((Element)new Bar("bar.hail-shield-health", this.barColor, () -> 1.0f - this.damage / this.maxHealth).blink(Color.white));
    }

    public void init(UnitType type) {
        if (this.radius == -1.0f) {
            this.radius = type.hitSize * 1.3f;
        }
    }

    public void draw(Unit unit) {
        if (this.broken) {
            return;
        }
        float alpha = Mathf.clamp((float)(this.shieldVisibleTime / this.shieldVisibleDuration));
        if (alpha > 0.001f) {
            Fill.light((float)(unit.x + this.x), (float)(unit.y + this.y), (int)Lines.circleVertices((float)this.radius), (float)this.radius, (Color)Color.clear, (Color)Tmp.c2.set(Pal.heal).lerp(Color.white, Mathf.clamp((float)(unit.hitTime() / 2.0f))).a(0.7f * alpha));
        }
    }

    public void update(Unit unit) {
        float dx = unit.x + this.x;
        float dy = unit.y + this.y;
        if (this.broken) {
            if (this.damage > 0.0f) {
                this.damage -= Time.delta * this.regenBroken;
            } else {
                this.broken = false;
                this.regenEffect.at(dx, dy);
            }
        } else {
            if (this.damage > 0.0f) {
                this.damage -= Time.delta * this.regen;
            }
            AtomicBoolean wasHit = new AtomicBoolean(false);
            Groups.bullet.intersect(unit.x + this.x - this.radius - OmaloonMod.shieldBuffer, unit.y + this.y - this.radius - OmaloonMod.shieldBuffer, (this.radius + OmaloonMod.shieldBuffer) * 2.0f, (this.radius + OmaloonMod.shieldBuffer) * 2.0f, b -> {
                if (b.team == Team.derelict && Mathf.dst((float)(unit.x + this.x), (float)(unit.y + this.y), (float)b.x, (float)b.y) <= this.radius + b.type.splashDamageRadius) {
                    b.absorb();
                    if (this.parentizeEffect) {
                        this.hitEffect.at(dx, dy, b.hitSize, this.hitColor);
                        this.hitSound.at(dx, dy, Mathf.random((float)0.9f, (float)1.1f), this.hitSoundVolume);
                    } else {
                        this.hitEffect.at(b.x, b.y, b.hitSize, this.hitColor);
                        this.hitSound.at(b.x, b.y, Mathf.random((float)0.9f, (float)1.1f), this.hitSoundVolume);
                    }
                    this.damage += b.damage;
                    wasHit.set(true);
                    if (this.damage > this.maxHealth) {
                        this.broken = true;
                        this.breakEffect.at(dx, dy, b.hitSize, (Object)unit);
                    }
                }
            });
            this.shieldVisibleTime = wasHit.get() ? this.shieldVisibleDuration : Math.max(0.0f, this.shieldVisibleTime - Time.delta);
        }
    }
}

