/*
 * Decompiled with CFR 0.152.
 */
package omaloon.core;

import arc.ApplicationCore;
import arc.ApplicationListener;
import arc.Core;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.core.Platform;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.meta.BuildVisibility;
import omaloon.content.OlFx;
import omaloon.content.OlPlanets;

public class SafeClearer
implements ApplicationListener {
    public static final Seq<Building> invalidBuilds = new Seq();

    public SafeClearer() {
        Platform platform = Vars.platform;
        if (platform instanceof ApplicationCore) {
            ApplicationCore core = (ApplicationCore)platform;
            core.add((ApplicationListener)this);
        }
    }

    public boolean enabled() {
        return Core.settings.getBool("omaloon-enable-soft-cleaner", true);
    }

    public void update() {
        if (this.enabled()) {
            invalidBuilds.clear();
            if (Vars.state.isCampaign() && Vars.state.getPlanet().solarSystem == OlPlanets.omaloon) {
                Block out = (Block)Vars.content.blocks().find(block -> {
                    boolean omaloonOnly = block.minfo.mod != null && block.minfo.mod.name.equals("omaloon");
                    boolean sandboxOnly = block.buildVisibility == BuildVisibility.sandboxOnly || block.buildVisibility == BuildVisibility.editorOnly;
                    boolean empty = Vars.player.team().data().getBuildings(block).isEmpty();
                    return !omaloonOnly && !sandboxOnly && !empty && !(block instanceof ConstructBlock);
                });
                if (out != null) {
                    invalidBuilds.add(Vars.player.team().data().getBuildings(out));
                }
                invalidBuilds.removeAll(b -> b instanceof ConstructBlock.ConstructBuild);
            }
            if (!invalidBuilds.isEmpty()) {
                invalidBuilds.each(build -> {
                    OlFx.stealInvalid.at(build.x, build.y, 0.0f, (Object)build.block);
                    build.tile.setAir();
                });
            }
        }
    }
}

