/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content.blocks;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Interp;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.Weapon;
import mindustry.type.unit.MissileUnitType;
import mindustry.world.Block;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.draw.DrawTurret;
import mindustry.world.meta.BuildVisibility;
import omaloon.content.OlFx;
import omaloon.content.OlItems;
import omaloon.content.OlSounds;
import omaloon.world.blocks.defense.BlastTower;
import omaloon.world.blocks.defense.ConsumeTurret;
import omaloon.world.blocks.defense.RepairProjector;
import omaloon.world.blocks.defense.Shelter;
import omaloon.world.consumers.ConsumePressure;
import omaloon.world.consumers.PressureEfficiencyRange;

public class OlDefenceBlocks {
    public static Block repairer;
    public static Block smallShelter;
    public static Block apex;
    public static Block convergence;
    public static Block blast;
    public static Block javelin;
    public static Block carborundumWall;
    public static Block carborundumWallLarge;
    public static Block end;

    public static void load() {
        repairer = new RepairProjector("repairer"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{OlItems.carborundum, 10, Items.beryllium, 15, Items.graphite, 3}));
                this.researchCostMultiplier = 0.6f;
                this.consumePower(0.2f);
                this.size = 1;
                this.range = 34.0f;
                this.healAmount = 1.6f;
                this.health = 80;
            }
        };
        smallShelter = new Shelter("small-shelter"){
            {
                this.requirements(Category.effect, ItemStack.with((Object[])new Object[]{OlItems.cobalt, 25, Items.beryllium, 30}));
                this.researchCostMultiplier = 0.3f;
                this.size = 2;
                this.rechargeStandard = 2.0f;
                this.shieldHealth = 260.0f;
                this.shieldRange = 170.0f;
                this.ambientSound = OlSounds.shelter;
                this.ambientSoundVolume = 0.08f;
                this.consumePower(0.2f);
                this.consume(new ConsumePressure(0.01f, true));
                this.consume(new PressureEfficiencyRange(15.0f, 50.0f, 1.8f, false));
            }
        };
        apex = new ItemTurret("apex"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{OlItems.carborundum, 10, OlItems.cobalt, 20}));
                this.outlineColor = Color.valueOf((String)"2f2f36");
                this.ammo(new Object[]{OlItems.cobalt, new BasicBulletType(2.5f, 9.0f){
                    {
                        super(arg0, arg1);
                        this.width = 7.0f;
                        this.height = 7.0f;
                        this.lifetime = 25.0f;
                        this.ammoMultiplier = 3.0f;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.hitEffect = Fx.hitBulletColor;
                        this.hitColor = OlItems.cobalt.color;
                        this.trailWidth = 1.3f;
                        this.trailLength = 10;
                        this.trailColor = OlItems.cobalt.color;
                        this.backColor = OlItems.cobalt.color;
                        this.fragBullet = new BasicBulletType(2.5f, 2.5f){
                            {
                                super(arg0, arg1);
                                this.width = 4.0f;
                                this.height = 4.0f;
                                this.lifetime = 15.0f;
                                this.despawnEffect = Fx.none;
                                this.hitEffect = Fx.none;
                                this.hitColor = OlItems.cobalt.color;
                                this.trailWidth = 0.8f;
                                this.trailLength = 10;
                                this.trailColor = OlItems.cobalt.color;
                                this.backColor = OlItems.cobalt.color;
                            }
                        };
                        this.fragOnHit = true;
                        this.fragBullets = 4;
                        this.fragRandomSpread = 45.0f;
                        this.fragVelocityMin = 0.7f;
                    }
                }, Items.graphite, new BasicBulletType(4.0f, 16.0f){
                    {
                        super(arg0, arg1);
                        this.width = 7.0f;
                        this.height = 7.0f;
                        this.lifetime = 25.0f;
                        this.ammoMultiplier = 2.0f;
                        this.reloadMultiplier = 1.13f;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.hitEffect = Fx.hitBulletColor;
                        this.hitColor = Items.graphite.color;
                        this.trailWidth = 1.3f;
                        this.trailLength = 3;
                        this.trailColor = Items.graphite.color;
                        this.backColor = Items.graphite.color;
                        this.knockback = 0.8f;
                    }
                }});
                this.shootY = 0.0f;
                this.shootSound = OlSounds.theShoot;
                this.drawer = new DrawTurret("gl-");
                this.reload = 30.0f;
                this.range = 100.0f;
                this.inaccuracy = 2.0f;
                this.rotateSpeed = 10.0f;
            }
        };
        blast = new BlastTower("blast"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{OlItems.carborundum, 25, OlItems.cobalt, 40, Items.beryllium, 40, Items.graphite, 10}));
                this.size = 2;
                this.consumePower(1.1666666f);
                this.consume(new ConsumePressure(-6.0f, false));
                this.consume(new PressureEfficiencyRange(-45.0f, -1.0f, 3.0f, true));
                this.targetGround = true;
                this.targetAir = false;
                this.damage = 0.6f;
                this.status = StatusEffects.slow;
                this.statusDuration = 30.0f;
                this.range = 70.0f;
                this.chargeTime = 120.0f;
                this.reload = 120.0f;
                this.shake = 3.0f;
            }
        };
        convergence = new PowerTurret("convergence"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{OlItems.carborundum, 20, OlItems.cobalt, 15, Items.beryllium, 20}));
                this.consumePower(0.2f);
                this.outlineColor = Color.valueOf((String)"2f2f36");
                this.size = 1;
                this.range = 185.0f;
                this.shootCone = 45.0f;
                this.reload = 50.0f;
                this.targetGround = false;
                this.shootSound = OlSounds.convergence;
                this.drawer = new DrawTurret("gl-");
                this.shootType = new BasicBulletType(2.5f, 18.0f, "omaloon-orb"){
                    {
                        super(arg0, arg1, arg2);
                        this.hitEffect = Fx.hitBulletColor;
                        this.despawnEffect = Fx.hitBulletColor;
                        this.lifetime = 73.0f;
                        this.collidesGround = false;
                        this.collidesAir = true;
                        this.shrinkY = 0.0f;
                        this.shrinkX = 0.0f;
                        this.height = 5.0f;
                        this.homingDelay = 1.0f;
                        this.homingPower = 0.2f;
                        this.homingRange = 120.0f;
                        this.backColor = Color.valueOf((String)"8ca9e8");
                        this.frontColor = Color.valueOf((String)"d1efff");
                        this.trailWidth = 2.5f;
                        this.trailLength = 4;
                        this.trailColor = Color.valueOf((String)"8ca9e8");
                    }

                    public void draw(Bullet b) {
                        int j;
                        super.draw(b);
                        this.drawTrail(b);
                        int sides = 4;
                        float radius = 0.0f;
                        float radiusTo = 15.0f;
                        float stroke = 3.0f;
                        float innerScl = 0.5f;
                        float innerRadScl = 0.33f;
                        Color color1 = Color.valueOf((String)"8ca9e8");
                        Color color2 = Color.valueOf((String)"d1efff");
                        float progress = b.fslope();
                        float rotation = 45.0f;
                        float layer = 110.0f;
                        float z = Draw.z();
                        Draw.z((float)layer);
                        float rx = b.x;
                        float ry = b.y;
                        float rad = Mathf.lerp((float)radius, (float)radiusTo, (float)progress);
                        Draw.color((Color)color1);
                        for (j = 0; j < sides; ++j) {
                            Drawf.tri((float)rx, (float)ry, (float)stroke, (float)rad, (float)((float)j * 360.0f / (float)sides + rotation));
                        }
                        Draw.color((Color)color2);
                        for (j = 0; j < sides; ++j) {
                            Drawf.tri((float)rx, (float)ry, (float)(stroke * innerScl), (float)(rad * innerRadScl), (float)((float)j * 360.0f / (float)sides + rotation));
                        }
                        Draw.color();
                        Draw.z((float)z);
                    }
                };
            }
        };
        javelin = new ConsumeTurret("javelin"){
            {
                this.requirements(Category.turret, BuildVisibility.sandboxOnly, ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Color.valueOf((String)"2f2f36");
                this.size = 2;
                this.reload = 270.0f;
                this.minRange = 64.0f;
                this.range = this.minRange + 441.59998f;
                this.minRangeShoot = false;
                this.targetUnderBlocks = false;
                this.targetAir = false;
                this.drawer = new DrawTurret("gl-"){
                    {
                        super(arg0);
                        this.parts.add((Object)new RegionPart("-missile"){
                            {
                                super(arg0);
                                this.y = 2.0f;
                                this.progress = DrawPart.PartProgress.smoothReload.curve((Interp)Interp.pow2In);
                                this.colorTo = new Color(1.0f, 1.0f, 1.0f, 0.0f);
                                this.color = Color.white;
                                this.mixColorTo = Pal.accent;
                                this.mixColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
                                this.outline = false;
                                this.under = true;
                                this.layerOffset = -0.01f;
                            }
                        });
                    }
                };
                this.shootSound = OlSounds.theShoot;
                this.consumeItem(Items.coal, 1);
                this.shootType = new BasicBulletType(1.6f, 12.0f, "omaloon-javelin-missile-outlined"){
                    {
                        super(arg0, arg1, arg2);
                        this.lifetime = 40.0f;
                        this.ammoMultiplier = 1.0f;
                        this.collidesGround = false;
                        this.collidesAir = false;
                        this.collides = false;
                        this.shrinkY = 0.0f;
                        this.shrinkX = 0.0f;
                        this.width = 6.5f;
                        this.height = 11.5f;
                        this.shootEffect = OlFx.javelinShoot;
                        this.despawnEffect = OlFx.javelinMissileShoot;
                        this.hitEffect = Fx.none;
                        this.despawnSound = Sounds.missileLarge;
                        this.layer = 49.99f;
                        this.despawnUnit = new MissileUnitType("javelin-missile"){
                            {
                                super(arg0);
                                this.drawCell = false;
                                this.hittable = false;
                                this.speed = 4.6f;
                                this.maxRange = 6.0f;
                                this.lifetime = 96.0f;
                                this.outlineColor = Color.valueOf((String)"2f2f36");
                                this.engineColor = this.trailColor = Pal.redLight;
                                this.engineLayer = 110.0f;
                                this.engineSize = 1.3f;
                                this.engineOffset = 5.0f;
                                this.rotateSpeed = 0.25f;
                                this.trailLength = 18;
                                trailWidth = 0.5f;
                                this.missileAccelTime = 0.0f;
                                this.lowAltitude = true;
                                this.loopSound = Sounds.missileTrail;
                                this.loopSoundVolume = 0.6f;
                                this.deathSound = Sounds.largeExplosion;
                                this.targetAir = false;
                                this.health = 210.0f;
                                this.weapons.add((Object)new Weapon(){
                                    {
                                        this.shootCone = 360.0f;
                                        this.mirror = false;
                                        this.reload = 1.0f;
                                        deathExplosionEffect = Fx.massiveExplosion;
                                        this.shootOnDeath = true;
                                        this.shake = 10.0f;
                                        this.bullet = new ExplosionBulletType(700.0f, 65.0f){
                                            {
                                                super(arg0, arg1);
                                                this.hitColor = Pal.redLight;
                                                this.collidesAir = false;
                                                this.buildingDamageMultiplier = 0.3f;
                                                this.ammoMultiplier = 1.0f;
                                                this.fragLifeMin = 0.1f;
                                                this.fragBullets = 7;
                                                this.fragBullet = new ArtilleryBulletType(3.4f, 32.0f){
                                                    {
                                                        super(arg0, arg1);
                                                        this.buildingDamageMultiplier = 0.3f;
                                                        this.drag = 0.02f;
                                                        this.hitEffect = Fx.massiveExplosion;
                                                        this.despawnEffect = Fx.scatheSlash;
                                                        this.knockback = 0.8f;
                                                        this.lifetime = 23.0f;
                                                        this.height = 18.0f;
                                                        this.width = 18.0f;
                                                        this.collidesTiles = false;
                                                        this.splashDamageRadius = 40.0f;
                                                        this.splashDamage = 80.0f;
                                                        this.trailColor = this.hitColor = Pal.redLight;
                                                        this.backColor = this.hitColor;
                                                        this.frontColor = Color.white;
                                                        this.smokeEffect = Fx.shootBigSmoke2;
                                                        this.despawnShake = 7.0f;
                                                        this.lightRadius = 30.0f;
                                                        this.lightColor = Pal.redLight;
                                                        this.lightOpacity = 0.5f;
                                                        this.trailLength = 10;
                                                        this.trailWidth = 0.5f;
                                                        this.trailEffect = Fx.none;
                                                    }
                                                };
                                            }
                                        };
                                    }
                                });
                            }
                        };
                    }
                };
            }
        };
        final int wallHealthMultiplier = 4;
        carborundumWall = new Wall("carborundum-wall"){
            {
                super(arg0);
                this.requirements(Category.defense, ItemStack.with((Object[])new Object[]{OlItems.carborundum, 6}));
                this.health = 90 * wallHealthMultiplier;
                this.researchCostMultiplier = 0.1f;
            }
        };
        carborundumWallLarge = new Wall("carborundum-wall-large"){
            {
                super(arg0);
                this.requirements(Category.defense, ItemStack.mult((ItemStack[])OlDefenceBlocks.carborundumWall.requirements, (float)4.0f));
                this.health = 360 * wallHealthMultiplier;
                this.size = 2;
                this.researchCostMultiplier = 0.1f;
            }
        };
    }
}

