/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Events;
import arc.audio.Music;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.game.EventType;
import mindustry.gen.Musics;
import omaloon.content.OlPlanets;
import omaloon.content.blocks.OlStorageBlocks;

public class OlMusics {
    private static final ObjectMap<String, Seq<Music>> musicSets = new ObjectMap();
    public static Music launch;
    public static Music land;
    public static Music orbital;
    public static Music glLand;
    public static Music chained;
    public static Music darkPurity;
    public static Music wisdom;
    public static Music space;
    public static Music sundown;
    public static Music fragile;
    public static Music solidFire;
    public static Music soredLuna;
    public static Music buryAlive;
    public static Music chaoticFlames;
    public static Music liquefy;
    public static Music piercingLine;

    public static void load() {
        OlMusics.initializeMusics();
        OlMusics.initializeMusicSets();
        OlMusics.setupEventHandlers();
    }

    private static void initializeMusics() {
        launch = Musics.launch;
        land = Musics.land;
        orbital = OlMusics.loadMusic("orbital");
        glLand = OlMusics.loadMusic("landings/glasmore-land");
        String[] ambientTracks = new String[]{"chained", "darkPurity", "wisdom", "space", "sundown"};
        String[] darkTracks = new String[]{"fragile", "solidFire", "soredLuna"};
        String[] bossTracks = new String[]{"buryAlive", "chaoticFlames", "liquefy", "piercingLine"};
        OlMusics.loadMusicSet("glasmore/ambient/", ambientTracks);
        OlMusics.loadMusicSet("glasmore/dark/", darkTracks);
        OlMusics.loadMusicSet("glasmore/boss/", bossTracks);
    }

    private static void loadMusicSet(String basePath, String[] trackNames) {
        for (String track : trackNames) {
            try {
                Music music = OlMusics.loadMusic(basePath + track);
                OlMusics.class.getField(track).set(null, music);
            }
            catch (Exception e) {
                Log.err((String)("Failed to load music: " + track), (Throwable)e);
            }
        }
    }

    private static void initializeMusicSets() {
        musicSets.put((Object)"vanillaAmbient", (Object)new Seq(Vars.control.sound.ambientMusic));
        musicSets.put((Object)"vanillaDark", (Object)new Seq(Vars.control.sound.darkMusic));
        musicSets.put((Object)"vanillaBoss", (Object)new Seq(Vars.control.sound.bossMusic));
        musicSets.put((Object)"glasmoreAmbient", (Object)Seq.with((Object[])new Music[]{chained, darkPurity, wisdom, space, sundown}));
        musicSets.put((Object)"glasmoreDark", (Object)Seq.with((Object[])new Music[]{fragile, solidFire, soredLuna}));
        musicSets.put((Object)"glasmoreBoss", (Object)Seq.with((Object[])new Music[]{buryAlive, chaoticFlames, liquefy, piercingLine}));
    }

    private static void setupEventHandlers() {
        Events.run((Object)EventType.Trigger.update, OlMusics::updateLaunchMusic);
        Events.on(EventType.WorldLoadEvent.class, e -> {
            OlMusics.updateLandMusic();
            OlMusics.updatePlanetMusic();
        });
    }

    private static void updateLaunchMusic() {
        Musics.launch = Vars.ui.planet.state.planet == OlPlanets.omaloon || Vars.ui.planet.state.planet == OlPlanets.glasmore ? orbital : launch;
    }

    private static void updateLandMusic() {
        Vars.state.rules.defaultTeam.cores().each(core -> {
            Musics.land = core.block == OlStorageBlocks.landingCapsule || core.block == OlStorageBlocks.coreFloe ? glLand : land;
        });
    }

    private static void updatePlanetMusic() {
        if (Vars.state.rules.planet != Planets.sun) {
            String prefix = Vars.state.rules.planet == OlPlanets.glasmore ? "glasmore" : "vanilla";
            OlMusics.setMusicSet(prefix + "Ambient", (Seq<Music>)Vars.control.sound.ambientMusic);
            OlMusics.setMusicSet(prefix + "Dark", (Seq<Music>)Vars.control.sound.darkMusic);
            OlMusics.setMusicSet(prefix + "Boss", (Seq<Music>)Vars.control.sound.bossMusic);
        } else {
            OlMusics.mixMusic();
        }
    }

    private static void mixMusic() {
        OlMusics.mixMusicSets("vanillaAmbient", "glasmoreAmbient", (Seq<Music>)Vars.control.sound.ambientMusic);
        OlMusics.mixMusicSets("vanillaDark", "glasmoreDark", (Seq<Music>)Vars.control.sound.darkMusic);
        OlMusics.mixMusicSets("vanillaBoss", "glasmoreBoss", (Seq<Music>)Vars.control.sound.bossMusic);
    }

    private static void mixMusicSets(String vanillaSetName, String modSetName, Seq<Music> target) {
        Seq vanillaSet = (Seq)musicSets.get((Object)vanillaSetName);
        Seq modSet = (Seq)musicSets.get((Object)modSetName);
        if (vanillaSet != null && modSet != null) {
            target.clear();
            target.addAll(vanillaSet);
            target.addAll(modSet);
        }
    }

    private static void setMusicSet(String setName, Seq<Music> target) {
        Seq set = (Seq)musicSets.get((Object)setName);
        if (set != null) {
            target.set(set);
        }
    }

    private static Music loadMusic(String name) {
        return Vars.tree.loadMusic(name);
    }
}

