/*
 * Decompiled with CFR 0.152.
 */
package arclibrary.graphics;

import arc.graphics.g2d.Lines;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arclibrary.graphics.EFill;

public class ELines {
    private static final FloatSeq floats = new FloatSeq(20);
    private static final Vec2 tmp1 = new Vec2();
    private static final float[] rectPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f};

    public static void arc(float x, float y, float radius, float finion) {
        ELines.arc(x, y, radius, finion, 0.0f);
    }

    public static void arc(float x, float y, float radius, float finion, float angle) {
        float stroke = Lines.getStroke();
        float halfStroke = stroke / 2.0f;
        EFill.donut(x, y, radius - halfStroke, radius + halfStroke, finion, angle);
    }

    public static void square(float x, float y, float rad) {
        ELines.rect(x - rad, y - rad, rad * 2.0f, rad * 2.0f);
    }

    public static void rect(float x, float y, float width, float height, float originX, float originY, float rotation) {
        float stroke = Lines.getStroke();
        float doubleStroke = stroke * 2.0f;
        for (int i = 0; i < 4; ++i) {
            int nextI = (i + 1) % 4;
            floats.clear();
            ELines.rectCorner(i, x, y, width, height, originX, originY, rotation);
            ELines.rectCorner(i, x, y, width - doubleStroke, height - doubleStroke, originX, originY, rotation);
            ELines.rectCorner(nextI, x, y, width - doubleStroke, height - doubleStroke, originX, originY, rotation);
            ELines.rectCorner(nextI, x, y, width, height, originX, originY, rotation);
            EFill.quad(floats);
        }
        floats.clear();
    }

    private static void rectCorner(int i, float x, float y, float width, float height, float originX, float originY, float rotation) {
        tmp1.set(rectPoints[i * 2], rectPoints[i * 2 + 1]).scl(width, height).sub(originX, originY).rotate(rotation).add(originX + x, originY + y);
        floats.add(ELines.tmp1.x, ELines.tmp1.y);
    }

    public static void rect(float x, float y, float width, float height) {
        ELines.rect(x, y, width, height, 0.0f);
    }

    public static void rect(float x, float y, float width, float height, float rot) {
        ELines.rect(x, y, width, height, width / 2.0f, height / 2.0f, rot);
    }

    public static void rect(Rect rect) {
        ELines.rect(rect.x, rect.y, rect.width, rect.height, 0.0f);
    }
}

