/*
 * Decompiled with CFR 0.152.
 */
package arclibrary.graphics;

import arc.Core;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;

public class EDraw {
    private static float[] vertices = new float[24];

    public static void quad(TextureRegion region, float x1, float y1, float c1, float x2, float y2, float c2, float x3, float y3, float c3, float x4, float y4, float c4) {
        float u = region.u;
        float v = region.v;
        float u2 = region.u2;
        float v2 = region.v2;
        EDraw.quad(region.texture, x1, y1, c1, u, v, x2, y2, c2, u, v2, x3, y3, c3, u2, v2, x4, y4, c4, u2, v);
    }

    public static void rectCenter(Texture texture, float x, float y, float width, float height) {
        EDraw.rect(texture, x - width / 2.0f, y - height / 2.0f, width, height);
    }

    public static void drawBuffer(FrameBuffer buffer, float centerX, float centerY) {
        EDraw.drawBuffer(buffer, centerX, centerY, Core.camera.width, -Core.camera.height);
    }

    public static void drawBuffer(FrameBuffer buffer, float centerX, float centerY, float width, float height) {
        EDraw.rectCenter((Texture)buffer.getTexture(), centerX, centerY, width, height);
    }

    public static void drawBuffer(FrameBuffer buffer) {
        EDraw.drawBuffer(buffer, Core.camera.position.x, Core.camera.position.y);
    }

    public static void rect(Texture texture, float x, float y, float width, float height) {
        float color = Draw.getColor().toFloatBits();
        EDraw.quad(texture, x, y, color, 0.0f, 1.0f, x, y + height, color, 0.0f, 0.0f, x + width, y + height, color, 1.0f, 0.0f, x + width, y, color, 1.0f, 1.0f);
    }

    public static void quad(Texture texture, float x1, float y1, float c1, float u1, float v1, float x2, float y2, float c2, float u2, float v2, float x3, float y3, float c3, float u3, float v3, float x4, float y4, float c4, float u4, float v4) {
        float mcolor = Draw.getMixColor().toFloatBits();
        EDraw.vertices[0] = x1;
        EDraw.vertices[1] = y1;
        EDraw.vertices[2] = c1;
        EDraw.vertices[3] = u1;
        EDraw.vertices[4] = v1;
        EDraw.vertices[5] = mcolor;
        EDraw.vertices[6] = x2;
        EDraw.vertices[7] = y2;
        EDraw.vertices[8] = c2;
        EDraw.vertices[9] = u2;
        EDraw.vertices[10] = v2;
        EDraw.vertices[11] = mcolor;
        EDraw.vertices[12] = x3;
        EDraw.vertices[13] = y3;
        EDraw.vertices[14] = c3;
        EDraw.vertices[15] = u3;
        EDraw.vertices[16] = v3;
        EDraw.vertices[17] = mcolor;
        EDraw.vertices[18] = x4;
        EDraw.vertices[19] = y4;
        EDraw.vertices[20] = c4;
        EDraw.vertices[21] = u4;
        EDraw.vertices[22] = v4;
        EDraw.vertices[23] = mcolor;
        Draw.vert((Texture)texture, (float[])vertices, (int)0, (int)vertices.length);
    }
}

