/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.modules;

import arc.util.Nullable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.type.Liquid;
import mindustry.world.modules.BlockModule;
import omaloon.world.graph.PressureGraph;
import omaloon.world.meta.PressureTank;

public class PressureModule
extends BlockModule {
    public PressureGraph graph = new PressureGraph();
    public PressureTank section = new PressureTank();
    public float[] liquids;
    public float[] pressures;

    public PressureModule() {
        this.liquids = new float[Vars.content.liquids().size + 1];
        this.pressures = new float[Vars.content.liquids().size + 1];
    }

    public float getAmount(int liquid) {
        return this.liquids[liquid + 1];
    }

    @Nullable
    public Liquid getMain() {
        float val = 0.0f;
        int out = -1;
        for (int i = -1; i < this.liquids.length - 1; ++i) {
            if (!(this.getAmount(i) > val)) continue;
            val = this.getAmount(i);
            out = i;
        }
        return Vars.content.liquid(out);
    }

    public float getPressure(int liquid) {
        return this.pressures[liquid + 1];
    }

    public void read(Reads read) {
        int size = read.b();
        for (int i = 0; i < size; ++i) {
            if (i >= this.liquids.length) continue;
            float amount = read.f();
            float pressure = read.f();
            this.setAmount(i, amount);
            this.setPressure(i, pressure);
        }
    }

    public void setAmount(int liquid, float amount) {
        this.liquids[liquid + 1] = amount;
    }

    public void setPressure(int liquid, float amount) {
        this.pressures[liquid + 1] = amount;
    }

    public float sumPressure() {
        float out = 0.0f;
        for (float val : this.pressures) {
            out += val;
        }
        return out;
    }

    public void write(Writes write) {
        write.b(this.liquids.length);
        for (int i = 0; i < this.liquids.length; ++i) {
            write.f(this.getAmount(i));
            write.f(this.getPressure(i));
        }
    }
}

