/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.meta;

import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.type.Liquid;
import omaloon.content.OlLiquids;
import omaloon.world.interfaces.HasPressure;

public class PressureTank {
    public Seq<HasPressure> builds = new Seq();

    public void addFluid(@Nullable Liquid fluid, float amount) {
        if (amount < 0.0f) {
            this.removeFluid(fluid, -amount);
        }
        float div = amount / (float)this.builds.size;
        int id = fluid == null ? -1 : (int)fluid.id;
        for (HasPressure build : this.builds) {
            build.pressure().setAmount(id, build.pressure().getAmount(id) + div);
            float pressure = build.pressure().getAmount(id) / build.pressureConfig().fluidCapacity / OlLiquids.getDensity(fluid);
            build.pressure().setPressure(id, pressure);
        }
    }

    public void equalize() {
        if (this.builds.size <= 1) {
            return;
        }
        for (int i = -1; i < Vars.content.liquids().size; ++i) {
            float sum = 0.0f;
            for (HasPressure build : this.builds) {
                sum += build.pressure().getAmount(i);
            }
            sum /= (float)this.builds.size;
            for (HasPressure build : this.builds) {
                build.pressure().setAmount(i, sum);
            }
        }
    }

    public void removeFluid(@Nullable Liquid fluid, float amount) {
        if (amount < 0.0f) {
            this.addFluid(fluid, -amount);
        }
        float div = amount / (float)this.builds.size;
        int id = fluid == null ? -1 : (int)fluid.id;
        for (HasPressure build : this.builds) {
            build.pressure().setAmount(id, build.pressure().getAmount(id) - div);
            float pressure = build.pressure().getAmount(id) / build.pressureConfig().fluidCapacity / OlLiquids.getDensity(fluid);
            build.pressure().setPressure(id, pressure);
        }
    }

    public static enum TankGroup {
        transportation,
        pumps,
        production;

    }
}

