/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.meta;

import arc.Core;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Mathf;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import omaloon.ui.elements.CenterBar;
import omaloon.world.consumers.ConsumeFluid;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureTank;

public class PressureConfig {
    public boolean hasPressure = false;
    public boolean acceptsPressure;
    public boolean outputsPressure;
    public float fluidCapacity = 8.0f;
    public float minPressure = -50.0f;
    public float maxPressure = 50.0f;
    public PressureTank.TankGroup group;

    public void addBars(Block block) {
        if (!this.hasPressure) {
            return;
        }
        block.removeBar("liquid");
        boolean added = false;
        for (Consume cons : block.consumers) {
            if (!(cons instanceof ConsumeFluid)) continue;
            ConsumeFluid consFluid = (ConsumeFluid)cons;
            if (block.consumers.length <= 1) continue;
            String barName = "omaloon-fluid-bar-" + (consFluid.fluid == null ? "air" : consFluid.fluid);
            block.addBar(barName, build -> {
                HasPressure e = (HasPressure)build;
                Liquid liq = consFluid.fluid;
                return new Bar(() -> liq == null ? Core.bundle.format("bar.omaloon-air-bar", new Object[]{OlStats.formatValue(e.getFluid(liq), 2, false)}) : Core.bundle.format("bar.omaloon-fluid-bar", new Object[]{liq.localizedName, OlStats.formatValue(e.getFluid(liq), 2, false), OlStats.formatValue(e.getFluid(null), 2, false)}), () -> liq == null ? Color.white : liq.color, () -> liq == null ? 0.0f : Mathf.clamp((float)e.getFluid(liq)));
            });
            added = true;
        }
        if (!added) {
            block.addBar("omaloon-fluid-bar", build -> {
                HasPressure e = (HasPressure)build;
                Liquid liq = e.pressure().getMain();
                return new Bar(() -> liq == null ? Core.bundle.format("bar.omaloon-air-bar", new Object[]{OlStats.formatValue(e.getFluid(liq), 2, false)}) : Core.bundle.format("bar.omaloon-fluid-bar", new Object[]{liq.localizedName, OlStats.formatValue(e.getFluid(liq), 2, false), OlStats.formatValue(e.getFluid(null), 2, false)}), () -> liq == null ? Color.white : liq.color, () -> Mathf.clamp((float)(liq == null ? 0.0f : e.getFluid(liq) / Math.max(1.0f, e.getFluid(liq) + Math.abs(e.getFluid(null))))));
            });
        } else {
            block.addBar("omaloon-fluid-bar-air", build -> {
                HasPressure e = (HasPressure)build;
                Liquid liq = null;
                return new Bar(() -> Core.bundle.format("bar.omaloon-air-bar", new Object[]{OlStats.formatValue(e.getFluid(liq), 2, false)}), () -> Color.white, () -> 0.0f);
            });
        }
        block.addBar("omaloon-pressure-bar", build -> {
            HasPressure e = (HasPressure)build;
            return new CenterBar((Prov<CharSequence>)((Prov)() -> Core.bundle.format("bar.omaloon-pressure-bar", new Object[]{OlStats.formatValue(e.pressure().sumPressure(), 2, false)})), (Prov<Color>)((Prov)() -> e.pressure().sumPressure() > 0.0f ? Color.white : Color.gray), () -> Mathf.map((float)e.pressure().sumPressure(), (float)this.minPressure, (float)this.maxPressure, (float)-1.0f, (float)1.0f));
        });
    }

    public void addStats(Block block, Stats stats) {
        if (!this.hasPressure) {
            return;
        }
        stats.remove(Stat.liquidCapacity);
        stats.add(Stat.liquidCapacity, this.fluidCapacity / 8.0f, OlStats.blocksCubed);
        stats.add(OlStats.minPressure, OlStats.number(this.minPressure, OlStats.pressureUnit, false));
        stats.add(OlStats.maxPressure, OlStats.number(this.maxPressure, OlStats.pressureUnit, false));
    }
}

