/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.meta;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import mindustry.type.Liquid;
import mindustry.ui.Styles;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;

public class OlStats {
    public static StatUnit blocksCubed = new StatUnit("omaloon-blocks-cubed");
    public static StatUnit densityUnit = new StatUnit("omaloon-density-unit");
    public static StatUnit viscosityUnit = new StatUnit("omaloon-viscosity-unit");
    public static StatUnit pressureUnit = new StatUnit("omaloon-pressure-unit");
    public static StatCat pressure = new StatCat("omaloon-pressure");
    public static Stat density = new Stat("omaloon-density");
    public static Stat minPressure = new Stat("omaloon-min-pressure", pressure);
    public static Stat maxPressure = new Stat("omaloon-max-pressure", pressure);
    public static Stat pumpStrength = new Stat("omaloon-pump-strength");
    public static Stat pressureGradient = new Stat("omaloon-pressure-gradient");

    public static String formatValue(float value, int decimals, boolean addPlus) {
        String format = Strings.autoFixed((float)Math.abs(value), (int)decimals);
        return (value < 0.0f ? "-" : (addPlus ? "+" : "")) + format;
    }

    public static StatValue fluid(final @Nullable Liquid liquid, final float amount, final float time, boolean showContinuous) {
        return table -> table.table(display -> {
            display.add((Element)new Stack(){
                {
                    this.add((Element)new Image((TextureRegion)(liquid != null ? liquid.uiIcon : Core.atlas.find("omaloon-pressure-icon"))).setScaling(Scaling.fit));
                    if (amount * 60.0f / time != 0.0f) {
                        Table t = new Table().left().bottom();
                        t.add((CharSequence)Strings.autoFixed((float)(amount * 60.0f / time), (int)2)).style((Style)Styles.outlineLabel);
                        this.add((Element)t);
                    }
                }
            }).size(32.0f).padRight((float)(3 + (amount * 60.0f / time != 0.0f && Strings.autoFixed((float)(amount * 60.0f / time), (int)2).length() > 2 ? 8 : 0)));
            if (showContinuous) {
                display.add((CharSequence)StatUnit.perSecond.localized()).padLeft(2.0f).padRight(5.0f).color(Color.lightGray).style((Style)Styles.outlineLabel);
            }
            display.add((CharSequence)(liquid != null ? liquid.localizedName : "@air"));
        });
    }

    public static StatValue number(float value, StatUnit unit, boolean merge) {
        return table -> {
            String l1 = (unit.icon == null ? "" : unit.icon + " ") + OlStats.formatValue(value, 2, false);
            String l2 = (unit.space ? " " : "") + unit.localized();
            if (merge) {
                table.add((CharSequence)(l1 + l2)).left();
            } else {
                table.add((CharSequence)l1).left();
                table.add((CharSequence)l2).left();
            }
        };
    }
}

