/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.interfaces;

import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import omaloon.world.graph.PressureGraph;
import omaloon.world.meta.PressureConfig;
import omaloon.world.meta.PressureTank;
import omaloon.world.modules.PressureModule;

public interface HasPressure {
    public static boolean canTransfer(HasPressure from, HasPressure to, @Nullable Liquid fluid, float amount) {
        return from.outputsFluid(to, fluid, amount) && to.acceptsFluid(from, fluid, amount) && amount > 0.0f || to.outputsFluid(from, fluid, amount) && from.acceptsFluid(to, fluid, amount) && amount < 0.0f;
    }

    public static boolean connects(HasPressure from, HasPressure to) {
        return from.connects(to) && to.connects(from);
    }

    default public boolean acceptsFluid(HasPressure from, @Nullable Liquid fluid, float amount) {
        return true;
    }

    default public void addFluid(@Nullable Liquid fluid, float amount) {
        if (amount >= 0.0f) {
            this.pressureSection().addFluid(fluid, amount);
        } else {
            this.removeFluid(fluid, -amount);
        }
    }

    default public Seq<HasPressure> connections() {
        return this.toBuilding().proximity.select(b -> {
            HasPressure p;
            return b instanceof HasPressure && HasPressure.connects(this, p = (HasPressure)b);
        }).as();
    }

    default public boolean connects(HasPressure to) {
        return this.pressureConfig().hasPressure && to.toBuilding().team == this.toBuilding().team;
    }

    default public float getFluid(@Nullable Liquid fluid) {
        return this.pressure().getAmount(fluid == null ? -1 : (int)fluid.id);
    }

    default public float getPressure(@Nullable Liquid fluid) {
        return this.pressure().getPressure(fluid == null ? -1 : (int)fluid.id);
    }

    default public void onPressureGraphUpdate() {
    }

    default public boolean outputsFluid(HasPressure to, @Nullable Liquid fluid, float amount) {
        return true;
    }

    public PressureModule pressure();

    public PressureConfig pressureConfig();

    default public PressureGraph pressureGraph() {
        return this.pressure().graph;
    }

    default public PressureTank pressureSection() {
        return this.pressure().section;
    }

    default public void removeFluid(@Nullable Liquid fluid, float amount) {
        if (amount >= 0.0f) {
            this.pressureSection().removeFluid(fluid, amount);
        } else {
            this.addFluid(fluid, -amount);
        }
    }

    default public Building toBuilding() {
        return (Building)this;
    }
}

