/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.graph;

import arc.struct.FloatSeq;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.type.Liquid;
import omaloon.content.OlLiquids;
import omaloon.gen.PressureGraphUpdater;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureTank;

public class PressureGraph {
    static Seq<HasPressure> tmp = new Seq();
    static Seq<HasPressure> tmp2 = new Seq();
    static Seq<HasPressure> tmp3 = new Seq();
    static ObjectMap<HasPressure, HasPressure> edges = new ObjectMap();
    static ObjectIntMap<HasPressure> connections = new ObjectIntMap();
    static FloatSeq flows = new FloatSeq(Vars.content.liquids().size + 1);
    public Seq<HasPressure> builds = new Seq(false);
    public boolean changed;
    public PressureGraphUpdater updater = PressureGraphUpdater.create().create(this);

    public void addRaw(HasPressure build) {
        this.builds.addUnique((Object)build);
        build.pressure().graph = this;
        this.checkEntity();
        this.changed = true;
    }

    public void checkEntity() {
        if (this.builds.isEmpty()) {
            this.updater.remove();
        } else {
            this.updater.add();
        }
    }

    public void floodMergeGraph(HasPressure start) {
        tmp.clear().add((Object)start);
        tmp2.clear();
        while (!tmp.isEmpty()) {
            HasPressure current = (HasPressure)tmp.pop();
            tmp2.add((Object)current);
            if (current.pressureGraph() != this) {
                current.pressureGraph().removeRaw(current);
                this.addRaw(current);
            }
            for (HasPressure next : current.connections()) {
                if (tmp2.contains((Object)next)) continue;
                tmp.add((Object)next);
                tmp2.add((Object)next);
            }
        }
    }

    public void rebuildTanks() {
        tmp.clear().add((Object)((HasPressure)this.builds.first()));
        tmp2.clear();
        tmp3.clear();
        while (!tmp.isEmpty()) {
            PressureTank section = new PressureTank();
            tmp2.add((Object)((HasPressure)tmp.pop()));
            while (!tmp2.isEmpty()) {
                HasPressure current = (HasPressure)tmp2.pop();
                section.builds.addUnique((Object)current);
                current.pressure().section = section;
                for (HasPressure other : current.connections()) {
                    if (tmp3.contains((Object)other)) continue;
                    if (other.pressureConfig().group != current.pressureConfig().group || other.pressureConfig().group == null) {
                        tmp.add((Object)other);
                    } else {
                        tmp2.add((Object)other);
                    }
                    tmp3.add((Object)other);
                }
            }
            section.equalize();
        }
    }

    public void removeRaw(HasPressure build) {
        this.builds.remove((Object)build);
        this.checkEntity();
        this.changed = true;
    }

    public void transferFluids() {
        edges.clear();
        connections.clear();
        this.builds.each(build -> {
            Seq others = build.connections().retainAll(other -> other.pressureSection() != build.pressureSection());
            connections.put(build, Math.max(1, others.size));
            others.each(other -> edges.put(build, other));
        });
        for (int i = 0; i < Vars.content.liquids().size + 1; ++i) {
            flows.clear();
            int liquidID = i - 1;
            Liquid liquid = Vars.content.liquid(liquidID);
            edges.each((to, from) -> {
                float flow = to.pressureConfig().fluidCapacity * from.pressure().getPressure(liquidID);
                flow += from.pressureConfig().fluidCapacity * to.pressure().getPressure(liquidID);
                flow /= from.pressureConfig().fluidCapacity + to.pressureConfig().fluidCapacity;
                flow -= from.pressure().getPressure(liquidID);
                flow *= from.pressureConfig().fluidCapacity;
                flow *= OlLiquids.getDensity(liquid);
                flow /= Math.max(1.0f, OlLiquids.getViscosity(liquid) / Time.delta);
                flow /= (float)connections.get(to);
                flows.add(flow /= 2.0f);
            });
            int edgeIndex = 0;
            for (ObjectMap.Entry currentEdge : edges) {
                if (HasPressure.canTransfer((HasPressure)currentEdge.key, (HasPressure)currentEdge.value, liquid, flows.get(edgeIndex))) {
                    ((HasPressure)currentEdge.key).pressureSection().removeFluid(liquid, flows.get(edgeIndex));
                    ((HasPressure)currentEdge.value).pressureSection().addFluid(liquid, flows.get(edgeIndex));
                }
                ++edgeIndex;
            }
        }
    }

    public void update() {
        if (this.changed) {
            this.rebuildTanks();
            this.builds.each(HasPressure::onPressureGraphUpdate);
            this.changed = false;
        }
        this.transferFluids();
    }
}

