/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.consumers;

import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;

public class ConsumeFluid
extends Consume {
    @Nullable
    public Liquid fluid;
    public float amount;
    public boolean continuous;
    public float startRange;
    public float endRange;
    public float efficiencyMultiplier = 1.0f;
    public float optimalPressure;
    public boolean hasOptimalPressure = false;
    public Interp curve = Interp.one;

    public ConsumeFluid(@Nullable Liquid fluid, float amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public HasPressure cast(Building build) {
        try {
            return (HasPressure)build;
        }
        catch (Exception e) {
            throw new RuntimeException("This consumer should be used on a building that implements HasPressure", e);
        }
    }

    public void apply(Block block) {
        block.hasLiquids = true;
    }

    public void display(Stats stats) {
        if (this.amount != 0.0f) {
            if (this.continuous) {
                stats.add(this.amount > 0.0f ? Stat.input : Stat.output, OlStats.fluid(this.fluid, Math.abs(this.amount), 1.0f, true));
            } else {
                stats.add(this.amount > 0.0f ? Stat.input : Stat.output, OlStats.fluid(this.fluid, Math.abs(this.amount), 60.0f, false));
            }
        }
    }

    public float efficiency(Building build) {
        if (!this.shouldConsume(this.cast(build))) {
            return 0.0f;
        }
        return 1.0f;
    }

    public float efficiencyMultiplier(Building build) {
        if (!this.shouldConsume(this.cast(build))) {
            return 0.0f;
        }
        return this.curve.apply(1.0f, this.efficiencyMultiplier, Mathf.clamp((float)Mathf.map((float)this.cast(build).getPressure(this.fluid), (float)this.startRange, (float)this.endRange, (float)0.0f, (float)1.0f)));
    }

    public boolean shouldConsume(HasPressure build) {
        if (this.fluid != null && this.amount > 0.0f && build.getFluid(this.fluid) <= this.amount) {
            return false;
        }
        if (this.startRange == this.endRange) {
            return true;
        }
        return this.startRange <= build.getPressure(this.fluid) && build.getPressure(this.fluid) <= this.endRange && (this.fluid == null || build.pressure().liquids[this.fluid.id] > this.amount);
    }

    public void trigger(Building build) {
        if (!this.continuous && this.shouldConsume(this.cast(build))) {
            this.cast(build).removeFluid(this.fluid, this.amount);
        }
    }

    public void update(Building build) {
        if (this.continuous && this.shouldConsume(this.cast(build))) {
            this.cast(build).removeFluid(this.fluid, this.amount * Time.delta);
        }
    }
}

