/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.production;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import omaloon.world.graph.PressureGraph;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class PressureCrafter
extends GenericCrafter {
    public PressureConfig pressureConfig = new PressureConfig();
    public boolean useConsumerMultiplier = true;
    public float outputAir;

    public PressureCrafter(String name) {
        super(name);
    }

    public void init() {
        super.init();
        if (this.hasLiquids) {
            this.hasLiquids = false;
            this.pressureConfig.hasPressure = true;
        }
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars((Block)this);
        if (this.outputLiquids != null && this.outputLiquids.length > 0) {
            this.removeBar("omaloon-fluid-bar");
            for (LiquidStack stack : this.outputLiquids) {
                this.addBar("omaloon-fluid-bar-" + stack.liquid.name, build -> {
                    HasPressure e = (HasPressure)build;
                    Liquid liq = stack.liquid;
                    return new Bar(() -> liq == null ? Core.bundle.format("bar.omaloon-air-bar", new Object[]{OlStats.formatValue(e.getFluid(liq), 2, false)}) : Core.bundle.format("bar.omaloon-fluid-bar", new Object[]{liq.localizedName, OlStats.formatValue(e.getFluid(liq), 2, false), OlStats.formatValue(e.getFluid(null), 2, false)}), () -> liq == null ? Color.white : liq.color, () -> liq == null ? 0.0f : e.getFluid(liq) / Math.max(1.0f, Math.abs(e.getFluid(null))));
                });
            }
            if (this.outputAir > 0.0f) {
                this.addBar("omaloon-fluid-bar-air", build -> {
                    HasPressure e = (HasPressure)build;
                    Liquid liq = null;
                    return new Bar(() -> Core.bundle.format("bar.omaloon-air-bar", new Object[]{OlStats.formatValue(e.getFluid(liq), 2, false)}), () -> Color.white, () -> 0.0f);
                });
            }
        }
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats((Block)this, this.stats);
        if (this.outputAir > 0.0f) {
            this.stats.add(Stat.output, OlStats.fluid(null, this.outputAir, 1.0f, true));
        }
    }

    public class PressureCrafterBuild
    extends GenericCrafter.GenericCrafterBuild
    implements HasPressure {
        public PressureModule pressure;

        public PressureCrafterBuild() {
            super((GenericCrafter)PressureCrafter.this);
        }

        public Building create(Block block, Team team) {
            super.create(block, team);
            if (this.pressureConfig().hasPressure) {
                this.pressure = new PressureModule();
                this.pressureGraph().addRaw(this);
            }
            return this;
        }

        public void dumpOutputs() {
            if (PressureCrafter.this.outputItems != null && this.timer(PressureCrafter.this.timerDump, (float)PressureCrafter.this.dumpTime / this.timeScale)) {
                for (ItemStack output : PressureCrafter.this.outputItems) {
                    this.dump(output.item);
                }
            }
        }

        public float efficiencyMultiplier() {
            float val = 1.0f;
            if (!PressureCrafter.this.useConsumerMultiplier) {
                return val;
            }
            for (Consume consumer : PressureCrafter.this.consumers) {
                val *= consumer.efficiencyMultiplier((Building)this);
            }
            return val;
        }

        public float efficiencyScale() {
            return super.efficiencyScale() * this.efficiencyMultiplier();
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            if (PressureCrafter.this.pressureConfig.hasPressure) {
                new PressureGraph().floodMergeGraph(this);
            }
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return PressureCrafter.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (PressureCrafter.this.pressureConfig.hasPressure) {
                this.pressure.read(read);
            }
        }

        public boolean shouldConsume() {
            if (PressureCrafter.this.outputLiquids != null && !PressureCrafter.this.ignoreLiquidFullness) {
                boolean allFull = true;
                boolean someFull = false;
                if (this.getFluid(null) >= PressureCrafter.this.pressureConfig.fluidCapacity) {
                    someFull = true;
                } else {
                    allFull = false;
                }
                for (LiquidStack output : PressureCrafter.this.outputLiquids) {
                    if (this.getFluid(output.liquid) >= PressureCrafter.this.pressureConfig.fluidCapacity) {
                        someFull = true;
                        continue;
                    }
                    allFull = false;
                }
                if (allFull || someFull && !PressureCrafter.this.ignoreLiquidFullness) {
                    return false;
                }
            }
            return this.enabled;
        }

        public void updateTile() {
            if (this.efficiency > 0.0f) {
                this.progress += this.getProgressIncrease(PressureCrafter.this.craftTime);
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)this.warmupTarget(), (float)PressureCrafter.this.warmupSpeed);
                float inc = this.getProgressIncrease(1.0f);
                if (PressureCrafter.this.outputLiquids != null) {
                    for (LiquidStack output : PressureCrafter.this.outputLiquids) {
                        this.addFluid(output.liquid, output.amount * inc);
                    }
                }
                if (PressureCrafter.this.outputAir > 0.0f) {
                    this.addFluid(null, PressureCrafter.this.outputAir * inc);
                }
                if (this.wasVisible && Mathf.chanceDelta((double)PressureCrafter.this.updateEffectChance)) {
                    PressureCrafter.this.updateEffect.at(this.x + Mathf.range((float)((float)PressureCrafter.this.size * PressureCrafter.this.updateEffectSpread)), this.y + Mathf.range((float)((float)PressureCrafter.this.size * PressureCrafter.this.updateEffectSpread)));
                }
            } else {
                this.warmup = Mathf.approachDelta((float)this.warmup, (float)0.0f, (float)PressureCrafter.this.warmupSpeed);
            }
            this.totalProgress += this.warmup * this.edelta();
            if (this.progress >= 1.0f) {
                this.craft();
            }
            this.dumpOutputs();
        }

        public void write(Writes write) {
            super.write(write);
            if (PressureCrafter.this.pressureConfig.hasPressure) {
                this.pressure.write(write);
            }
        }
    }
}

