/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment.customsshapeproop;

import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Bits;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.world.Block;
import mindustry.world.Tile;
import omaloon.world.blocks.environment.customsshapeproop.MultiPropGroup;
import omaloon.world.interfaces.MultiPropI;

public class CustomShapePropProcess
implements AsyncProcess {
    public static CustomShapePropProcess instance;
    private final Bits visitedTilePos = new Bits();
    private final Seq<Tile> tempNonThreadSafeSeq = new Seq();
    public Seq<MultiPropGroup> multiProps = new Seq();

    public static void create() {
        instance = new CustomShapePropProcess();
        Vars.asyncCore.processes.add((Object)instance);
    }

    public void init() {
        this.multiProps.clear();
        this.visitedTilePos.clear();
        for (Tile tile : Vars.world.tiles) {
            Block block = tile.block();
            if (!(block instanceof MultiPropI) || this.visitedTilePos.get(tile.pos())) continue;
            MultiPropGroup multiProp = this.createMultiProp(tile);
            this.multiProps.add((Object)multiProp);
            multiProp.findCenter();
            multiProp.findShape();
        }
    }

    public MultiPropGroup createMultiProp(Tile from) {
        Seq temp = this.tempNonThreadSafeSeq.clear().add((Object)from);
        MultiPropGroup out = new MultiPropGroup(from.block());
        Seq<Tile> group = out.group;
        group.add((Object)from);
        this.visitedTilePos.set(from.pos());
        while (!temp.isEmpty()) {
            Tile tile = (Tile)temp.pop();
            for (Point2 point : Geometry.d4) {
                Tile nearby = tile.nearby(point);
                if (nearby == null) continue;
                int pos = nearby.pos();
                if (!(nearby.block() instanceof MultiPropI) || this.visitedTilePos.get(pos) || nearby.block() != out.type) continue;
                group.add((Object)nearby);
                this.visitedTilePos.set(pos);
                temp.add((Object)nearby);
            }
        }
        temp.clear();
        return out;
    }

    public void process() {
        for (int i = 0; i < this.multiProps.size; ++i) {
            MultiPropGroup multiProp = (MultiPropGroup)this.multiProps.get(i);
            multiProp.update();
            if (!multiProp.removed) continue;
            this.multiProps.remove(i);
            --i;
        }
    }

    public void onRemoveBlock(Tile tile, Block block) {
        this.multiProps.each(multiPropGroup -> {
            if (multiPropGroup.group.contains((Object)tile)) {
                multiPropGroup.remove();
            }
        });
    }
}

