/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.LongSeq;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.graphics.MultiPacker;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import omaloon.type.shape.RectanglePatternShape;
import omaloon.type.shape.Shape;

public class PatternedFloor
extends Floor {
    private static final LongSeq claimedTiles = new LongSeq();
    private static final ObjectMap<Block, TextureRegion[][]> edgeCache = new ObjectMap();
    private static long lastFrameId = -1L;
    public Shape shape = new RectanglePatternShape();
    public Block parent = Blocks.stone;
    public boolean drawPatternEdges = true;

    public PatternedFloor(String name) {
        super(name);
        this.variants = 0;
        this.blendGroup = this.parent;
    }

    public void createIcons(MultiPacker packer) {
        super.createIcons(packer);
        this.shape.load();
    }

    private boolean isPatternComplete(Tile bottomLeft) {
        if (bottomLeft == null) {
            return false;
        }
        boolean[] allMatch = new boolean[]{true};
        this.shape.each((x, y) -> {
            Tile other;
            if (!allMatch[0]) {
                return;
            }
            if (this.shape.get(x, y) && ((other = Vars.world.tile(bottomLeft.x + x, bottomLeft.y + y)) == null || other.floor() != this || claimedTiles.contains((long)other.pos()))) {
                allMatch[0] = false;
            }
        });
        return allMatch[0];
    }

    private Tile findPatternAnchorFor(Tile tile) {
        if (tile == null) {
            return null;
        }
        for (int dx = 0; dx < this.shape.width(); ++dx) {
            for (int dy = 0; dy < this.shape.height(); ++dy) {
                Tile potentialAnchor;
                if (!this.shape.get(dx, dy) || !this.isPatternComplete(potentialAnchor = tile.nearby(-dx, -dy))) continue;
                return potentialAnchor;
            }
        }
        return null;
    }

    public void drawBase(Tile tile) {
        long frameId = Core.graphics.getFrameId();
        if (frameId != lastFrameId) {
            claimedTiles.clear();
            edgeCache.clear();
            lastFrameId = frameId;
        }
        if (claimedTiles.contains((long)tile.pos())) {
            return;
        }
        Tile bottomLeft = this.findPatternAnchorFor(tile);
        if (bottomLeft == null) {
            if (this.parent != Blocks.air) {
                this.parent.drawBase(tile);
            }
            return;
        }
        this.claimArea(bottomLeft);
        this.shape.each((x, y) -> {
            Tile other;
            if (this.shape.get(x, y) && (other = Vars.world.tile(bottomLeft.x + x, bottomLeft.y + y)) != null && this.parent != Blocks.air) {
                this.parent.drawBase(other);
            }
        });
        Mathf.rand.setSeed((long)bottomLeft.pos());
        Draw.rect((TextureRegion)this.variantRegions[Mathf.randomSeed((long)bottomLeft.pos(), (int)0, (int)Math.max(0, this.variantRegions.length - 1))], (float)(bottomLeft.worldx() + (float)((this.shape.width() - 1) * 8) / 2.0f), (float)(bottomLeft.worldy() + (float)((this.shape.height() - 1) * 8) / 2.0f));
        if (this.drawPatternEdges) {
            this.drawPatternEdges(bottomLeft);
        }
    }

    private void drawPatternEdges(Tile bottomLeft) {
        this.shape.each((x, y) -> {
            if (!this.shape.get(x, y)) {
                return;
            }
            Tile tileInPattern = Vars.world.tile(bottomLeft.x + x, bottomLeft.y + y);
            if (tileInPattern == null) {
                return;
            }
            for (int i = 0; i < 8; ++i) {
                TextureRegion region;
                boolean isNeighborInShape;
                Point2 point = Geometry.d8[i];
                Tile neighbor = tileInPattern.nearby(point.x, point.y);
                int nx = x + point.x;
                int ny = y + point.y;
                boolean bl = isNeighborInShape = neighbor != null && nx >= 0 && nx < this.shape.width() && ny >= 0 && ny < this.shape.height() && this.shape.get(nx, ny);
                if (neighbor == null || isNeighborInShape || !this.doEdge(tileInPattern, neighbor, neighbor.floor()) || (region = this.edge(neighbor.floor(), 1 - point.x, 1 - point.y)) == null) continue;
                Draw.rect((TextureRegion)region, (float)tileInPattern.worldx(), (float)tileInPattern.worldy());
            }
        });
    }

    public boolean doEdge(Tile tile, Tile otherTile, Floor other) {
        return other.realBlendId(otherTile) > this.realBlendId(tile) || this.getEdges(this.parent.asFloor()) == null;
    }

    private TextureRegion edge(Floor floor, int rx, int ry) {
        TextureRegion[][] edges = this.getEdges(floor);
        if (edges == null || edges.length <= rx || edges[rx].length <= 2 - ry) {
            return null;
        }
        return edges[rx][2 - ry];
    }

    private TextureRegion[][] getEdges(Floor floor) {
        Block blendBlock = floor.blendGroup;
        if (edgeCache.containsKey((Object)blendBlock)) {
            return (TextureRegion[][])edgeCache.get((Object)blendBlock);
        }
        TextureAtlas.AtlasRegion edgeSheet = Core.atlas.find(blendBlock.name + "-edge");
        if (!edgeSheet.found()) {
            return null;
        }
        int size = (int)(8.0f / Draw.scl);
        TextureRegion[][] split = edgeSheet.split(size, size);
        edgeCache.put((Object)blendBlock, (Object)split);
        return split;
    }

    private void claimArea(Tile bottomLeft) {
        if (bottomLeft == null) {
            return;
        }
        this.shape.each((x, y) -> {
            Tile other;
            if (this.shape.get(x, y) && (other = Vars.world.tile(bottomLeft.x + x, bottomLeft.y + y)) != null) {
                claimedTiles.add((long)other.pos());
            }
        });
    }

    public boolean updateRender(Tile tile) {
        for (int dx = -this.shape.width() + 1; dx < this.shape.width(); ++dx) {
            for (int dy = -this.shape.height() + 1; dy < this.shape.height(); ++dy) {
                Tile other = tile.nearby(dx, dy);
                if (other == null || other.floor() != this) continue;
                return true;
            }
        }
        return false;
    }
}

