/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.environment;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Geometry;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.graphics.CacheLayer;
import mindustry.world.Block;
import mindustry.world.Tile;
import omaloon.content.blocks.OlEnvironmentBlocks;
import omaloon.world.blocks.environment.CliffHelper;

public class Cliff
extends Block {
    public float colorMultiplier = 1.5f;
    public boolean useMapColor = true;
    public TextureRegion[] cliffs;

    public Cliff(String name) {
        super(name);
        this.alwaysReplace = false;
        this.breakable = false;
        this.solid = true;
        this.saveData = true;
        this.cacheLayer = CacheLayer.walls;
        this.fillsTile = false;
        this.hasShadow = false;
    }

    public static void processCliffs() {
        Vars.world.tiles.eachTile(tile -> {
            if (tile.block() instanceof Cliff && tile.data == 0) {
                int i;
                for (i = 0; i < 4; ++i) {
                    if (!(tile.nearby(i).block() instanceof CliffHelper)) continue;
                    tile.data = (byte)(i + 1);
                }
                if (tile.data == 0) {
                    for (i = 0; i < 4; ++i) {
                        if (!(tile.nearby(Geometry.d8edge((int)i)).block() instanceof CliffHelper)) continue;
                        tile.data = (byte)(i + 5);
                    }
                }
                for (i = 0; i < 4; ++i) {
                    if (!(tile.nearby(i).block() instanceof CliffHelper) || !(tile.nearby((i + 1) % 4).block() instanceof CliffHelper)) continue;
                    tile.data = (byte)(i + 9);
                }
                if (tile.data == 0) {
                    tile.setBlock(Blocks.air);
                }
            }
        });
        Vars.world.tiles.eachTile(tile -> {
            if (tile.block() instanceof CliffHelper) {
                Call.setTile((Tile)tile, (Block)Blocks.air, (Team)Team.derelict, (int)0);
            }
        });
    }

    public static void unProcessCliffs() {
        Vars.world.tiles.eachTile(tile -> {
            if (tile.block() instanceof Cliff && tile.data != 0) {
                if (tile.data <= 4) {
                    tile.nearby(tile.data - 1).setBlock(OlEnvironmentBlocks.cliffHelper);
                } else if (tile.data <= 8) {
                    tile.nearby(Geometry.d8edge((int)(tile.data - 5))).setBlock(OlEnvironmentBlocks.cliffHelper);
                } else {
                    tile.nearby(Geometry.d4((int)(tile.data - 9))).setBlock(OlEnvironmentBlocks.cliffHelper);
                    tile.nearby(Geometry.d4((int)(tile.data - 8))).setBlock(OlEnvironmentBlocks.cliffHelper);
                }
                tile.data = 0;
            }
        });
    }

    public void drawBase(Tile tile) {
        if (tile.data == 0) {
            Draw.color();
            Draw.rect((TextureRegion)this.region, (float)tile.drawx(), (float)tile.drawy());
        } else {
            if (this.useMapColor) {
                Draw.color((Color)Tmp.c1.set(tile.floor().mapColor).mul(this.colorMultiplier));
            }
            Draw.rect((TextureRegion)this.cliffs[tile.data - 1], (float)tile.drawx(), (float)tile.drawy());
        }
        Draw.color();
    }

    public void load() {
        super.load();
        this.cliffs = new TextureRegion[12];
        for (int i = 0; i < 12; ++i) {
            this.cliffs[i] = Core.atlas.find(this.name + "-" + (i + 1), "omaloon-cliff-" + (i + 1));
        }
    }

    public int minimapColor(Tile tile) {
        return Tmp.c1.set(tile.floor().mapColor).mul(1.2f).rgba();
    }
}

