/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Puddles;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.Tile;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import omaloon.content.OlLiquids;
import omaloon.math.Physics;
import omaloon.world.GenericPressureBlock;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.OlStats;
import omaloon.world.meta.PressureTank;

public class PressureLiquidPump
extends GenericPressureBlock {
    public float pumpStrength = 0.1f;
    public float pressureDifference = 10.0f;
    public float liquidPadding = 3.0f;
    public float smoothAlphaSpeed = 0.014f;
    public float effectInterval = 5.0f;
    public Effect pumpEffectOut = Fx.none;
    public Effect pumpEffectIn = Fx.none;
    public TextureRegion[][] liquidRegions;
    public TextureRegion[] tiles;
    public TextureRegion topRegion;
    public TextureRegion bottomRegion;
    public TextureRegion arrowRegion;

    public PressureLiquidPump(String name) {
        super(name);
        this.rotate = true;
        this.destructible = true;
        this.update = true;
        this.copyConfig = true;
        this.saveConfig = true;
    }

    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-0"), Core.atlas.find(this.name + "-top")};
    }

    @Override
    public void init() {
        this.pressureConfig.hasPressure = true;
        this.pressureConfig.outputsPressure = false;
        this.pressureConfig.acceptsPressure = false;
        super.init();
        this.pressureConfig.group = PressureTank.TankGroup.pumps;
    }

    public void load() {
        super.load();
        this.liquidRegions = new TextureRegion[2][50];
        if (Vars.renderer != null) {
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int fluid = 0; fluid < 2; ++fluid) {
                for (int frame = 0; frame < 50; ++frame) {
                    TextureRegion base = frames[fluid][frame];
                    TextureRegion result = new TextureRegion();
                    result.set(base);
                    result.setHeight((float)result.height - this.liquidPadding);
                    result.setWidth((float)result.width - this.liquidPadding);
                    result.setX((float)result.getX() + this.liquidPadding);
                    result.setY((float)result.getY() + this.liquidPadding);
                    this.liquidRegions[fluid][frame] = result;
                }
            }
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.liquidCapacity);
        this.stats.add(OlStats.pumpStrength, this.pumpStrength * 60.0f, StatUnit.liquidSecond);
        this.stats.add(OlStats.pressureGradient, OlStats.number(this.pressureDifference, OlStats.pressureUnit, false));
    }

    public class PressureLiquidPumpBuild
    extends GenericPressureBlock.GenericPressureBlockBuild {
        public float effectTimer;
        public int tiling;
        public float smoothAlpha;
        public boolean functioning;

        @Override
        public boolean acceptsFluid(HasPressure from, @Nullable Liquid liquid, float amount) {
            return false;
        }

        public float ambientVolume() {
            return 1.0f / (float)this.chainSize();
        }

        public int chainSize() {
            return this.pressure.section.builds.size;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean connects(HasPressure to) {
            if (!super.connects(to)) return false;
            if (this.front() != to) {
                if (this.back() != to) return false;
            }
            if (!(to instanceof PressureLiquidPumpBuild)) return true;
            PressureLiquidPumpBuild pump = (PressureLiquidPumpBuild)to;
            if (pump.rotation != this.rotation) return false;
            return true;
        }

        public void draw() {
            Draw.rect((TextureRegion)PressureLiquidPump.this.bottomRegion, (float)this.x, (float)this.y);
            if (this.tiling != 0) {
                Draw.rect((TextureRegion)PressureLiquidPump.this.arrowRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
            if (this.rotation == 1 || this.rotation == 2) {
                Draw.yscl = -1.0f;
            }
            Draw.rect((TextureRegion)PressureLiquidPump.this.tiles[this.tiling], (float)this.x, (float)this.y, (float)this.rotdeg());
            Draw.yscl = 1.0f;
            if (this.tiling == 0) {
                Draw.rect((TextureRegion)PressureLiquidPump.this.topRegion, (float)this.x, (float)this.y, (float)this.rotdeg());
            }
        }

        @Nullable
        public HasPressure getFrom() {
            PressureLiquidPumpBuild last = this;
            HasPressure out = (HasPressure)this.back();
            while (out instanceof PressureLiquidPumpBuild) {
                PressureLiquidPumpBuild pump = (PressureLiquidPumpBuild)out;
                if (!HasPressure.connects(pump, last)) {
                    return null;
                }
                last = pump;
                out = (HasPressure)pump.back();
            }
            return out != null && HasPressure.connects(out, last) ? out : null;
        }

        @Nullable
        public HasPressure getTo() {
            PressureLiquidPumpBuild last = this;
            HasPressure out = (HasPressure)this.front();
            while (out instanceof PressureLiquidPumpBuild) {
                PressureLiquidPumpBuild pump = (PressureLiquidPumpBuild)out;
                if (!HasPressure.connects(pump, last)) {
                    return null;
                }
                last = pump;
                out = (HasPressure)pump.front();
            }
            return out != null && HasPressure.connects(out, last) ? out : null;
        }

        @Override
        public void onPressureGraphUpdate() {
            HasPressure back;
            HasPressure front;
            this.tiling = 0;
            Building building = this.front();
            if (building instanceof HasPressure && HasPressure.connects(this, front = (HasPressure)building)) {
                this.tiling |= 1;
            }
            if ((building = this.back()) instanceof HasPressure && HasPressure.connects(this, back = (HasPressure)building)) {
                this.tiling |= 2;
            }
        }

        @Override
        public boolean outputsFluid(HasPressure to, @Nullable Liquid liquid, float amount) {
            return false;
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.smoothAlpha = read.f();
        }

        public boolean shouldAmbientSound() {
            return this.functioning;
        }

        public void updateTile() {
            if (this.efficiency > 0.0f) {
                HasPressure front = this.getTo();
                HasPressure back = this.getFrom();
                Liquid pumpLiquid = back == null ? null : back.pressure().getMain();
                float frontPressure = front == null ? 0.0f : front.getPressure(pumpLiquid);
                float backPressure = back == null ? 0.0f : back.getPressure(pumpLiquid);
                float maxFlow = -Physics.fluidFlow(backPressure + PressureLiquidPump.this.pressureDifference * (float)this.chainSize(), back == null ? 8.0f : back.pressureConfig().fluidCapacity, frontPressure, front == null ? 8.0f : front.pressureConfig().fluidCapacity, OlLiquids.getDensity(pumpLiquid), 1.0f, 1.0f);
                float flow = Mathf.clamp((float)((maxFlow > 0.0f ? PressureLiquidPump.this.pumpStrength : -PressureLiquidPump.this.pumpStrength) / (float)this.chainSize() * Time.delta), (float)(-Math.abs(maxFlow)), (float)Math.abs(maxFlow));
                if (front == null || back == null || front.acceptsFluid(back, pumpLiquid, flow) && back.outputsFluid(front, pumpLiquid, flow)) {
                    if (front != null) {
                        front.addFluid(pumpLiquid, flow);
                    } else if (pumpLiquid != null && flow > 0.0f) {
                        Puddles.deposit((Tile)this.tile.nearby(this.rotation), (Tile)this.tile, (Liquid)pumpLiquid, (float)flow);
                    }
                    if (back != null) {
                        back.removeFluid(pumpLiquid, flow);
                    } else if (pumpLiquid != null && flow < 0.0f) {
                        Puddles.deposit((Tile)this.tile.nearby((this.rotation + 2) % 4), (Tile)this.tile, (Liquid)pumpLiquid, (float)(-flow));
                    }
                }
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.smoothAlpha);
        }
    }
}

