/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world.blocks.distribution;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;
import omaloon.world.GenericPressureBlock;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureTank;

public class PressureLiquidConduit
extends GenericPressureBlock {
    public TextureRegion bottomRegion;
    public TextureRegion[] topRegions;
    public TextureRegion[][] liquidRegions;
    public float liquidPadding = 3.0f;
    public float smoothAlphaSpeed = 0.014f;
    @Nullable
    public Block junctionReplacement;
    @Nullable
    public Block bridgeReplacement;

    public PressureLiquidConduit(String name) {
        super(name);
        this.rotate = true;
        this.destructible = true;
        this.update = true;
        this.canOverdrive = false;
        this.group = BlockGroup.liquids;
    }

    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-bottom", "omaloon-liquid-bottom"), Core.atlas.find(this.name + "-0")};
    }

    @Override
    public void init() {
        this.pressureConfig.outputsPressure = true;
        this.pressureConfig.acceptsPressure = true;
        this.pressureConfig.hasPressure = true;
        super.init();
        if (this.hasLiquids) {
            this.hasLiquids = false;
        }
        if (this.pressureConfig.group == null) {
            this.pressureConfig.group = PressureTank.TankGroup.transportation;
        }
    }

    public void load() {
        super.load();
        this.liquidRegions = new TextureRegion[2][50];
        if (Vars.renderer != null) {
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int fluid = 0; fluid < 2; ++fluid) {
                for (int frame = 0; frame < 50; ++frame) {
                    TextureRegion base = frames[fluid][frame];
                    TextureRegion result = new TextureRegion();
                    result.set(base);
                    result.setHeight((float)result.height - this.liquidPadding);
                    result.setWidth((float)result.width - this.liquidPadding);
                    result.setX((float)result.getX() + this.liquidPadding);
                    result.setY((float)result.getY() + this.liquidPadding);
                    this.liquidRegions[fluid][frame] = result;
                }
            }
        }
    }

    public class PressureLiquidConduitBuild
    extends GenericPressureBlock.GenericPressureBlockBuild {
        public int tiling = 0;
        public float smoothAlpha;

        @Override
        public boolean connects(HasPressure to) {
            return super.connects(to) && (!(to instanceof PressureLiquidConduitBuild) || to == this.front() || to == this.back() || this == to.toBuilding().front() || this == to.toBuilding().back());
        }

        public void draw() {
            Draw.rect((TextureRegion)PressureLiquidConduit.this.bottomRegion, (float)this.x, (float)this.y);
            Liquid main = this.pressure.getMain();
            this.smoothAlpha = Mathf.approachDelta((float)this.smoothAlpha, (float)(main == null ? 0.0f : this.getFluid(main) / (this.getFluid(main) + this.getFluid(null))), (float)PressureLiquidConduit.this.smoothAlphaSpeed);
            if (this.smoothAlpha > 0.001f && main != null) {
                int frame = main.getAnimationFrame();
                int gas = main.gas ? 1 : 0;
                float xscl = Draw.xscl;
                float yscl = Draw.yscl;
                Draw.scl((float)1.0f, (float)1.0f);
                Drawf.liquid((TextureRegion)PressureLiquidConduit.this.liquidRegions[gas][frame], (float)this.x, (float)this.y, (float)Mathf.clamp((float)this.smoothAlpha), (Color)main.color.write(Tmp.c1).a(1.0f));
                Draw.scl((float)xscl, (float)yscl);
            }
            Draw.rect((TextureRegion)PressureLiquidConduit.this.topRegions[this.tiling], (float)this.x, (float)this.y, (float)(this.tiling != 0 ? 0.0f : (this.rotdeg() + 90.0f) % 180.0f - 90.0f));
        }

        @Override
        public void onPressureGraphUpdate() {
            this.tiling = 0;
            for (int i = 0; i < 4; ++i) {
                HasPressure build;
                HasPressure hasPressure = build = this.nearby(i) instanceof HasPressure ? (HasPressure)this.nearby(i) : null;
                if (build == null || !HasPressure.connects(this, build)) continue;
                this.tiling |= 1 << i;
            }
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.smoothAlpha = read.f();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.smoothAlpha);
        }
    }
}

