/*
 * Decompiled with CFR 0.152.
 */
package omaloon.world;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.world.Block;
import omaloon.world.graph.PressureGraph;
import omaloon.world.interfaces.HasPressure;
import omaloon.world.meta.PressureConfig;
import omaloon.world.modules.PressureModule;

public class GenericPressureBlock
extends Block {
    public PressureConfig pressureConfig = new PressureConfig();

    public GenericPressureBlock(String name) {
        super(name);
    }

    public void init() {
        super.init();
        if (this.hasLiquids) {
            this.hasLiquids = false;
            this.pressureConfig.hasPressure = true;
        }
    }

    public void setBars() {
        super.setBars();
        this.pressureConfig.addBars(this);
    }

    public void setStats() {
        super.setStats();
        this.pressureConfig.addStats(this, this.stats);
    }

    public class GenericPressureBlockBuild
    extends Building
    implements HasPressure {
        public PressureModule pressure;

        public Building create(Block block, Team team) {
            super.create(block, team);
            if (this.pressureConfig().hasPressure) {
                this.pressure = new PressureModule();
                this.pressureGraph().addRaw(this);
            }
            return this;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            if (GenericPressureBlock.this.pressureConfig.hasPressure) {
                new PressureGraph().floodMergeGraph(this);
            }
        }

        @Override
        public PressureModule pressure() {
            return this.pressure;
        }

        @Override
        public PressureConfig pressureConfig() {
            return GenericPressureBlock.this.pressureConfig;
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (GenericPressureBlock.this.pressureConfig.hasPressure) {
                this.pressure.read(read);
            }
        }

        public void write(Writes write) {
            super.write(write);
            if (GenericPressureBlock.this.pressureConfig.hasPressure) {
                this.pressure.write(write);
            }
        }
    }
}

