/*
 * Decompiled with CFR 0.152.
 */
package omaloon.utils;

import arc.Core;
import arc.func.Floatc;
import arc.func.Intc2;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.struct.IntSet;
import org.jetbrains.annotations.Contract;

public class OlUtils {
    public static float angleDistSigned(float a, float b) {
        a += 360.0f;
        b += 360.0f;
        float d = Math.abs((a %= 360.0f) - (b %= 360.0f)) % 360.0f;
        int sign = a - b >= 0.0f && a - b <= 180.0f || a - b <= -180.0f && a - b >= -360.0f ? 1 : -1;
        return (d > 180.0f ? 360.0f - d : d) * (float)sign;
    }

    public static float angleDistSigned(float a, float b, float start) {
        float dst = OlUtils.angleDistSigned(a, b);
        if (Math.abs(dst) > start) {
            return dst > 0.0f ? dst - start : dst + start;
        }
        return 0.0f;
    }

    public static float angleDist(float a, float b) {
        float d = Math.abs(a - b) % 360.0f;
        return d > 180.0f ? 360.0f - d : d;
    }

    public static void shotgun(int points, float spacing, float offset, Floatc cons) {
        for (int i = 0; i < points; ++i) {
            cons.get((float)i * spacing - (float)(points - 1) * spacing / 2.0f + offset);
        }
    }

    public static float clampedAngle(float angle, float relative, float limit) {
        if (limit >= 180.0f) {
            return angle;
        }
        if (limit <= 0.0f) {
            return relative;
        }
        float dst = OlUtils.angleDistSigned(angle, relative);
        if (Math.abs(dst) > limit) {
            float val = dst > 0.0f ? dst - limit : dst + limit;
            return (angle - val) % 360.0f;
        }
        return angle;
    }

    @Contract(pure=true)
    public static int reverse(int rotation) {
        int n;
        switch (rotation) {
            case 0: {
                n = 2;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + rotation);
            }
        }
        return n;
    }

    public static int getByIndex(IntSet intSet, int index) {
        if (index < 0 || index >= intSet.size) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for IntSet of size " + intSet.size);
        }
        int counter = 0;
        IntSet.IntSetIterator iterator = intSet.iterator();
        while (iterator.hasNext) {
            int item = iterator.next();
            if (counter == index) {
                return item;
            }
            ++counter;
        }
        throw new IllegalArgumentException("Index out of range for IntSet.");
    }

    public static TextureRegion[][] splitLayers(String name, int size, int layerCount) {
        TextureRegion[][] layers = new TextureRegion[layerCount][];
        for (int i = 0; i < layerCount; ++i) {
            layers[i] = OlUtils.split(name, size, i);
        }
        return layers;
    }

    public static TextureRegion[] split(String name, int size, int layer) {
        TextureAtlas.AtlasRegion tex = Core.atlas.find(name);
        int margin = 0;
        int countX = tex.width / size;
        TextureRegion[] tiles = new TextureRegion[countX];
        for (int step = 0; step < countX; ++step) {
            tiles[step] = new TextureRegion((TextureRegion)tex, step * (margin + size), layer * (margin + size), size, size);
        }
        return tiles;
    }

    public static void readTexturePixels(PixmapRegion pixmap, Intc2 cons) {
        for (int j = 0; j < pixmap.height; ++j) {
            for (int i = 0; i < pixmap.width; ++i) {
                cons.get(pixmap.get(i, j), i + pixmap.width * (pixmap.height - 1 - j));
            }
        }
    }
}

