/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.elements;

import arc.Core;
import arc.func.Floatp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.ui.layout.Scl;
import arc.util.pooling.Pools;
import mindustry.gen.Tex;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;

public class CenterBar
extends Bar {
    private Floatp fraction;
    private CharSequence name = "";
    private float value;
    private float lastValue;
    private float blink;
    private float outlineRadius;
    private Color blinkColor = new Color();
    private Color outlineColor = new Color();

    public CenterBar(String name, Color color, Floatp fraction) {
        this.fraction = fraction;
        this.name = Core.bundle.get(name, name);
        this.blinkColor.set(color);
        this.lastValue = this.value = fraction.get();
        this.setColor(color);
    }

    public CenterBar(Prov<CharSequence> name, Prov<Color> color, Floatp fraction) {
        this.fraction = fraction;
        this.lastValue = this.value = Mathf.clamp((float)fraction.get());
        this.update(() -> {
            this.name = (CharSequence)name.get();
            this.blinkColor.set((Color)color.get());
            this.setColor((Color)color.get());
        });
    }

    public CenterBar() {
    }

    public void reset(float value) {
        this.lastValue = this.blink = value;
        this.value = this.blink;
    }

    public void set(Prov<String> name, Floatp fraction, Color color) {
        this.fraction = fraction;
        this.lastValue = fraction.get();
        this.blinkColor.set(color);
        this.setColor(color);
        this.update(() -> {
            this.name = (CharSequence)name.get();
        });
    }

    public void snap() {
        this.lastValue = this.value = this.fraction.get();
    }

    public Bar outline(Color color, float stroke) {
        this.outlineColor.set(color);
        this.outlineRadius = Scl.scl((float)stroke);
        return this;
    }

    public void flash() {
        this.blink = 1.0f;
    }

    public Bar blink(Color color) {
        this.blinkColor.set(color);
        return this;
    }

    public void draw() {
        if (this.fraction == null) {
            return;
        }
        float computed = Mathf.clamp((float)this.fraction.get(), (float)-1.0f, (float)1.0f);
        if (this.lastValue > computed) {
            this.blink = 1.0f;
            this.lastValue = computed;
        }
        if (Float.isNaN(this.lastValue)) {
            this.lastValue = 0.0f;
        }
        if (Float.isInfinite(this.lastValue)) {
            this.lastValue = 1.0f;
        }
        if (Float.isNaN(this.value)) {
            this.value = 0.0f;
        }
        if (Float.isInfinite(this.value)) {
            this.value = 1.0f;
        }
        if (Float.isNaN(computed)) {
            computed = 0.0f;
        }
        if (Float.isInfinite(computed)) {
            computed = 1.0f;
        }
        this.blink = Mathf.lerpDelta((float)this.blink, (float)0.0f, (float)0.2f);
        this.value = Mathf.lerpDelta((float)this.value, (float)computed, (float)0.15f);
        Drawable bar = Tex.bar;
        if (this.outlineRadius > 0.0f) {
            Draw.color((Color)this.outlineColor);
            bar.draw(this.x - this.outlineRadius, this.y - this.outlineRadius, this.width + this.outlineRadius * 2.0f, this.height + this.outlineRadius * 2.0f);
        }
        Draw.colorl((float)0.1f);
        Draw.alpha((float)this.parentAlpha);
        bar.draw(this.x, this.y, this.width, this.height);
        Draw.color((Color)this.color, (Color)this.blinkColor, (float)this.blink);
        Draw.alpha((float)this.parentAlpha);
        Drawable top = Tex.barTop;
        top.draw(this.x + (this.width / 2.0f - (float)Core.atlas.find((String)"bar-top").width / 2.0f) * (Math.min(this.value, 0.0f) + 1.0f), this.y, (float)Core.atlas.find((String)"bar-top").width + ((float)(-Core.atlas.find((String)"bar-top").width) / 2.0f + this.width / 2.0f) * Math.abs(this.value), this.height);
        Draw.color();
        Font font = Fonts.outline;
        GlyphLayout lay = (GlyphLayout)Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        lay.setText(font, this.name);
        font.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        font.getCache().clear();
        font.getCache().addText(this.name, this.x + this.width / 2.0f - lay.width / 2.0f, this.y + this.height / 2.0f + lay.height / 2.0f + 1.0f);
        font.getCache().draw(this.parentAlpha);
        Pools.free((Object)lay);
    }
}

