/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui.dialogs;

import arc.Application;
import arc.Core;
import arc.files.Fi;
import arc.input.KeyCode;
import arc.scene.style.Drawable;
import arc.scene.ui.Label;
import arc.util.Http;
import arc.util.io.Streams;
import arc.util.serialization.Jval;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.mod.Mods;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.fragments.LoadingFragment;

public class UpdateDialog {
    public static final String repo = "stabu-dev/Omaloon";
    public static Mods.LoadedMod mod = Vars.mods.locateMod("omaloon");
    public static String url = "https://api.github.com/repos/stabu-dev/Omaloon/releases/latest";
    public static String changes = "https://github.com/stabu-dev/Omaloon/releases/latest";
    public static float progress;
    public static String download;

    public static void check() {
        if (!Core.settings.getBool("omaloon-check-updates", true)) {
            return;
        }
        Http.get((String)url, res -> {
            Jval json = Jval.read((String)res.getResultAsString());
            String latest = json.getString("tag_name").substring(1);
            download = ((Jval)json.get("assets").asArray().get(0)).getString("browser_download_url");
            if (!latest.equals(UpdateDialog.mod.meta.version)) {
                BaseDialog dialog = new BaseDialog("@dialog.omaloon-updater.tile");
                ((Label)dialog.cont.add((CharSequence)Core.bundle.format("dialog.omaloon-updater", new Object[]{UpdateDialog.mod.meta.version, latest})).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get()).setAlignment(1, 1);
                dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
                dialog.setFillParent(false);
                dialog.buttons.button("@button.omaloon-ignore", (Drawable)Icon.cancel, () -> ((BaseDialog)dialog).hide());
                dialog.buttons.button("@button.omaloon-updater-show-changes", (Drawable)Icon.link, () -> {
                    if (!Core.app.openURI(changes)) {
                        Vars.ui.showInfoFade("@linkfail");
                        Core.app.setClipboardText(changes);
                    }
                });
                dialog.buttons.button("@button.omaloon-install-update", (Drawable)Icon.download, UpdateDialog::update);
                dialog.keyDown(KeyCode.escape, () -> ((BaseDialog)dialog).hide());
                dialog.keyDown(KeyCode.back, () -> ((BaseDialog)dialog).hide());
                Core.app.post(() -> ((BaseDialog)dialog).show());
            }
        });
    }

    public static void update() {
        try {
            ClassLoader classLoader = UpdateDialog.mod.loader;
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader cl = (URLClassLoader)classLoader;
                cl.close();
            }
            UpdateDialog.mod.loader = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vars.ui.loadfrag.show("@downloading");
        Vars.ui.loadfrag.setProgress(() -> progress);
        Http.get((String)download, UpdateDialog::handle);
    }

    public static void handle(Http.HttpResponse res) {
        try {
            Fi file = Vars.tmpDirectory.child(repo.replace("/", "") + ".zip");
            Streams.copyProgress((InputStream)res.getResultAsStream(), (OutputStream)file.write(false), (long)res.getContentLength(), (int)4096, p -> {
                progress = p;
            });
            Vars.mods.importMod(file).setRepo(repo);
            file.delete();
            Core.app.post(() -> ((LoadingFragment)Vars.ui.loadfrag).hide());
            Vars.ui.showInfoOnHidden("@mods.reloadexit", () -> ((Application)Core.app).exit());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

