/*
 * Decompiled with CFR 0.152.
 */
package omaloon.ui;

import arc.ApplicationListener;
import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.ui.layout.Scl;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Time;
import arc.util.Tmp;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.graphics.Pal;
import mindustry.mod.Mods;
import omaloon.OmaloonMod;

public class SplashDrawer
implements ApplicationListener,
Disposable {
    private final Texture iconTex;
    private final TextureRegion icon;
    private final String version;
    private final long startTime;
    private Font font;
    private boolean fadingOut = false;
    private long fadeOutStartTime;

    public SplashDrawer(Mods.LoadedMod mod) {
        this.version = mod.meta.version;
        try (InputStream iconStream = OmaloonMod.class.getResourceAsStream("/sprites/ui/splash-icon.png");){
            if (iconStream == null) {
                throw new IOException("Splash screen image stream was null. Check asset packaging.");
            }
            byte[] iconBytes = this.readStream(iconStream);
            Pixmap iconPixmap = new Pixmap(iconBytes);
            this.iconTex = new Texture(iconPixmap);
            iconPixmap.dispose();
            this.icon = new TextureRegion(this.iconTex);
            this.startTime = Time.millis();
        }
        catch (Exception e) {
            Log.err((String)"Failed to load Omaloon splash screen images.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void add(Mods.LoadedMod mod) {
        if (SplashDrawer.isEnabled()) {
            Core.app.addListener((ApplicationListener)new SplashDrawer(mod));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEnabled() {
        try {
            Fi file = Core.settings.getSettingsFile();
            if (!file.exists()) {
                return true;
            }
            byte[] header = new byte[2];
            file.readBytes(header, 0, 2);
            boolean compressed = header[0] == 120;
            try (DataInputStream stream = new DataInputStream(compressed ? new InflaterInputStream(file.read()) : file.read());){
                int amount = stream.readInt();
                int i = 0;
                while (i < amount) {
                    String key = stream.readUTF();
                    byte type = stream.readByte();
                    if (key.equals("omaloon-loading-screen")) {
                        if (type == 0) {
                            boolean bl = stream.readBoolean();
                            return bl;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    switch (type) {
                        case 0: {
                            stream.skipBytes(1);
                            break;
                        }
                        case 1: 
                        case 3: {
                            stream.skipBytes(4);
                            break;
                        }
                        case 2: {
                            stream.skipBytes(8);
                            break;
                        }
                        case 4: {
                            stream.skipBytes(stream.readUnsignedShort());
                            break;
                        }
                        case 5: {
                            stream.skipBytes(stream.readInt());
                            break;
                        }
                    }
                    ++i;
                }
                return true;
            }
        }
        catch (Exception e) {
            return true;
        }
    }

    private byte[] readStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private void draw() {
        float backgroundAlpha;
        float elementsAlpha;
        if (this.fadingOut && (float)Time.timeSinceMillis((long)this.fadeOutStartTime) >= 900.0f) {
            this.dispose();
            return;
        }
        if (Vars.clientLoaded && !this.fadingOut) {
            this.fadingOut = true;
            this.fadeOutStartTime = Time.millis();
        }
        if (this.fadingOut) {
            float elapsed = (float)Time.timeSinceMillis((long)this.fadeOutStartTime) / 1000.0f;
            float uiFadeDuration = 0.3f;
            float holdDuration = 0.2f;
            float backgroundFadeDelay = uiFadeDuration + holdDuration;
            float backgroundFadeDuration = 0.4f;
            elementsAlpha = 1.0f - Interp.fade.apply(Math.min(elapsed / uiFadeDuration, 1.0f));
            backgroundAlpha = 1.0f;
            if (elapsed > backgroundFadeDelay) {
                float fadeProgress = (elapsed - backgroundFadeDelay) / backgroundFadeDuration;
                backgroundAlpha = 1.0f - Interp.fade.apply(Math.min(fadeProgress, 1.0f));
            }
        } else {
            float time = (float)Time.timeSinceMillis((long)this.startTime) / 1000.0f;
            backgroundAlpha = Interp.fade.apply(Math.min(time / 0.15f, 1.0f));
            elementsAlpha = Interp.fade.apply(Math.min(time / 0.4f, 1.0f));
        }
        if (this.font == null && Core.assets.isLoaded("tech")) {
            this.font = (Font)Core.assets.get("tech");
        }
        Draw.color((Color)Pal.darkestGray, (float)backgroundAlpha);
        Fill.rect((float)((float)Core.graphics.getWidth() / 2.0f), (float)((float)Core.graphics.getHeight() / 2.0f), (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
        Draw.proj().setOrtho(0.0f, 0.0f, (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
        float progress = Core.assets.getProgress();
        float w = Core.graphics.getWidth();
        float h = Core.graphics.getHeight();
        Draw.color((Color)Color.black, (float)backgroundAlpha);
        Fill.poly((float)(w / 2.0f), (float)(h / 2.0f), (int)6, (float)(Mathf.dst((float)w, (float)h) / 2.0f * progress * 1.3f));
        Draw.reset();
        if (elementsAlpha > 0.001f) {
            float scaledIconSize = 256.0f * Scl.scl();
            Draw.color((Color)Color.white, (float)elementsAlpha);
            Draw.rect((TextureRegion)this.icon, (float)(w / 2.0f), (float)(h / 2.0f), (float)scaledIconSize, (float)scaledIconSize);
            if (this.font != null) {
                this.font.getData().setScale(1.0f);
                this.font.setColor(Tmp.c1.set(Pal.darkerGray).a(elementsAlpha));
                this.font.draw((CharSequence)this.version, w / 2.0f, h / 2.0f - scaledIconSize / 2.0f - Scl.scl((float)20.0f), 0.0f, 1, false);
            }
            float barHeight = 32.0f * Scl.scl();
            float barCenterX = w / 2.0f;
            float barCenterY = 40.0f * Scl.scl() + barHeight / 2.0f;
            float barWidth = w * 0.6f;
            Draw.color((Color)Color.white, (float)elementsAlpha);
            float stroke = 3.0f * Scl.scl();
            Lines.stroke((float)stroke);
            Lines.rect((float)(barCenterX - barWidth / 2.0f), (float)(barCenterY - barHeight / 2.0f), (float)barWidth, (float)barHeight);
            float fillPadding = 2.0f * Scl.scl();
            float maxFillWidth = barWidth - stroke * 2.0f - fillPadding * 2.0f;
            float fillHeight = barHeight - stroke * 2.0f - fillPadding * 2.0f;
            float fillWidth = maxFillWidth * progress;
            if (fillWidth > 0.0f && fillHeight > 0.0f) {
                float fillStartX = barCenterX - barWidth / 2.0f + stroke + fillPadding;
                Fill.rect((float)(fillStartX + fillWidth / 2.0f), (float)barCenterY, (float)fillWidth, (float)fillHeight);
                if (this.font != null) {
                    int percentage = (int)(progress * 100.0f);
                    this.font.setColor(Tmp.c1.set(Pal.darkestGray).a(elementsAlpha));
                    this.font.draw((CharSequence)(percentage + "%"), barCenterX, barCenterY + this.font.getCapHeight() / 2.0f, 0.0f, 1, false);
                }
            }
        }
        Draw.flush();
    }

    public void dispose() {
        this.iconTex.dispose();
    }

    public void update() {
        this.draw();
    }
}

