/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type.shape;

import arc.Core;
import arc.func.Intc2;
import arc.graphics.g2d.PixmapRegion;
import arc.util.Log;
import omaloon.struct.BitWordList;
import omaloon.type.shape.Shape;
import omaloon.utils.OlUtils;

public class CustomPatternShape
extends Shape {
    public final String maskName;
    private int width = 1;
    private int height = 1;
    private BitWordList blocks;
    private boolean built = false;

    public CustomPatternShape(String maskName) {
        this.maskName = maskName;
        this.blocks = new BitWordList(1, BitWordList.WordLength.two);
        this.blocks.set(0, (byte)1);
    }

    @Override
    public void load() {
        if (this.built) {
            return;
        }
        PixmapRegion pixmap = Core.atlas.getPixmap(Core.atlas.find(this.maskName));
        if (pixmap == null) {
            Log.err((String)"Pixmap for CustomPatternShape is null for mask: @", (Object[])new Object[]{this.maskName});
            return;
        }
        this.width = pixmap.width;
        this.height = pixmap.height;
        this.blocks = new BitWordList(this.width * this.height, BitWordList.WordLength.two);
        OlUtils.readTexturePixels(pixmap, (color, index) -> {
            switch (color) {
                case 2815: {
                    this.blocks.set(index, (byte)3);
                    break;
                }
                case 255: {
                    this.blocks.set(index, (byte)2);
                    break;
                }
                default: {
                    this.blocks.set(index, (byte)1);
                }
            }
        });
        this.built = true;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public boolean get(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return false;
        }
        byte id = this.blocks.get(x + y * this.width);
        return id == 2 || id == 3;
    }

    @Override
    public void each(Intc2 consumer) {
        for (int i = 0; i < this.blocks.initialWordsAmount; ++i) {
            byte id = this.blocks.get(i);
            if (id != 2 && id != 3) continue;
            consumer.get(i % this.width, i / this.width);
        }
    }
}

