/*
 * Decompiled with CFR 0.152.
 */
package omaloon.type.customshape;

import arc.func.Intc2;
import omaloon.struct.BitWordList;

public class CustomShape {
    public final int width;
    public final int height;
    public BitWordList blocks;
    int centerX;
    int centerY;

    public CustomShape(int width, int height, BitWordList blocks) {
        this.blocks = blocks;
        this.width = width;
        this.height = height;
        this.findCenter();
    }

    public int centerX() {
        return this.centerX;
    }

    public int centerY() {
        return this.centerY;
    }

    public void findCenter() {
        for (int i = 0; i < this.blocks.initialWordsAmount; ++i) {
            if (this.blocks.get(i) != 3) continue;
            this.centerX = this.unpackX(i);
            this.centerY = this.unpackY(i);
            return;
        }
        throw new RuntimeException("Cannot find center");
    }

    public int unpackX(int index) {
        return index % this.width;
    }

    public int unpackY(int index) {
        return index / this.width;
    }

    public int getId(int x, int y) {
        return this.blocks.get(x + y * this.width);
    }

    public void eachRelativeCenter(Intc2 consumer) {
        for (int i = 0; i < this.blocks.initialWordsAmount; ++i) {
            consumer.get(this.unpackX(i) - this.centerX, this.unpackY(i) - this.centerY);
        }
    }

    public int getIdRelativeCenter(int x, int y) {
        return this.getId(x + this.centerX, y + this.centerY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomShape)) {
            return false;
        }
        CustomShape shape = (CustomShape)obj;
        return this.width == shape.width && this.height == shape.height && this.blocks.equals(shape.blocks);
    }
}

