/*
 * Decompiled with CFR 0.152.
 */
package omaloon.struct;

public class BitWordList {
    public final int initialWordsAmount;
    final byte wordLen;
    final short wordMask;
    long[] bits = new long[]{0L};

    public BitWordList(int nwords, WordLength wordLen) {
        this.checkCapacity(nwords * wordLen.value >>> 6);
        this.initialWordsAmount = nwords;
        this.wordLen = wordLen.value;
        this.wordMask = (short)(~(-2 << wordLen.value - 1));
    }

    public void set(BitWordList other) {
        int length = Math.min(this.bits.length, other.bits.length);
        System.arraycopy(other.bits, 0, this.bits, 0, length);
    }

    public byte get(int index) {
        int wordPosition = index * this.wordLen >>> 6;
        if (wordPosition >= this.bits.length) {
            throw new IndexOutOfBoundsException();
        }
        index = index * this.wordLen & 0x3F;
        return (byte)(this.bits[wordPosition] >>> index & (long)this.wordMask);
    }

    public void set(int index, byte number) {
        int wordIndex = index * this.wordLen >>> 6;
        index = index * this.wordLen & 0x3F;
        number = (byte)(number & this.wordMask);
        this.checkCapacity(wordIndex);
        int n = wordIndex;
        this.bits[n] = this.bits[n] & ((long)this.wordMask << index ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = wordIndex;
        this.bits[n2] = this.bits[n2] | (long)number << index;
    }

    private void checkCapacity(int len) {
        if (len >= this.bits.length) {
            long[] newBits = new long[len + 1];
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public void clear() {
        long[] bits = this.bits;
        int length = bits.length;
        for (int i = 0; i < length; ++i) {
            bits[i] = 0L;
        }
    }

    public int size() {
        return this.bits.length << 6 / this.wordLen;
    }

    public int nonZeroLength() {
        long[] bits = this.bits;
        for (int word = bits.length - 1; word >= 0; --word) {
            long bitsAtWord = bits[word];
            if (bitsAtWord == 0L) continue;
            for (int bit = 63; bit >= 0; bit -= this.wordLen) {
                if ((bitsAtWord & (long)this.wordMask << bit) == 0L) continue;
                return ((word << 6) + bit + 1) / this.wordLen;
            }
        }
        return 0;
    }

    public boolean isEmpty() {
        long[] bits = this.bits;
        int length = bits.length;
        for (int i = 0; i < length; ++i) {
            if (bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int word = this.nonZeroLength() >>> 6;
        int hash = 0;
        for (int i = 0; word >= i; ++i) {
            hash = 127 * hash + (int)(this.bits[i] ^ this.bits[i] >>> 32);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitWordList other = (BitWordList)obj;
        long[] otherBits = other.bits;
        int commonWords = Math.min(this.bits.length, otherBits.length);
        for (int i = 0; commonWords > i; ++i) {
            if (this.bits[i] == otherBits[i]) continue;
            return false;
        }
        if (this.bits.length == otherBits.length) {
            return true;
        }
        return this.nonZeroLength() == other.nonZeroLength();
    }

    public static enum WordLength {
        two(2),
        four(4);

        public final byte value;

        private WordLength(int value) {
            this.value = (byte)value;
        }
    }
}

