/*
 * Decompiled with CFR 0.152.
 */
package omaloon.graphics;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.GLVersion;
import arc.graphics.gl.Shader;
import arc.math.geom.Vec3;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Shaders;
import mindustry.type.Planet;
import omaloon.graphics.shaders.DepthAtmosphereShader;
import omaloon.graphics.shaders.DepthShader;

public class OlShaders {
    public static DepthShader depth;
    public static DepthAtmosphereShader depthAtmosphere;
    @Nullable
    public static SurfaceShader glacium;
    public static CacheLayer.ShaderLayer glaciumLayer;
    public static PlanetTextureShader planetTextureShader;

    public static void load() {
        String prevVert = Shader.prependVertexCode;
        String prevFrag = Shader.prependFragmentCode;
        Shader.prependFragmentCode = "";
        Shader.prependVertexCode = "";
        if (Core.graphics.getGLVersion().type == GLVersion.GlType.OpenGL) {
            Shader.prependFragmentCode = "#define HAS_GL_FRAGDEPTH\n";
        }
        depth = new DepthShader();
        depthAtmosphere = new DepthAtmosphereShader();
        glacium = new SurfaceShader("glacium");
        glaciumLayer = new CacheLayer.ShaderLayer((Shader)glacium);
        CacheLayer.add((CacheLayer[])new CacheLayer[]{glaciumLayer});
        planetTextureShader = new PlanetTextureShader();
        Shader.prependVertexCode = prevVert;
        Shader.prependFragmentCode = prevFrag;
    }

    public static void dispose() {
        if (!Vars.headless) {
            glacium.dispose();
        }
    }

    public static Fi file(String name) {
        return Vars.tree.get("shaders/" + name);
    }

    public static class SurfaceShader
    extends Shader {
        Texture noiseTex;

        public SurfaceShader(String frag) {
            super(Shaders.getShaderFi((String)"screenspace.vert"), Vars.tree.get("shaders/" + frag + ".frag"));
            this.loadNoise();
        }

        public String textureName() {
            return "noise";
        }

        public void loadNoise() {
            Core.assets.load((String)new StringBuilder().append((String)"sprites/").append((String)this.textureName()).append((String)".png").toString(), Texture.class).loaded = t -> {
                t.setFilter(Texture.TextureFilter.linear);
                t.setWrap(Texture.TextureWrap.repeat);
            };
        }

        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_ccampos", Core.camera.position);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_rresolution", Core.graphics.getWidth(), Core.graphics.getHeight());
            this.setUniformf("u_time", Time.time);
            if (this.hasUniform("u_noise")) {
                if (this.noiseTex == null) {
                    this.noiseTex = (Texture)Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                }
                this.noiseTex.bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise", 1);
            }
        }
    }

    public static class PlanetTextureShader
    extends OlLoadShader {
        public Vec3 lightDir = new Vec3(1.0f, 1.0f, 1.0f).nor();
        public Color ambientColor = Color.white.cpy();
        public Vec3 camDir = new Vec3();
        public float alpha = 1.0f;
        public Planet planet;

        public PlanetTextureShader() {
            super("circle-mesh", "circle-mesh");
        }

        @Override
        public void apply() {
            this.camDir.set(Vars.renderer.planets.cam.direction).rotate(Vec3.Y, this.planet.getRotation());
            this.setUniformf("u_alpha", this.alpha);
            this.setUniformf("u_lightdir", this.lightDir);
            this.setUniformf("u_ambientColor", this.ambientColor.r, this.ambientColor.g, this.ambientColor.b);
            this.setPlanetInfo("u_sun_info", this.planet.solarSystem);
            this.setPlanetInfo("u_planet_info", this.planet);
            this.setUniformf("u_camdir", this.camDir);
            this.setUniformf("u_campos", Vars.renderer.planets.cam.position);
        }

        private void setPlanetInfo(String name, Planet planet) {
            Vec3 position = planet.position;
            PlanetTextureShader shader = this;
            shader.setUniformf(name, position.x, position.y, position.z, planet.radius);
        }
    }

    public static class OlLoadShader
    extends Shader {
        public OlLoadShader(String fragment, String vertex) {
            super(OlShaders.file(vertex + ".vert"), OlShaders.file(fragment + ".frag"));
        }

        public void set() {
            Draw.shader((Shader)this);
        }

        public void apply() {
            super.apply();
            this.setUniformf("u_time_millis", (float)System.currentTimeMillis() / 1000.0f * 60.0f);
        }
    }
}

