/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content.blocks;

import arc.graphics.Color;
import arc.math.geom.Vec2;
import mindustry.content.Items;
import mindustry.gen.Sounds;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.environment.Prop;
import mindustry.world.blocks.environment.StaticWall;
import omaloon.content.OlItems;
import omaloon.content.OlLiquids;
import omaloon.content.OlStatusEffects;
import omaloon.gen.OlSounds;
import omaloon.graphics.OlShaders;
import omaloon.type.shape.CustomPatternShape;
import omaloon.type.shape.RectanglePatternShape;
import omaloon.world.blocks.environment.Cliff;
import omaloon.world.blocks.environment.CliffHelper;
import omaloon.world.blocks.environment.PatternedFloor;
import omaloon.world.blocks.environment.RotatedProp;
import omaloon.world.blocks.environment.customsshapeproop.CustomShapeProp;

public class OlEnvironmentBlocks {
    public static Block cliff;
    public static Block cliffHelper;
    public static Block oreCobalt;
    public static Block oreNickel;
    public static Block oreCoal;
    public static Block glasmoreMetal;
    public static Block glasmoreMetalPlus;
    public static Block gerbRemains;
    public static Block ruinedTiles;
    public static Block ruinedMasonry;
    public static Block ruinedWall;
    public static Block deadShrub;
    public static Block deadSpikeTree;
    public static Block deadBushTree;
    public static Block fallenDeadTree;
    public static Block fallenDeadTreeTopHalf;
    public static Block fallenDeadTreeBottomHalf;
    public static Block deadTree;
    public static Block deadStump;
    public static Block deadGrass;
    public static Block frozenSoil;
    public static Block frozenSoilWall;
    public static Block frozenSoilBoulder;
    public static Block albaster;
    public static Block albasterTiles;
    public static Block albasterCrater;
    public static Block albasterCraterLarge;
    public static Block albasterWall;
    public static Block albasterBoulder;
    public static Block aghaniteWall;
    public static Block aghaniteCrag;
    public static Block aghaniteBoulder;
    public static Block smoothAghanite;
    public static Block crackedAghanite;
    public static Block pebbledAghanite;
    public static Block sandyAghanite;
    public static Block aghanite;
    public static Block whiteAghaniteWall;
    public static Block whiteAghaniteBoulder;
    public static Block smoothWhiteAghanite;
    public static Block weatheredWhiteAghanite;
    public static Block whiteAghanite;
    public static Block whiteAghaniteDust;
    public static Block grayAghanite;
    public static Block smoothGrayAghanite;
    public static Block grayAghaniteWall;
    public static Block grayAghaniteCrag;
    public static Block grayAghaniteBoulder;
    public static Block verdantAghanite;
    public static Block verdantAghaniteWall;
    public static Block verdantAghaniteBoulder;
    public static Block deepGlacium;
    public static Block glacium;
    public static Block greniteGlacium;
    public static Block grenite;
    public static Block coastalGrenite;
    public static Block greniteWall;
    public static Block darkGreniteWall;
    public static Block greniteBoulder;
    public static Block blueIce;
    public static Block blueIcePieces;
    public static Block weatheredIce;
    public static Block blueIceWall;
    public static Block weatheredIceWall;
    public static Block blueSnow;
    public static Block blueSnowdrifts;
    public static Block blueSnowWall;
    public static Block blueBoulder;

    public static void load() {
        cliff = new Cliff("cliff");
        cliffHelper = new CliffHelper("cliff-helper");
        oreCobalt = new OreBlock("ore-cobalt", OlItems.cobalt){
            {
                this.mapColor = Color.valueOf((String)"85939d");
                this.oreThreshold = 0.81f;
                this.oreScale = 23.47619f;
            }
        };
        oreNickel = new OreBlock("ore-nickel", OlItems.nickel){
            {
                this.mapColor = Color.valueOf((String)"3a8f64");
            }
        };
        oreCoal = new OreBlock("ore-coal", Items.coal){
            {
                this.oreThreshold = 0.846f;
                this.oreScale = 24.428572f;
            }
        };
        glasmoreMetal = new Floor("glasmore-metal", 6);
        glasmoreMetalPlus = new PatternedFloor("glasmore-metal-plus"){
            {
                this.shape = new CustomPatternShape("omaloon-glasmore-metal-plus-mask");
                this.drawPatternEdges = true;
                this.blendGroup = glasmoreMetal;
                this.parent = glasmoreMetal;
            }
        };
        ruinedTiles = new Floor("ruined-tiles", 3){
            {
                this.wall = ruinedWall;
            }
        };
        ruinedMasonry = new Floor("ruined-masonry", 3){
            {
                this.wall = ruinedWall;
            }
        };
        ruinedWall = new StaticWall("ruined-wall"){
            {
                this.variants = 4;
            }
        };
        gerbRemains = new RotatedProp("gerb-remains"){
            {
                this.variants = 3;
                this.breakSound = OlSounds.debrisBreak;
                OlEnvironmentBlocks.ruinedTiles.asFloor().decoration = this;
                OlEnvironmentBlocks.ruinedMasonry.asFloor().decoration = this;
            }
        };
        deadGrass = new Floor("dead-grass", 5){
            {
                this.wall = frozenSoilWall;
            }
        };
        deadShrub = new Prop("dead-shrub"){
            {
                this.customShadow = true;
                this.variants = 3;
                OlEnvironmentBlocks.deadGrass.asFloor().decoration = this;
            }
        };
        deadSpikeTree = new Prop("dead-spike-tree"){
            {
                this.variants = 2;
                this.customShadow = true;
            }
        };
        deadBushTree = new RotatedProp("dead-bush-tree"){
            {
                this.variants = 1;
                this.customShadow = true;
                this.breakSound = Sounds.plantBreak;
            }
        };
        fallenDeadTree = new CustomShapeProp("fallen-dead-tree"){
            {
                this.clipSize = 144.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-16.0f, -32.0f), new Vec2(8.0f, -32.0f), new Vec2(-16.0f, -32.0f), new Vec2(-8.0f, -32.0f), new Vec2(-8.0f, -16.0f), new Vec2(-32.0f, -16.0f), new Vec2(0.0f, -16.0f), new Vec2(-32.0f, -16.0f)};
            }
        };
        fallenDeadTreeTopHalf = new CustomShapeProp("fallen-dead-tree-top-half"){
            {
                this.clipSize = 80.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-8.0f, -16.0f), new Vec2(-8.0f, -16.0f), new Vec2(-8.0f, -16.0f), new Vec2(0.0f, -16.0f), new Vec2(-16.0f, -8.0f), new Vec2(-16.0f, -8.0f), new Vec2(-8.0f, -8.0f), new Vec2(-16.0f, -8.0f)};
            }
        };
        fallenDeadTreeBottomHalf = new CustomShapeProp("fallen-dead-tree-bottom-half"){
            {
                this.clipSize = 64.0f;
                this.variants = 8;
                this.canMirror = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-12.0f, -8.0f), new Vec2(-4.0f, -8.0f), new Vec2(-12.0f, -8.0f), new Vec2(-12.0f, -8.0f), new Vec2(-8.0f, -12.0f), new Vec2(-8.0f, -12.0f), new Vec2(0.0f, -12.0f), new Vec2(-8.0f, -12.0f)};
            }
        };
        deadTree = new CustomShapeProp("dead-tree"){
            {
                this.clipSize = 32.0f;
                this.variants = 1;
                this.spriteOffsets = new Vec2[]{new Vec2(-4.0f, -12.0f)};
            }
        };
        deadStump = new CustomShapeProp("dead-tree-stump"){
            {
                this.clipSize = 16.0f;
                this.variants = 1;
                this.drawUnder = true;
                this.rotateRegions = true;
                this.spriteOffsets = new Vec2[]{new Vec2(-4.0f, -4.0f)};
            }
        };
        frozenSoil = new Floor("frozen-soil", 4){
            {
                this.wall = frozenSoilWall;
            }
        };
        frozenSoilWall = new StaticWall("frozen-soil-wall"){
            {
                this.variants = 4;
            }
        };
        frozenSoilBoulder = new Prop("frozen-soil-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.frozenSoil.asFloor().decoration = this;
            }
        };
        albaster = new Floor("albaster", 4){
            {
                this.wall = albasterWall;
            }
        };
        albasterTiles = new Floor("albaster-tiles", 3){
            {
                this.wall = albasterWall;
            }
        };
        albasterCrater = new Floor("albaster-craters", 4){
            {
                this.blendGroup = albaster;
                this.wall = albasterWall;
            }
        };
        albasterCraterLarge = new PatternedFloor("albaster-craters-large"){
            {
                this.shape = new RectanglePatternShape(2, 2);
                this.variants = 0;
                this.parent = albasterCrater;
                this.blendGroup = albaster;
                this.wall = albasterWall;
            }
        };
        albasterWall = new StaticWall("albaster-wall"){
            {
                this.variants = 3;
            }
        };
        albasterBoulder = new Prop("albaster-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.albaster.asFloor().decoration = this;
                OlEnvironmentBlocks.albasterTiles.asFloor().decoration = this;
                OlEnvironmentBlocks.albasterCrater.asFloor().decoration = this;
            }
        };
        smoothAghanite = new Floor("smooth-aghanite", 2){
            {
                this.wall = aghaniteWall;
            }
        };
        crackedAghanite = new Floor("cracked-aghanite", 6){
            {
                this.wall = aghaniteWall;
            }
        };
        pebbledAghanite = new Floor("pebbled-aghanite", 4){
            {
                this.wall = aghaniteWall;
            }
        };
        sandyAghanite = new Floor("sandy-aghanite", 5){
            {
                this.wall = aghaniteWall;
            }
        };
        aghanite = new Floor("aghanite", 3){
            {
                this.wall = aghaniteWall;
            }
        };
        aghaniteWall = new StaticWall("aghanite-wall"){
            {
                this.variants = 4;
            }
        };
        aghaniteCrag = new Prop("aghanite-crag"){
            {
                this.customShadow = true;
                this.variants = 3;
            }
        };
        aghaniteBoulder = new Prop("aghanite-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.smoothAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.crackedAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.pebbledAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.sandyAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.aghanite.asFloor().decoration = this;
            }
        };
        grayAghanite = new Floor("gray-aghanite", 3){
            {
                this.wall = grayAghaniteWall;
            }
        };
        smoothGrayAghanite = new Floor("smooth-gray-aghanite", 3){
            {
                this.wall = grayAghaniteWall;
            }
        };
        grayAghaniteWall = new StaticWall("gray-aghanite-wall"){
            {
                this.variants = 2;
            }
        };
        grayAghaniteCrag = new Prop("gray-aghanite-crag"){
            {
                this.customShadow = true;
                this.variants = 2;
            }
        };
        grayAghaniteBoulder = new Prop("gray-aghanite-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.grayAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.smoothGrayAghanite.asFloor().decoration = this;
            }
        };
        smoothWhiteAghanite = new Floor("smooth-white-aghanite", 4){
            {
                this.wall = whiteAghaniteWall;
            }
        };
        weatheredWhiteAghanite = new Floor("weathered-white-aghanite", 2){
            {
                this.wall = whiteAghaniteWall;
            }
        };
        whiteAghanite = new Floor("white-aghanite", 4){
            {
                this.wall = whiteAghaniteWall;
            }
        };
        whiteAghaniteDust = new OverlayFloor("white-aghanite-dust"){
            {
                this.variants = 2;
            }
        };
        whiteAghaniteWall = new StaticWall("white-aghanite-wall"){
            {
                this.variants = 2;
            }
        };
        whiteAghaniteBoulder = new Prop("white-aghanite-boulder"){
            {
                this.customShadow = true;
                this.variants = 2;
                OlEnvironmentBlocks.smoothWhiteAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.weatheredWhiteAghanite.asFloor().decoration = this;
                OlEnvironmentBlocks.whiteAghanite.asFloor().decoration = this;
            }
        };
        verdantAghanite = new Floor("verdant-aghanite", 3){
            {
                this.wall = verdantAghaniteWall;
            }
        };
        verdantAghaniteWall = new StaticWall("verdant-aghanite-wall"){
            {
                this.variants = 3;
            }
        };
        verdantAghaniteBoulder = new Prop("verdant-aghanite-boulder"){
            {
                this.customShadow = true;
                this.variants = 2;
                OlEnvironmentBlocks.verdantAghanite.asFloor().decoration = this;
            }
        };
        deepGlacium = new Floor("deep-glacium", 1){
            {
                this.speedMultiplier = 0.1f;
                this.liquidDrop = OlLiquids.glacium;
                this.liquidMultiplier = 1.3f;
                this.isLiquid = true;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 120.0f;
                this.drownTime = 200.0f;
                this.cacheLayer = OlShaders.glaciumLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        glacium = new Floor("shallow-glacium", 1){
            {
                this.speedMultiplier = 0.3f;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 90.0f;
                this.liquidDrop = OlLiquids.glacium;
                this.isLiquid = true;
                this.cacheLayer = OlShaders.glaciumLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        greniteGlacium = new Floor("grenite-glacium", 3){
            {
                this.speedMultiplier = 0.6f;
                this.status = OlStatusEffects.glacied;
                this.statusDuration = 60.0f;
                this.liquidDrop = OlLiquids.glacium;
                this.isLiquid = true;
                this.cacheLayer = OlShaders.glaciumLayer;
                this.albedo = 0.9f;
                this.supportsOverlay = true;
            }
        };
        grenite = new Floor("grenite", 4){
            {
                this.wall = albasterWall;
            }
        };
        coastalGrenite = new Floor("coastal-grenite", 3){
            {
                this.wall = albasterWall;
            }
        };
        greniteWall = new StaticWall("grenite-wall"){
            {
                this.variants = 2;
            }
        };
        darkGreniteWall = new StaticWall("dark-grenite-wall"){
            {
                this.variants = 2;
            }
        };
        greniteBoulder = new Prop("grenite-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.grenite.asFloor().decoration = this;
                OlEnvironmentBlocks.coastalGrenite.asFloor().decoration = this;
            }
        };
        blueIce = new Floor("blue-ice", 3){
            {
                this.mapColor = Color.valueOf((String)"5195ab");
                this.wall = blueIceWall;
                this.albedo = 0.9f;
            }
        };
        blueIcePieces = new OverlayFloor("blue-ice-pieces"){
            {
                this.variants = 3;
            }
        };
        weatheredIce = new OverlayFloor("weathered-ice"){
            {
                this.variants = 2;
            }
        };
        blueIceWall = new StaticWall("blue-ice-wall"){
            {
                this.variants = 2;
            }
        };
        weatheredIceWall = new StaticWall("weathered-ice-wall"){
            {
                this.variants = 2;
            }
        };
        blueSnow = new Floor("blue-snow", 3){
            {
                this.wall = blueIceWall;
                this.albedo = 0.7f;
            }
        };
        blueSnowdrifts = new OverlayFloor("blue-snowdrifts"){
            {
                this.variants = 3;
            }
        };
        blueSnowWall = new StaticWall("blue-snow-wall"){
            {
                this.variants = 2;
            }
        };
        blueBoulder = new Prop("blue-boulder"){
            {
                this.variants = 3;
                OlEnvironmentBlocks.blueIce.asFloor().decoration = this;
                OlEnvironmentBlocks.blueSnow.asFloor().decoration = this;
            }
        };
    }
}

