/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content.blocks;

import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import omaloon.content.OlFx;
import omaloon.content.OlItems;
import omaloon.world.blocks.production.PressureCrafter;
import omaloon.world.consumers.ConsumeFluid;
import omaloon.world.meta.PressureConfig;
import omaloon.world.meta.PressureTank;

public class OlCraftingBlocks {
    public static Block compositePress;

    public static void load() {
        compositePress = new PressureCrafter("composite-press"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{OlItems.cobalt, 30, OlItems.nickel, 30}));
                this.researchCostMultiplier = 0.3f;
                this.size = 2;
                this.craftTime = 120.0f;
                this.craftEffect = OlFx.compositeCraft;
                this.consumeItems(ItemStack.with((Object[])new Object[]{OlItems.nickel, 1, OlItems.cobalt, 1}));
                this.consume(new ConsumeFluid(null, 5.0f){
                    {
                        super(fluid, amount);
                        this.startRange = 5.0f;
                        this.endRange = 50.0f;
                        this.efficiencyMultiplier = 1.6f;
                        this.curve = t -> Math.min(4.5f * (1.0f - t), 1.2857143f * t);
                        this.optimalPressure = 40.0f;
                        this.hasOptimalPressure = true;
                    }
                });
                this.outputItems = ItemStack.with((Object[])new Object[]{OlItems.composite, 1});
                this.pressureConfig = new PressureConfig(){
                    {
                        this.hasPressure = true;
                        this.fluidCapacity = 16.0f;
                        this.group = PressureTank.TankGroup.production;
                    }
                };
            }
        };
    }
}

