/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Events;
import arc.graphics.Color;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.core.GameState;
import mindustry.game.EventType;
import mindustry.type.StatusEffect;
import omaloon.content.OlFx;
import omaloon.content.OlLiquids;

public class OlStatusEffects {
    public static StatusEffect glacied;
    public static StatusEffect breeze;
    public static StatusEffect filledWithWater;
    public static StatusEffect filledWithGlacium;
    public static StatusEffect filledWithSlag;
    public static StatusEffect filledWithOil;

    public static void load() {
        glacied = new StatusEffect("glacied"){
            {
                this.color = Color.valueOf((String)"5195ab");
                this.speedMultiplier = 0.8f;
                this.buildSpeedMultiplier = 0.8f;
                this.effect = OlFx.glacied.layer(20.0f);
                this.effectChance = 0.1f;
                this.init(() -> {
                    this.affinity(StatusEffects.shocked, (unit, result, time) -> {
                        unit.damagePierce(this.transitionDamage);
                        if (unit.team == Vars.state.rules.waveTeam) {
                            Events.fire((Enum)EventType.Trigger.shock);
                        }
                    });
                    this.opposite(new StatusEffect[]{StatusEffects.burning, StatusEffects.melting});
                });
            }
        };
        breeze = new StatusEffect("wind-breeze"){
            {
                this.color = Color.valueOf((String)"ffffff");
                this.speedMultiplier = 1.2f;
            }
        };
        filledWithWater = new StatusEffect("filled-with-water"){
            {
                this.color = Liquids.water.color;
            }

            public boolean isHidden() {
                return Vars.state.getState() != GameState.State.menu;
            }
        };
        filledWithGlacium = new StatusEffect("filled-with-glacium"){
            {
                this.color = OlLiquids.glacium.color;
            }

            public boolean isHidden() {
                return Vars.state.getState() != GameState.State.menu;
            }
        };
        filledWithSlag = new StatusEffect("filled-with-slag"){
            {
                this.color = Liquids.slag.color;
            }

            public boolean isHidden() {
                return Vars.state.getState() != GameState.State.menu;
            }
        };
        filledWithOil = new StatusEffect("filled-with-oil"){
            {
                this.color = Liquids.oil.color;
            }

            public boolean isHidden() {
                return Vars.state.getState() != GameState.State.menu;
            }
        };
    }
}

