/*
 * Decompiled with CFR 0.152.
 */
package omaloon.content;

import arc.Core;
import arc.graphics.Color;
import arc.struct.ObjectFloatMap;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.type.Liquid;
import mindustry.world.meta.Stat;
import omaloon.content.OlStatusEffects;
import omaloon.type.liquid.CrystalLiquid;
import omaloon.world.meta.OlStats;

public class OlLiquids {
    public static Liquid glacium;
    public static Liquid tiredGlacium;
    public static ObjectFloatMap<Liquid> densities;
    public static ObjectFloatMap<Liquid> viscosities;

    public static float getDensity(Liquid liquid) {
        return densities.get((Object)liquid, 0.125f);
    }

    public static float getViscosity(Liquid liquid) {
        return viscosities.get((Object)liquid, 1.0f);
    }

    public static void load() {
        glacium = new CrystalLiquid("glacium", Color.valueOf((String)"5e929d")){
            {
                this.effect = OlStatusEffects.glacied;
                this.temperature = 0.1f;
                this.heatCapacity = 0.2f;
                densities.put((Object)this, 0.125f);
                viscosities.put((Object)this, 1.0f);
                this.coolant = false;
                this.colorFrom = Color.valueOf((String)"5e929d");
                this.colorTo = Color.valueOf((String)"3e6067");
                this.canStayOn.add((Object)Liquids.water);
            }
        };
        tiredGlacium = new Liquid("tired-glacium", Color.valueOf((String)"456c74")){
            {
                this.effect = OlStatusEffects.glacied;
                this.temperature = 0.1f;
                this.heatCapacity = 0.2f;
                densities.put((Object)this, 0.125f);
                viscosities.put((Object)this, 1.0f);
                this.coolant = false;
                this.canStayOn.add((Object)Liquids.water);
            }
        };
    }

    public static void init() {
        if (!Core.settings.getBool("omaloon-override-stats", true)) {
            return;
        }
        for (Liquid liquid : Vars.content.liquids()) {
            liquid.checkStats();
            liquid.stats.remove(Stat.viscosity);
            liquid.stats.add(OlStats.density, OlLiquids.getDensity(liquid) * 8.0f, OlStats.densityUnit);
            liquid.stats.add(Stat.viscosity, OlLiquids.getViscosity(liquid) * 60.0f, OlStats.viscosityUnit);
        }
    }

    static {
        densities = new ObjectFloatMap();
        viscosities = new ObjectFloatMap();
    }
}

