/*
 * Decompiled with CFR 0.152.
 */
package omaloon;

import arc.Core;
import arc.Events;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.MappableContent;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import omaloon.content.OlBlocks;
import omaloon.content.OlItems;
import omaloon.content.OlLiquids;
import omaloon.content.OlStatusEffects;
import omaloon.core.OlIcons;
import omaloon.core.OlSettings;
import omaloon.gen.OlContentRegionRegistry;
import omaloon.gen.OlEntityMapping;
import omaloon.gen.OlSounds;
import omaloon.gen.Regions;
import omaloon.graphics.OlShaders;
import omaloon.ui.SplashDrawer;
import omaloon.ui.dialogs.DisclaimerDialog;
import omaloon.ui.dialogs.UpdateDialog;
import omaloon.world.blocks.environment.customsshapeproop.CustomShapePropProcess;

public class OmaloonMod
extends Mod {
    public static boolean tools = false;
    protected static Mods.LoadedMod mod;

    public OmaloonMod() {
        this(false);
    }

    public OmaloonMod(boolean tools) {
        OmaloonMod.tools = tools;
        Events.on(EventType.ClientLoadEvent.class, e -> {
            OlIcons.load();
            OlSettings.load();
            CustomShapePropProcess.create();
            OlLiquids.init();
            DisclaimerDialog.check();
            UpdateDialog.check();
        });
        Events.on(EventType.ContentInitEvent.class, e -> {
            if (!Vars.headless) {
                Regions.load();
                Vars.content.each(content -> {
                    if (OmaloonMod.isOmaloon(content) && content instanceof MappableContent) {
                        MappableContent mContent = (MappableContent)content;
                        OlContentRegionRegistry.load(mContent);
                    }
                });
            }
        });
        Events.on(EventType.FileTreeInitEvent.class, e -> {
            Core.app.post(() -> {
                mod = Vars.mods.getMod(OmaloonMod.class);
                if (!Vars.headless) {
                    SplashDrawer.add(mod);
                }
            });
            Core.app.post(OlShaders::load);
        });
        Events.on(EventType.DisposeEvent.class, e -> OlShaders.dispose());
    }

    public static boolean isOmaloon(Content content) {
        return content.minfo.mod != null && content.minfo.mod.name.equals("omaloon");
    }

    public static Mods.LoadedMod mod() {
        return mod;
    }

    public void init() {
    }

    public void loadContent() {
        OlSounds.load();
        OlItems.load();
        OlLiquids.load();
        OlStatusEffects.load();
        OlBlocks.load();
        OlEntityMapping.init();
    }
}

