/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.system.DuplicateNameException;
import org.apache.zookeeper.test.system.Instance;
import org.apache.zookeeper.test.system.NoAssignmentException;
import org.apache.zookeeper.test.system.NoAvailableContainers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManager
implements AsyncCallback.ChildrenCallback,
Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceManager.class);
    private ZooKeeper zk;
    private String prefixNode;
    private String reportsNode = "reports";
    private String readyNode = "ready";
    private String assignmentsNode = "assignments";
    private String statusNode = "available";
    private static final int maxTries = 3;
    private static List<String> preferredList = new ArrayList<String>();
    private HashMap<String, HashSet<Assigned>> assignments = new HashMap();
    private HashMap<String, Assigned> instanceToAssignment = new HashMap();

    public InstanceManager(ZooKeeper zk, String prefix) throws KeeperException, InterruptedException {
        this.zk = zk;
        this.prefixNode = prefix;
        this.readyNode = prefix + '/' + this.readyNode;
        this.assignmentsNode = prefix + '/' + this.assignmentsNode;
        this.reportsNode = prefix + '/' + this.reportsNode;
        this.statusNode = prefix + '/' + this.statusNode;
        for (int i = 0; i < 3; ++i) {
            try {
                this.setupNodes(zk);
                break;
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                continue;
            }
        }
        KeeperException.ConnectionLossException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                List<String> children = zk.getChildren(this.statusNode, this);
                this.processResult(0, this.statusNode, null, children);
                lastException = null;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void setupNodes(ZooKeeper zk) throws KeeperException, InterruptedException {
        try {
            zk.create(this.prefixNode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        try {
            zk.create(this.assignmentsNode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        try {
            zk.create(this.statusNode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        try {
            zk.create(this.reportsNode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
        try {
            zk.create(this.readyNode, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void processResult(int rc, String path, Object ctx, List<String> children) {
        if (rc != KeeperException.Code.OK.intValue()) {
            this.zk.getChildren(this.statusNode, (Watcher)this, (AsyncCallback.ChildrenCallback)this, null);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got " + children + " children from " + path);
        }
        HashMap newAssignments = new HashMap();
        for (String c : children) {
            HashSet<Assigned> a = this.assignments.remove(c);
            if (a != null) {
                newAssignments.put(c, a);
                continue;
            }
            newAssignments.put(c, new HashSet());
        }
        for (String dead : this.assignments.keySet()) {
            try {
                this.removeInstance(dead);
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.assignments = newAssignments;
    }

    private void removeAssignmentNode(String dead) throws KeeperException, InterruptedException {
        String deadNode = this.assignmentsNode + '/' + dead;
        List<String> children = this.zk.getChildren(deadNode, false);
        for (String c : children) {
            this.zk.delete(deadNode + '/' + c, -1);
        }
        try {
            this.zk.delete(deadNode, -1);
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
    }

    @Override
    public void process(WatchedEvent event) {
        if (event.getPath().equals(this.statusNode)) {
            this.zk.getChildren(this.statusNode, (Watcher)this, (AsyncCallback.ChildrenCallback)this, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized String assignInstance(String name, Class<? extends Instance> clazz, String params, int weight) throws NoAvailableContainers, DuplicateNameException, InterruptedException, KeeperException {
        void var9_14;
        if (weight < 1) {
            weight = 1;
        }
        String instanceSpec = clazz.getName() + ' ' + params;
        if (this.instanceToAssignment.get(name) != null) {
            throw new DuplicateNameException(name + " already exists");
        }
        String mostIdle = null;
        int mostIdleWeight = Integer.MAX_VALUE;
        for (String string : preferredList) {
            HashSet<Assigned> assignmentList = this.assignments.get(string);
            int w = 0;
            if (assignmentList == null) continue;
            for (Assigned a : assignmentList) {
                w += a.weight;
            }
            if (w >= mostIdleWeight) continue;
            mostIdleWeight = w;
            mostIdle = string;
        }
        for (Map.Entry entry : this.assignments.entrySet()) {
            int w = 0;
            for (Assigned a : (HashSet)entry.getValue()) {
                w += a.weight;
            }
            if (w >= mostIdleWeight) continue;
            mostIdleWeight = w;
            mostIdle = (String)entry.getKey();
        }
        if (mostIdle == null) {
            throw new NoAvailableContainers("No available containers");
        }
        Assigned a = new Assigned(mostIdle, name, weight);
        this.instanceToAssignment.put(name, a);
        HashSet<Assigned> hashSet = this.assignments.get(mostIdle);
        if (hashSet == null) {
            HashSet hashSet2 = new HashSet();
            this.assignments.put(mostIdle, hashSet2);
        }
        var9_14.add(a);
        KeeperException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.create(this.assignmentsNode + '/' + mostIdle + '/' + name, instanceSpec.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                return mostIdle;
            }
            catch (KeeperException.NodeExistsException e) {
                return mostIdle;
            }
            catch (KeeperException e) {
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    public void reconfigureInstance(String name, String params) throws NoAssignmentException, InterruptedException, KeeperException {
        Assigned assigned;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reconfiguring " + name + " with " + params);
        }
        if ((assigned = this.instanceToAssignment.get(name)) == null) {
            throw new NoAssignmentException();
        }
        KeeperException.ConnectionLossException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.setData(this.assignmentsNode + '/' + assigned.container + '/' + name, ("update " + params).getBytes(), -1);
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                lastException = e;
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    private void doDelete(String path) throws InterruptedException, KeeperException {
        KeeperException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.delete(path, -1);
                return;
            }
            catch (KeeperException.NoNodeException e) {
                return;
            }
            catch (KeeperException e) {
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    public synchronized void removeInstance(String name) throws InterruptedException, KeeperException {
        Assigned assigned = this.instanceToAssignment.remove(name);
        if (assigned == null) {
            return;
        }
        this.assignments.get(assigned.container).remove(name);
        this.doDelete(this.assignmentsNode + '/' + assigned.container + '/' + name);
        this.doDelete(this.reportsNode + '/' + name);
    }

    synchronized boolean isAlive(String name) {
        return this.instanceToAssignment.get(name) != null;
    }

    public void resetStatus(String name) throws InterruptedException, KeeperException {
        KeeperException.ConnectionLossException lastException = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.zk.delete(this.reportsNode + '/' + name, -1);
                lastException = null;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                lastException = e;
                continue;
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatus(String name, long timeout) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] data = null;
        long endTime = System.currentTimeMillis() + timeout;
        KeeperException lastException = null;
        for (int i = 0; i < 3 && endTime > System.currentTimeMillis(); ++i) {
            try {
                data = this.zk.getData(this.reportsNode + '/' + name, false, stat);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got Data: " + (data == null ? "null" : new String(data)));
                }
                lastException = null;
                break;
            }
            catch (KeeperException.ConnectionLossException e) {
                lastException = e;
                continue;
            }
            catch (KeeperException.NoNodeException e) {
                Object eventObj;
                Object object = eventObj = new Object();
                synchronized (object) {
                    Stat eStat = this.zk.exists(this.reportsNode + '/' + name, new Watcher(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void process(WatchedEvent event) {
                            Object object = eventObj;
                            synchronized (object) {
                                eventObj.notifyAll();
                            }
                        }
                    });
                    if (eStat == null) {
                        eventObj.wait(endTime - System.currentTimeMillis());
                    }
                }
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return new String(data);
    }

    public synchronized void close() throws InterruptedException {
        for (String name : this.instanceToAssignment.keySet().toArray(new String[0])) {
            try {
                this.removeInstance(name);
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
        }
        try {
            this.doDelete(this.readyNode);
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }

    static {
        String list = System.getProperty("ic.preferredList");
        if (list != null) {
            preferredList = Arrays.asList(list.split(","));
            System.err.println("Preferred List: " + preferredList);
        } else {
            System.err.println("Preferred List is empty");
        }
    }

    private static final class Assigned {
        String container;
        String instance;
        int weight;

        Assigned(String container, String instance, int weight) {
            this.container = container;
            this.instance = instance;
            this.weight = weight;
        }
    }
}

