/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import org.apache.zookeeper.JUnit4ZKTestRunner;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestWatchman;
import org.junit.runner.RunWith;
import org.junit.runners.model.FrameworkMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4ZKTestRunner.class)
public class ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ZKTestCase.class);
    private String testName;
    @Rule
    public MethodRule watchman = new TestWatchman(){

        public void starting(FrameworkMethod method) {
            ZKTestCase.this.testName = method.getName();
            System.setProperty("zookeeper.4lw.commands.whitelist", "*");
            LOG.info("STARTING " + ZKTestCase.this.testName);
        }

        public void finished(FrameworkMethod method) {
            LOG.info("FINISHED " + ZKTestCase.this.testName);
        }

        public void succeeded(FrameworkMethod method) {
            LOG.info("SUCCEEDED " + ZKTestCase.this.testName);
        }

        public void failed(Throwable e, FrameworkMethod method) {
            LOG.info("FAILED " + ZKTestCase.this.testName, e);
        }
    };

    protected String getTestName() {
        return this.testName;
    }
}

