set bytea_output='escape';

-- Basic RLE test
create table rle_basic (i int encoding (compresstype=rle_type))
       with (appendonly=true, orientation=column);

insert into rle_basic select 1 from generate_series(1,10) i;
select * from rle_basic;
drop table rle_basic;

create table rle_manycoltypes (c1 int, c2 int, c3 char(10), c4 varchar, c5 timestamp, c6 numeric(7,7)) 
  with (appendonly=true, orientation=column, 
       compresstype=rle_type, 
       compresslevel=1)                                                             distributed by (c1);
insert into rle_manycoltypes select  1, 1, 'abcdefghij', 'x', '2011-09-16 05:33:45.37103-07', 0.1 FROM generate_series(1,1000);

select * from rle_manycoltypes;
drop table rle_manycoltypes;

create table rle_runtest (c1 INT, c2 CHAR(30)) WITH (appendonly=true, orientation=column, compresstype=rle_type, compresslevel=1) DISTRIBUTED BY (C1);
insert into rle_runtest select 1, 'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa' FROM generate_series(1,10000);
select * from rle_runtest;
drop table rle_runtest;

-- This tests the delta compression's delta computation arithmetic. The bigint
-- column is used for the same and values inserted are INT64_MIN to INT64_MAX
-- to check extreme overflow case.
CREATE TABLE rle_overflowtest (a INT, b BIGINT, c char) WITH (appendonly=true, compresstype=rle_type, orientation=column, compresslevel=1);
INSERT INTO rle_overflowtest VALUES (1,9223372036854775807,'a'), (1,-9,'b');
INSERT INTO rle_overflowtest VALUES (1,-9,'c'), (1,9223372036854775807,'d');
INSERT INTO rle_overflowtest VALUES (1,-9223372036854775808,'e'), (1,9223372036854775807,'f');
INSERT INTO rle_overflowtest VALUES (1,9223372036854775807,'g'), (1,-9223372036854775808,'h');
SELECT * FROM rle_overflowtest;

DROP TABLE if exists CO_1_create_table_storage_directive_RLE_TYPE_8192_1;

--
-- Create table
--
CREATE TABLE CO_1_create_table_storage_directive_RLE_TYPE_8192_1 (id SERIAL,
	 a1 int ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a2 char(5) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a3 numeric ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a4 boolean DEFAULT false  ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a5 char DEFAULT 'd' ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a6 text ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a7 timestamp ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a8 character varying(555) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a9 bigint ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a10 date ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a11 varchar(400) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a12 text ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a13 decimal ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a14 real ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a15 bigint ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a16 int4  ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a17 bytea ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a18 timestamp with time zone ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a19 timetz ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a20 path ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a21 box ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a22 macaddr ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a23 interval ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a24 character varying(800) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a25 lseg ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a26 point ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a27 double precision ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a28 circle ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a29 int4 ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a30 numeric(8) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a31 polygon ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a32 date ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a33 real ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a34 money ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a35 cidr ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a36 inet ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a37 time ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a38 text ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a39 bit ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a40 bit varying(5) ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a41 smallint ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192),
a42 int ENCODING (compresstype=RLE_TYPE,compresslevel=1,blocksize=8192)) WITH (appendonly=true, orientation=column) distributed randomly;

-- 
-- Create Indexes
--
CREATE INDEX CO_1_create_table_storage_directive_RLE_TYPE_8192_1_idx_bitmap ON CO_1_create_table_storage_directive_RLE_TYPE_8192_1 USING bitmap (a1);

CREATE INDEX CO_1_create_table_storage_directive_RLE_TYPE_8192_1_idx_btree ON CO_1_create_table_storage_directive_RLE_TYPE_8192_1(a9);

--
-- Insert data to the table
--
INSERT INTO CO_1_create_table_storage_directive_RLE_TYPE_8192_1(a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19,a20,a21,a22,a23,a24,a25,a26,a27,a28,a29,a30,a31,a32,a33,a34,a35,a36,a37,a38,a39,a40,a41,a42)
select g % 10 + 1  as a1,
       '5char' as a2,
       2011  as a3,
       't'   as a4,
       'a'   as a5,
       'This is news of today: Deadlock between Republicans and Democrats over how best to reduce the U.S. deficit, and over what period, has blocked an agreement to allow the raising of the $14.3 trillion debt ceiling' as a6,
       '2001-12-24 02:26:11' as a7,
       'U.S. House of Representatives Speaker John Boehner, the top Republican in Congress who has put forward a deficit reduction plan to be voted on later on Thursday said he had no control over whether his bill would avert a credit downgrade.' as a8,
       g % 11 + 2450 as a9,
       '2011-10-11' as a10,
       'The Republican-controlled House is tentatively scheduled to vote on Boehner proposal this afternoon at around 6 p.m. EDT (2200 GMT). The main Republican vote counter in the House, Kevin McCarthy, would not say if there were enough votes to pass the bill.' as a11,
       'WASHINGTON:House Speaker John Boehner says his plan mixing spending cuts in exchange for raising the nations $14.3 trillion debt limit is not perfect but is as large a step that a divided government can take that is doable and signable by President Barack Obama.The Ohio Republican says the measure is an honest and sincere attempt at compromise and was negotiated with Democrats last weekend and that passing it would end the ongoing debt crisis. The plan blends $900 billion-plus in spending cuts with a companion increase in the nations borrowing cap.' as a12,
       '1234.56' as a13,
       323453 as a14,
       g % 11 + 3452 as a15,
       7845 as a16,
       '0011' as a17,
       '2005-07-16 01:51:15+1359' as a18,
       '2001-12-13 01:51:15' as a19,
       '((1,2),(0,3),(2,1))' as a20,
       '((2,3)(4,5))' as a21,
       '08:00:2b:01:02:03' as a22,
       '1-2' as a23,
       'Republicans had been working throughout the day Thursday to lock down support for their plan to raise the nations debt ceiling, even as Senate Democrats vowed to swiftly kill it if passed.' as a24,
       '((2,3)(4,5))' as a25,
       '(6,7)' as a26,
       11.222 as a27,
       '((4,5),7)' as a28,
       32 as a29,
       3214 as a30,
       '(1,0,2,3)' as a31,
       '2010-02-21' as a32,
       43564 as a33,
       '$1,000.00' as a34,
       '192.168.1' as a35,
       '126.1.3.4' as a36,
       '12:30:45' as a37,
       'Johnson & Johnsons McNeil Consumer Healthcare announced the voluntary dosage reduction today. Labels will carry new dosing instructions this fall.The company says it will cut the maximum dosage of Regular Strength Tylenol and other acetaminophen-containing products in 2012.Acetaminophen is safe when used as directed, says Edwin Kuffner, MD, McNeil vice president of over-the-counter medical affairs. But, when too much is taken, it can cause liver damage.The action is intended to cut the risk of such accidental overdoses, the company says in a news release.' as a38,
       '1' as a39,
       '0' as a40,
       12 as a41,
       23 as a42
from generate_series(0,109) as g;

select * from CO_1_create_table_storage_directive_RLE_TYPE_8192_1;
DROP TABLE CO_1_create_table_storage_directive_RLE_TYPE_8192_1;

--
-- Test case to check boundary condition of CO block full,
-- where nullBitMapSize is non-aligned and needs padding
-- of 7 bits during block finalization.
--
CREATE TABLE rle_co_block_boundary (
        distcol integer,
        col1 BIGINT
)
WITH (appendonly=true, orientation=column, compresstype=rle_type, compresslevel=3, blocksize=8192)
DISTRIBUTED BY (distcol);

COPY rle_co_block_boundary (distcol, col1) FROM stdin NULL AS 'NULL';
1	510233155578439
1	510233154578439
1	510233153578439
1	510233148578439
1	510233144578439
1	510233142578439
1	510233140578439
1	510233137578439
1	510233136578439
1	510233135578439
1	510233130578439
1	510233126578439
1	510233124578439
1	510233119578439
1	510233115578439
1	510233114578439
1	510233111578439
1	510233104578439
1	510233102578439
1	510233101578439
1	510233099578439
1	510233094578439
1	510233092578439
1	510233091578439
1	510233088578439
1	510233087578439
1	510233084578439
1	510233083578439
1	510233080578439
1	510233078578439
1	510233077578439
1	510233075578439
1	510233074578439
1	510233073578439
1	510233064578439
1	510233058578439
1	510233057578439
1	510233050578439
1	510233045578439
1	510233040578439
1	510233038578439
1	510233037578439
1	510233034578439
1	510233030578439
1	510233029578439
1	510233024578439
1	510233022578439
1	510233021578439
1	510233015578439
1	510233013578439
1	510233011578439
1	510233010578439
1	510233008578439
1	510233006578439
1	510233004578439
1	510232996578439
1	510232994578439
1	510232993578439
1	510232992578439
1	510232989578439
1	510232984578439
1	510232983578439
1	510232981578439
1	510232978578439
1	510232977578439
1	510232975578439
1	510232970578439
1	510232968578439
1	510232967578439
1	510232965578439
1	510232956578439
1	510232955578439
1	510232954578439
1	510232953578439
1	510232944578439
1	510232943578439
1	510232938578439
1	510232935578439
1	510232925578439
1	510232921578439
1	510232920578439
1	510232914578439
1	510232903578439
1	510232902578439
1	510232901578439
1	510232900578439
1	510232898578439
1	510232892578439
1	510232890578439
1	510232887578439
1	510232886578439
1	510232881578439
1	510232879578439
1	510232876578439
1	510232875578439
1	510232874578439
1	510232867578439
1	510232864578439
1	510232863578439
1	510232862578439
1	510232861578439
1	510232858578439
1	510232854578439
1	510232853578439
1	510232852578439
1	510232851578439
1	510232847578439
1	510232846578439
1	510232840578439
1	510232836578439
1	510232828578439
1	510232825578439
1	510232823578439
1	510232818578439
1	510232817578439
1	510232812578439
1	510232807578439
1	510232802578439
1	510232801578439
1	510232800578439
1	510232799578439
1	510232798578439
1	510232796578439
1	510232794578439
1	510232792578439
1	510232783578439
1	510232780578439
1	510232779578439
1	510232778578439
1	510232776578439
1	510232767578439
1	510232766578439
1	510232765578439
1	510232761578439
1	510232754578439
1	510232750578439
1	510232749578439
1	510232746578439
1	510232742578439
1	510232741578439
1	510232738578439
1	510232737578439
1	510232732578439
1	510232727578439
1	510232723578439
1	510232721578439
1	510232720578439
1	510232718578439
1	510232717578439
1	510232716578439
1	510232715578439
1	510232714578439
1	510232713578439
1	510232709578439
1	510232705578439
1	510232704578439
1	510232703578439
1	510232702578439
1	510232701578439
1	510232699578439
1	510232694578439
1	510232693578439
1	510232692578439
1	510232691578439
1	510232684578439
1	510232681578439
1	510232676578439
1	510232674578439
1	510232672578439
1	510232671578439
1	510232668578439
1	510232666578439
1	510232665578439
1	510232664578439
1	510232661578439
1	510232657578439
1	510232654578439
1	510232652578439
1	510232651578439
1	510232648578439
1	510232638578439
1	510232635578439
1	510232633578439
1	510232631578439
1	510232629578439
1	510232627578439
1	510232626578439
1	510232622578439
1	510232621578439
1	510232617578439
1	510232613578439
1	510232612578439
1	510232610578439
1	510232604578439
1	510232603578439
1	510232599578439
1	510232597578439
1	510232594578439
1	510232592578439
1	510232591578439
1	510232588578439
1	510232587578439
1	510232583578439
1	510232582578439
1	510232577578439
1	510232576578439
1	510232574578439
1	510232558578439
1	510232557578439
1	510232549578439
1	510232547578439
1	510232541578439
1	510232535578439
1	510232530578439
1	510232529578439
1	510232528578439
1	510232527578439
1	510232522578439
1	510232521578439
1	510232519578439
1	510232517578439
1	510232516578439
1	510232513578439
1	510232512578439
1	510232511578439
1	510232508578439
1	510232507578439
1	510232504578439
1	510232499578439
1	510232498578439
1	510232497578439
1	510232491578439
1	510232487578439
1	510232486578439
1	510232478578439
1	510232477578439
1	510232476578439
1	510232469578439
1	510232461578439
1	510232458578439
1	510232454578439
1	510232453578439
1	510232452578439
1	510232450578439
1	510232447578439
1	510232446578439
1	510232442578439
1	510232440578439
1	510232439578439
1	510232436578439
1	510232430578439
1	510232428578439
1	510232426578439
1	510232425578439
1	510232420578439
1	510232419578439
1	510232416578439
1	510232415578439
1	510232412578439
1	510232408578439
1	510232407578439
1	510232402578439
1	510232401578439
1	510232399578439
1	510232396578439
1	510232385578439
1	510232381578439
1	510232378578439
1	510232377578439
1	510232373578439
1	510232372578439
1	510232371578439
1	510232369578439
1	510232363578439
1	510232362578439
1	510232359578439
1	510232358578439
1	510232355578439
1	510232349578439
1	510232348578439
1	510232341578439
1	510232336578439
1	510232333578439
1	510232332578439
1	510232331578439
1	510232330578439
1	510232329578439
1	510232328578439
1	510232327578439
1	510232323578439
1	510232317578439
1	510232315578439
1	510232306578439
1	510232305578439
1	510232300578439
1	510232297578439
1	510232294578439
1	510232292578439
1	510232290578439
1	510232278578439
1	510232276578439
1	510232272578439
1	510232269578439
1	510232264578439
1	510232263578439
1	510232260578439
1	510232258578439
1	510232255578439
1	510232251578439
1	510232248578439
1	510232247578439
1	510232245578439
1	510232244578439
1	510232242578439
1	510232237578439
1	510232233578439
1	510232229578439
1	510232228578439
1	510232227578439
1	510232222578439
1	510232218578439
1	510232217578439
1	510232214578439
1	510232212578439
1	510232211578439
1	510232206578439
1	510232201578439
1	510232198578439
1	510232192578439
1	510232191578439
1	510232189578439
1	510232184578439
1	510232183578439
1	510232174578439
1	510232170578439
1	510232168578439
1	510232167578439
1	510232161578439
1	510232153578439
1	510232148578439
1	510232144578439
1	510232143578439
1	510232140578439
1	510232132578439
1	510232131578439
1	510232127578439
1	510232122578439
1	510232117578439
1	510232114578439
1	510232112578439
1	510232107578439
1	510232106578439
1	510232104578439
1	510232102578439
1	510232101578439
1	510232097578439
1	510232096578439
1	510232094578439
1	510232093578439
1	510232087578439
1	510232084578439
1	510232081578439
1	510232078578439
1	510232076578439
1	510232074578439
1	510232071578439
1	510232068578439
1	510232064578439
1	510232057578439
1	510232052578439
1	510232048578439
1	510232043578439
1	510232041578439
1	510232038578439
1	510232037578439
1	510232036578439
1	510232035578439
1	510232034578439
1	510232030578439
1	510232027578439
1	510232023578439
1	510232022578439
1	510232021578439
1	510232016578439
1	510232014578439
1	510232009578439
1	510232007578439
1	510232003578439
1	510232000578439
1	510231999578439
1	510231998578439
1	510231996578439
1	510231995578439
1	510231993578439
1	510231988578439
1	510231985578439
1	510231980578439
1	510231978578439
1	510231976578439
1	510231972578439
1	510231970578439
1	510231962578439
1	510231960578439
1	510231958578439
1	510231957578439
1	510231954578439
1	510231953578439
1	510231949578439
1	510231944578439
1	510231942578439
1	510231939578439
1	510231938578439
1	510231937578439
1	510231935578439
1	510231934578439
1	510231923578439
1	510231919578439
1	510231918578439
1	510231917578439
1	510231916578439
1	510231912578439
1	510231908578439
1	510231907578439
1	510231904578439
1	510231898578439
1	510231895578439
1	510231893578439
1	510231891578439
1	510231881578439
1	510231866578439
1	510231862578439
1	510231861578439
1	510231859578439
1	510231855578439
1	510231851578439
1	510231848578439
1	510231847578439
1	510231846578439
1	510231845578439
1	510231844578439
1	510231843578439
1	510231839578439
1	510231838578439
1	510231832578439
1	510231824578439
1	510231823578439
1	510231822578439
1	510231821578439
1	510231816578439
1	510231809578439
1	510231808578439
1	510231801578439
1	510231799578439
1	510231798578439
1	510231794578439
1	510231788578439
1	510231787578439
1	510231786578439
1	510231785578439
1	510231782578439
1	510231781578439
1	510231778578439
1	510231774578439
1	510231772578439
1	510231771578439
1	510231768578439
1	510231766578439
1	510231765578439
1	510231764578439
1	510231763578439
1	510231761578439
1	510231760578439
1	510231759578439
1	510231758578439
1	510231757578439
1	510231755578439
1	510231752578439
1	510231749578439
1	510231748578439
1	510231747578439
1	510231744578439
1	510231743578439
1	510231738578439
1	510231736578439
1	510231730578439
1	510231727578439
1	510231721578439
1	510231719578439
1	510231711578439
1	510231707578439
1	510231705578439
1	510231702578439
1	510231701578439
1	510231698578439
1	510231691578439
1	510231686578439
1	510231685578439
1	510231684578439
1	510231683578439
1	510231682578439
1	510231681578439
1	510231675578439
1	510231673578439
1	510231672578439
1	510231668578439
1	510231662578439
1	510231658578439
1	510231657578439
1	510231655578439
1	510231653578439
1	510231647578439
1	510231637578439
1	510231633578439
1	510231627578439
1	510231625578439
1	510231623578439
1	510231622578439
1	510231616578439
1	510231612578439
1	510231610578439
1	510231608578439
1	510231607578439
1	510231606578439
1	510231604578439
1	510231603578439
1	510231600578439
1	510231597578439
1	510231596578439
1	510231595578439
1	510231594578439
1	510231590578439
1	510231584578439
1	510231578578439
1	510231573578439
1	510231567578439
1	510231553578439
1	510231549578439
1	510231548578439
1	510231545578439
1	510231544578439
1	510231543578439
1	510231542578439
1	510231538578439
1	510231536578439
1	510231533578439
1	510231532578439
1	510231531578439
1	510231526578439
1	510231524578439
1	510231523578439
1	510231520578439
1	510231519578439
1	510231517578439
1	510231515578439
1	510231514578439
1	510231499578439
1	510231498578439
1	510231494578439
1	510231489578439
1	510231481578439
1	510231477578439
1	510231473578439
1	510231466578439
1	510231465578439
1	510231460578439
1	510231459578439
1	NULL
1	510231451578439
1	510231449578439
1	510231448578439
1	510231447578439
1	510231443578439
1	510231442578439
1	510231440578439
1	510231438578439
1	510231437578439
1	510231435578439
1	510231432578439
1	510231426578439
1	510231419578439
1	510231409578439
1	510231408578439
1	510231405578439
1	510231403578439
1	510231398578439
1	510231397578439
1	510231395578439
1	510231391578439
1	510231390578439
1	510231389578439
1	510231387578439
1	510231386578439
1	510231385578439
1	510231382578439
1	510231381578439
1	510231376578439
1	510231375578439
1	510231374578439
1	510231369578439
1	510231368578439
1	510231360578439
1	510231358578439
1	510231356578439
1	510231352578439
1	510231347578439
1	510231344578439
1	510231343578439
1	510231337578439
1	510231335578439
1	510231331578439
1	510231328578439
1	510231325578439
1	510231319578439
1	510231314578439
1	510231313578439
1	510231302578439
1	510231298578439
1	510231294578439
1	510231292578439
1	510231291578439
1	510231287578439
1	510231285578439
1	510231284578439
1	510231281578439
1	510231280578439
1	510231272578439
1	510231271578439
1	510231268578439
1	510231265578439
1	510231264578439
1	510231262578439
1	510231259578439
1	510231253578439
1	510231250578439
1	510231247578439
1	510231243578439
1	510231242578439
1	510231241578439
1	510231240578439
1	510231238578439
1	510231237578439
1	510231234578439
1	510231232578439
1	510231231578439
1	510231224578439
1	510231222578439
1	510231220578439
1	510231214578439
1	510231212578439
1	510231204578439
1	510231201578439
1	510231195578439
1	510231190578439
1	510231189578439
1	510231187578439
1	510231181578439
1	510231179578439
1	510231178578439
1	510231175578439
1	510231173578439
1	510231169578439
1	510231167578439
1	510231162578439
1	510231161578439
1	510231160578439
1	510231154578439
1	510231151578439
1	510231144578439
1	510231143578439
1	510231132578439
1	510231130578439
1	510231129578439
1	510231124578439
1	510231121578439
1	510231118578439
1	510231117578439
1	510231116578439
1	510231114578439
1	510231113578439
1	510231110578439
1	510231105578439
1	510231102578439
1	510231101578439
1	510231099578439
1	510231089578439
1	510231084578439
1	510231083578439
1	510231080578439
1	510231077578439
1	510231075578439
1	510231072578439
1	510231068578439
1	510231064578439
1	510231063578439
1	510231060578439
1	510231059578439
1	510231058578439
1	510231055578439
1	510231052578439
1	510231050578439
1	510231048578439
1	510231047578439
1	510231042578439
1	510231038578439
1	510231036578439
1	510231034578439
1	510231033578439
1	510231025578439
1	510231023578439
1	510231020578439
1	510231019578439
1	510231018578439
1	510231017578439
1	510231015578439
1	510231013578439
1	510231008578439
1	510231006578439
1	510231005578439
1	510231003578439
1	510231000578439
1	510230999578439
1	510230997578439
1	510230994578439
1	510230984578439
1	510230980578439
1	510230978578439
1	510230973578439
1	510230970578439
1	510230969578439
1	510230968578439
1	510230966578439
1	510230965578439
1	510230959578439
1	510230958578439
1	510230957578439
1	510230954578439
1	510230953578439
1	510230950578439
1	510230943578439
1	510230939578439
1	510230931578439
1	510230928578439
1	510230924578439
1	510230919578439
1	510230916578439
1	510230912578439
1	510230910578439
1	510230909578439
1	510230904578439
1	510230902578439
1	510230900578439
1	510230898578439
1	510230894578439
1	510230891578439
1	510230889578439
1	510230882578439
1	510230879578439
1	510230878578439
1	510230874578439
1	510230868578439
1	510230865578439
1	510230864578439
1	510230863578439
1	510230858578439
1	510230857578439
1	510230852578439
1	510230851578439
1	510230849578439
1	510230848578439
1	510230844578439
1	510230840578439
1	510230837578439
1	510230829578439
1	510230828578439
1	510230821578439
1	510230818578439
1	510230807578439
1	510230804578439
1	510230802578439
1	510230795578439
1	510230794578439
1	510230791578439
1	510230790578439
1	510230788578439
1	510230787578439
1	510230786578439
1	510230781578439
1	510230780578439
1	510230779578439
1	510230778578439
1	510230777578439
1	510230776578439
1	510230772578439
1	510230767578439
1	510230764578439
1	510230761578439
1	510230760578439
1	510230756578439
1	510230755578439
1	510230753578439
1	510230743578439
1	510230741578439
1	510230738578439
1	510230734578439
1	510230727578439
1	510230726578439
1	510230725578439
1	510230722578439
1	510230720578439
1	510230718578439
1	510230714578439
1	510230713578439
1	510230711578439
1	510230710578439
1	510230708578439
1	510230704578439
1	510230703578439
1	510230701578439
1	510230697578439
1	510230695578439
1	510230694578439
1	510230693578439
1	510230692578439
1	510230691578439
1	510230689578439
1	510230681578439
1	510230680578439
1	510230677578439
1	510230675578439
1	510230669578439
1	510230664578439
1	510230660578439
1	510230659578439
1	510230651578439
1	510230647578439
1	510230643578439
1	510230642578439
1	510230638578439
1	510230637578439
1	510230632578439
1	510230630578439
1	510230627578439
1	510230626578439
1	510230620578439
1	510230617578439
1	510230616578439
1	510230614578439
1	510230613578439
1	510230610578439
1	510230605578439
1	510230604578439
1	510230602578439
1	510230601578439
1	510230594578439
1	510230589578439
1	510230585578439
1	510230584578439
1	510230582578439
1	510230575578439
1	510230574578439
1	510230573578439
1	510230564578439
1	510230557578439
1	510230555578439
1	510230554578439
1	510230553578439
1	510230548578439
1	510230546578439
1	510230545578439
1	510230532578439
1	510230531578439
1	510230528578439
1	510230524578439
1	510230523578439
1	510230521578439
1	510230519578439
1	510230517578439
1	510230513578439
1	510230512578439
1	510230504578439
1	510230503578439
1	510230502578439
1	510230500578439
1	510230496578439
1	510230494578439
1	510230493578439
1	510230492578439
1	510230491578439
1	510230488578439
1	510230487578439
1	510230485578439
1	510230484578439
1	510230483578439
1	510230480578439
1	510230476578439
1	510230473578439
1	510230468578439
1	510230466578439
1	510230463578439
1	510230460578439
1	510230458578439
1	510230456578439
1	510230455578439
1	510230451578439
1	510230449578439
1	510230448578439
1	510230447578439
1	510230445578439
1	510230441578439
1	510230438578439
1	510230433578439
1	510230430578439
1	510230424578439
1	510230419578439
1	510230418578439
1	510230413578439
1	510230411578439
1	510230409578439
1	510230405578439
1	510230403578439
1	510230402578439
1	510230398578439
1	510230377578439
1	510230376578439
1	510230373578439
1	510230372578439
1	510230365578439
1	510230364578439
1	510230361578439
1	510230360578439
1	510230358578439
1	510230357578439
1	510230353578439
1	510230345578439
1	510230342578439
1	510230332578439
1	510230328578439
1	510230325578439
1	510230318578439
1	510230315578439
1	510230314578439
1	510230307578439
1	510230305578439
1	510230297578439
1	510230292578439
1	510230287578439
1	510230286578439
1	510230285578439
1	510230284578439
1	510230282578439
1	510230279578439
1	510230278578439
1	510230276578439
1	510230275578439
1	510230271578439
1	510230269578439
1	510230263578439
1	510230262578439
1	510230261578439
1	510230258578439
1	510230256578439
1	510230253578439
1	510230252578439
1	510230250578439
1	510230248578439
1	510230247578439
1	510230245578439
1	510230243578439
1	510230241578439
1	510230240578439
1	510230231578439
1	510230228578439
1	510230227578439
1	510230225578439
1	510230224578439
1	510230220578439
1	510230218578439
1	510230217578439
1	510230216578439
1	510230213578439
1	510230211578439
1	510230209578439
1	510230200578439
1	510230199578439
1	510230196578439
1	510230193578439
1	510230192578439
1	510230191578439
1	510230189578439
1	510230188578439
1	510230181578439
1	510230178578439
1	510230171578439
1	510230169578439
1	510230168578439
1	510230161578439
1	510230153578439
1	510230150578439
1	510230148578439
1	510230143578439
1	510230142578439
1	510230134578439
1	510230133578439
1	510230127578439
1	510230124578439
1	510230118578439
1	510230117578439
1	510230112578439
1	510230111578439
1	510230096578439
1	510230093578439
1	510230091578439
1	510230090578439
1	510230089578439
1	510230087578439
1	510230086578439
1	510230081578439
1	510230080578439
1	510230076578439
1	510230074578439
1	510230073578439
1	510230061578439
1	510230058578439
1	510230057578439
1	510230054578439
1	510230053578439
1	510230052578439
1	510230051578439
1	510230050578439
1	510230048578439
1	510230045578439
1	510230044578439
1	510230043578439
1	510230042578439
1	510230040578439
1	510230038578439
1	510230036578439
1	510230033578439
1	510230032578439
1	510230030578439
1	510230029578439
1	510230025578439
1	510230024578439
1	510230023578439
1	510230022578439
1	510230019578439
1	510230016578439
1	510230013578439
1	510230010578439
1	510230009578439
1	510230008578439
1	510230007578439
1	510230005578439
1	510230004578439
1	510230002578439
1	510229999578439
1	510229993578439
1	510229991578439
1	510229988578439
1	510229987578439
1	510229983578439
1	510229981578439
1	510229979578439
1	510229974578439
1	510229972578439
1	510229963578439
1	510229953578439
1	510229951578439
1	510229947578439
1	510229944578439
1	510229932578439
1	510229930578439
1	510229928578439
1	510229925578439
1	510229922578439
1	510229921578439
1	510229919578439
1	510229916578439
1	510229909578439
1	510229904578439
1	510229901578439
1	510229900578439
1	510229894578439
1	510229893578439
1	510229889578439
1	510229888578439
1	510229886578439
1	510229885578439
1	510229883578439
1	510229881578439
1	510229879578439
1	510229873578439
1	510229872578439
1	510229869578439
1	510229864578439
1	510229863578439
1	510229860578439
1	510229856578439
1	510229855578439
1	510229852578439
1	510229848578439
1	510229841578439
1	510229837578439
1	510229835578439
1	510229834578439
1	510229833578439
1	510229830578439
1	510229828578439
1	510229827578439
1	510229818578439
1	510229817578439
1	510229813578439
1	510229811578439
1	510229808578439
1	510229805578439
1	510229802578439
1	510229801578439
1	510229799578439
1	510229798578439
1	510229795578439
1	510229792578439
1	510229791578439
1	510229789578439
1	510229785578439
1	510229782578439
1	510229781578439
1	510229773578439
1	510229769578439
1	510229766578439
1	510229762578439
1	510229759578439
1	510229758578439
1	510229756578439
1	510229754578439
1	510229753578439
1	510229752578439
1	510229750578439
1	510229747578439
1	510229739578439
1	510229738578439
1	510229736578439
1	510229733578439
1	510229730578439
1	510229725578439
1	510229724578439
1	510229720578439
1	510229719578439
1	510229718578439
1	510229712578439
1	510229711578439
1	510229708578439
1	510229697578439
1	510229694578439
1	510229692578439
1	510229691578439
1	510229688578439
1	510229684578439
1	510229679578439
1	510229673578439
1	510229669578439
1	510229667578439
1	510229665578439
1	510229664578439
1	510229659578439
1	510229656578439
1	510229655578439
1	510229653578439
1	510229652578439
1	510229649578439
1	510229647578439
1	510229645578439
1	510229641578439
1	510229638578439
1	510229637578439
1	510229631578439
1	510229627578439
1	510229626578439
1	510229623578439
1	510229622578439
1	510229621578439
1	510229619578439
1	510229617578439
1	510229615578439
1	510229601578439
1	510229596578439
1	510229593578439
1	510229591578439
1	510229590578439
1	510229589578439
1	510229583578439
1	510229580578439
1	510229576578439
1	510229574578439
1	510229571578439
1	510229570578439
1	510229568578439
1	510229567578439
1	510229564578439
1	510229563578439
1	510229562578439
1	510229561578439
1	510229559578439
1	510229556578439
1	510229555578439
1	510229554578439
1	510229547578439
1	510229546578439
1	510229539578439
1	510229538578439
1	510229535578439
1	510229531578439
1	510229529578439
1	510229528578439
1	510229518578439
1	510229517578439
1	510229512578439
1	510229510578439
1	510229509578439
1	510229504578439
1	510229502578439
1	510229501578439
1	510229499578439
1	510229498578439
1	510229486578439
1	510229485578439
1	510229484578439
1	510229482578439
1	510229479578439
1	510229470578439
1	510229467578439
1	510229466578439
1	510229463578439
1	510229457578439
1	510229449578439
1	510229447578439
1	510229442578439
1	510229438578439
1	510229437578439
1	510229433578439
1	510229431578439
1	510229428578439
1	510229427578439
1	510229426578439
1	510229422578439
1	510229421578439
1	510229417578439
1	510229412578439
1	510229411578439
1	510229410578439
1	510229401578439
1	510229399578439
1	510229396578439
1	510229393578439
1	510229391578439
1	510229385578439
1	510229384578439
1	510229382578439
1	510229381578439
1	510229378578439
1	510229376578439
1	510229369578439
1	510229368578439
1	510229366578439
1	510229364578439
1	510229363578439
1	510229362578439
1	510229360578439
1	510229359578439
1	510229358578439
1	510229357578439
1	510229356578439
1	510229354578439
1	510229351578439
1	510229350578439
1	510229349578439
1	510229346578439
1	510229343578439
1	510229331578439
1	510229330578439
1	510229326578439
1	510229324578439
1	510229323578439
1	510229315578439
1	510229314578439
1	510229311578439
1	510229308578439
1	510229302578439
1	510229299578439
1	510229294578439
1	510229293578439
1	510229292578439
1	510229291578439
1	510229289578439
1	510229285578439
1	510229279578439
1	510229278578439
1	510229272578439
1	510229267578439
1	510229266578439
1	510229265578439
1	510229262578439
1	510229258578439
1	510229256578439
1	510229249578439
1	510229243578439
1	510229240578439
1	510229239578439
1	510229236578439
1	510229235578439
1	510229233578439
1	510229232578439
1	510229226578439
1	510229225578439
1	510229223578439
1	510229222578439
1	510229210578439
1	510229207578439
1	510229199578439
1	510229194578439
1	510229190578439
1	510229187578439
1	510229186578439
1	510229178578439
1	510229175578439
1	510229174578439
1	510229169578439
1	510229166578439
1	510229164578439
1	510229160578439
1	510229159578439
1	510229158578439
1	510229157578439
1	510229156578439
1	510229155578439
1	510229153578439
1	510229151578439
1	510229149578439
1	510229147578439
1	510229146578439
1	510229143578439
1	510229142578439
1	510229141578439
1	510229140578439
1	510229134578439
1	510229125578439
1	510229124578439
1	510229122578439
1	510229107578439
1	510229104578439
1	510229103578439
1	510229099578439
1	510229098578439
1	510229097578439
1	510229094578439
1	510229092578439
1	510229088578439
1	510229087578439
1	510229084578439
1	510229082578439
1	510229081578439
1	510229080578439
1	510229079578439
1	510229067578439
1	510229061578439
1	510229055578439
1	510229054578439
1	510229046578439
1	510229041578439
1	510229040578439
1	510229035578439
1	510229031578439
1	510229027578439
1	510229026578439
1	510229024578439
1	510229021578439
1	510229017578439
1	510229014578439
1	510229009578439
1	510229005578439
1	510229002578439
1	510228996578439
1	510228989578439
1	510228987578439
1	510228974578439
1	510228970578439
1	510228969578439
1	510228966578439
1	510228962578439
1	510228958578439
1	510228957578439
1	510228956578439
1	510228954578439
1	510228952578439
1	510228951578439
1	510228948578439
1	510228944578439
1	510228942578439
1	510228938578439
1	510228937578439
1	510228936578439
1	510228935578439
1	510228934578439
1	510228933578439
1	510228929578439
1	510228927578439
1	510228925578439
1	510228922578439
1	510228917578439
1	510228916578439
1	510228902578439
1	510228899578439
1	510228896578439
1	510228895578439
1	510228891578439
1	510228890578439
1	510228889578439
1	510228888578439
1	510228887578439
1	510228876578439
1	510228873578439
1	510228870578439
1	510228867578439
1	510228860578439
1	510228856578439
1	510228855578439
1	510228852578439
1	510228846578439
1	510228844578439
1	510228841578439
1	510228838578439
1	510228835578439
1	510228834578439
1	510228829578439
1	510228826578439
1	510228825578439
1	510228821578439
1	510228819578439
1	510228817578439
1	510228813578439
1	510228806578439
1	510228803578439
1	510228800578439
1	510228799578439
1	510228796578439
1	510228788578439
1	510228783578439
1	510228782578439
1	510228781578439
1	510228780578439
1	510228776578439
1	510228774578439
1	510228764578439
1	510228763578439
1	510228759578439
1	510228755578439
1	510228749578439
1	510228747578439
1	510228746578439
1	510228744578439
1	510228743578439
1	510228741578439
1	510228728578439
1	510228727578439
1	510228712578439
1	510228709578439
1	510228702578439
1	510228701578439
1	510228699578439
1	510228698578439
1	510228697578439
1	510228696578439
1	510228690578439
1	510228689578439
1	510228683578439
1	510228682578439
1	510228675578439
1	510228673578439
1	510228672578439
1	510228671578439
1	510228667578439
1	510228666578439
1	510228663578439
1	510228660578439
1	510228659578439
1	510228655578439
1	510228654578439
1	510228652578439
1	510228646578439
1	510228644578439
1	510228638578439
1	510228634578439
1	510228633578439
1	510228630578439
1	510228628578439
1	510228625578439
1	510228620578439
1	510228614578439
1	510228608578439
1	510228605578439
1	510228602578439
1	510228598578439
1	510228596578439
1	510228592578439
1	510228586578439
1	510228585578439
1	510228583578439
1	510228581578439
1	510228580578439
1	510228576578439
1	510228573578439
1	510228570578439
1	510228565578439
1	510228560578439
1	510228559578439
1	510228555578439
1	510228553578439
1	510228552578439
1	510228550578439
1	510228549578439
1	510228545578439
1	510228544578439
1	510228541578439
1	510228535578439
1	510228533578439
1	510228531578439
1	510228528578439
1	510228527578439
1	510228520578439
1	510228513578439
1	510228512578439
1	510228504578439
1	510228502578439
1	510228500578439
1	510228499578439
1	510228496578439
1	510228495578439
1	510228492578439
1	510228489578439
1	510228482578439
1	510228481578439
1	510228479578439
1	510228478578439
1	510228476578439
1	510228474578439
1	510228472578439
1	510228469578439
1	510228468578439
1	510228467578439
1	510228466578439
1	510228465578439
1	510228460578439
1	510228459578439
1	510228458578439
1	510228453578439
1	510228452578439
1	510228449578439
1	510228442578439
1	510228439578439
1	510228438578439
1	510228436578439
1	510228433578439
1	510228428578439
1	510228422578439
1	510228421578439
1	510228416578439
1	510228414578439
1	510228413578439
1	510228412578439
1	510228411578439
1	510228409578439
1	510228399578439
1	510228396578439
1	510228392578439
1	510228391578439
1	510228389578439
1	510228387578439
1	510228386578439
1	510228384578439
1	510228379578439
1	510228378578439
1	510228367578439
1	510228362578439
1	510228360578439
1	510228358578439
1	510228356578439
1	510228355578439
1	510228352578439
1	510228351578439
1	510228347578439
1	510228345578439
1	510228344578439
1	510228342578439
1	510228341578439
1	510228337578439
1	510228333578439
1	510228325578439
1	510228322578439
1	510228320578439
1	510228318578439
1	510228310578439
1	510228308578439
1	510228305578439
1	510228304578439
1	510228303578439
1	510228302578439
1	510228301578439
1	510228300578439
1	510228298578439
1	510228297578439
1	510228296578439
1	510228291578439
1	510228289578439
1	510228288578439
1	510228285578439
1	510228281578439
1	510228279578439
1	510228278578439
1	510228271578439
1	510228269578439
1	510228265578439
1	510228264578439
1	510228261578439
1	510228260578439
1	510228256578439
1	510228255578439
1	510228254578439
1	510228253578439
1	510228250578439
1	510228245578439
1	510228241578439
1	510228240578439
1	510228235578439
1	510228233578439
1	510228232578439
1	510228229578439
1	510228228578439
1	510228225578439
1	510228224578439
1	510228223578439
1	510228220578439
1	510228217578439
1	510228216578439
1	510228209578439
1	510228204578439
1	510228203578439
1	510228201578439
1	510228199578439
1	510228196578439
1	510228189578439
1	510228185578439
1	510228180578439
1	510228178578439
1	510228174578439
1	510228173578439
1	510228171578439
1	510228164578439
1	510228156578439
1	510228155578439
1	510228154578439
1	510228150578439
1	510228147578439
1	510228146578439
1	510228143578439
1	510228141578439
1	510228139578439
1	510228136578439
1	510228128578439
1	510228126578439
1	510228124578439
1	510228117578439
1	510228114578439
1	510228112578439
1	510228111578439
1	510228110578439
1	510228109578439
1	510228104578439
1	510228097578439
1	510228096578439
1	510228095578439
1	510228094578439
1	510228090578439
1	510228089578439
1	510228088578439
1	510228083578439
1	510228082578439
1	510228081578439
1	510228080578439
1	510228078578439
1	510228073578439
1	510228072578439
1	510228071578439
1	510228069578439
1	510228063578439
1	510228062578439
1	510228061578439
1	510228060578439
1	510228059578439
1	510228056578439
1	510228055578439
1	510228054578439
1	510228052578439
1	510228049578439
1	510228047578439
1	510228045578439
1	510228042578439
1	510228039578439
1	510228037578439
1	510228030578439
1	510228024578439
1	510228023578439
1	510228022578439
1	510228021578439
1	510228020578439
1	510228019578439
1	510228016578439
1	510228014578439
1	510228005578439
1	510228002578439
1	510228001578439
1	510227999578439
1	510227998578439
1	510227992578439
1	510227991578439
1	510227989578439
1	510227981578439
1	510227980578439
1	510227979578439
1	510227970578439
1	510227968578439
1	510227967578439
1	510227964578439
1	510227957578439
1	510227955578439
1	510227954578439
1	510227953578439
1	510227947578439
1	510227944578439
1	510227939578439
1	510227938578439
1	510227937578439
1	510227936578439
1	510227932578439
1	510227929578439
1	510227923578439
1	510227922578439
1	510227921578439
1	510227919578439
1	510227916578439
1	510227915578439
1	510227912578439
1	510227911578439
1	510227908578439
1	510227900578439
1	510227898578439
1	510227897578439
1	510227896578439
1	510227894578439
1	510227892578439
1	510227889578439
1	510227887578439
1	510227886578439
1	510227883578439
1	510227879578439
1	510227877578439
1	510227876578439
1	510227872578439
1	510227870578439
1	510227865578439
1	510227864578439
1	510227863578439
1	510227861578439
1	510227857578439
1	510227855578439
1	510227853578439
1	510227847578439
1	510227843578439
1	510227839578439
1	510227837578439
1	510227834578439
1	510227833578439
1	510227829578439
1	510227828578439
1	510227822578439
1	510227820578439
1	510227814578439
1	510227813578439
1	510227811578439
1	510227808578439
1	510227806578439
1	510227798578439
1	510227792578439
1	510227790578439
1	510227789578439
1	510227788578439
1	510227783578439
1	510227781578439
1	510227776578439
1	510227775578439
1	510227774578439
1	510227770578439
1	510227768578439
1	510227766578439
1	510227765578439
1	510227760578439
1	510227759578439
1	510227756578439
1	510227755578439
1	510227753578439
1	510227752578439
1	510227749578439
1	510227748578439
1	510227746578439
1	510227742578439
1	510227741578439
1	510227739578439
1	510227738578439
1	510227732578439
1	510227728578439
1	510227723578439
1	510227719578439
1	510227715578439
1	510227713578439
1	510227709578439
1	510227706578439
1	510227703578439
1	510227701578439
1	510227700578439
1	510227698578439
1	510227697578439
1	510227695578439
1	510227689578439
1	510227687578439
1	510227686578439
1	510227684578439
1	510227682578439
1	510227681578439
1	510227677578439
1	510227675578439
1	510227673578439
1	510227668578439
1	510227667578439
1	510227666578439
1	510227665578439
1	510227663578439
1	510227662578439
1	510227661578439
1	510227657578439
1	510227648578439
1	510227641578439
1	510227640578439
1	510227635578439
1	510227633578439
1	510227630578439
1	510227626578439
1	510227624578439
1	510227622578439
1	510227621578439
1	510227616578439
1	510227614578439
1	510227612578439
1	510227603578439
1	510227602578439
1	510227600578439
1	510227598578439
1	510227597578439
1	510227595578439
1	510227594578439
1	510227593578439
1	510227588578439
1	510227587578439
1	510227584578439
1	510227581578439
1	510227580578439
1	510227575578439
1	510227573578439
1	510227563578439
1	510227558578439
1	510227556578439
1	510227550578439
1	510227549578439
1	510227546578439
1	510227544578439
1	510227543578439
1	510227540578439
1	510227539578439
1	510227538578439
1	510227523578439
1	510227521578439
1	510227517578439
1	510227510578439
1	510227507578439
1	510227503578439
1	510227499578439
1	510227497578439
1	510227495578439
1	510227493578439
1	510227490578439
1	510227489578439
1	510227486578439
1	510227484578439
1	510227483578439
1	510227480578439
1	510227479578439
1	510227477578439
1	510227475578439
1	510227471578439
1	510227467578439
1	510227466578439
1	510227463578439
1	510227461578439
1	510227460578439
1	510227457578439
1	510227455578439
1	510227447578439
1	510227443578439
1	510227440578439
1	510227439578439
1	510227437578439
1	510227433578439
1	510227430578439
1	510227426578439
1	510227423578439
1	510227418578439
1	510227413578439
1	510227410578439
1	510227406578439
1	510227402578439
1	510227400578439
1	510227398578439
1	510227397578439
1	510227394578439
1	510227386578439
1	510227382578439
1	510227376578439
1	510227368578439
1	510227366578439
1	510227361578439
1	510227358578439
1	510227356578439
1	510227355578439
1	510227354578439
1	510227352578439
1	510227350578439
1	510227346578439
1	510227342578439
1	510227340578439
1	510227339578439
1	510227332578439
1	510227329578439
1	510227326578439
1	510227324578439
1	510227322578439
1	510227320578439
1	510227315578439
1	510227313578439
1	510227307578439
1	510227306578439
1	510227305578439
1	510227303578439
1	510227300578439
1	510227299578439
1	510227297578439
1	510227293578439
1	510227292578439
1	510227290578439
1	510227284578439
1	510227282578439
1	510227279578439
1	510227277578439
1	510227273578439
1	510227272578439
1	510227271578439
1	510227269578439
1	510227268578439
1	510227267578439
1	510227259578439
1	510227250578439
1	510227248578439
1	510227247578439
1	510227243578439
1	510227239578439
1	510227231578439
1	510227227578439
1	510227225578439
1	510227224578439
1	510227222578439
1	510227219578439
1	510227218578439
1	510227215578439
1	510227214578439
1	510227213578439
1	510227209578439
1	510227207578439
1	510227206578439
1	510227200578439
1	510227199578439
1	510227198578439
1	510227197578439
1	510227195578439
1	510227190578439
1	510227182578439
1	510227178578439
1	510227168578439
1	510227166578439
1	510227164578439
1	510227163578439
1	510227162578439
1	510227158578439
1	510227153578439
1	510227144578439
1	510227140578439
1	510227138578439
1	510227135578439
1	510227134578439
1	510227129578439
1	510227126578439
1	510227125578439
1	510227123578439
1	510227122578439
1	510227120578439
1	510227118578439
1	510227115578439
1	510227112578439
1	510227106578439
1	510227098578439
1	510227090578439
1	510227089578439
1	510227087578439
1	510227085578439
1	510227084578439
1	510227083578439
1	510227082578439
1	510227081578439
1	510227080578439
1	510227074578439
1	510227069578439
1	510227068578439
1	510227064578439
1	510227063578439
1	510227058578439
1	510227054578439
1	510227053578439
1	510227049578439
1	510227047578439
1	510227043578439
1	510227041578439
1	510227035578439
1	510227026578439
1	510227025578439
1	510227020578439
1	510227015578439
1	510227011578439
1	510227010578439
1	510227009578439
1	510227008578439
1	510227007578439
1	510227004578439
1	510227002578439
1	510227000578439
1	510226999578439
1	510226997578439
1	510226994578439
1	510226991578439
1	510226989578439
1	510226984578439
1	510226983578439
1	510226982578439
1	510226981578439
1	510226967578439
1	510226965578439
1	510226963578439
1	510226962578439
1	510226961578439
1	510226955578439
1	510226945578439
1	510226942578439
1	510226938578439
1	510226933578439
1	510226932578439
1	510226929578439
1	510226927578439
1	510226926578439
1	510226924578439
1	510226911578439
1	510226910578439
1	510226905578439
1	510226901578439
1	510226895578439
1	510226886578439
1	510226882578439
1	510226880578439
1	510226878578439
1	510226876578439
1	510226872578439
1	510226867578439
1	510226866578439
1	510226862578439
1	510226860578439
1	510226858578439
1	510226856578439
1	510226855578439
1	510226852578439
1	510226850578439
1	510226846578439
1	510226845578439
1	510226844578439
1	510226838578439
1	510226836578439
1	510226834578439
1	510226833578439
1	510226827578439
1	510226826578439
1	510226823578439
1	510226820578439
1	510226818578439
1	510226817578439
1	510226816578439
1	510226810578439
1	510226806578439
1	510226802578439
1	510226801578439
1	510226800578439
1	510226799578439
1	510226795578439
1	510226791578439
1	510226789578439
1	510226785578439
1	510226782578439
1	510226781578439
1	510226776578439
1	510226772578439
1	510226768578439
1	510226767578439
1	510226763578439
1	510226757578439
1	510226756578439
1	510226754578439
1	510226753578439
1	510226751578439
1	510226750578439
1	510226749578439
1	510226743578439
1	510226740578439
1	510226739578439
1	510226738578439
1	510226737578439
1	510226736578439
1	510226731578439
1	510226730578439
1	510226729578439
1	510226727578439
1	510226725578439
1	510226723578439
1	510226719578439
1	510226716578439
1	510226710578439
1	510226705578439
1	510226683578439
1	510226677578439
1	510226675578439
1	510226670578439
1	510226669578439
1	510226665578439
1	510226659578439
1	510226656578439
1	510226654578439
1	510226648578439
1	510226647578439
1	510226646578439
1	510226643578439
1	510226640578439
1	510226638578439
1	510226637578439
1	510226632578439
1	510226630578439
1	510226628578439
1	510226626578439
1	510226624578439
1	510226622578439
1	510226612578439
1	510226610578439
1	510226608578439
1	510226606578439
1	510226605578439
1	510226602578439
1	510226599578439
1	510226596578439
1	510226594578439
1	510226590578439
1	510226588578439
1	510226587578439
1	510226584578439
1	510226581578439
1	510226576578439
\.

-- Another test on RLE block boundary
CREATE TABLE rle_block_boundary (a int, b text) with (appendonly=true, orientation=column, compresstype=rle_type);

COPY rle_block_boundary(b) FROM STDIN;
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
nnnnnnnnnnnnnnnnnn
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
nnnnnnnnnnnnn
Inner Suburbs
Inner Suburbs
Middleburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Country Comfort
Landed Gentry
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
n
Country Comfort
Midtown Mix
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
n
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Elite Suburbs
Landed Gentry
Second City Society
Micro-City Blues
Elite Suburbs
Elite Suburbs
Inner Suburbs
The Affluentials
Urban Cores
Midtown Mix
Second City Society
City Centers
Middleburbs
Micro-City Blues
Middleburbs
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Elite Suburbs
Middleburbs
Inner Suburbs
Middle America
Landed Gentry
Second City Society
Second City Society
The Affluentials
The Affluentials
Middle America
n
Elite Suburbs
Elite Suburbs
The Affluentials
The Affluentials
Midtown Mix
Midtown Mix
Country Comfort
Landed Gentry
Landed Gentry
n
Inner Suburbs
Inner Suburbs
Middleburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfortountry Comfort
Landed Gentry
Landed Gentry
n
Inner Suburbs
Middleburbs
Inner Suburbs
Landed Gentry
Rustic Living
Second City Society
Urban Cores
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
Country Comfort
Second City Society
City Centers
Middleburbs
Middleburbs
Micro-City Blues
Elite Suburbs
Urban Uptown
Landed Gentry
The Affluentials
Eountry Comfort
Landed Gentry
Country Comfort
The Affluentials
The Affluentials
n
n
Country Comfort
Midtown Mix
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
The Affluentials
n
n
Country Comfort
Country Comfort
The Affluentials
The Affluentials
n
n
Country Comfort
Country Comfort
Midtown Mix
Landed Gentry
Country Comfort
The Affluentials
The Affluentials
n
n
Country Comfort
Country Comfort
The Affluentials
The Affluentials
n
Midto
Midto
Country Comfort
Landed Gentry
Country Comfort
The Affluentials
The Affluentials
Country Comfort
Country Comfort
The Affluentials
The Affluentials
Countryyyyyyyyyyyyyy
Midtown Mixxxxxxxxxxxxxxx
Landed Gentryyyyyyyyyyyyyyy
Country Comfort
Affluen
Affluen
Affluen
\N
The Affluentials
\.

SELECT COUNT(*) FROM rle_block_boundary;

--
-- Bulk dense content header with RLE compression
begin;
create table bulk_rle_tab (a int) with (appendonly=true, orientation=column, compresstype='rle_type', compresslevel=3, checksum=true);
insert into bulk_rle_tab select i/50 from generate_series(1, 1000000)i;
insert into bulk_rle_tab values (1),(1),(1),(1),(1),(1),(2),(2),(2),(2),(2),(2),(2),(33),(3),(3),(3),(1),(8),(19),
    (20),(31),(32),(33),(34),(5),(5),(5),(5),(5),(6),(6),(6),(6),(6),(6),(7),(7),(7),(7),(7),(7),(7),(7),
    (null),(7),(7),(7),(null),(8),(8),(8),(8),(8),(8),(4),(4),(null),(4),(17),(17),(17),(null),(null),(null);
alter table bulk_rle_tab add column b varchar default 'abc' encoding(blocksize=8192);
insert into bulk_rle_tab values (-1, 'xyz');
update bulk_rle_tab set b = 'green' where a = -1;
commit;
--
-- Small content header with RLE header inside 
begin;
create table sml_rle_hdr (a int) with (appendonly=true, orientation=column, compresstype='rle_type');
insert into sml_rle_hdr values (1),(1),(1),(1),(1),(1),(2),(2),(2),(2),(2),(2),(2),(33),(3),(3),(3),(1),(8),(19),
    (20),(31),(32),(33),(34),(5),(5),(5),(5),(5),(6),(6),(6),(6),(6),(6),(7),(7),(7),(7),(7),(7),(7),(7),
    (null),(7),(7),(7),(null),(8),(8),(8),(8),(8),(8),(4),(4),(null),(4),(17),(17),(17),(null),(null),(null);
alter table sml_rle_hdr add column b float default random();
-- update / insert / select after this operation
insert into sml_rle_hdr values (-1,-1.1);
set client_min_messages=warning;
update sml_rle_hdr set b = b + 10 where a = -1;
commit;

-- Some smoke tests against rle's levels using zstd
create table co_rle_zstd1(i int encoding(compresstype=rle_type, compresslevel=5)) using ao_column;
create table co_rle_zstd3(i int encoding(compresstype=rle_type, compresslevel=6)) using ao_column;
\d+ co_rle_zstd1
\d+ co_rle_zstd3
insert into co_rle_zstd1 select generate_series(1, 100000);
insert into co_rle_zstd3 select generate_series(1, 100000);
select count(distinct i) from co_rle_zstd1;
select count(distinct i) from co_rle_zstd3;

create table co_rle_zlib_to_zstd(i int encoding(compresstype=rle_type, compresslevel=4)) using ao_column;
insert into co_rle_zlib_to_zstd select generate_series(1, 100000);
alter table co_rle_zlib_to_zstd alter column i set encoding(compresstype=rle_type, compresslevel=5);
\d+ co_rle_zlib_to_zstd
select count(distinct i) from co_rle_zlib_to_zstd;
