# gpmemreport 

Interprets the output created by the [gpmemwatcher](gpmemwatcher.html) utility and generates output files in a readable format.

## <a id="section2"></a>Synopsis 

```
gpmemreport [<GZIP_FILE>] [[-s <START>] | [--start= <START>]] [[-e <END>] | [--end= <END>]] 
        
gpmemreport --version

gpmemreport -h | --help 
```

## <a id="section3"></a>Description 

The `gpmemreport` utility helps interpret the output file created by the [gpmemwatcher](gpmemwatcher.html) utility.

When running `gpmemreport` against the `.gz` files generated by `gpmemwatcher`, it generates a series of files, where each file corresponds to a 60 second period of data collected by `gpmemwatcher` converted into a readable format.

## <a id="section4"></a>Options 

-s \| --start start\_time
:   Indicates the start of the reporting period. Timestamp format must be `'%Y-%m-%d %H:%M:%S'`.

-e \| --end end\_time
:   Indicates the end of the reporting period. Timestamp format must be `'%Y-%m-%d %H:%M:%S'`.

--version
:   Displays the version of this utility.

-h \| --help
:   Displays the online help.

## <a id="section5"></a>Examples 

**Example 1: Extract all the files generated by `gpmemwatcher` for the Greenplum coordinator**

Locate the output `.gz` file from `gpmemwatcher` and run `gpmemreport` against it:

```
$ gpmemreport cdw.ps.out.gz
>>>21:11:19:15:37:18<<<

>>>21:11:19:15:38:18<<<

>>>21:11:19:15:39:18<<<

```

Check that the generated files are listed under the current directory:

```
$ ls -thrl
-rw-rw-r--. 1 gpadmin gpadmin 1.2K Nov 19 15:50 20211119-153718
-rw-rw-r--. 1 gpadmin gpadmin 1.2K Nov 19 15:50 20211119-153818
-rw-rw-r--. 1 gpadmin gpadmin 1.2K Nov 19 15:50 20211119-153918
```

**Example 2: Extract the files generated by `gpmemwatcher` for the Greenplum coordinator starting after a certain timestamp**

Locate the output `.gz` file from `gpmemwatcher` and run `gpmemreport` against it, indicating the start time as `2021-11-19 15:38:00`:

```
$ gpmemreport cdw.ps.out.gz --start='2021-11-19 15:38:00'
>>>21:11:19:15:37:18<<<

>>>21:11:19:15:38:18<<<

>>>21:11:19:15:39:18<<<
```

Check under the current directory that only the selected timestamp files are listed:

```
$ ls -thrl
-rw-rw-r--. 1 gpadmin gpadmin 1.2K Nov 19 15:50 20211119-153818
-rw-rw-r--. 1 gpadmin gpadmin 1.2K Nov 19 15:50 20211119-153918
```

## <a id="section6"></a>See Also 

[gpmemwatcher](gpmemwatcher.html)

