# Greenplum Database Security Configuration Guide 

This guide describes how to secure a Greenplum Database system. The guide assumes knowledge of Linux/UNIX system administration and database management systems. Familiarity with structured query language \(SQL\) is helpful.

> **Important** Because VMware Greenplum is based on PostgreSQL, certain commercial security scanning software, when trying to identify VMware Greenplum Database vulnerabilities, may use a PostgreSQL database profile. The reports generated by these tools can produce misleading results, and cannot be trusted as an accurate assessment of vulnerabilities that may exist in VMware Greenplum. For further assistance, or to report any specific VMware Greenplum security concerns, refer to the [VMware Tanzu Security Response Center](https://tanzu.vmware.com/security) guidelines.

Because Greenplum Database is based on PostgreSQL 9.4, this guide assumes some familiarity with PostgreSQL. References to [PostgreSQL documentation](https://www.postgresql.org/docs/12/index.html) are provided throughout this guide for features that are similar to those in Greenplum Database.

This information is intended for system administrators responsible for administering a Greenplum Database system.

-   **[Securing the Database](../topics/SecuringGPDB.html)**  
Introduces Greenplum Database security topics.
-   **[Greenplum Database Ports and Protocols](../topics/ports_and_protocols.html)**  
Lists network ports and protocols used within the Greenplum cluster.
-   **[Configuring Client Authentication](../topics/Authenticate.html)**  
Describes the available methods for authenticating Greenplum Database clients.
-   **[Configuring Database Authorization](../topics/Authorization.html)**  
Describes how to restrict authorization access to database data at the user level by using roles and permissions.
-   **[Auditing](../topics/Auditing.html)**  
Describes Greenplum Database events that are logged and should be monitored to detect security threats.
-   **[Encrypting Data and Database Connections](../topics/Encryption.html)**  
Describes how to encrypt data at rest in the database or in transit over the network, to protect from eavesdroppers or man-in-the-middle attacks.
-   **[Security Best Practices](../topics/BestPractices.html)**  
Describes basic security best practices that you should follow to ensure the highest level of system security. 

## <a id="endpoint_security"></a>About Endpoint Security Software

If you install any endpoint security software on your Greenplum Database hosts, such as anti-virus, data protection, network security, or other security related software, the additional CPU, IO, network or memory load can interfere with Greenplum Database operations and may affect database performance and stability.

Refer to your endpoint security vendor and perform careful testing in a non-production environment to ensure it does not have any negative impact on Greenplum Database operations.

