# pg_depend 

The `pg_depend` system catalog table records the dependency relationships between database objects. This information allows `DROP` commands to find which other objects must be dropped by `DROP CASCADE` or prevent dropping in the `DROP RESTRICT` case. See also [pg\_shdepend](pg_shdepend.html), which performs a similar function for dependencies involving objects that are shared across a Greenplum system.

In all cases, a `pg_depend` entry indicates that the referenced object may not be dropped without also dropping the dependent object. However, there are several subtypes identified by `deptype`:

-   **DEPENDENCY\_NORMAL \(n\)** — A normal relationship between separately-created objects. The dependent object may be dropped without affecting the referenced object. The referenced object may only be dropped by specifying `CASCADE`, in which case the dependent object is dropped, too. Example: a table column has a normal dependency on its data type.
-   **DEPENDENCY\_AUTO \(a\)** — The dependent object can be dropped separately from the referenced object, and should be automatically dropped \(regardless of `RESTRICT` or `CASCADE` mode\) if the referenced object is dropped. Example: a named constraint on a table is made auto-dependent on the table, so that it will go away if the table is dropped.
-   **DEPENDENCY\_INTERNAL \(i\)** — The dependent object was created as part of creation of the referenced object, and is really just a part of its internal implementation. A direct `DROP` of the dependent object will be disallowed outright \(issue a `DROP` against the referenced object instead\). A `DROP` of the referenced object will be propagated through to drop the dependent object whether `CASCADE` is specified or not. If the dependent object has to be dropped due to a dependency on some other object being removed, its drop is converted to a drop of the referenced object, so that `NORMAL` and `AUTO` dependencies of the dependent object behave much like they were dependencies of the referenced object. Example: a view's `ON SELECT` rule is made internally dependent on the view, preventing it from being dropped while the view remains. Dependencies of the rule \(such as tables it refers to\) act as if they were dependencies of the view.
-   **DEPENDENCY\_PARTITION\_PRI \(P\)**, **DEPENDENCY\_PARTITION\_SEC \(S\)** - The dependent object was created as part of creation of the referenced object, and is really just a part of its internal implementation; however, unlike `INTERNAL`, there is more than one such referenced object. The dependent object must not be dropped unless at least one of these referenced objects is dropped; if any one is, the dependent object should be dropped whether or not `CASCADE` is specified. Also unlike `INTERNAL`, a drop of some other object that the dependent object depends on does not result in automatic deletion of any partition-referenced object. Hence, if the drop does not cascade to at least one of these objects via some other path, it will be refused. \(In most cases, the dependent object shares all its non-partition dependencies with at least one partition-referenced object, so that this restriction does not result in blocking any cascaded delete.\) Primary and secondary partition dependencies behave identically except that the primary dependency is preferred for use in error messages; hence, a partition-dependent object should have one primary partition dependency and one or more secondary partition dependencies. Note that partition dependencies are made in addition to, not instead of, any dependencies the object would normally have. This simplifies `ATTACH/DETACH PARTITION` operations: the partition dependencies need only be added or removed. Example: a child partitioned index is made partition-dependent on both the partition table it is on and the parent partitioned index, so that it goes away if either of those is dropped, but not otherwise. The dependency on the parent index is primary, so that if the user tries to drop the child partitioned index, the error message will suggest dropping the parent index instead \(not the table\).
-   **DEPENDENCY\_EXTENSION \(e\)** - The dependent object is a member of the extension that is the referenced object \(see [pg_extension](pg_extension.html)\). The dependent object can be dropped only via `DROP EXTENSION` on the referenced object. Functionally, this dependency type acts the same as an `INTERNAL` dependency, but it's kept separate for clarity and to simplify pg_dump.
-   **DEPENDENCY\_AUTO\_EXTENSION (x)** - The dependent object is not a member of the extension that is the referenced object \(and so it should not be ignored by pg_dump\), but it cannot function without the extension and should be auto-dropped if the extension is. The dependent object may be dropped on its own as well. Functionally this dependency type acts the same as an `AUTO` dependency, but it's kept separate for clarity and to simplify pg_dump.
-   **DEPENDENCY\_PIN \(p\)** — There is no dependent object; this type of entry is a signal that the system itself depends on the referenced object, and so that object must never be deleted. Entries of this type are created only by system initialization. The columns for the dependent object contain zeroes.

Note that it's quite possible for two objects to be linked by more than one `pg_depend` entry. For example, a child partitioned index would have both a partition-type dependency on its associated partition table, and an auto dependency on each column of that table that it indexes. This sort of situation expresses the union of multiple dependency semantics. A dependent object can be dropped without `CASCADE` if any of its dependencies satisfies its condition for automatic dropping. Conversely, all the dependencies' restrictions about which objects must be dropped together must be satisfied.

|column|type|references|description|
|------|----|----------|-----------|
|`classid`|oid|[pg\_class](pg_class.html).oid|The object identifier of the system catalog the dependent object is in.|
|`objid`|oid|any OID column|The object identifier of the specific dependent object.|
|`objsubid`|integer| |For a table column, this is the column number \(the `objid` and `classid` refer to the table itself\). For all other object types, this column is zero.|
|`refclassid`|oid|[pg\_class](pg_class.html).oid|The object identifier of the system catalog the referenced object is in.|
|`refobjid`|oid|any OID column|The object identifier of the specific referenced object.|
|`refobjsubid`|integer| |For a table column, this is the referenced column number \(the `refobjid` and `refclassid` refer to the table itself\). For all other object types, this column is zero.|
|`deptype`|char| |The code defining the specific semantics of this dependency relationship.|

**Parent topic:** [System Catalogs Definitions](../system_catalogs/catalog_ref-html.html)

