---
title: Security 
---

Best practices to ensure the highest level of system security. 

## <a id="secbp"></a>Basic Security Best Practices 

-   Secure the `gpadmin` system user. Greenplum requires a UNIX user id to install and initialize the Greenplum Database system. This system user is referred to as `gpadmin` in the Greenplum documentation. The `gpadmin` user is the default database superuser in Greenplum Database, as well as the file system owner of the Greenplum installation and its underlying data files. The default administrator account is fundamental to the design of Greenplum Database. The system cannot run without it, and there is no way to limit the access of the `gpadmin` user id. This `gpadmin` user can bypass all security features of Greenplum Database. Anyone who logs on to a Greenplum host with this user id can read, alter, or delete any data, including system catalog data and database access rights. Therefore, it is very important to secure the `gpadmin` user id and only allow essential system administrators access to it. Administrators should only log in to Greenplum as `gpadmin` when performing certain system maintenance tasks \(such as upgrade or expansion\). Database users should never log on as `gpadmin`, and ETL or production workloads should never run as `gpadmin`.
-   Assign a distinct role to each user who logs in. For logging and auditing purposes, each user who is allowed to log in to Greenplum Database should be given their own database role. For applications or web services, consider creating a distinct role for each application or service. See "Creating New Roles \(Users\)" in the *Greenplum Database Administrator Guide*.
-   Use groups to manage access privileges. See "Creating Groups \(Role Membership\)" in the *Greenplum Database Administrator Guide*.
-   Limit users who have the `SUPERUSER` role attribute. Roles that are superusers bypass all access privilege checks in Greenplum Database, as well as resource queuing. Only system administrators should be given superuser rights. See "Altering Role Attributes" in the *Greenplum Database Administrator Guide*.

## <a id="password-strength-recommendations"></a>Password Strength Guidelines 

To protect the network from intrusion, system administrators should verify the passwords used within an organization are strong ones. The following recommendations can strengthen a password:

-   Minimum password length recommendation: At least 9 characters. MD5 passwords should be 15 characters or longer.
-   Mix upper and lower case letters.
-   Mix letters and numbers.
-   Include non-alphanumeric characters.
-   Pick a password you can remember.

The following are recommendations for password cracker software that you can use to determine the strength of a password.

-   John The Ripper. A fast and flexible password cracking program. It allows the use of multiple word lists and is capable of brute-force password cracking. It is available online at [http://www.openwall.com/john/](http://www.commoncriteriaportal.org/products/?expand#ALL).
-   Crack. Perhaps the most well-known password cracking software, Crack is also very fast, though not as easy to use as John The Ripper. It can be found online at [http://www.crypticide.com/alecm/security/crack/c50-faq.html](http://www.commoncriteriaportal.org/products/?expand#ALL).   

The security of the entire system depends on the strength of the root password. This password should be at least 12 characters long and include a mix of capitalized letters, lowercase letters, special characters, and numbers. It should not be based on any dictionary word.

Password expiration parameters should be configured. The following commands must be run as `root` or using `sudo`.

Ensure the following line exists within the file `/etc/libuser.conf` under the `[import]` section.

```
login_defs = /etc/login.defs

```

Ensure no lines in the `[userdefaults]` section begin with the following text, as these words override settings from `/etc/login.defs`:

-   `LU_SHADOWMAX`
-   `LU_SHADOWMIN`
-   `LU_SHADOWWARNING`

Ensure the following command produces no output. Any accounts listed by running this command should be locked.

```

grep "^+:" /etc/passwd /etc/shadow /etc/group

```

Note: We strongly recommend that customers change their passwords after initial setup.

```

cd /etc
chown root:root passwd shadow group gshadow
chmod 644 passwd group
chmod 400 shadow gshadow

```

Find all the files that are world-writable and that do not have their sticky bits set.

```

find / -xdev -type d \( -perm -0002 -a ! -perm -1000 \) -print

```

Set the sticky bit \(`# chmod +t {dir}`\) for all the directories that result from running the previous command.

Find all the files that are world-writable and fix each file listed.

```

find / -xdev -type f -perm -0002 -print

```

Set the right permissions \(`# chmod o-w {file}`\) for all the files generated by running the aforementioned command.

Find all the files that do not belong to a valid user or group and either assign an owner or remove the file, as appropriate.

```

find / -xdev \( -nouser -o -nogroup \) -print

```

Find all the directories that are world-writable and ensure they are owned by either root or a system account \(assuming only system accounts have a User ID lower than 500\). If the command generates any output, verify the assignment is correct or reassign it to root.

```

find / -xdev -type d -perm -0002 -uid +500 -print

```

Authentication settings such as password quality, password expiration policy, password reuse, password retry attempts, and more can be configured using the Pluggable Authentication Modules \(PAM\) framework. PAM looks in the directory `/etc/pam.d` for application-specific configuration information. Running `authconfig` or `system-config-authentication` will re-write the PAM configuration files, destroying any manually made changes and replacing them with system defaults.

The default `pam_cracklib` PAM module provides strength checking for passwords. To configure `pam_cracklib` to require at least one uppercase character, lowercase character, digit, and special character, as recommended by the U.S. Department of Defense guidelines, edit the file `/etc/pam.d/system-auth` to include the following parameters in the line corresponding to password requisite `pam_cracklib.so try_first_pass`.

```
retry=3:
dcredit=-1. Require at least one digit
ucredit=-1. Require at least one upper case character
ocredit=-1. Require at least one special character
lcredit=-1. Require at least one lower case character
minlen-14. Require a minimum password length of 14.
```

For example:

```

password required pam_cracklib.so try_first_pass retry=3\minlen=14 dcredit=-1 ucredit=-1 ocredit=-1 lcredit=-1

```

These parameters can be set to reflect your security policy requirements. Note that the password restrictions are not applicable to the root password.

The `pam_tally2` PAM module provides the capability to lock out user accounts after a specified number of failed login attempts. To enforce password lockout, edit the file `/etc/pam.d/system-auth` to include the following lines:

-   The first of the auth lines should include:

    ```
    auth required pam_tally2.so deny=5 onerr=fail unlock_time=900
    ```

-   The first of the account lines should include:

    ```
    account required pam_tally2.so
    ```


Here, the deny parameter is set to limit the number of retries to 5 and the `unlock_time` has been set to 900 seconds to keep the account locked for 900 seconds before it is unlocked. These parameters may be configured appropriately to reflect your security policy requirements. A locked account can be manually unlocked using the `pam_tally2` utility:

```

/sbin/pam_tally2 --user {username} --reset

```

You can use PAM to limit the reuse of recent passwords. The remember option for the `pam_unix` module can be set to remember the recent passwords and prevent their reuse. To accomplish this, edit the appropriate line in `/etc/pam.d/system-auth` to include the remember option.

For example:

```

password sufficient pam_unix.so [ … existing_options …] 
remember=5

```

You can set the number of previous passwords to remember to appropriately reflect your security policy requirements.

```

cd /etc
chown root:root passwd shadow group gshadow
chmod 644 passwd group
chmod 400 shadow gshadow

```

**Parent topic:** [Greenplum Database Best Practices](intro.html)

