---
title: Querying Data 
---

This topic provides information about using SQL in Greenplum databases.

You enter SQL statements called queries to view, change, and analyze data in a database using the `psql` interactive SQL client and other client tools.

-   **[About Greenplum Query Processing](../../query/topics/parallel-proc.html)**  
This topic provides an overview of how Greenplum Database processes queries. Understanding this process can be useful when writing and tuning queries.
-   **[About GPORCA](../../query/topics/query-piv-optimizer.html)**  
In Greenplum Database, the default GPORCA optimizer co-exists with the Postgres-based planner.
-   **[Defining Queries](../../query/topics/defining-queries.html)**  
Greenplum Database is based on the PostgreSQL implementation of the SQL standard.
-   **[WITH Queries \(Common Table Expressions\)](../../query/topics/CTE-query.html)**  
The `WITH` clause provides a way to use subqueries or perform a data modifying operation in a larger `SELECT` query. You can also use the `WITH` clause in an `INSERT`, `UPDATE`, or `DELETE` command.
-   **[Using Functions and Operators](../../query/topics/functions-operators.html)**  
Description of user-defined and built-in functions and operators in Greenplum Database.
-   **[Working with JSON Data](../../query/topics/json-data.html)**  
Greenplum Database supports the `json` and `jsonb` data types that store JSON \(JavaScript Object Notation\) data.
-   **[Working with XML Data](../../query/topics/xml-data.html)**  
Greenplum Database supports the `xml` data type that stores XML data.
-   **[Using Full Text Search](../../textsearch/full-text-search.html)**  
Greenplum Database provides data types, functions, operators, index types, and configurations for querying natural language documents.
-   **[Query Performance](../../query/topics/query-performance.html)**  
Greenplum Database dynamically eliminates irrelevant partitions in a table and optimally allocates memory for different operators in a query.
-   **[Managing Spill Files Generated by Queries](../../query/topics/spill-files.html)**  
Greenplum Database creates spill files, also known as workfiles, on disk if it does not have sufficient memory to run an SQL query in memory.
-   **[Query Profiling](../../query/topics/query-profiling.html)**  
Examine the query plans of poorly performing queries to identify possible performance tuning opportunities.
-   **[Just-in-Time Compilation (JIT)](../../query/topics/just-in-time.html)**
Greenplum Database supports Just-in-Time compilation for long-running CPU-bound queries.


**Parent topic:** [Greenplum Database Administrator Guide](../../admin_guide.html)

