---
title: Managing Performance 
---

The topics in this section cover Greenplum Database performance management, including how to monitor performance and how to configure workloads to prioritize resource utilization.

-   **[Defining Database Performance](perf_intro.html)**  
Managing system performance includes measuring performance, identifying the causes of performance problems, and applying the tools and techniques available to you to remedy the problems.
-   **[Common Causes of Performance Issues](perf_issues.html)**  
This section explains the troubleshooting processes for common performance issues and potential solutions to these issues.
-   **[Greenplum Database Memory Overview](wlmgmt_intro.html)**  
Memory is a key resource for a Greenplum Database system and, when used efficiently, can ensure high performance and throughput. This topic describes how segment host memory is allocated between segments and the options available to administrators to configure memory.
-   **[Managing Resources](wlmgmt.html)**  
Greenplum Database provides features to help you prioritize and allocate resources to queries according to business requirements and to prevent queries from starting when resources are unavailable.
-   **[Investigating a Performance Problem](perf_troubleshoot.html)**  
This section provides guidelines for identifying and troubleshooting performance problems in a Greenplum Database system.

**Parent topic:** [Greenplum Database Administrator Guide](admin_guide.html)

