/*
 * Copyright (c) 2008-2021
 *      Nakata, Maho
 *      All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <mpblas.h>
#include <mplapack.h>

void Rlapll(INTEGER const n, REAL *x, INTEGER const incx, REAL *y, INTEGER const incy, REAL &ssmin) {
    //
    //     Quick return if possible
    //
    const REAL zero = 0.0;
    if (n <= 1) {
        ssmin = zero;
        return;
    }
    //
    //     Compute the QR factorization of the N-by-2 matrix ( X Y )
    //
    REAL tau = 0.0;
    Rlarfg(n, x[1 - 1], &x[(1 + incx) - 1], incx, tau);
    REAL a11 = x[1 - 1];
    const REAL one = 1.0;
    x[1 - 1] = one;
    //
    REAL c = -tau * Rdot(n, x, incx, y, incy);
    Raxpy(n, c, x, incx, y, incy);
    //
    Rlarfg(n - 1, y[(1 + incy) - 1], &y[(1 + 2 * incy) - 1], incy, tau);
    //
    REAL a12 = y[1 - 1];
    REAL a22 = y[(1 + incy) - 1];
    //
    //     Compute the SVD of 2-by-2 Upper triangular matrix.
    //
    REAL ssmax = 0.0;
    Rlas2(a11, a12, a22, ssmin, ssmax);
    //
    //     End of Rlapll
    //
}
