/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_qd.h,v 1.31 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_LIN_QD_H_
#define _MPLAPACK_LIN_QD_H_

#include "mplapack_config.h"
#include <qd/qd_real.h>
#include "qd_complex.h"

bool Cgennd(mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda);
bool Rgennd(mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda);
mplapackint iMlaenv2stage_qd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_qd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
qd_real Cqpt01(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *a, qd_complex *af, mplapackint const lda, qd_complex *tau, mplapackint *jpvt, qd_complex *work, mplapackint const lwork);
qd_real Cqrt11(mplapackint const m, mplapackint const k, qd_complex *a, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork);
qd_real Cqrt12(mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda, qd_real *s, qd_complex *work, mplapackint const lwork, qd_real *rwork);
qd_real Cqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *work, mplapackint const lwork);
qd_real Cqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *c, qd_complex *work, mplapackint const lwork);
qd_real Crzt01(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork);
qd_real Crzt02(mplapackint const m, mplapackint const n, qd_complex *af, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork);
qd_real Rget06(qd_real const rcond, qd_real const rcondc);
qd_real Rlamch_qd(const char *cmach);
qd_real Rqpt01(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *a, qd_real *af, mplapackint const lda, qd_real *tau, mplapackint *jpvt, qd_real *work, mplapackint const lwork);
qd_real Rqrt11(mplapackint const m, mplapackint const k, qd_real *a, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork);
qd_real Rqrt12(mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *s, qd_real *work, mplapackint const lwork);
qd_real Rqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *work, mplapackint const lwork);
qd_real Rqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *c, qd_real *work, mplapackint const lwork);
qd_real Rrzt01(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork);
qd_real Rrzt02(mplapackint const m, mplapackint const n, qd_real *af, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork);
void Aladhd(mplapackint const iounit, const char *path);
void Alaerh(const char *path, const char *subnam, mplapackint const info, mplapackint const infoe, const char *opts, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const n5, mplapackint const imat, mplapackint const nfail, mplapackint &nerrs, mplapackint const nout);
void Alaesm(const char *path, bool const ok, mplapackint const nout);
void Alahd(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cchkeq(qd_real const thresh, mplapackint const nout);
void Cchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_complex *a, mplapackint const la, qd_complex *afac, mplapackint const lafac, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_complex *a, qd_complex *af, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *e, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *aq, qd_complex *al, qd_complex *ac, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchklqt(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchklqtp(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *perm, mplapackint *piv, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_complex *a, qd_real *d, qd_complex *e, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, qd_real const thresh, qd_complex *a, qd_complex *copya, qd_real *s, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *aq, qd_complex *al, qd_complex *ac, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *aq, qd_complex *ar, qd_complex *ac, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint *, mplapackint const nout);
void Cchkqrt(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkqrtp(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *aq, qd_complex *ar, qd_complex *ac, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint *, mplapackint const nout);
void Cchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *e, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *ab, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *ap, qd_complex *ainvp, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchktsqr(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, qd_real const thresh, bool const tsterr, qd_complex *a, qd_complex *copya, qd_real *s, qd_complex *tau, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cchkunhr_col(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_complex *a, mplapackint const la, qd_complex *afb, mplapackint const lafb, qd_complex *asav, qd_complex *b, qd_complex *bsav, qd_complex *x, qd_complex *xact, qd_real *s, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *asav, qd_complex *b, qd_complex *bsav, qd_complex *x, qd_complex *xact, qd_real *s, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_complex *a, qd_complex *af, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *e, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, qd_real const thresh, bool const tsterr, qd_complex *a, qd_complex *copya, qd_complex *b, qd_complex *copyb, qd_complex *c, qd_real *s, qd_real *copys, mplapackint const nout);
void Cdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *asav, qd_complex *b, qd_complex *bsav, qd_complex *x, qd_complex *xact, qd_real *s, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *asav, qd_complex *b, qd_complex *bsav, qd_complex *x, qd_complex *xact, qd_real *s, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *asav, qd_complex *b, qd_complex *bsav, qd_complex *x, qd_complex *xact, qd_real *s, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_complex *a, qd_real *d, qd_complex *e, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint const nout);
void Cdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_complex *a, mplapackint const lda, qd_complex *arf, qd_real *work);
void Cdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_complex *a, mplapackint const lda, qd_complex *arf, qd_complex *ap, qd_complex *asav);
void Cdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_complex *a, mplapackint const lda, qd_complex *arf, qd_complex *b1, qd_complex *b2, qd_real *d_work_Clange, qd_complex *z_work_Cgeqrf, qd_complex *tau);
void Cdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_complex *c1, qd_complex *c2, mplapackint const ldc, qd_complex *crf, qd_complex *a, mplapackint const lda, qd_real *d_work_Clange);
void Cdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, qd_real const thresh, qd_complex *a, qd_complex *asav, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *bsav, qd_complex *xact, qd_complex *x, qd_complex *arf, qd_complex *arfinv, qd_complex *z_work_Clatms, qd_complex *z_work_Cpot02, qd_complex *z_work_Cpot03, qd_real *d_work_Clatms, qd_real *d_work_Clanhe, qd_real *d_work_Cpot01, qd_real *d_work_Cpot02, qd_real *d_work_Cpot03);
void Cdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *e, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_complex *a, qd_complex *afac, qd_complex *ainv, qd_complex *b, qd_complex *x, qd_complex *xact, qd_complex *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Cerrge(const char *path, mplapackint const nunit);
void Cerrgt(const char *path, mplapackint const nunit);
void Cerrhe(const char *path, mplapackint const nunit);
void Cerrlq(const char *path, mplapackint const nunit);
void Cerrlqt(const char *path, mplapackint const nunit);
void Cerrlqtp(const char *path, mplapackint const nunit);
void Cerrls(const char *path, mplapackint const nunit);
void Cerrpo(const char *path, mplapackint const nunit);
void Cerrps(const char *path, mplapackint const nunit);
void Cerrql(const char *path, mplapackint const nunit);
void Cerrqp(const char *path, mplapackint const nunit);
void Cerrqr(const char *path, mplapackint const nunit);
void Cerrqrt(const char *path, mplapackint const nunit);
void Cerrqrtp(const char *path, mplapackint const nunit);
void Cerrrfp(mplapackint const nunit);
void Cerrrq(const char *path, mplapackint const nunit);
void Cerrsy(const char *path, mplapackint const nunit);
void Cerrtr(const char *path, mplapackint const nunit);
void Cerrtsqr(const char *path, mplapackint const nunit);
void Cerrtz(const char *path, mplapackint const nunit);
void Cerrunhr_col(const char *path, mplapackint const nunit);
void Cerrvx(const char *path, mplapackint const nunit);
void Cgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *work, qd_real &resid);
void Cgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real &resid);
void Cgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_complex *ab, mplapackint const ldab, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Cgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *tau, qd_complex *b, mplapackint const ldb, qd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *tau, qd_complex *b, mplapackint const ldb, qd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *tau, qd_complex *b, mplapackint const ldb, qd_complex *work, mplapackint const lwork, mplapackint &info);
void Cgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *tau, qd_complex *b, mplapackint const ldb, qd_complex *work, mplapackint const lwork, mplapackint &info);
void Cget01(mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *rwork, qd_real &resid);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cget03(mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *ainv, mplapackint const ldainv, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Cget04(mplapackint const n, mplapackint const nrhs, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real const rcond, qd_real &resid);
void Cget07(const char *trans, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, bool const chkferr, qd_real *berr, qd_real *reslts);
void Cget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cgtt01(mplapackint const n, qd_complex *dl, qd_complex *d, qd_complex *du, qd_complex *dlf, qd_complex *df, qd_complex *duf, qd_complex *du2, mplapackint *ipiv, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real &resid);
void Cgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, qd_complex *dl, qd_complex *d, qd_complex *du, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real &resid);
void Cgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, qd_complex *dl, qd_complex *d, qd_complex *du, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Chet01(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Chet01_3(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, qd_complex *e, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Chet01_aa(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Chet01_rook(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Chpt01(const char *uplo, mplapackint const n, qd_complex *a, qd_complex *afac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Clahilb(mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *work, mplapackint &info, const char *path);
void Claipd(mplapackint const n, qd_complex *a, mplapackint const inda, mplapackint const vinda);
void Claptm(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real const alpha, qd_real *d, qd_complex *e, qd_complex *x, mplapackint const ldx, qd_real const beta, qd_complex *b, mplapackint const ldb);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, qd_real &anorm, mplapackint &mode, qd_real &cndnum, char *dist);
void Clatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, qd_real &anorm, mplapackint &mode, qd_real &cndnum, char *dist);
void Clatsp(const char *uplo, mplapackint const n, qd_complex *x, mplapackint *iseed);
void Clatsy(const char *uplo, mplapackint const n, qd_complex *x, mplapackint const ldx, mplapackint *iseed);
void Clattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, qd_complex *ab, mplapackint const ldab, qd_complex *b, qd_complex *work, qd_real *rwork, mplapackint &info);
void Clattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, qd_complex *ap, qd_complex *b, qd_complex *work, qd_real *rwork, mplapackint &info);
void Clattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *work, qd_real *rwork, mplapackint &info);
void Clavhe(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clavhe_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clavhp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, mplapackint *ipiv, qd_complex *b, mplapackint const ldb, mplapackint &info);
void Clqt01(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *l, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Clqt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *l, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Clqt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *af, qd_complex *c, qd_complex *cc, qd_complex *q, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Clqt04(mplapackint const m, mplapackint const n, mplapackint const nb, qd_real *result);
void Clqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, qd_real *result);
void Cpbt01(const char *uplo, mplapackint const n, mplapackint const kd, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, qd_real *rwork, qd_real &resid);
void Cpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_complex *ab, mplapackint const ldab, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Cpot01(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, qd_real *rwork, qd_real &resid);
void Cpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cpot03(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *ainv, mplapackint const ldainv, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Cpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Cpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cppt01(const char *uplo, mplapackint const n, qd_complex *a, qd_complex *afac, qd_real *rwork, qd_real &resid);
void Cppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cppt03(const char *uplo, mplapackint const n, qd_complex *a, qd_complex *ainv, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Cppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *ap, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Cpst01(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, qd_complex *perm, mplapackint const ldperm, mplapackint *piv, qd_real *rwork, qd_real &resid, mplapackint const rank);
void Cptt01(mplapackint const n, qd_real *d, qd_complex *e, qd_real *df, qd_complex *ef, qd_complex *work, qd_real &resid);
void Cptt02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *d, qd_complex *e, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real &resid);
void Cptt05(mplapackint const n, mplapackint const nrhs, qd_real *d, qd_complex *e, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Cqlt01(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *l, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqlt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *l, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqlt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *af, qd_complex *c, qd_complex *cc, qd_complex *q, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqrt01(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqrt01p(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqrt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqrt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *af, qd_complex *c, qd_complex *cc, qd_complex *q, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, qd_real *result);
void Cqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, qd_real *result);
void Cqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda, qd_real &norma, mplapackint *iseed);
void Cqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_real *s, mplapackint &rank, qd_real &norma, qd_real &normb, mplapackint *iseed, qd_complex *work, mplapackint const lwork);
void Cqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Crqt01(mplapackint const m, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Crqt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Crqt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_complex *af, qd_complex *c, qd_complex *cc, qd_complex *q, mplapackint const lda, qd_complex *tau, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, qd_complex const alpha, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const incx, qd_complex const beta, qd_complex *y, mplapackint const incy);
void Cspt01(const char *uplo, mplapackint const n, qd_complex *a, qd_complex *afac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Cspt02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cspt03(const char *uplo, mplapackint const n, qd_complex *a, qd_complex *ainv, qd_complex *work, mplapackint const ldw, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Csyt01(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Csyt01_3(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, qd_complex *e, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Csyt01_aa(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Csyt01_rook(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *afac, mplapackint const ldafac, mplapackint *ipiv, qd_complex *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Csyt02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Csyt03(const char *uplo, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *ainv, mplapackint const ldainv, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Ctbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_complex *ab, mplapackint const ldab, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real *rwork, qd_real &resid);
void Ctbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_complex *ab, mplapackint const ldab, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real &resid);
void Ctbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_complex *ab, mplapackint const ldab, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Ctbt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, qd_complex *ab, mplapackint const ldab, qd_real *rwork, qd_real &rat);
void Ctpt01(const char *uplo, const char *diag, mplapackint const n, qd_complex *ap, qd_complex *ainvp, qd_real &rcond, qd_real *rwork, qd_real &resid);
void Ctpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *ap, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real *rwork, qd_real &resid);
void Ctpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *ap, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real &resid);
void Ctpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *ap, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Ctpt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, qd_complex *ap, qd_real *rwork, qd_real &rat);
void Ctrt01(const char *uplo, const char *diag, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *ainv, mplapackint const ldainv, qd_real &rcond, qd_real *rwork, qd_real &resid);
void Ctrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real *rwork, qd_real &resid);
void Ctrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real &resid);
void Ctrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *x, mplapackint const ldx, qd_complex *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Ctrt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, qd_complex *a, mplapackint const lda, qd_real *rwork, qd_real &rat);
void Ctsqr01(const char *tssw, mplapackint &m, mplapackint &n, mplapackint const mb, mplapackint const nb, qd_real *result);
void Cunhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, qd_real *result);
void Cunhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, qd_real *result);
void Mxerbla_qd(const char *srname, int info);
void Rchkeq(qd_real const thresh, mplapackint const nout);
void Rchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_real *a, mplapackint const la, qd_real *afac, mplapackint const lafac, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *af, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *aq, qd_real *al, qd_real *ac, qd_real *b, qd_real *x, qd_real *xact, qd_real *tau, qd_real *work, qd_real *rwork, mplapackint const nout);
void Rchklqt(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchklqtp(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkorhr_col(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *perm, mplapackint *piv, qd_real *work, qd_real *rwork, mplapackint const nout);
void Rchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *d, qd_real *e, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint const nout);
void Rchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, qd_real const thresh, qd_real *a, qd_real *copya, qd_real *s, qd_real *tau, qd_real *work, mplapackint *iwork, mplapackint const nout);
void Rchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *aq, qd_real *al, qd_real *ac, qd_real *b, qd_real *x, qd_real *xact, qd_real *tau, qd_real *work, qd_real *rwork, mplapackint const nout);
void Rchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *aq, qd_real *ar, qd_real *ac, qd_real *b, qd_real *x, qd_real *xact, qd_real *tau, qd_real *work, qd_real *rwork, mplapackint *, mplapackint const nout);
void Rchkqrt(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkqrtp(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *aq, qd_real *ar, qd_real *ac, qd_real *b, qd_real *x, qd_real *xact, qd_real *tau, qd_real *work, qd_real *rwork, mplapackint *, mplapackint const nout);
void Rchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *e, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *ab, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *ap, qd_real *ainvp, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktsqr(qd_real const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *copya, qd_real *s, qd_real *tau, qd_real *work, mplapackint const nout);
void Rdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_real *a, mplapackint const la, qd_real *afb, mplapackint const lafb, qd_real *asav, qd_real *b, qd_real *bsav, qd_real *x, qd_real *xact, qd_real *s, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *asav, qd_real *b, qd_real *bsav, qd_real *x, qd_real *xact, qd_real *s, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *af, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *copya, qd_real *b, qd_real *copyb, qd_real *c, qd_real *s, qd_real *copys, mplapackint const nout);
void Rdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *asav, qd_real *b, qd_real *bsav, qd_real *x, qd_real *xact, qd_real *s, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *asav, qd_real *b, qd_real *bsav, qd_real *x, qd_real *xact, qd_real *s, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *asav, qd_real *b, qd_real *bsav, qd_real *x, qd_real *xact, qd_real *s, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, qd_real *a, qd_real *d, qd_real *e, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint const nout);
void Rdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_real *a, mplapackint const lda, qd_real *arf, qd_real *work);
void Rdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real *a, mplapackint const lda, qd_real *arf, qd_real *ap, qd_real *asav);
void Rdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_real *a, mplapackint const lda, qd_real *arf, qd_real *b1, qd_real *b2, qd_real *d_work_Rlange, qd_real *d_work_Rgeqrf, qd_real *tau);
void Rdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, qd_real const thresh, qd_real *c1, qd_real *c2, mplapackint const ldc, qd_real *crf, qd_real *a, mplapackint const lda, qd_real *d_work_Rlange);
void Rdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, qd_real const thresh, qd_real *a, qd_real *asav, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *bsav, qd_real *xact, qd_real *x, qd_real *arf, qd_real *arfinv, qd_real *d_work_Rlatms, qd_real *d_work_Rpot01, qd_real *d_temp_Rpot02, qd_real *d_temp_Rpot03, qd_real *d_work_Rlansy, qd_real *d_work_Rpot02, qd_real *d_work_Rpot03);
void Rdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *e, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, qd_real const thresh, bool const tsterr, mplapackint const nmax, qd_real *a, qd_real *afac, qd_real *ainv, qd_real *b, qd_real *x, qd_real *xact, qd_real *work, qd_real *rwork, mplapackint *iwork, mplapackint const nout);
void Rerrge(const char *path, mplapackint const nunit);
void Rerrgt(const char *path, mplapackint const nunit);
void Rerrlq(const char *path, mplapackint const nunit);
void Rerrlqt(const char *path, mplapackint const nunit);
void Rerrlqtp(const char *path, mplapackint const nunit);
void Rerrls(const char *path, mplapackint const nunit);
void Rerrorhr_col(const char *path, mplapackint const nunit);
void Rerrpo(const char *path, mplapackint const nunit);
void Rerrps(const char *path, mplapackint const nunit);
void Rerrql(const char *path, mplapackint const nunit);
void Rerrqp(const char *path, mplapackint const nunit);
void Rerrqr(const char *path, mplapackint const nunit);
void Rerrqrt(const char *path, mplapackint const nunit);
void Rerrqrtp(const char *path, mplapackint const nunit);
void Rerrrfp(mplapackint const nunit);
void Rerrrq(const char *path, mplapackint const nunit);
void Rerrsy(const char *path, mplapackint const nunit);
void Rerrtr(const char *path, mplapackint const nunit);
void Rerrtsqr(const char *path, mplapackint const nunit);
void Rerrtz(const char *path, mplapackint const nunit);
void Rerrvx(const char *path, mplapackint const nunit);
void Rgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *work, qd_real &resid);
void Rgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real &resid);
void Rgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_real *ab, mplapackint const ldab, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *tau, qd_real *b, mplapackint const ldb, qd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *tau, qd_real *b, mplapackint const ldb, qd_real *work, mplapackint const lwork, mplapackint &info);
void Rgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *tau, qd_real *b, mplapackint const ldb, qd_real *work, mplapackint const lwork, mplapackint &info);
void Rgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *tau, qd_real *b, mplapackint const ldb, qd_real *work, mplapackint const lwork, mplapackint &info);
void Rget01(mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *rwork, qd_real &resid);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rget03(mplapackint const n, qd_real *a, mplapackint const lda, qd_real *ainv, mplapackint const ldainv, qd_real *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Rget04(mplapackint const n, mplapackint const nrhs, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real const rcond, qd_real &resid);
void Rget07(const char *trans, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, bool const chkferr, qd_real *berr, qd_real *reslts);
void Rget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rgtt01(mplapackint const n, qd_real *dl, qd_real *d, qd_real *du, qd_real *dlf, qd_real *df, qd_real *duf, qd_real *du2, mplapackint *ipiv, qd_real *work, mplapackint const ldwork, qd_real *rwork, qd_real &resid);
void Rgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, qd_real *dl, qd_real *d, qd_real *du, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real &resid);
void Rgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, qd_real *dl, qd_real *d, qd_real *du, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rlahilb(mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, mplapackint &info);
void Rlaord(const char *job, mplapackint const n, qd_real *x, mplapackint const incx);
void Rlaptm(mplapackint const n, mplapackint const nrhs, qd_real const alpha, qd_real *d, qd_real *e, qd_real *x, mplapackint const ldx, qd_real const beta, qd_real *b, mplapackint const ldb);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, qd_real &anorm, mplapackint &mode, qd_real &cndnum, char *dist);
void Rlatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, qd_real &anorm, mplapackint &mode, qd_real &cndnum, char *dist);
void Rlattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, qd_real *ab, mplapackint const ldab, qd_real *b, qd_real *work, mplapackint &info);
void Rlattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, qd_real *a, qd_real *b, qd_real *work, mplapackint &info);
void Rlattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *b, qd_real *work, mplapackint &info);
void Rlavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint *ipiv, qd_real *b, mplapackint const ldb, mplapackint &info);
void Rlavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, mplapackint *ipiv, qd_real *b, mplapackint const ldb, mplapackint &info);
void Rlavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, mplapackint *ipiv, qd_real *b, mplapackint const ldb, mplapackint &info);
void Rlqt01(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *l, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rlqt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *a, qd_real *af, qd_real *q, qd_real *l, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rlqt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *af, qd_real *c, qd_real *cc, qd_real *q, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rlqt04(mplapackint const m, mplapackint const n, mplapackint const nb, qd_real *result);
void Rlqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, qd_real *result);
void Rorhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, qd_real *result);
void Rorhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, qd_real *result);
void Rpbt01(const char *uplo, mplapackint const n, mplapackint const kd, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, qd_real *rwork, qd_real &resid);
void Rpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_real *ab, mplapackint const ldab, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rpot01(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, qd_real *rwork, qd_real &resid);
void Rpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rpot03(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *ainv, mplapackint const ldainv, qd_real *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Rpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rppt01(const char *uplo, mplapackint const n, qd_real *a, qd_real *afac, qd_real *rwork, qd_real &resid);
void Rppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *a, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rppt03(const char *uplo, mplapackint const n, qd_real *a, qd_real *ainv, qd_real *work, mplapackint const ldwork, qd_real *rwork, qd_real &rcond, qd_real &resid);
void Rppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, qd_real *ap, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rpst01(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, qd_real *perm, mplapackint const ldperm, mplapackint *piv, qd_real *rwork, qd_real &resid, mplapackint const rank);
void Rptt01(mplapackint const n, qd_real *d, qd_real *e, qd_real *df, qd_real *ef, qd_real *work, qd_real &resid);
void Rptt02(mplapackint const n, mplapackint const nrhs, qd_real *d, qd_real *e, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real &resid);
void Rptt05(mplapackint const n, mplapackint const nrhs, qd_real *d, qd_real *e, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rqlt01(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *l, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqlt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *a, qd_real *af, qd_real *q, qd_real *l, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqlt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *af, qd_real *c, qd_real *cc, qd_real *q, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqrt01(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqrt01p(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqrt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqrt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *af, qd_real *c, qd_real *cc, qd_real *q, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, qd_real *result);
void Rqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, qd_real *result);
void Rqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda, qd_real &norma, mplapackint *iseed);
void Rqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *s, mplapackint &rank, qd_real &norma, qd_real &normb, mplapackint *iseed, qd_real *work, mplapackint const lwork);
void Rqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rrqt01(mplapackint const m, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rrqt02(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rrqt03(mplapackint const m, mplapackint const n, mplapackint const k, qd_real *af, qd_real *c, qd_real *cc, qd_real *q, mplapackint const lda, qd_real *tau, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rspt01(const char *uplo, mplapackint const n, qd_real *a, qd_real *afac, mplapackint *ipiv, qd_real *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Rsyt01(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Rsyt01_3(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, qd_real *e, mplapackint *ipiv, qd_real *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Rsyt01_aa(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Rsyt01_rook(const char *uplo, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *afac, mplapackint const ldafac, mplapackint *ipiv, qd_real *c, mplapackint const ldc, qd_real *rwork, qd_real &resid);
void Rtbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_real *ab, mplapackint const ldab, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_real *ab, mplapackint const ldab, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, qd_real *ab, mplapackint const ldab, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rtbt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, qd_real *ab, mplapackint const ldab, qd_real *work, qd_real &rat);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *t, mplapackint const ldt, qd_real *work, mplapackint &info);
void Rtpt01(const char *uplo, const char *diag, mplapackint const n, qd_real *ap, qd_real *ainvp, qd_real &rcond, qd_real *work, qd_real &resid);
void Rtpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *ap, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *ap, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *ap, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rtpt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, qd_real *ap, qd_real *work, qd_real &rat);
void Rtrt01(const char *uplo, const char *diag, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *ainv, mplapackint const ldainv, qd_real &rcond, qd_real *work, qd_real &resid);
void Rtrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real const scale, qd_real *cnorm, qd_real const tscal, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &resid);
void Rtrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *x, mplapackint const ldx, qd_real *xact, mplapackint const ldxact, qd_real *ferr, qd_real *berr, qd_real *reslts);
void Rtrt06(qd_real const rcond, qd_real const rcondc, const char *uplo, const char *diag, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *work, qd_real &rat);
void Rtsqr01(const char *tssw, mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, qd_real *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void icopy(mplapackint const &n, mplapackint *sx, mplapackint const &incx, mplapackint *sy, mplapackint const &incy);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
