/*
 * Copyright (c) 2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_gmp.h,v 1.34 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_LIN_GMP_H_
#define _MPLAPACK_LIN_GMP_H_

#include "mplapack_config.h"
#include "gmpxx.h"
#include "mpc_class.h"

bool Cgennd(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda);
bool Rgennd(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda);
mpf_class Cqpt01(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mpc_class *af, mplapackint const lda, mpc_class *tau, mplapackint *jpvt, mpc_class *work, mplapackint const lwork);
mpf_class Cqrt11(mplapackint const m, mplapackint const k, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork);
mpf_class Cqrt12(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *s, mpc_class *work, mplapackint const lwork, mpf_class *rwork);
mpf_class Cqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *work, mplapackint const lwork);
mpf_class Cqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *c, mpc_class *work, mplapackint const lwork);
mpf_class Crzt01(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork);
mpf_class Crzt02(mplapackint const m, mplapackint const n, mpc_class *af, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork);
mpf_class Rget06(mpf_class const rcond, mpf_class const rcondc);
mpf_class Rlamch_gmp(const char *cmach);
mpf_class Rqpt01(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mpf_class *af, mplapackint const lda, mpf_class *tau, mplapackint *jpvt, mpf_class *work, mplapackint const lwork);
mpf_class Rqrt11(mplapackint const m, mplapackint const k, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork);
mpf_class Rqrt12(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *s, mpf_class *work, mplapackint const lwork);
mpf_class Rqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *work, mplapackint const lwork);
mpf_class Rqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *c, mpf_class *work, mplapackint const lwork);
mpf_class Rrzt01(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork);
mpf_class Rrzt02(mplapackint const m, mplapackint const n, mpf_class *af, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork);
mplapackint iMlaenv2stage_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Aladhd(mplapackint const iounit, const char *path);
void Alaerh(const char *path, const char *subnam, mplapackint const info, mplapackint const infoe, const char *opts, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const n5, mplapackint const imat, mplapackint const nfail, mplapackint &nerrs, mplapackint const nout);
void Alaesm(const char *path, bool const ok, mplapackint const nout);
void Alahd(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cchkeq(mpf_class const thresh, mplapackint const nout);
void Cchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpc_class *a, mplapackint const la, mpc_class *afac, mplapackint const lafac, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpc_class *a, mpc_class *af, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *e, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *aq, mpc_class *al, mpc_class *ac, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchklqt(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchklqtp(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *perm, mplapackint *piv, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpc_class *a, mpf_class *d, mpc_class *e, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpf_class const thresh, mpc_class *a, mpc_class *copya, mpf_class *s, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *aq, mpc_class *al, mpc_class *ac, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *aq, mpc_class *ar, mpc_class *ac, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint *, mplapackint const nout);
void Cchkqrt(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkqrtp(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *af, mpc_class *aq, mpc_class *ar, mpc_class *ac, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint *, mplapackint const nout);
void Cchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *e, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *ab, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *ap, mpc_class *ainvp, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchktsqr(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mpf_class const thresh, bool const tsterr, mpc_class *a, mpc_class *copya, mpf_class *s, mpc_class *tau, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cchkunhr_col(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpc_class *a, mplapackint const la, mpc_class *afb, mplapackint const lafb, mpc_class *asav, mpc_class *b, mpc_class *bsav, mpc_class *x, mpc_class *xact, mpf_class *s, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *asav, mpc_class *b, mpc_class *bsav, mpc_class *x, mpc_class *xact, mpf_class *s, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpc_class *a, mpc_class *af, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *e, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpf_class const thresh, bool const tsterr, mpc_class *a, mpc_class *copya, mpc_class *b, mpc_class *copyb, mpc_class *c, mpf_class *s, mpf_class *copys, mplapackint const nout);
void Cdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *asav, mpc_class *b, mpc_class *bsav, mpc_class *x, mpc_class *xact, mpf_class *s, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *asav, mpc_class *b, mpc_class *bsav, mpc_class *x, mpc_class *xact, mpf_class *s, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *asav, mpc_class *b, mpc_class *bsav, mpc_class *x, mpc_class *xact, mpf_class *s, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpc_class *a, mpf_class *d, mpc_class *e, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint const nout);
void Cdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpc_class *a, mplapackint const lda, mpc_class *arf, mpf_class *work);
void Cdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpc_class *a, mplapackint const lda, mpc_class *arf, mpc_class *ap, mpc_class *asav);
void Cdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpc_class *a, mplapackint const lda, mpc_class *arf, mpc_class *b1, mpc_class *b2, mpf_class *d_work_Clange, mpc_class *z_work_Cgeqrf, mpc_class *tau);
void Cdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpc_class *c1, mpc_class *c2, mplapackint const ldc, mpc_class *crf, mpc_class *a, mplapackint const lda, mpf_class *d_work_Clange);
void Cdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, mpf_class const thresh, mpc_class *a, mpc_class *asav, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *bsav, mpc_class *xact, mpc_class *x, mpc_class *arf, mpc_class *arfinv, mpc_class *z_work_Clatms, mpc_class *z_work_Cpot02, mpc_class *z_work_Cpot03, mpf_class *d_work_Clatms, mpf_class *d_work_Clanhe, mpf_class *d_work_Cpot01, mpf_class *d_work_Cpot02, mpf_class *d_work_Cpot03);
void Cdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *e, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpc_class *a, mpc_class *afac, mpc_class *ainv, mpc_class *b, mpc_class *x, mpc_class *xact, mpc_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Cerrge(const char *path, mplapackint const nunit);
void Cerrgt(const char *path, mplapackint const nunit);
void Cerrhe(const char *path, mplapackint const nunit);
void Cerrlq(const char *path, mplapackint const nunit);
void Cerrlqt(const char *path, mplapackint const nunit);
void Cerrlqtp(const char *path, mplapackint const nunit);
void Cerrls(const char *path, mplapackint const nunit);
void Cerrpo(const char *path, mplapackint const nunit);
void Cerrps(const char *path, mplapackint const nunit);
void Cerrql(const char *path, mplapackint const nunit);
void Cerrqp(const char *path, mplapackint const nunit);
void Cerrqr(const char *path, mplapackint const nunit);
void Cerrqrt(const char *path, mplapackint const nunit);
void Cerrqrtp(const char *path, mplapackint const nunit);
void Cerrrfp(mplapackint const nunit);
void Cerrrq(const char *path, mplapackint const nunit);
void Cerrsy(const char *path, mplapackint const nunit);
void Cerrtr(const char *path, mplapackint const nunit);
void Cerrtsqr(const char *path, mplapackint const nunit);
void Cerrtz(const char *path, mplapackint const nunit);
void Cerrunhr_col(const char *path, mplapackint const nunit);
void Cerrvx(const char *path, mplapackint const nunit);
void Cgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *work, mpf_class &resid);
void Cgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class &resid);
void Cgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Cgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *tau, mpc_class *b, mplapackint const ldb, mpc_class *work, mplapackint const lwork, mplapackint &info);
void Cget01(mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *rwork, mpf_class &resid);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cget03(mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *ainv, mplapackint const ldainv, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Cget04(mplapackint const n, mplapackint const nrhs, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class const rcond, mpf_class &resid);
void Cget07(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, bool const chkferr, mpf_class *berr, mpf_class *reslts);
void Cget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cgtt01(mplapackint const n, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *dlf, mpc_class *df, mpc_class *duf, mpc_class *du2, mplapackint *ipiv, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &resid);
void Cgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class &resid);
void Cgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, mpc_class *dl, mpc_class *d, mpc_class *du, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Chet01(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Chet01_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mpc_class *e, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Chet01_aa(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Chet01_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Chpt01(const char *uplo, mplapackint const n, mpc_class *a, mpc_class *afac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Clahilb(mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *work, mplapackint &info, const char *path);
void Claipd(mplapackint const n, mpc_class *a, mplapackint const inda, mplapackint const vinda);
void Claptm(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class const alpha, mpf_class *d, mpc_class *e, mpc_class *x, mplapackint const ldx, mpf_class const beta, mpc_class *b, mplapackint const ldb);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpf_class &anorm, mplapackint &mode, mpf_class &cndnum, char *dist);
void Clatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpf_class &anorm, mplapackint &mode, mpf_class &cndnum, char *dist);
void Clatsp(const char *uplo, mplapackint const n, mpc_class *x, mplapackint *iseed);
void Clatsy(const char *uplo, mplapackint const n, mpc_class *x, mplapackint const ldx, mplapackint *iseed);
void Clattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpc_class *b, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Clattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpc_class *ap, mpc_class *b, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Clattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *b, mpc_class *work, mpf_class *rwork, mplapackint &info);
void Clavhe(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clavhe_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clavhp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mplapackint *ipiv, mpc_class *b, mplapackint const ldb, mplapackint &info);
void Clqt01(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *l, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Clqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *l, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Clqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *af, mpc_class *c, mpc_class *cc, mpc_class *q, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Clqt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *result);
void Clqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpf_class *result);
void Cpbt01(const char *uplo, mplapackint const n, mplapackint const kd, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mpf_class *rwork, mpf_class &resid);
void Cpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Cpot01(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mpf_class *rwork, mpf_class &resid);
void Cpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cpot03(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *ainv, mplapackint const ldainv, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Cpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Cpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cppt01(const char *uplo, mplapackint const n, mpc_class *a, mpc_class *afac, mpf_class *rwork, mpf_class &resid);
void Cppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cppt03(const char *uplo, mplapackint const n, mpc_class *a, mpc_class *ainv, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Cppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Cpst01(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mpc_class *perm, mplapackint const ldperm, mplapackint *piv, mpf_class *rwork, mpf_class &resid, mplapackint const rank);
void Cptt01(mplapackint const n, mpf_class *d, mpc_class *e, mpf_class *df, mpc_class *ef, mpc_class *work, mpf_class &resid);
void Cptt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class &resid);
void Cptt05(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpc_class *e, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Cqlt01(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *l, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqlt02(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *l, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqlt03(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *af, mpc_class *c, mpc_class *cc, mpc_class *q, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqrt01(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqrt01p(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqrt02(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqrt03(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *af, mpc_class *c, mpc_class *cc, mpc_class *q, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Cqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *result);
void Cqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpf_class *result);
void Cqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class &norma, mplapackint *iseed);
void Cqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpf_class *s, mplapackint &rank, mpf_class &norma, mpf_class &normb, mplapackint *iseed, mpc_class *work, mplapackint const lwork);
void Cqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Crqt01(mplapackint const m, mplapackint const n, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Crqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *a, mpc_class *af, mpc_class *q, mpc_class *r, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Crqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpc_class *af, mpc_class *c, mpc_class *cc, mpc_class *q, mplapackint const lda, mpc_class *tau, mpc_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, mpc_class const alpha, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const incx, mpc_class const beta, mpc_class *y, mplapackint const incy);
void Cspt01(const char *uplo, mplapackint const n, mpc_class *a, mpc_class *afac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Cspt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Cspt03(const char *uplo, mplapackint const n, mpc_class *a, mpc_class *ainv, mpc_class *work, mplapackint const ldw, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Csyt01(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Csyt01_3(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mpc_class *e, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Csyt01_aa(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Csyt01_rook(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpc_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Csyt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Csyt03(const char *uplo, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *ainv, mplapackint const ldainv, mpc_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Ctbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class *rwork, mpf_class &resid);
void Ctbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class &resid);
void Ctbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpc_class *ab, mplapackint const ldab, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Ctbt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpc_class *ab, mplapackint const ldab, mpf_class *rwork, mpf_class &rat);
void Ctpt01(const char *uplo, const char *diag, mplapackint const n, mpc_class *ap, mpc_class *ainvp, mpf_class &rcond, mpf_class *rwork, mpf_class &resid);
void Ctpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class *rwork, mpf_class &resid);
void Ctpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class &resid);
void Ctpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *ap, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Ctpt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mpc_class *ap, mpf_class *rwork, mpf_class &rat);
void Ctrt01(const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint const lda, mpc_class *ainv, mplapackint const ldainv, mpf_class &rcond, mpf_class *rwork, mpf_class &resid);
void Ctrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class *rwork, mpf_class &resid);
void Ctrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpc_class *x, mplapackint const ldx, mpc_class *b, mplapackint const ldb, mpc_class *work, mpf_class &resid);
void Ctrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpc_class *a, mplapackint const lda, mpc_class *b, mplapackint const ldb, mpc_class *x, mplapackint const ldx, mpc_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Ctrt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mpc_class *a, mplapackint const lda, mpf_class *rwork, mpf_class &rat);
void Ctsqr01(const char *tssw, mplapackint &m, mplapackint &n, mplapackint const mb, mplapackint const nb, mpf_class *result);
void Cunhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpf_class *result);
void Cunhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpf_class *result);
void Mxerbla_gmp(const char *srname, int info);
void Rchkeq(mpf_class const thresh, mplapackint const nout);
void Rchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpf_class *a, mplapackint const la, mpf_class *afac, mplapackint const lafac, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *af, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *aq, mpf_class *al, mpf_class *ac, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *tau, mpf_class *work, mpf_class *rwork, mplapackint const nout);
void Rchklqt(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchklqtp(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkorhr_col(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *perm, mplapackint *piv, mpf_class *work, mpf_class *rwork, mplapackint const nout);
void Rchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *d, mpf_class *e, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint const nout);
void Rchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpf_class const thresh, mpf_class *a, mpf_class *copya, mpf_class *s, mpf_class *tau, mpf_class *work, mplapackint *iwork, mplapackint const nout);
void Rchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *aq, mpf_class *al, mpf_class *ac, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *tau, mpf_class *work, mpf_class *rwork, mplapackint const nout);
void Rchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *aq, mpf_class *ar, mpf_class *ac, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *tau, mpf_class *work, mpf_class *rwork, mplapackint *, mplapackint const nout);
void Rchkqrt(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkqrtp(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *af, mpf_class *aq, mpf_class *ar, mpf_class *ac, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *tau, mpf_class *work, mpf_class *rwork, mplapackint *, mplapackint const nout);
void Rchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *e, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *ab, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *ap, mpf_class *ainvp, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktsqr(mpf_class const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *copya, mpf_class *s, mpf_class *tau, mpf_class *work, mplapackint const nout);
void Rdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpf_class *a, mplapackint const la, mpf_class *afb, mplapackint const lafb, mpf_class *asav, mpf_class *b, mpf_class *bsav, mpf_class *x, mpf_class *xact, mpf_class *s, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *asav, mpf_class *b, mpf_class *bsav, mpf_class *x, mpf_class *xact, mpf_class *s, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *af, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *copya, mpf_class *b, mpf_class *copyb, mpf_class *c, mpf_class *s, mpf_class *copys, mplapackint const nout);
void Rdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *asav, mpf_class *b, mpf_class *bsav, mpf_class *x, mpf_class *xact, mpf_class *s, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *asav, mpf_class *b, mpf_class *bsav, mpf_class *x, mpf_class *xact, mpf_class *s, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *asav, mpf_class *b, mpf_class *bsav, mpf_class *x, mpf_class *xact, mpf_class *s, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mpf_class *a, mpf_class *d, mpf_class *e, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint const nout);
void Rdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpf_class *a, mplapackint const lda, mpf_class *arf, mpf_class *work);
void Rdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class *a, mplapackint const lda, mpf_class *arf, mpf_class *ap, mpf_class *asav);
void Rdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpf_class *a, mplapackint const lda, mpf_class *arf, mpf_class *b1, mpf_class *b2, mpf_class *d_work_Rlange, mpf_class *d_work_Rgeqrf, mpf_class *tau);
void Rdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, mpf_class const thresh, mpf_class *c1, mpf_class *c2, mplapackint const ldc, mpf_class *crf, mpf_class *a, mplapackint const lda, mpf_class *d_work_Rlange);
void Rdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, mpf_class const thresh, mpf_class *a, mpf_class *asav, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *bsav, mpf_class *xact, mpf_class *x, mpf_class *arf, mpf_class *arfinv, mpf_class *d_work_Rlatms, mpf_class *d_work_Rpot01, mpf_class *d_temp_Rpot02, mpf_class *d_temp_Rpot03, mpf_class *d_work_Rlansy, mpf_class *d_work_Rpot02, mpf_class *d_work_Rpot03);
void Rdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *e, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, mpf_class const thresh, bool const tsterr, mplapackint const nmax, mpf_class *a, mpf_class *afac, mpf_class *ainv, mpf_class *b, mpf_class *x, mpf_class *xact, mpf_class *work, mpf_class *rwork, mplapackint *iwork, mplapackint const nout);
void Rerrge(const char *path, mplapackint const nunit);
void Rerrgt(const char *path, mplapackint const nunit);
void Rerrlq(const char *path, mplapackint const nunit);
void Rerrlqt(const char *path, mplapackint const nunit);
void Rerrlqtp(const char *path, mplapackint const nunit);
void Rerrls(const char *path, mplapackint const nunit);
void Rerrorhr_col(const char *path, mplapackint const nunit);
void Rerrpo(const char *path, mplapackint const nunit);
void Rerrps(const char *path, mplapackint const nunit);
void Rerrql(const char *path, mplapackint const nunit);
void Rerrqp(const char *path, mplapackint const nunit);
void Rerrqr(const char *path, mplapackint const nunit);
void Rerrqrt(const char *path, mplapackint const nunit);
void Rerrqrtp(const char *path, mplapackint const nunit);
void Rerrrfp(mplapackint const nunit);
void Rerrrq(const char *path, mplapackint const nunit);
void Rerrsy(const char *path, mplapackint const nunit);
void Rerrtr(const char *path, mplapackint const nunit);
void Rerrtsqr(const char *path, mplapackint const nunit);
void Rerrtz(const char *path, mplapackint const nunit);
void Rerrvx(const char *path, mplapackint const nunit);
void Rgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *work, mpf_class &resid);
void Rgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class &resid);
void Rgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *tau, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint const lwork, mplapackint &info);
void Rget01(mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *rwork, mpf_class &resid);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rget03(mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *ainv, mplapackint const ldainv, mpf_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Rget04(mplapackint const n, mplapackint const nrhs, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class const rcond, mpf_class &resid);
void Rget07(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, bool const chkferr, mpf_class *berr, mpf_class *reslts);
void Rget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rgtt01(mplapackint const n, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *dlf, mpf_class *df, mpf_class *duf, mpf_class *du2, mplapackint *ipiv, mpf_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &resid);
void Rgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class &resid);
void Rgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, mpf_class *dl, mpf_class *d, mpf_class *du, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rlahilb(mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mplapackint &info);
void Rlaord(const char *job, mplapackint const n, mpf_class *x, mplapackint const incx);
void Rlaptm(mplapackint const n, mplapackint const nrhs, mpf_class const alpha, mpf_class *d, mpf_class *e, mpf_class *x, mplapackint const ldx, mpf_class const beta, mpf_class *b, mplapackint const ldb);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpf_class &anorm, mplapackint &mode, mpf_class &cndnum, char *dist);
void Rlatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, mpf_class &anorm, mplapackint &mode, mpf_class &cndnum, char *dist);
void Rlattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *b, mpf_class *work, mplapackint &info);
void Rlattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpf_class *a, mpf_class *b, mpf_class *work, mplapackint &info);
void Rlattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *b, mpf_class *work, mplapackint &info);
void Rlavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rlavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rlavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mplapackint *ipiv, mpf_class *b, mplapackint const ldb, mplapackint &info);
void Rlqt01(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *l, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rlqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *l, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rlqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *af, mpf_class *c, mpf_class *cc, mpf_class *q, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rlqt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *result);
void Rlqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpf_class *result);
void Rorhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpf_class *result);
void Rorhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, mpf_class *result);
void Rpbt01(const char *uplo, mplapackint const n, mplapackint const kd, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mpf_class *rwork, mpf_class &resid);
void Rpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rpot01(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mpf_class *rwork, mpf_class &resid);
void Rpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rpot03(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *ainv, mplapackint const ldainv, mpf_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Rpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rppt01(const char *uplo, mplapackint const n, mpf_class *a, mpf_class *afac, mpf_class *rwork, mpf_class &resid);
void Rppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *a, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rppt03(const char *uplo, mplapackint const n, mpf_class *a, mpf_class *ainv, mpf_class *work, mplapackint const ldwork, mpf_class *rwork, mpf_class &rcond, mpf_class &resid);
void Rppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rpst01(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mpf_class *perm, mplapackint const ldperm, mplapackint *piv, mpf_class *rwork, mpf_class &resid, mplapackint const rank);
void Rptt01(mplapackint const n, mpf_class *d, mpf_class *e, mpf_class *df, mpf_class *ef, mpf_class *work, mpf_class &resid);
void Rptt02(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class &resid);
void Rptt05(mplapackint const n, mplapackint const nrhs, mpf_class *d, mpf_class *e, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rqlt01(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *l, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqlt02(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *l, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqlt03(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *af, mpf_class *c, mpf_class *cc, mpf_class *q, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqrt01(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqrt01p(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqrt02(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqrt03(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *af, mpf_class *c, mpf_class *cc, mpf_class *q, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, mpf_class *result);
void Rqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, mpf_class *result);
void Rqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class &norma, mplapackint *iseed);
void Rqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *s, mplapackint &rank, mpf_class &norma, mpf_class &normb, mplapackint *iseed, mpf_class *work, mplapackint const lwork);
void Rqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *rwork, mpf_class &resid);
void Rrqt01(mplapackint const m, mplapackint const n, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rrqt02(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *a, mpf_class *af, mpf_class *q, mpf_class *r, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rrqt03(mplapackint const m, mplapackint const n, mplapackint const k, mpf_class *af, mpf_class *c, mpf_class *cc, mpf_class *q, mplapackint const lda, mpf_class *tau, mpf_class *work, mplapackint const lwork, mpf_class *rwork, mpf_class *result);
void Rspt01(const char *uplo, mplapackint const n, mpf_class *a, mpf_class *afac, mplapackint *ipiv, mpf_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Rsyt01(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Rsyt01_3(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mpf_class *e, mplapackint *ipiv, mpf_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Rsyt01_aa(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Rsyt01_rook(const char *uplo, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *afac, mplapackint const ldafac, mplapackint *ipiv, mpf_class *c, mplapackint const ldc, mpf_class *rwork, mpf_class &resid);
void Rtbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, mpf_class *ab, mplapackint const ldab, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rtbt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, mpf_class *ab, mplapackint const ldab, mpf_class *work, mpf_class &rat);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *t, mplapackint const ldt, mpf_class *work, mplapackint &info);
void Rtpt01(const char *uplo, const char *diag, mplapackint const n, mpf_class *ap, mpf_class *ainvp, mpf_class &rcond, mpf_class *work, mpf_class &resid);
void Rtpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *ap, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rtpt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mpf_class *ap, mpf_class *work, mpf_class &rat);
void Rtrt01(const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *ainv, mplapackint const ldainv, mpf_class &rcond, mpf_class *work, mpf_class &resid);
void Rtrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class const scale, mpf_class *cnorm, mpf_class const tscal, mpf_class *x, mplapackint const ldx, mpf_class *b, mplapackint const ldb, mpf_class *work, mpf_class &resid);
void Rtrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, mpf_class *a, mplapackint const lda, mpf_class *b, mplapackint const ldb, mpf_class *x, mplapackint const ldx, mpf_class *xact, mplapackint const ldxact, mpf_class *ferr, mpf_class *berr, mpf_class *reslts);
void Rtrt06(mpf_class const rcond, mpf_class const rcondc, const char *uplo, const char *diag, mplapackint const n, mpf_class *a, mplapackint const lda, mpf_class *work, mpf_class &rat);
void Rtsqr01(const char *tssw, mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, mpf_class *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void icopy(mplapackint const &n, mplapackint *sx, mplapackint const &incx, mplapackint *sy, mplapackint const &incy);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
