/*
 * Copyright (c) 2008-2021
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_LIN_DOUBLE_H_
#define _MPLAPACK_LIN_DOUBLE_H_

#include "mplapack_config.h"

bool Cgennd(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda);
bool Rgennd(mplapackint const m, mplapackint const n, double *a, mplapackint const lda);
double Cqpt01(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, std::complex<double> *af, mplapackint const lda, std::complex<double> *tau, mplapackint *jpvt, std::complex<double> *work, mplapackint const lwork);
double Cqrt11(mplapackint const m, mplapackint const k, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork);
double Cqrt12(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *s, std::complex<double> *work, mplapackint const lwork, double *rwork);
double Cqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *work, mplapackint const lwork);
double Cqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *c, std::complex<double> *work, mplapackint const lwork);
double Crzt01(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork);
double Crzt02(mplapackint const m, mplapackint const n, std::complex<double> *af, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork);
double Rget06(double const rcond, double const rcondc);
double Rlamch_double(const char *cmach);
double Rqpt01(mplapackint const m, mplapackint const n, mplapackint const k, double *a, double *af, mplapackint const lda, double *tau, mplapackint *jpvt, double *work, mplapackint const lwork);
double Rqrt11(mplapackint const m, mplapackint const k, double *a, mplapackint const lda, double *tau, double *work, mplapackint const lwork);
double Rqrt12(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *s, double *work, mplapackint const lwork);
double Rqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *work, mplapackint const lwork);
double Rqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *c, double *work, mplapackint const lwork);
double Rrzt01(mplapackint const m, mplapackint const n, double *a, double *af, mplapackint const lda, double *tau, double *work, mplapackint const lwork);
double Rrzt02(mplapackint const m, mplapackint const n, double *af, mplapackint const lda, double *tau, double *work, mplapackint const lwork);
mplapackint iMlaenv2stage_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Aladhd(mplapackint const iounit, const char *path);
void Alaerh(const char *path, const char *subnam, mplapackint const info, mplapackint const infoe, const char *opts, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const n5, mplapackint const imat, mplapackint const nfail, mplapackint &nerrs, mplapackint const nout);
void Alaesm(const char *path, bool const ok, mplapackint const nout);
void Alahd(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cchkeq(double const thresh, mplapackint const nout);
void Cchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, std::complex<double> *a, mplapackint const la, std::complex<double> *afac, mplapackint const lafac, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, std::complex<double> *a, std::complex<double> *af, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *e, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *aq, std::complex<double> *al, std::complex<double> *ac, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchklqt(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchklqtp(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *perm, mplapackint *piv, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, std::complex<double> *a, double *d, std::complex<double> *e, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, double const thresh, std::complex<double> *a, std::complex<double> *copya, double *s, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *aq, std::complex<double> *al, std::complex<double> *ac, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *aq, std::complex<double> *ar, std::complex<double> *ac, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint *, mplapackint const nout);
void Cchkqrt(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkqrtp(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *af, std::complex<double> *aq, std::complex<double> *ar, std::complex<double> *ac, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint *, mplapackint const nout);
void Cchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *e, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *ab, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *ap, std::complex<double> *ainvp, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchktsqr(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, double const thresh, bool const tsterr, std::complex<double> *a, std::complex<double> *copya, double *s, std::complex<double> *tau, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cchkunhr_col(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, std::complex<double> *a, mplapackint const la, std::complex<double> *afb, mplapackint const lafb, std::complex<double> *asav, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *x, std::complex<double> *xact, double *s, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *asav, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *x, std::complex<double> *xact, double *s, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, std::complex<double> *a, std::complex<double> *af, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *e, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, double const thresh, bool const tsterr, std::complex<double> *a, std::complex<double> *copya, std::complex<double> *b, std::complex<double> *copyb, std::complex<double> *c, double *s, double *copys, mplapackint const nout);
void Cdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *asav, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *x, std::complex<double> *xact, double *s, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *asav, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *x, std::complex<double> *xact, double *s, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *asav, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *x, std::complex<double> *xact, double *s, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, std::complex<double> *a, double *d, std::complex<double> *e, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint const nout);
void Cdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, std::complex<double> *a, mplapackint const lda, std::complex<double> *arf, double *work);
void Cdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, std::complex<double> *a, mplapackint const lda, std::complex<double> *arf, std::complex<double> *ap, std::complex<double> *asav);
void Cdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, std::complex<double> *a, mplapackint const lda, std::complex<double> *arf, std::complex<double> *b1, std::complex<double> *b2, double *d_work_Clange, std::complex<double> *z_work_Cgeqrf, std::complex<double> *tau);
void Cdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, std::complex<double> *c1, std::complex<double> *c2, mplapackint const ldc, std::complex<double> *crf, std::complex<double> *a, mplapackint const lda, double *d_work_Clange);
void Cdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, double const thresh, std::complex<double> *a, std::complex<double> *asav, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *bsav, std::complex<double> *xact, std::complex<double> *x, std::complex<double> *arf, std::complex<double> *arfinv, std::complex<double> *z_work_Clatms, std::complex<double> *z_work_Cpot02, std::complex<double> *z_work_Cpot03, double *d_work_Clatms, double *d_work_Clanhe, double *d_work_Cpot01, double *d_work_Cpot02, double *d_work_Cpot03);
void Cdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *e, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, std::complex<double> *a, std::complex<double> *afac, std::complex<double> *ainv, std::complex<double> *b, std::complex<double> *x, std::complex<double> *xact, std::complex<double> *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Cerrge(const char *path, mplapackint const nunit);
void Cerrgt(const char *path, mplapackint const nunit);
void Cerrhe(const char *path, mplapackint const nunit);
void Cerrlq(const char *path, mplapackint const nunit);
void Cerrlqt(const char *path, mplapackint const nunit);
void Cerrlqtp(const char *path, mplapackint const nunit);
void Cerrls(const char *path, mplapackint const nunit);
void Cerrpo(const char *path, mplapackint const nunit);
void Cerrps(const char *path, mplapackint const nunit);
void Cerrql(const char *path, mplapackint const nunit);
void Cerrqp(const char *path, mplapackint const nunit);
void Cerrqr(const char *path, mplapackint const nunit);
void Cerrqrt(const char *path, mplapackint const nunit);
void Cerrqrtp(const char *path, mplapackint const nunit);
void Cerrrfp(mplapackint const nunit);
void Cerrrq(const char *path, mplapackint const nunit);
void Cerrsy(const char *path, mplapackint const nunit);
void Cerrtr(const char *path, mplapackint const nunit);
void Cerrtsqr(const char *path, mplapackint const nunit);
void Cerrtz(const char *path, mplapackint const nunit);
void Cerrunhr_col(const char *path, mplapackint const nunit);
void Cerrvx(const char *path, mplapackint const nunit);
void Cgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *work, double &resid);
void Cgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double &resid);
void Cgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Cgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *tau, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, mplapackint const lwork, mplapackint &info);
void Cget01(mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, double *rwork, double &resid);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cget03(mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *ainv, mplapackint const ldainv, std::complex<double> *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Cget04(mplapackint const n, mplapackint const nrhs, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double const rcond, double &resid);
void Cget07(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, bool const chkferr, double *berr, double *reslts);
void Cget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cgtt01(mplapackint const n, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *dlf, std::complex<double> *df, std::complex<double> *duf, std::complex<double> *du2, mplapackint *ipiv, std::complex<double> *work, mplapackint const ldwork, double *rwork, double &resid);
void Cgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double &resid);
void Cgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<double> *dl, std::complex<double> *d, std::complex<double> *du, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Chet01(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Chet01_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Chet01_aa(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Chet01_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Chpt01(const char *uplo, mplapackint const n, std::complex<double> *a, std::complex<double> *afac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Clahilb(mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *work, mplapackint &info, const char *path);
void Claipd(mplapackint const n, std::complex<double> *a, mplapackint const inda, mplapackint const vinda);
void Claptm(const char *uplo, mplapackint const n, mplapackint const nrhs, double const alpha, double *d, std::complex<double> *e, std::complex<double> *x, mplapackint const ldx, double const beta, std::complex<double> *b, mplapackint const ldb);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, double &anorm, mplapackint &mode, double &cndnum, char *dist);
void Clatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, double &anorm, mplapackint &mode, double &cndnum, char *dist);
void Clatsp(const char *uplo, mplapackint const n, std::complex<double> *x, mplapackint *iseed);
void Clatsy(const char *uplo, mplapackint const n, std::complex<double> *x, mplapackint const ldx, mplapackint *iseed);
void Clattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, std::complex<double> *work, double *rwork, mplapackint &info);
void Clattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, std::complex<double> *ap, std::complex<double> *b, std::complex<double> *work, double *rwork, mplapackint &info);
void Clattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, std::complex<double> *work, double *rwork, mplapackint &info);
void Clavhe(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clavhe_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clavhp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, mplapackint *ipiv, std::complex<double> *b, mplapackint const ldb, mplapackint &info);
void Clqt01(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *l, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Clqt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *l, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Clqt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *af, std::complex<double> *c, std::complex<double> *cc, std::complex<double> *q, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Clqt04(mplapackint const m, mplapackint const n, mplapackint const nb, double *result);
void Clqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, double *result);
void Cpbt01(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, double *rwork, double &resid);
void Cpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Cpot01(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, double *rwork, double &resid);
void Cpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cpot03(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *ainv, mplapackint const ldainv, std::complex<double> *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Cpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Cpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cppt01(const char *uplo, mplapackint const n, std::complex<double> *a, std::complex<double> *afac, double *rwork, double &resid);
void Cppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cppt03(const char *uplo, mplapackint const n, std::complex<double> *a, std::complex<double> *ainv, std::complex<double> *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Cppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Cpst01(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, std::complex<double> *perm, mplapackint const ldperm, mplapackint *piv, double *rwork, double &resid, mplapackint const rank);
void Cptt01(mplapackint const n, double *d, std::complex<double> *e, double *df, std::complex<double> *ef, std::complex<double> *work, double &resid);
void Cptt02(const char *uplo, mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double &resid);
void Cptt05(mplapackint const n, mplapackint const nrhs, double *d, std::complex<double> *e, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Cqlt01(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *l, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqlt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *l, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqlt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *af, std::complex<double> *c, std::complex<double> *cc, std::complex<double> *q, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqrt01(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqrt01p(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqrt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqrt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *af, std::complex<double> *c, std::complex<double> *cc, std::complex<double> *q, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Cqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, double *result);
void Cqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, double *result);
void Cqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, std::complex<double> *a, mplapackint const lda, double &norma, mplapackint *iseed);
void Cqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, double *s, mplapackint &rank, double &norma, double &normb, mplapackint *iseed, std::complex<double> *work, mplapackint const lwork);
void Cqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Crqt01(mplapackint const m, mplapackint const n, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Crqt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *a, std::complex<double> *af, std::complex<double> *q, std::complex<double> *r, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Crqt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<double> *af, std::complex<double> *c, std::complex<double> *cc, std::complex<double> *q, mplapackint const lda, std::complex<double> *tau, std::complex<double> *work, mplapackint const lwork, double *rwork, double *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, std::complex<double> const alpha, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const incx, std::complex<double> const beta, std::complex<double> *y, mplapackint const incy);
void Cspt01(const char *uplo, mplapackint const n, std::complex<double> *a, std::complex<double> *afac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Cspt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Cspt03(const char *uplo, mplapackint const n, std::complex<double> *a, std::complex<double> *ainv, std::complex<double> *work, mplapackint const ldw, double *rwork, double &rcond, double &resid);
void Csyt01(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Csyt01_3(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, std::complex<double> *e, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Csyt01_aa(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Csyt01_rook(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<double> *c, mplapackint const ldc, double *rwork, double &resid);
void Csyt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, double *rwork, double &resid);
void Csyt03(const char *uplo, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *ainv, mplapackint const ldainv, std::complex<double> *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Ctbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double *rwork, double &resid);
void Ctbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, double const scale, double *cnorm, double const tscal, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double &resid);
void Ctbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<double> *ab, mplapackint const ldab, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Ctbt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, std::complex<double> *ab, mplapackint const ldab, double *rwork, double &rat);
void Ctpt01(const char *uplo, const char *diag, mplapackint const n, std::complex<double> *ap, std::complex<double> *ainvp, double &rcond, double *rwork, double &resid);
void Ctpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double *rwork, double &resid);
void Ctpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, double const scale, double *cnorm, double const tscal, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double &resid);
void Ctpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *ap, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Ctpt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *ap, double *rwork, double &rat);
void Ctrt01(const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint const lda, std::complex<double> *ainv, mplapackint const ldainv, double &rcond, double *rwork, double &resid);
void Ctrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double *rwork, double &resid);
void Ctrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, double const scale, double *cnorm, double const tscal, std::complex<double> *x, mplapackint const ldx, std::complex<double> *b, mplapackint const ldb, std::complex<double> *work, double &resid);
void Ctrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<double> *a, mplapackint const lda, std::complex<double> *b, mplapackint const ldb, std::complex<double> *x, mplapackint const ldx, std::complex<double> *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Ctrt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, std::complex<double> *a, mplapackint const lda, double *rwork, double &rat);
void Ctsqr01(const char *tssw, mplapackint &m, mplapackint &n, mplapackint const mb, mplapackint const nb, double *result);
void Cunhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, double *result);
void Cunhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, double *result);
void Mxerbla_double(const char *srname, int info);
void Rchkeq(double const thresh, mplapackint const nout);
void Rchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, double *a, mplapackint const la, double *afac, mplapackint const lafac, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, double *a, double *af, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *af, double *aq, double *al, double *ac, double *b, double *x, double *xact, double *tau, double *work, double *rwork, mplapackint const nout);
void Rchklqt(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchklqtp(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkorhr_col(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *perm, mplapackint *piv, double *work, double *rwork, mplapackint const nout);
void Rchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, double *a, double *d, double *e, double *b, double *x, double *xact, double *work, double *rwork, mplapackint const nout);
void Rchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, double const thresh, double *a, double *copya, double *s, double *tau, double *work, mplapackint *iwork, mplapackint const nout);
void Rchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *af, double *aq, double *al, double *ac, double *b, double *x, double *xact, double *tau, double *work, double *rwork, mplapackint const nout);
void Rchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *af, double *aq, double *ar, double *ac, double *b, double *x, double *xact, double *tau, double *work, double *rwork, mplapackint *, mplapackint const nout);
void Rchkqrt(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkqrtp(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *af, double *aq, double *ar, double *ac, double *b, double *x, double *xact, double *tau, double *work, double *rwork, mplapackint *, mplapackint const nout);
void Rchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *e, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *ab, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *ap, double *ainvp, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, double const thresh, bool const tsterr, mplapackint const, double *a, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktsqr(double const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, double const thresh, bool const tsterr, double *a, double *copya, double *s, double *tau, double *work, mplapackint const nout);
void Rdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, double *a, mplapackint const la, double *afb, mplapackint const lafb, double *asav, double *b, double *bsav, double *x, double *xact, double *s, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *asav, double *b, double *bsav, double *x, double *xact, double *s, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, double *a, double *af, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, double const thresh, bool const tsterr, double *a, double *copya, double *b, double *copyb, double *c, double *s, double *copys, mplapackint const nout);
void Rdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *asav, double *b, double *bsav, double *x, double *xact, double *s, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *asav, double *b, double *bsav, double *x, double *xact, double *s, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *asav, double *b, double *bsav, double *x, double *xact, double *s, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, double *a, double *d, double *e, double *b, double *x, double *xact, double *work, double *rwork, mplapackint const nout);
void Rdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, double *a, mplapackint const lda, double *arf, double *work);
void Rdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, double *a, mplapackint const lda, double *arf, double *ap, double *asav);
void Rdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, double *a, mplapackint const lda, double *arf, double *b1, double *b2, double *d_work_Rlange, double *d_work_Rgeqrf, double *tau);
void Rdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, double const thresh, double *c1, double *c2, mplapackint const ldc, double *crf, double *a, mplapackint const lda, double *d_work_Rlange);
void Rdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, double const thresh, double *a, double *asav, double *afac, double *ainv, double *b, double *bsav, double *xact, double *x, double *arf, double *arfinv, double *d_work_Rlatms, double *d_work_Rpot01, double *d_temp_Rpot02, double *d_temp_Rpot03, double *d_work_Rlansy, double *d_work_Rpot02, double *d_work_Rpot03);
void Rdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *e, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, double const thresh, bool const tsterr, mplapackint const nmax, double *a, double *afac, double *ainv, double *b, double *x, double *xact, double *work, double *rwork, mplapackint *iwork, mplapackint const nout);
void Rerrge(const char *path, mplapackint const nunit);
void Rerrgt(const char *path, mplapackint const nunit);
void Rerrlq(const char *path, mplapackint const nunit);
void Rerrlqt(const char *path, mplapackint const nunit);
void Rerrlqtp(const char *path, mplapackint const nunit);
void Rerrls(const char *path, mplapackint const nunit);
void Rerrorhr_col(const char *path, mplapackint const nunit);
void Rerrpo(const char *path, mplapackint const nunit);
void Rerrps(const char *path, mplapackint const nunit);
void Rerrql(const char *path, mplapackint const nunit);
void Rerrqp(const char *path, mplapackint const nunit);
void Rerrqr(const char *path, mplapackint const nunit);
void Rerrqrt(const char *path, mplapackint const nunit);
void Rerrqrtp(const char *path, mplapackint const nunit);
void Rerrrfp(mplapackint const nunit);
void Rerrrq(const char *path, mplapackint const nunit);
void Rerrsy(const char *path, mplapackint const nunit);
void Rerrtr(const char *path, mplapackint const nunit);
void Rerrtsqr(const char *path, mplapackint const nunit);
void Rerrtz(const char *path, mplapackint const nunit);
void Rerrvx(const char *path, mplapackint const nunit);
void Rgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, mplapackint *ipiv, double *work, double &resid);
void Rgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double &resid);
void Rgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tau, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tau, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tau, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *tau, double *b, mplapackint const ldb, double *work, mplapackint const lwork, mplapackint &info);
void Rget01(mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, mplapackint *ipiv, double *rwork, double &resid);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rget03(mplapackint const n, double *a, mplapackint const lda, double *ainv, mplapackint const ldainv, double *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Rget04(mplapackint const n, mplapackint const nrhs, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double const rcond, double &resid);
void Rget07(const char *trans, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, bool const chkferr, double *berr, double *reslts);
void Rget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rgtt01(mplapackint const n, double *dl, double *d, double *du, double *dlf, double *df, double *duf, double *du2, mplapackint *ipiv, double *work, mplapackint const ldwork, double *rwork, double &resid);
void Rgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double &resid);
void Rgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, double *dl, double *d, double *du, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rlahilb(mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, mplapackint &info);
void Rlaord(const char *job, mplapackint const n, double *x, mplapackint const incx);
void Rlaptm(mplapackint const n, mplapackint const nrhs, double const alpha, double *d, double *e, double *x, mplapackint const ldx, double const beta, double *b, mplapackint const ldb);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, double &anorm, mplapackint &mode, double &cndnum, char *dist);
void Rlatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, double &anorm, mplapackint &mode, double &cndnum, char *dist);
void Rlattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *b, double *work, mplapackint &info);
void Rlattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, double *a, double *b, double *work, mplapackint &info);
void Rlattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, double *a, mplapackint const lda, double *b, double *work, mplapackint &info);
void Rlavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rlavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rlavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, mplapackint *ipiv, double *b, mplapackint const ldb, mplapackint &info);
void Rlqt01(mplapackint const m, mplapackint const n, double *a, double *af, double *q, double *l, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rlqt02(mplapackint const m, mplapackint const n, mplapackint const k, double *a, double *af, double *q, double *l, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rlqt03(mplapackint const m, mplapackint const n, mplapackint const k, double *af, double *c, double *cc, double *q, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rlqt04(mplapackint const m, mplapackint const n, mplapackint const nb, double *result);
void Rlqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, double *result);
void Rorhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, double *result);
void Rorhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, double *result);
void Rpbt01(const char *uplo, mplapackint const n, mplapackint const kd, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, double *rwork, double &resid);
void Rpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rpot01(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, double *rwork, double &resid);
void Rpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rpot03(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *ainv, mplapackint const ldainv, double *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Rpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rppt01(const char *uplo, mplapackint const n, double *a, double *afac, double *rwork, double &resid);
void Rppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, double *a, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rppt03(const char *uplo, mplapackint const n, double *a, double *ainv, double *work, mplapackint const ldwork, double *rwork, double &rcond, double &resid);
void Rppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rpst01(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, double *perm, mplapackint const ldperm, mplapackint *piv, double *rwork, double &resid, mplapackint const rank);
void Rptt01(mplapackint const n, double *d, double *e, double *df, double *ef, double *work, double &resid);
void Rptt02(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double &resid);
void Rptt05(mplapackint const n, mplapackint const nrhs, double *d, double *e, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rqlt01(mplapackint const m, mplapackint const n, double *a, double *af, double *q, double *l, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqlt02(mplapackint const m, mplapackint const n, mplapackint const k, double *a, double *af, double *q, double *l, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqlt03(mplapackint const m, mplapackint const n, mplapackint const k, double *af, double *c, double *cc, double *q, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqrt01(mplapackint const m, mplapackint const n, double *a, double *af, double *q, double *r, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqrt01p(mplapackint const m, mplapackint const n, double *a, double *af, double *q, double *r, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqrt02(mplapackint const m, mplapackint const n, mplapackint const k, double *a, double *af, double *q, double *r, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqrt03(mplapackint const m, mplapackint const n, mplapackint const k, double *af, double *c, double *cc, double *q, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, double *result);
void Rqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, double *result);
void Rqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, double *a, mplapackint const lda, double &norma, mplapackint *iseed);
void Rqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *s, mplapackint &rank, double &norma, double &normb, mplapackint *iseed, double *work, mplapackint const lwork);
void Rqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *rwork, double &resid);
void Rrqt01(mplapackint const m, mplapackint const n, double *a, double *af, double *q, double *r, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rrqt02(mplapackint const m, mplapackint const n, mplapackint const k, double *a, double *af, double *q, double *r, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rrqt03(mplapackint const m, mplapackint const n, mplapackint const k, double *af, double *c, double *cc, double *q, mplapackint const lda, double *tau, double *work, mplapackint const lwork, double *rwork, double *result);
void Rspt01(const char *uplo, mplapackint const n, double *a, double *afac, mplapackint *ipiv, double *c, mplapackint const ldc, double *rwork, double &resid);
void Rsyt01(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, mplapackint *ipiv, double *c, mplapackint const ldc, double *rwork, double &resid);
void Rsyt01_3(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, double *e, mplapackint *ipiv, double *c, mplapackint const ldc, double *rwork, double &resid);
void Rsyt01_aa(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, mplapackint *ipiv, double *c, mplapackint const ldc, double *rwork, double &resid);
void Rsyt01_rook(const char *uplo, mplapackint const n, double *a, mplapackint const lda, double *afac, mplapackint const ldafac, mplapackint *ipiv, double *c, mplapackint const ldc, double *rwork, double &resid);
void Rtbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double const scale, double *cnorm, double const tscal, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, double *ab, mplapackint const ldab, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rtbt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, double *ab, mplapackint const ldab, double *work, double &rat);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *t, mplapackint const ldt, double *work, mplapackint &info);
void Rtpt01(const char *uplo, const char *diag, mplapackint const n, double *ap, double *ainvp, double &rcond, double *work, double &resid);
void Rtpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *ap, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *ap, double const scale, double *cnorm, double const tscal, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *ap, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rtpt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, double *ap, double *work, double &rat);
void Rtrt01(const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint const lda, double *ainv, mplapackint const ldainv, double &rcond, double *work, double &resid);
void Rtrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double const scale, double *cnorm, double const tscal, double *x, mplapackint const ldx, double *b, mplapackint const ldb, double *work, double &resid);
void Rtrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, double *a, mplapackint const lda, double *b, mplapackint const ldb, double *x, mplapackint const ldx, double *xact, mplapackint const ldxact, double *ferr, double *berr, double *reslts);
void Rtrt06(double const rcond, double const rcondc, const char *uplo, const char *diag, mplapackint const n, double *a, mplapackint const lda, double *work, double &rat);
void Rtsqr01(const char *tssw, mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, double *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void icopy(mplapackint const &n, mplapackint *sx, mplapackint const &incx, mplapackint *sy, mplapackint const &incy);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
