/*
 * Copyright (c) 2012
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_double.h,v 1.4 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_LIN__FLOAT64X_H_
#define _MPLAPACK_LIN__FLOAT64X_H_

#include "mplapack_config.h"

_Float64x Cqpt01(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *tau, mplapackint *jpvt, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Cqrt11(mplapackint const m, mplapackint const k, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Cqrt12(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *s, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork);
_Float64x Cqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Cqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *c, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Crzt01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Crzt02(mplapackint const m, mplapackint const n, std::complex<_Float64x> *af, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork);
_Float64x Rget06(_Float64x const rcond, _Float64x const rcondc);
_Float64x Rlamch__Float64x(const char *cmach);
_Float64x Rqpt01(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, _Float64x *af, mplapackint const lda, _Float64x *tau, mplapackint *jpvt, _Float64x *work, mplapackint const lwork);
_Float64x Rqrt11(mplapackint const m, mplapackint const k, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork);
_Float64x Rqrt12(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *s, _Float64x *work, mplapackint const lwork);
_Float64x Rqrt14(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *work, mplapackint const lwork);
_Float64x Rqrt17(const char *trans, mplapackint const iresid, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *c, _Float64x *work, mplapackint const lwork);
_Float64x Rrzt01(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork);
_Float64x Rrzt02(mplapackint const m, mplapackint const n, _Float64x *af, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork);
bool Cgennd(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda);
bool Rgennd(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda);
mplapackint iMlaenv2stage__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv__Float64x(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Aladhd(mplapackint const iounit, const char *path);
void Alaerh(const char *path, const char *subnam, mplapackint const info, mplapackint const infoe, const char *opts, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const n5, mplapackint const imat, mplapackint const nfail, mplapackint &nerrs, mplapackint const nout);
void Alaesm(const char *path, bool const ok, mplapackint const nout);
void Alahd(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cchkeq(_Float64x const thresh, mplapackint const nout);
void Cchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, mplapackint const la, std::complex<_Float64x> *afac, mplapackint const lafac, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *e, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *aq, std::complex<_Float64x> *al, std::complex<_Float64x> *ac, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchklqt(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchklqtp(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *perm, mplapackint *piv, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, _Float64x const thresh, std::complex<_Float64x> *a, std::complex<_Float64x> *copya, _Float64x *s, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *aq, std::complex<_Float64x> *al, std::complex<_Float64x> *ac, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *aq, std::complex<_Float64x> *ar, std::complex<_Float64x> *ac, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *, mplapackint const nout);
void Cchkqrt(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkqrtp(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *aq, std::complex<_Float64x> *ar, std::complex<_Float64x> *ac, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *, mplapackint const nout);
void Cchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *e, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *ab, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *ap, std::complex<_Float64x> *ainvp, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchktsqr(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, std::complex<_Float64x> *copya, _Float64x *s, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cchkunhr_col(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Cdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, mplapackint const la, std::complex<_Float64x> *afb, mplapackint const lafb, std::complex<_Float64x> *asav, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, _Float64x *s, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *asav, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, _Float64x *s, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *e, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhe_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvhp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, std::complex<_Float64x> *copya, std::complex<_Float64x> *b, std::complex<_Float64x> *copyb, std::complex<_Float64x> *c, _Float64x *s, _Float64x *copys, mplapackint const nout);
void Cdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *asav, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, _Float64x *s, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *asav, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, _Float64x *s, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *asav, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, _Float64x *s, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, std::complex<_Float64x> *a, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint const nout);
void Cdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *arf, _Float64x *work);
void Cdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *arf, std::complex<_Float64x> *ap, std::complex<_Float64x> *asav);
void Cdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *arf, std::complex<_Float64x> *b1, std::complex<_Float64x> *b2, _Float64x *d_work_Clange, std::complex<_Float64x> *z_work_Cgeqrf, std::complex<_Float64x> *tau);
void Cdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, std::complex<_Float64x> *c1, std::complex<_Float64x> *c2, mplapackint const ldc, std::complex<_Float64x> *crf, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *d_work_Clange);
void Cdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, _Float64x const thresh, std::complex<_Float64x> *a, std::complex<_Float64x> *asav, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *bsav, std::complex<_Float64x> *xact, std::complex<_Float64x> *x, std::complex<_Float64x> *arf, std::complex<_Float64x> *arfinv, std::complex<_Float64x> *z_work_Clatms, std::complex<_Float64x> *z_work_Cpot02, std::complex<_Float64x> *z_work_Cpot03, _Float64x *d_work_Clatms, _Float64x *d_work_Clanhe, _Float64x *d_work_Cpot01, _Float64x *d_work_Cpot02, _Float64x *d_work_Cpot03);
void Cdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *e, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, std::complex<_Float64x> *ainv, std::complex<_Float64x> *b, std::complex<_Float64x> *x, std::complex<_Float64x> *xact, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Cerrge(const char *path, mplapackint const nunit);
void Cerrgt(const char *path, mplapackint const nunit);
void Cerrhe(const char *path, mplapackint const nunit);
void Cerrlq(const char *path, mplapackint const nunit);
void Cerrlqt(const char *path, mplapackint const nunit);
void Cerrlqtp(const char *path, mplapackint const nunit);
void Cerrls(const char *path, mplapackint const nunit);
void Cerrpo(const char *path, mplapackint const nunit);
void Cerrps(const char *path, mplapackint const nunit);
void Cerrql(const char *path, mplapackint const nunit);
void Cerrqp(const char *path, mplapackint const nunit);
void Cerrqr(const char *path, mplapackint const nunit);
void Cerrqrt(const char *path, mplapackint const nunit);
void Cerrqrtp(const char *path, mplapackint const nunit);
void Cerrrfp(mplapackint const nunit);
void Cerrrq(const char *path, mplapackint const nunit);
void Cerrsy(const char *path, mplapackint const nunit);
void Cerrtr(const char *path, mplapackint const nunit);
void Cerrtsqr(const char *path, mplapackint const nunit);
void Cerrtz(const char *path, mplapackint const nunit);
void Cerrunhr_col(const char *path, mplapackint const nunit);
void Cerrvx(const char *path, mplapackint const nunit);
void Cgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *work, _Float64x &resid);
void Cgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x &resid);
void Cgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Cgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, mplapackint const lwork, mplapackint &info);
void Cget01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *rwork, _Float64x &resid);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cget03(mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ainv, mplapackint const ldainv, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Cget04(mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x const rcond, _Float64x &resid);
void Cget07(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, bool const chkferr, _Float64x *berr, _Float64x *reslts);
void Cget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cgtt01(mplapackint const n, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *dlf, std::complex<_Float64x> *df, std::complex<_Float64x> *duf, std::complex<_Float64x> *du2, mplapackint *ipiv, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &resid);
void Cgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x &resid);
void Cgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *dl, std::complex<_Float64x> *d, std::complex<_Float64x> *du, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Chet01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Chet01_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Chet01_aa(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Chet01_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Chpt01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Clahilb(mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *work, mplapackint &info, const char *path);
void Claipd(mplapackint const n, std::complex<_Float64x> *a, mplapackint const inda, mplapackint const vinda);
void Claptm(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x const alpha, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *x, mplapackint const ldx, _Float64x const beta, std::complex<_Float64x> *b, mplapackint const ldb);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, _Float64x &anorm, mplapackint &mode, _Float64x &cndnum, char *dist);
void Clatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, _Float64x &anorm, mplapackint &mode, _Float64x &cndnum, char *dist);
void Clatsp(const char *uplo, mplapackint const n, std::complex<_Float64x> *x, mplapackint *iseed);
void Clatsy(const char *uplo, mplapackint const n, std::complex<_Float64x> *x, mplapackint const ldx, mplapackint *iseed);
void Clattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Clattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Clattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, std::complex<_Float64x> *work, _Float64x *rwork, mplapackint &info);
void Clavhe(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clavhe_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clavhp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, mplapackint *ipiv, std::complex<_Float64x> *b, mplapackint const ldb, mplapackint &info);
void Clqt01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *l, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Clqt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *l, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Clqt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *af, std::complex<_Float64x> *c, std::complex<_Float64x> *cc, std::complex<_Float64x> *q, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Clqt04(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *result);
void Clqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float64x *result);
void Cpbt01(const char *uplo, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, _Float64x *rwork, _Float64x &resid);
void Cpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Cpot01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, _Float64x *rwork, _Float64x &resid);
void Cpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cpot03(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ainv, mplapackint const ldainv, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Cpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Cpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cppt01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, _Float64x *rwork, _Float64x &resid);
void Cppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cppt03(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *ainv, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Cppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Cpst01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, std::complex<_Float64x> *perm, mplapackint const ldperm, mplapackint *piv, _Float64x *rwork, _Float64x &resid, mplapackint const rank);
void Cptt01(mplapackint const n, _Float64x *d, std::complex<_Float64x> *e, _Float64x *df, std::complex<_Float64x> *ef, std::complex<_Float64x> *work, _Float64x &resid);
void Cptt02(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x &resid);
void Cptt05(mplapackint const n, mplapackint const nrhs, _Float64x *d, std::complex<_Float64x> *e, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Cqlt01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *l, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqlt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *l, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqlt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *af, std::complex<_Float64x> *c, std::complex<_Float64x> *cc, std::complex<_Float64x> *q, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqrt01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqrt01p(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqrt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqrt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *af, std::complex<_Float64x> *c, std::complex<_Float64x> *cc, std::complex<_Float64x> *q, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Cqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *result);
void Cqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float64x *result);
void Cqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x &norma, mplapackint *iseed);
void Cqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *s, mplapackint &rank, _Float64x &norma, _Float64x &normb, mplapackint *iseed, std::complex<_Float64x> *work, mplapackint const lwork);
void Cqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Crqt01(mplapackint const m, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Crqt02(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *a, std::complex<_Float64x> *af, std::complex<_Float64x> *q, std::complex<_Float64x> *r, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Crqt03(mplapackint const m, mplapackint const n, mplapackint const k, std::complex<_Float64x> *af, std::complex<_Float64x> *c, std::complex<_Float64x> *cc, std::complex<_Float64x> *q, mplapackint const lda, std::complex<_Float64x> *tau, std::complex<_Float64x> *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, std::complex<_Float64x> const alpha, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const incx, std::complex<_Float64x> const beta, std::complex<_Float64x> *y, mplapackint const incy);
void Cspt01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *afac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Cspt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Cspt03(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, std::complex<_Float64x> *ainv, std::complex<_Float64x> *work, mplapackint const ldw, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Csyt01(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Csyt01_3(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, std::complex<_Float64x> *e, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Csyt01_aa(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Csyt01_rook(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *afac, mplapackint const ldafac, mplapackint *ipiv, std::complex<_Float64x> *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Csyt02(const char *uplo, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Csyt03(const char *uplo, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ainv, mplapackint const ldainv, std::complex<_Float64x> *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Ctbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &resid);
void Ctbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x &resid);
void Ctbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, std::complex<_Float64x> *ab, mplapackint const ldab, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Ctbt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, std::complex<_Float64x> *ab, mplapackint const ldab, _Float64x *rwork, _Float64x &rat);
void Ctpt01(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *ap, std::complex<_Float64x> *ainvp, _Float64x &rcond, _Float64x *rwork, _Float64x &resid);
void Ctpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &resid);
void Ctpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x &resid);
void Ctpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *ap, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Ctpt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *ap, _Float64x *rwork, _Float64x &rat);
void Ctrt01(const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *ainv, mplapackint const ldainv, _Float64x &rcond, _Float64x *rwork, _Float64x &resid);
void Ctrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x *rwork, _Float64x &resid);
void Ctrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *work, _Float64x &resid);
void Ctrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, std::complex<_Float64x> *a, mplapackint const lda, std::complex<_Float64x> *b, mplapackint const ldb, std::complex<_Float64x> *x, mplapackint const ldx, std::complex<_Float64x> *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Ctrt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, std::complex<_Float64x> *a, mplapackint const lda, _Float64x *rwork, _Float64x &rat);
void Ctsqr01(const char *tssw, mplapackint &m, mplapackint &n, mplapackint const mb, mplapackint const nb, _Float64x *result);
void Cunhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float64x *result);
void Cunhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float64x *result);
void Mxerbla__Float64x(const char *srname, int info);
void Rchkeq(_Float64x const thresh, mplapackint const nout);
void Rchkgb(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, _Float64x *a, mplapackint const la, _Float64x *afac, mplapackint const lafac, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkge(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *af, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchklq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *aq, _Float64x *al, _Float64x *ac, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *tau, _Float64x *work, _Float64x *rwork, mplapackint const nout);
void Rchklqt(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchklqtp(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkorhr_col(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchkps(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nrank, mplapackint *rankval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *perm, mplapackint *piv, _Float64x *work, _Float64x *rwork, mplapackint const nout);
void Rchkpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *d, _Float64x *e, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint const nout);
void Rchkq3(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, _Float64x const thresh, _Float64x *a, _Float64x *copya, _Float64x *s, _Float64x *tau, _Float64x *work, mplapackint *iwork, mplapackint const nout);
void Rchkql(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *aq, _Float64x *al, _Float64x *ac, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *tau, _Float64x *work, _Float64x *rwork, mplapackint const nout);
void Rchkqr(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *aq, _Float64x *ar, _Float64x *ac, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *tau, _Float64x *work, _Float64x *rwork, mplapackint *, mplapackint const nout);
void Rchkqrt(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkqrtp(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchkrq(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *af, _Float64x *aq, _Float64x *ar, _Float64x *ac, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *tau, _Float64x *work, _Float64x *rwork, mplapackint *, mplapackint const nout);
void Rchksp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *e, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchksy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *ab, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *ap, _Float64x *ainvp, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktr(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nns, mplapackint *nsval, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rchktsqr(_Float64x const thresh, bool const tsterr, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nnb, mplapackint *nbval, mplapackint const nout);
void Rchktz(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *copya, _Float64x *s, _Float64x *tau, _Float64x *work, mplapackint const nout);
void Rdrvgb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, _Float64x *a, mplapackint const la, _Float64x *afb, mplapackint const lafb, _Float64x *asav, _Float64x *b, _Float64x *bsav, _Float64x *x, _Float64x *xact, _Float64x *s, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvge(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *asav, _Float64x *b, _Float64x *bsav, _Float64x *x, _Float64x *xact, _Float64x *s, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvgt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *af, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvls(bool *dotype, mplapackint const nm, mplapackint *mval, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnb, mplapackint *nbval, mplapackint *nxval, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *copya, _Float64x *b, _Float64x *copyb, _Float64x *c, _Float64x *s, _Float64x *copys, mplapackint const nout);
void Rdrvpb(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *asav, _Float64x *b, _Float64x *bsav, _Float64x *x, _Float64x *xact, _Float64x *s, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpo(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *asav, _Float64x *b, _Float64x *bsav, _Float64x *x, _Float64x *xact, _Float64x *s, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *asav, _Float64x *b, _Float64x *bsav, _Float64x *x, _Float64x *xact, _Float64x *s, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvpt(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, _Float64x *a, _Float64x *d, _Float64x *e, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint const nout);
void Rdrvrf1(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, _Float64x *a, mplapackint const lda, _Float64x *arf, _Float64x *work);
void Rdrvrf2(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x *a, mplapackint const lda, _Float64x *arf, _Float64x *ap, _Float64x *asav);
void Rdrvrf3(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, _Float64x *a, mplapackint const lda, _Float64x *arf, _Float64x *b1, _Float64x *b2, _Float64x *d_work_Rlange, _Float64x *d_work_Rgeqrf, _Float64x *tau);
void Rdrvrf4(mplapackint const nout, mplapackint const nn, mplapackint *nval, _Float64x const thresh, _Float64x *c1, _Float64x *c2, mplapackint const ldc, _Float64x *crf, _Float64x *a, mplapackint const lda, _Float64x *d_work_Rlange);
void Rdrvrfp(mplapackint const nout, mplapackint const nn, mplapackint *nval, mplapackint const nns, mplapackint *nsval, mplapackint const nnt, mplapackint *ntval, _Float64x const thresh, _Float64x *a, _Float64x *asav, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *bsav, _Float64x *xact, _Float64x *x, _Float64x *arf, _Float64x *arfinv, _Float64x *d_work_Rlatms, _Float64x *d_work_Rpot01, _Float64x *d_temp_Rpot02, _Float64x *d_temp_Rpot03, _Float64x *d_work_Rlansy, _Float64x *d_work_Rpot02, _Float64x *d_work_Rpot03);
void Rdrvsp(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_aa_2stage(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rk(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *e, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rdrvsy_rook(bool *dotype, mplapackint const nn, mplapackint *nval, mplapackint const nrhs, _Float64x const thresh, bool const tsterr, mplapackint const nmax, _Float64x *a, _Float64x *afac, _Float64x *ainv, _Float64x *b, _Float64x *x, _Float64x *xact, _Float64x *work, _Float64x *rwork, mplapackint *iwork, mplapackint const nout);
void Rerrge(const char *path, mplapackint const nunit);
void Rerrgt(const char *path, mplapackint const nunit);
void Rerrlq(const char *path, mplapackint const nunit);
void Rerrlqt(const char *path, mplapackint const nunit);
void Rerrlqtp(const char *path, mplapackint const nunit);
void Rerrls(const char *path, mplapackint const nunit);
void Rerrorhr_col(const char *path, mplapackint const nunit);
void Rerrpo(const char *path, mplapackint const nunit);
void Rerrps(const char *path, mplapackint const nunit);
void Rerrql(const char *path, mplapackint const nunit);
void Rerrqp(const char *path, mplapackint const nunit);
void Rerrqr(const char *path, mplapackint const nunit);
void Rerrqrt(const char *path, mplapackint const nunit);
void Rerrqrtp(const char *path, mplapackint const nunit);
void Rerrrfp(mplapackint const nunit);
void Rerrrq(const char *path, mplapackint const nunit);
void Rerrsy(const char *path, mplapackint const nunit);
void Rerrtr(const char *path, mplapackint const nunit);
void Rerrtsqr(const char *path, mplapackint const nunit);
void Rerrtz(const char *path, mplapackint const nunit);
void Rerrvx(const char *path, mplapackint const nunit);
void Rgbt01(mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *work, _Float64x &resid);
void Rgbt02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x &resid);
void Rgbt05(const char *trans, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rgelqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqls(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgeqrs(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rgerqs(mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *tau, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint const lwork, mplapackint &info);
void Rget01(mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *rwork, _Float64x &resid);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rget03(mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *ainv, mplapackint const ldainv, _Float64x *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Rget04(mplapackint const n, mplapackint const nrhs, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x const rcond, _Float64x &resid);
void Rget07(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, bool const chkferr, _Float64x *berr, _Float64x *reslts);
void Rget08(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rgtt01(mplapackint const n, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *dlf, _Float64x *df, _Float64x *duf, _Float64x *du2, mplapackint *ipiv, _Float64x *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &resid);
void Rgtt02(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x &resid);
void Rgtt05(const char *trans, mplapackint const n, mplapackint const nrhs, _Float64x *dl, _Float64x *d, _Float64x *du, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rlahilb(mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, mplapackint &info);
void Rlaord(const char *job, mplapackint const n, _Float64x *x, mplapackint const incx);
void Rlaptm(mplapackint const n, mplapackint const nrhs, _Float64x const alpha, _Float64x *d, _Float64x *e, _Float64x *x, mplapackint const ldx, _Float64x const beta, _Float64x *b, mplapackint const ldb);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlatb4(const char *path, mplapackint const imat, mplapackint const m, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, _Float64x &anorm, mplapackint &mode, _Float64x &cndnum, char *dist);
void Rlatb5(const char *path, mplapackint const imat, mplapackint const n, char *type, mplapackint &kl, mplapackint &ku, _Float64x &anorm, mplapackint &mode, _Float64x &cndnum, char *dist);
void Rlattb(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *b, _Float64x *work, mplapackint &info);
void Rlattp(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, _Float64x *a, _Float64x *b, _Float64x *work, mplapackint &info);
void Rlattr(mplapackint const imat, const char *uplo, const char *trans, char *diag, mplapackint *iseed, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *b, _Float64x *work, mplapackint &info);
void Rlavsp(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rlavsy(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rlavsy_rook(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, mplapackint *ipiv, _Float64x *b, mplapackint const ldb, mplapackint &info);
void Rlqt01(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *l, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rlqt02(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *l, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rlqt03(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *af, _Float64x *c, _Float64x *cc, _Float64x *q, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rlqt04(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *result);
void Rlqt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float64x *result);
void Rorhr_col01(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float64x *result);
void Rorhr_col02(mplapackint const m, mplapackint const n, mplapackint const mb1, mplapackint const nb1, mplapackint const nb2, _Float64x *result);
void Rpbt01(const char *uplo, mplapackint const n, mplapackint const kd, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, _Float64x *rwork, _Float64x &resid);
void Rpbt02(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rpbt05(const char *uplo, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rpot01(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, _Float64x *rwork, _Float64x &resid);
void Rpot02(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rpot03(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *ainv, mplapackint const ldainv, _Float64x *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Rpot05(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rpot06(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rppt01(const char *uplo, mplapackint const n, _Float64x *a, _Float64x *afac, _Float64x *rwork, _Float64x &resid);
void Rppt02(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *a, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rppt03(const char *uplo, mplapackint const n, _Float64x *a, _Float64x *ainv, _Float64x *work, mplapackint const ldwork, _Float64x *rwork, _Float64x &rcond, _Float64x &resid);
void Rppt05(const char *uplo, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rpst01(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, _Float64x *perm, mplapackint const ldperm, mplapackint *piv, _Float64x *rwork, _Float64x &resid, mplapackint const rank);
void Rptt01(mplapackint const n, _Float64x *d, _Float64x *e, _Float64x *df, _Float64x *ef, _Float64x *work, _Float64x &resid);
void Rptt02(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x &resid);
void Rptt05(mplapackint const n, mplapackint const nrhs, _Float64x *d, _Float64x *e, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rqlt01(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *l, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqlt02(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *l, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqlt03(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *af, _Float64x *c, _Float64x *cc, _Float64x *q, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqrt01(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqrt01p(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqrt02(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqrt03(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *af, _Float64x *c, _Float64x *cc, _Float64x *q, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rqrt04(mplapackint const m, mplapackint const n, mplapackint const nb, _Float64x *result);
void Rqrt05(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const nb, _Float64x *result);
void Rqrt13(mplapackint const scale, mplapackint const m, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x &norma, mplapackint *iseed);
void Rqrt15(mplapackint const scale, mplapackint const rksel, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *s, mplapackint &rank, _Float64x &norma, _Float64x &normb, mplapackint *iseed, _Float64x *work, mplapackint const lwork);
void Rqrt16(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *rwork, _Float64x &resid);
void Rrqt01(mplapackint const m, mplapackint const n, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rrqt02(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *a, _Float64x *af, _Float64x *q, _Float64x *r, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rrqt03(mplapackint const m, mplapackint const n, mplapackint const k, _Float64x *af, _Float64x *c, _Float64x *cc, _Float64x *q, mplapackint const lda, _Float64x *tau, _Float64x *work, mplapackint const lwork, _Float64x *rwork, _Float64x *result);
void Rspt01(const char *uplo, mplapackint const n, _Float64x *a, _Float64x *afac, mplapackint *ipiv, _Float64x *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Rsyt01(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Rsyt01_3(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, _Float64x *e, mplapackint *ipiv, _Float64x *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Rsyt01_aa(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Rsyt01_rook(const char *uplo, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *afac, mplapackint const ldafac, mplapackint *ipiv, _Float64x *c, mplapackint const ldc, _Float64x *rwork, _Float64x &resid);
void Rtbt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtbt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtbt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const kd, mplapackint const nrhs, _Float64x *ab, mplapackint const ldab, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rtbt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, mplapackint const kd, _Float64x *ab, mplapackint const ldab, _Float64x *work, _Float64x &rat);
void Rtplqt(mplapackint const m, mplapackint const n, mplapackint const l, mplapackint const mb, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *t, mplapackint const ldt, _Float64x *work, mplapackint &info);
void Rtpt01(const char *uplo, const char *diag, mplapackint const n, _Float64x *ap, _Float64x *ainvp, _Float64x &rcond, _Float64x *work, _Float64x &resid);
void Rtpt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtpt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtpt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *ap, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rtpt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, _Float64x *ap, _Float64x *work, _Float64x &rat);
void Rtrt01(const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *ainv, mplapackint const ldainv, _Float64x &rcond, _Float64x *work, _Float64x &resid);
void Rtrt02(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtrt03(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x const scale, _Float64x *cnorm, _Float64x const tscal, _Float64x *x, mplapackint const ldx, _Float64x *b, mplapackint const ldb, _Float64x *work, _Float64x &resid);
void Rtrt05(const char *uplo, const char *trans, const char *diag, mplapackint const n, mplapackint const nrhs, _Float64x *a, mplapackint const lda, _Float64x *b, mplapackint const ldb, _Float64x *x, mplapackint const ldx, _Float64x *xact, mplapackint const ldxact, _Float64x *ferr, _Float64x *berr, _Float64x *reslts);
void Rtrt06(_Float64x const rcond, _Float64x const rcondc, const char *uplo, const char *diag, mplapackint const n, _Float64x *a, mplapackint const lda, _Float64x *work, _Float64x &rat);
void Rtsqr01(const char *tssw, mplapackint const m, mplapackint const n, mplapackint const mb, mplapackint const nb, _Float64x *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void icopy(mplapackint const &n, mplapackint *sx, mplapackint const &incx, mplapackint *sy, mplapackint const &incy);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
