/*
 * Copyright (c) 2008-2010
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * $Id: mplapack_generic.h,v 1.18 2010/08/07 03:15:46 nakatamaho Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_GENERIC_H_
#define _MPLAPACK_GENERIC_H_

/* MPLAPACK prototypes */

/* MPLAPACK driver routines */
void Rsyev(const char *jobz, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *w, REAL *work, INTEGER lwork, INTEGER *info);
void Cheev(const char *jobz, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *w, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgesv(INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cgesv(INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);

/* MPLAPACK computational routines */
void Rsteqr(const char *compz, INTEGER n, REAL *d, REAL *e, REAL *Z, INTEGER ldz, REAL *work, INTEGER *info);
void Csteqr(const char *compz, INTEGER n, REAL *d, REAL *e, COMPLEX *z, INTEGER ldz, REAL *work, INTEGER *info);
void Rsterf(INTEGER n, REAL *d, REAL *e, INTEGER *info);
void Rorgqr(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cungqr(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rorgql(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cungql(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rsytrd(const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *d, REAL *e, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Chetrd(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *d, REAL *e, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rorgtr(const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cungtr(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rpotrf(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Cpotrf(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rtrtri(const char *uplo, const char *diag, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Ctrtri(const char *uplo, const char *diag, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rgetrf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Cgetrf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Rgetri(INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *work, INTEGER lwork, INTEGER *info);
void Cgetri(INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgetrs(const char *trans, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cgetrs(const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rtrtrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *info);
void Ctrtrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *info);

/* MPLAPACK Auxiliary routines */
REAL Rlamc3(REAL a, REAL b);
mpf_class Rlamch_gmp(const char *cmach);
mplapackint iMlaenv_gmp(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mpreal Rlamch_mpfr(const char *cmach);
mplapackint iMlaenv_mpfr(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
qd_real Rlamch_qd(const char *cmach);
mplapackint iMlaenv_qd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
dd_real Rlamch_dd(const char *cmach);
mplapackint iMlaenv_dd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
double Rlamch_double(const char *cmach);
mplapackint iMlaenv_double(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
void Rlae2(REAL a, REAL b, REAL c, REAL *rt1, REAL *rt2);
void Rlaev2(REAL a, REAL b, REAL c, REAL *rt1, REAL *rt2, REAL *cs1, REAL *sn1);
void Claev2(COMPLEX a, COMPLEX b, COMPLEX c, REAL *rt1, REAL *rt2, REAL *cs1, COMPLEX *sn1);
void Rlassq(INTEGER n, REAL *x, INTEGER incx, REAL *scale, REAL *sumsq);
void Classq(INTEGER n, COMPLEX *x, INTEGER incx, REAL *scale, REAL *sumsq);
REAL Rlanst(const char *norm, INTEGER n, REAL *d, REAL *e);
REAL Clanht(const char *norm, INTEGER n, REAL *d, COMPLEX *e);
REAL Rlansy(const char *norm, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *work);
REAL Clansy(const char *norm, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *work);
REAL Clanhe(const char *norm, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *work);
REAL Rlapy2(REAL x, REAL y);
void Rlarfg(INTEGER N, REAL *alpha, REAL *x, INTEGER incx, REAL *tau);
REAL Rlapy3(REAL x, REAL y, REAL z);
void Rladiv(REAL a, REAL b, REAL c, REAL d, REAL *p, REAL *q);
COMPLEX Cladiv(COMPLEX x, COMPLEX y);
void Clarfg(INTEGER n, COMPLEX *alpha, COMPLEX *x, INTEGER incx, COMPLEX *tau);
void Rlartg(REAL f, REAL g, REAL *cs, REAL *sn, REAL *r);
void Clartg(COMPLEX f, COMPLEX g, REAL *cs, COMPLEX *sn, COMPLEX *r);
void Rlaset(const char *uplo, INTEGER m, INTEGER n, REAL alpha, REAL beta, REAL *A, INTEGER lda);
void Claset(const char *uplo, INTEGER m, INTEGER n, COMPLEX alpha, COMPLEX beta, COMPLEX *A, INTEGER lda);
void Rlasr(const char *side, const char *pivot, const char *direct, INTEGER m, INTEGER n, REAL *c, REAL *s, REAL *A, INTEGER lda);
void Clasr(const char *side, const char *pivot, const char *direct, INTEGER m, INTEGER n, REAL *c, REAL *s, COMPLEX *A, INTEGER lda);
void Rpotf2(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Clacgv(INTEGER n, COMPLEX *x, INTEGER incx);
void Cpotf2(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rlascl(const char *type, INTEGER kl, INTEGER ku, REAL cfrom, REAL cto, INTEGER m, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Clascl(const char *type, INTEGER kl, INTEGER ku, REAL cfrom, REAL cto, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rlasrt(const char *id, INTEGER n, REAL *d, INTEGER *info);
void Rsytd2(const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *d, REAL *e, REAL *tau, INTEGER *info);
void Chetd2(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *d, REAL *e, COMPLEX *tau, INTEGER *info);
void Rlarf(const char *side, INTEGER m, INTEGER n, REAL *v, INTEGER incv, REAL tau, REAL *C, INTEGER ldc, REAL *work);
void Clarf(const char *side, INTEGER m, INTEGER n, COMPLEX *v, INTEGER incv, COMPLEX tau, COMPLEX *c, INTEGER ldc, COMPLEX *work);
void Rorg2l(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cung2l(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rorg2r(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cung2r(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rlarft(const char *direct, const char *storev, INTEGER n, INTEGER k, REAL *v, INTEGER ldv, REAL *tau, REAL *t, INTEGER ldt);
void Clarft(const char *direct, const char *storev, INTEGER n, INTEGER k, COMPLEX *v, INTEGER ldv, COMPLEX *tau, COMPLEX *t, INTEGER ldt);
void Rlarfb(const char *side, const char *trans, const char *direct, const char *storev, INTEGER m, INTEGER n, INTEGER k, REAL *V, INTEGER ldv, REAL *T, INTEGER ldt, REAL *C, INTEGER ldc, REAL *work, INTEGER ldwork);
void Clarfb(const char *side, const char *trans, const char *direct, const char *storev, INTEGER m, INTEGER n, INTEGER k, COMPLEX *V, INTEGER ldv, COMPLEX *T, INTEGER ldt, COMPLEX *C, INTEGER ldc, COMPLEX *work, INTEGER ldwork);
void Rlatrd(const char *uplo, INTEGER n, INTEGER nb, REAL *A, INTEGER lda, REAL *e, REAL *tau, REAL *w, INTEGER ldw);
void Clatrd(const char *uplo, INTEGER n, INTEGER nb, COMPLEX *A, INTEGER lda, REAL *e, COMPLEX *tau, COMPLEX *w, INTEGER ldw);
void Clacrm(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *B, INTEGER ldb, COMPLEX *c, INTEGER ldc, REAL *rwork);
void Rtrti2(const char *uplo, const char *diag, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Ctrti2(const char *uplo, const char *diag, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rgetf2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Cgetf2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Rlaswp(INTEGER n, REAL *A, INTEGER lda, INTEGER k1, INTEGER k2, INTEGER *ipiv, INTEGER incx);
void Claswp(INTEGER n, COMPLEX *A, INTEGER lda, INTEGER k1, INTEGER k2, INTEGER *ipiv, INTEGER incx);
void Rlasyf(const char *uplo, INTEGER n, INTEGER nb, INTEGER kb, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *w, INTEGER ldw, INTEGER *info);
void Clasyf(const char *uplo, INTEGER n, INTEGER nb, INTEGER kb, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *w, INTEGER ldw, INTEGER *info);
void Clahef(const char *uplo, INTEGER n, INTEGER nb, INTEGER kb, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *w, INTEGER ldw, INTEGER *info);
void Clacrt(INTEGER n, COMPLEX *cx, INTEGER incx, COMPLEX *cy, INTEGER incy, COMPLEX c, COMPLEX s);
void Claesy(COMPLEX a, COMPLEX b, COMPLEX c, COMPLEX *rt1, COMPLEX *rt2, COMPLEX *evscal, COMPLEX *cs1, COMPLEX *sn1);
void Crot(INTEGER n, COMPLEX *cx, INTEGER incx, COMPLEX *cy, INTEGER incy, REAL c, COMPLEX s);
void Cspmv(const char *uplo, INTEGER n, COMPLEX alpha, COMPLEX *AP, COMPLEX *x, INTEGER incx, COMPLEX beta, COMPLEX *y, INTEGER incy);
void Cspr(const char *uplo, INTEGER n, COMPLEX alpha, COMPLEX *x, INTEGER incx, COMPLEX *AP);
void Csymv(const char *uplo, INTEGER n, COMPLEX alpha, COMPLEX *A, INTEGER lda, COMPLEX *x, INTEGER incx, COMPLEX beta, COMPLEX *y, INTEGER incy);
void Csyr(const char *uplo, INTEGER n, COMPLEX alpha, COMPLEX *x, INTEGER incx, COMPLEX *A, INTEGER lda);
INTEGER iCmax1(INTEGER n, COMPLEX *cx, INTEGER incx);
REAL RCsum1(INTEGER n, COMPLEX *cx, INTEGER incx);
void Rlacn2(INTEGER n, REAL *v, REAL *x, INTEGER *isgn, REAL *est, INTEGER *kase, INTEGER *isave);
void Clacn2(INTEGER n, COMPLEX *v, COMPLEX *x, REAL *est, INTEGER *kase, INTEGER *isave);
void Rlatrs(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, REAL *A, INTEGER lda, REAL *x, REAL *scale, REAL *cnorm, INTEGER *info);
void Clatrs(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *x, REAL *scale, REAL *cnorm, INTEGER *info);

/* not yet done ... auxiliary routines */
void Rgbtf2(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, INTEGER *ipiv, INTEGER *info);
void Cgbtf2(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, INTEGER *ipiv, INTEGER *info);
void Rgebd2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *d, REAL *e, REAL *tauq, REAL *taup, REAL *work, INTEGER *info);
void Cgebd2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *d, REAL *e, COMPLEX *tauq, COMPLEX *taup, COMPLEX *work, INTEGER *info);
void Rgehd2(INTEGER n, INTEGER ilo, INTEGER ihi, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cgehd2(INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgelq2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cgelq2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgeql2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cgeql2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgeqr2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cgeqr2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgerq2(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cgerq2(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgesc2(INTEGER n, REAL *A, INTEGER lda, REAL *rhs, INTEGER *ipiv, INTEGER *jpiv, REAL *scale);
void Cgesc2(INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *rhs, INTEGER *ipiv, INTEGER *jpiv, REAL *scale);
void Rgetc2(INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, INTEGER *jpiv, INTEGER *info);
void Cgetc2(INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, INTEGER *jpiv, INTEGER *info);
void Rgtts2(INTEGER itrans, INTEGER n, INTEGER nrhs, REAL *dl, REAL *d, REAL *du, REAL *du2, INTEGER *ipiv, REAL *B, INTEGER ldb);
void Cgtts2(INTEGER itrans, INTEGER n, INTEGER nrhs, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *du2, INTEGER *ipiv, COMPLEX *B, INTEGER ldb);
void Rlabrd(INTEGER m, INTEGER n, INTEGER nb, REAL *A, INTEGER lda, REAL *d, REAL *e, REAL *tauq, REAL *taup, REAL *x, INTEGER ldx, REAL *y, INTEGER ldy);
void Clabrd(INTEGER m, INTEGER n, INTEGER nb, COMPLEX *A, INTEGER lda, REAL *d, REAL *e, COMPLEX *tauq, COMPLEX *taup, COMPLEX *x, INTEGER ldx, COMPLEX *y, INTEGER ldy);
void Rlacpy(const char *uplo, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb);
void Clacpy(const char *uplo, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb);
void Clarcm(INTEGER m, INTEGER n, REAL *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *c, INTEGER ldc, REAL *rwork);
void Rlaebz(INTEGER ijob, INTEGER nitmax, INTEGER n, INTEGER mmax, INTEGER minp, INTEGER nbmin, REAL abstol, REAL reltol, REAL pivmin, REAL *d, REAL *e, REAL *e2, INTEGER *nval, REAL *AB, REAL *c, INTEGER *mout, INTEGER *nab, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlaed0(INTEGER icompq, INTEGER qsiz, INTEGER n, REAL *d, REAL *e, REAL *q, INTEGER ldq, REAL *qstore, INTEGER ldqs, REAL *work, INTEGER *iwork, INTEGER *info);
void Claed0(INTEGER qsiz, INTEGER n, REAL *d, REAL *e, COMPLEX *q, INTEGER ldq, COMPLEX *qstore, INTEGER ldqs, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rlaed1(INTEGER n, REAL *d, REAL *q, INTEGER ldq, INTEGER *indxq, REAL rho, INTEGER cutpnt, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlaed2(INTEGER *k, INTEGER n, INTEGER n1, REAL *d, REAL *q, INTEGER ldq, INTEGER *indxq, REAL *rho, REAL *z, REAL *dlamda, REAL *w, REAL *q2, INTEGER *indx, INTEGER *indxc, INTEGER *indxp, INTEGER *coltyp, INTEGER *info);
void Rlaed3(INTEGER k, INTEGER n, INTEGER n1, REAL *d, REAL *q, INTEGER ldq, REAL *rho, REAL *dlamda, REAL *q2, INTEGER *indx, INTEGER *ctot, REAL *w, REAL *s, INTEGER *info);
void Rlaed4(INTEGER n, INTEGER i, REAL *d, REAL *z, REAL *delta, REAL rho, REAL *dlam, INTEGER *info);
void Rlaed5(INTEGER i, REAL *d, REAL *z, REAL *delta, REAL rho, REAL *dlam);
void Rlaed6(INTEGER kniter, INTEGER orgati, REAL rho, REAL *d, REAL *z, REAL *finit, REAL *tau, INTEGER *info);
void Rlaed7(INTEGER icompq, INTEGER n, INTEGER qsiz, INTEGER tlvls, INTEGER curlvl, INTEGER curpbm, REAL *d, REAL *q, INTEGER ldq, INTEGER *indxq, REAL rho, INTEGER cutpnt, REAL *qstore, INTEGER *qptr, INTEGER *prmptr, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, REAL *givnum, REAL *work, INTEGER *iwork, INTEGER *info);
void Claed7(INTEGER n, INTEGER cutpnt, INTEGER qsiz, INTEGER tlvls, INTEGER curlvl, INTEGER curpbm, REAL *d, COMPLEX *q, INTEGER ldq, REAL rho, INTEGER *indxq, REAL *qstore, INTEGER *qptr, INTEGER *prmptr, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, REAL *givnum, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rlaed8(INTEGER icompq, INTEGER *k, INTEGER n, INTEGER qsiz, REAL *d, REAL *q, INTEGER ldq, INTEGER *indxq, REAL *rho, INTEGER cutpnt, REAL *z, REAL *dlamda, REAL *q2, INTEGER ldq2, REAL *w, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, REAL *givnum, INTEGER *indxp, INTEGER *indx, INTEGER *info);
void Claed8(INTEGER *k, INTEGER n, INTEGER qsiz, COMPLEX *q, INTEGER ldq, REAL *d, REAL *rho, INTEGER cutpnt, REAL *z, REAL *dlamda, COMPLEX *q2, INTEGER ldq2, REAL *w, INTEGER *indxp, INTEGER *indx, INTEGER *indxq, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, REAL *givnum, INTEGER *info);
void Rlaed9(INTEGER k, INTEGER kstart, INTEGER kstop, INTEGER n, REAL *d, REAL *q, INTEGER ldq, REAL rho, REAL *dlamda, REAL *w, REAL *s, INTEGER lds, INTEGER *info);
void Rlaeda(INTEGER n, INTEGER tlvls, INTEGER curlvl, INTEGER curpbm, INTEGER *prmptr, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, REAL *givnum, REAL *q, INTEGER *qptr, REAL *z, REAL *ztemp, INTEGER *info);
void Rlaein(INTEGER rightv, INTEGER noinit, INTEGER n, REAL *h, INTEGER ldh, REAL wr, REAL wi, REAL *vr, REAL *vi, REAL *B, INTEGER ldb, REAL *work, REAL eps3, REAL smlnum, REAL bignum, INTEGER *info);
void Claein(INTEGER rightv, INTEGER noinit, INTEGER n, COMPLEX *h, INTEGER ldh, COMPLEX w, COMPLEX *v, COMPLEX *B, INTEGER ldb, REAL *rwork, REAL eps3, REAL smlnum, INTEGER *info);
void Rlaexc(INTEGER wantq, INTEGER n, REAL *t, INTEGER ldt, REAL *q, INTEGER ldq, INTEGER j1, INTEGER n1, INTEGER n2, REAL *work, INTEGER *info);
void Rlag2(REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL safmin, REAL *scale1, REAL *scale2, REAL *wr1, REAL *wr2, REAL *wi);
void Rlags2(INTEGER upper, REAL a1, REAL a2, REAL a3, REAL b1, REAL b2, REAL b3, REAL *csu, REAL *snu, REAL *csv, REAL *snv, REAL *csq, REAL *snq);
void Clags2(LOGICAL *upper, REAL a1, COMPLEX a2, REAL a3, REAL b1, COMPLEX b2, REAL b3, REAL *csu, COMPLEX *snu, REAL *csv, COMPLEX *snv, REAL *csq, COMPLEX *snq);
void Rlagtf(INTEGER n, REAL *a, REAL lambda, REAL *b, REAL *c, REAL *tol, REAL *d, INTEGER *in, INTEGER *info);
void Rlagtm(const char *trans, INTEGER n, INTEGER nrhs, REAL alpha, REAL *dl, REAL *d, REAL *du, REAL *x, INTEGER ldx, REAL *beta, REAL *B, INTEGER ldb);
void Clagtm(const char *trans, INTEGER n, INTEGER nrhs, REAL alpha, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *x, INTEGER ldx, REAL beta, COMPLEX *B, INTEGER ldb);
void Rlagts(INTEGER job, INTEGER n, REAL *a, REAL *b, REAL *c, REAL *d, INTEGER *in, REAL *y, REAL *tol, INTEGER *info);
void Rlagv2(REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *csl, REAL *snl, REAL *csr, REAL *snr);
void Rlahqr(INTEGER wantt, INTEGER wantz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *h, INTEGER ldh, REAL *wr, REAL *wi, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, INTEGER *info);
void Clahqr(INTEGER wantt, INTEGER wantz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *h, INTEGER ldh, COMPLEX *w, INTEGER iloz, INTEGER ihiz, COMPLEX *z, INTEGER ldz, INTEGER *info);
void Rlahr2(INTEGER n, INTEGER k, INTEGER nb, REAL *A, INTEGER lda, REAL *tau, REAL *t, INTEGER ldt, REAL *y, INTEGER ldy);
void Clahr2(INTEGER n, INTEGER k, INTEGER nb, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *t, INTEGER ldt, COMPLEX *y, INTEGER ldy);
void Rlahrd(INTEGER n, INTEGER k, INTEGER nb, REAL *A, INTEGER lda, REAL *tau, REAL *t, INTEGER ldt, REAL *y, INTEGER ldy);
void Clahrd(INTEGER n, INTEGER k, INTEGER nb, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *t, INTEGER ldt, COMPLEX *y, INTEGER ldy);
void Rlaic1(INTEGER job, INTEGER j, REAL *x, REAL sest, REAL *w, REAL gamma, REAL *sestpr, REAL *s, REAL *c);
void Claic1(INTEGER job, INTEGER j, COMPLEX *x, REAL sest, COMPLEX *w, COMPLEX gamma, REAL *sestpr, COMPLEX *s, COMPLEX *c);
void Rlaln2(INTEGER ltrans, INTEGER na, INTEGER nw, REAL smin, REAL ca, REAL *A, INTEGER lda, REAL d1, REAL d2, REAL *B, INTEGER ldb, REAL wr, REAL wi, REAL *x, INTEGER ldx, REAL *scale, REAL *xnorm, INTEGER *info);
void Rlals0(INTEGER icompq, INTEGER nl, INTEGER nr, INTEGER sqre, INTEGER nrhs, REAL *B, INTEGER ldb, REAL *bx, INTEGER ldbx, INTEGER *perm, INTEGER givptr, INTEGER *givcol, INTEGER ldgcol, REAL *givnum, INTEGER ldgnum, REAL *poles, REAL *difl, REAL *difr, REAL *z, INTEGER k, REAL c, REAL s, REAL *work, INTEGER *info);
void Clals0(INTEGER icompq, INTEGER nl, INTEGER nr, INTEGER sqre, INTEGER nrhs, COMPLEX *B, INTEGER ldb, COMPLEX *bx, INTEGER ldbx, INTEGER *perm, INTEGER givptr, INTEGER *givcol, INTEGER ldgcol, REAL *givnum, INTEGER ldgnum, REAL *poles, REAL *difl, REAL *difr, REAL *z, INTEGER k, REAL c, REAL s, REAL *rwork, INTEGER *info);
void Rlalsa(INTEGER icompq, INTEGER smlsiz, INTEGER n, INTEGER nrhs, REAL *B, INTEGER ldb, REAL *bx, INTEGER ldbx, REAL *u, INTEGER ldu, REAL *vt, INTEGER *k, REAL *difl, REAL *difr, REAL *z, REAL *poles, INTEGER *givptr, INTEGER *givcol, INTEGER ldgcol, INTEGER *perm, REAL *givnum, REAL *c, REAL *s, REAL *work, INTEGER *iwork, INTEGER *info);
void Clalsa(INTEGER icompq, INTEGER smlsiz, INTEGER n, INTEGER nrhs, COMPLEX *B, INTEGER ldb, COMPLEX *bx, INTEGER ldbx, REAL *u, INTEGER ldu, REAL *vt, INTEGER *k, REAL *difl, REAL *difr, REAL *z, REAL *poles, INTEGER *givptr, INTEGER *givcol, INTEGER ldgcol, INTEGER *perm, REAL *givnum, REAL *c, REAL *s, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rlalsd(const char *uplo, INTEGER smlsiz, INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *B, INTEGER ldb, REAL rcond, INTEGER *rank, REAL *work, INTEGER *iwork, INTEGER *info);
void Clalsd(const char *uplo, INTEGER smlsiz, INTEGER n, INTEGER nrhs, REAL *d, REAL *e, COMPLEX *B, INTEGER ldb, REAL rcond, INTEGER *rank, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rlamrg(INTEGER n1, INTEGER n2, REAL *a, INTEGER dtrd1, INTEGER dtrd2, INTEGER *index);
REAL Rlangb(const char *norm, INTEGER n, INTEGER kl, INTEGER ku, REAL *ab, INTEGER ldab, REAL *work);
REAL Clangb(const char *norm, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, REAL *work);
REAL Rlange(const char *norm, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *work);
REAL Clange(const char *norm, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *work);
REAL Rlangt(const char *norm, INTEGER n, REAL *dl, REAL *d, REAL *du);
REAL Clangt(const char *norm, INTEGER n, COMPLEX *dl, COMPLEX *d, COMPLEX *du);
REAL Rlanhs(const char *norm, INTEGER n, REAL *A, INTEGER lda, REAL *work);
REAL Clanhs(const char *norm, INTEGER n, COMPLEX *A, INTEGER lda, REAL *work);
REAL Rlansb(const char *norm, const char *uplo, INTEGER n, INTEGER k, REAL *AB, INTEGER ldab, REAL *work);
REAL Clansb(const char *norm, const char *uplo, INTEGER n, INTEGER k, COMPLEX *AB, INTEGER ldab, REAL *work);
REAL Clanhb(const char *norm, const char *uplo, INTEGER n, INTEGER k, COMPLEX *AB, INTEGER ldab, REAL *work);
REAL Rlansp(const char *norm, const char *uplo, INTEGER n, REAL *ap, REAL *work);
REAL Clansp(const char *norm, const char *uplo, INTEGER n, COMPLEX *ap, REAL *work);
REAL Clanhp(const char *norm, const char *uplo, INTEGER n, COMPLEX *ap, REAL *work);
REAL Rlantb(const char *norm, const char *uplo, const char *diag, INTEGER n, INTEGER k, REAL *AB, INTEGER ldab, REAL *work);
COMPLEX Clantb(const char *norm, const char *uplo, const char *diag, INTEGER n, INTEGER k, COMPLEX *AB, INTEGER ldab, REAL *work);
REAL Rlantp(const char *norm, const char *uplo, const char *diag, INTEGER n, REAL *ap, REAL *work);
COMPLEX Clantp(const char *norm, const char *uplo, const char *diag, INTEGER n, COMPLEX *ap, REAL *work);
REAL Rlantr(const char *norm, const char *uplo, const char *diag, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *work);
REAL Clantr(const char *norm, const char *uplo, const char *diag, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *work);
void Rlanv2(REAL *a, REAL *b, REAL *c, REAL *d, REAL *rt1r, REAL *rt1i, REAL *rt2r, REAL *rt2i, REAL *cs, REAL *sn);
void Rlapll(INTEGER n, REAL *x, INTEGER incx, REAL *y, INTEGER incy, REAL *ssmin);
void Clapll(INTEGER n, COMPLEX *x, INTEGER incx, COMPLEX *y, INTEGER incy, REAL *ssmin);
void Rlapmt(INTEGER *forwrd, INTEGER m, INTEGER n, REAL *X, INTEGER ldx, INTEGER *k);
void Clapmt(INTEGER *forwrd, INTEGER m, INTEGER n, COMPLEX *X, INTEGER ldx, INTEGER *k);
void Rlaqgb(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, REAL *r, REAL *c, REAL rowcnd, REAL colcnd, REAL amax, char *equed);
void Claqgb(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, REAL *r, REAL *c, REAL rowcnd, REAL colcnd, REAL amax, char *equed);
void Rlaqge(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *r, REAL *c, REAL rowcnd, REAL colcnd, REAL amax, char *equed);
void Claqge(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *r, REAL *c, REAL rowcnd, REAL colcnd, REAL amax, char *equed);
void Rlaqp2(INTEGER m, INTEGER n, INTEGER offset, REAL *A, INTEGER lda, INTEGER *jpvt, REAL *tau, REAL *vn1, REAL *vn2, REAL *work);
void Claqp2(INTEGER m, INTEGER n, INTEGER offset, COMPLEX *A, INTEGER lda, INTEGER *jpvt, COMPLEX *tau, REAL *vn1, REAL *vn2, COMPLEX *work);
void Rlaqps(INTEGER m, INTEGER n, INTEGER offset, INTEGER nb, INTEGER *kb, REAL *A, INTEGER lda, INTEGER *jpvt, REAL *tau, REAL *vn1, REAL *vn2, REAL *auxv, REAL *f, INTEGER ldf);
void Claqps(INTEGER m, INTEGER n, INTEGER offset, INTEGER nb, INTEGER *kb, COMPLEX *A, INTEGER lda, INTEGER *jpvt, COMPLEX *tau, REAL *vn1, REAL *vn2, COMPLEX *auxv, COMPLEX *f, INTEGER ldf);
void Rlaqsb(const char *uplo, INTEGER n, INTEGER kd, REAL *ab, INTEGER ldab, REAL *s, REAL scond, REAL amax, char *equed);
void Claqsb(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *ab, INTEGER ldab, REAL *s, REAL scond, REAL amax, char *equed);
void Claqhb(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *s, REAL scond, REAL amax, char *equed);
void Rlaqsp(const char *uplo, INTEGER n, REAL *ap, REAL *s, REAL scond, REAL amax, char *equed);
void Claqsp(const char *uplo, INTEGER n, COMPLEX *ap, REAL *s, REAL scond, REAL amax, char *equed);
void Claqhp(const char *uplo, INTEGER n, COMPLEX *ap, REAL *s, REAL scond, REAL amax, char *equed);
void Rlaqsy(const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *s, REAL scond, REAL amax, char *equed);
void Claqsy(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *s, REAL scond, REAL amax, char *equed);
void Claqhe(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *s, REAL scond, REAL amax, char *equed);
void Rlaqtr(INTEGER ltran, INTEGER lreal, INTEGER n, REAL *t, INTEGER ldt, REAL *B, REAL w, REAL *scale, REAL *x, REAL *work, INTEGER *info);
void Rlar1v(INTEGER n, INTEGER b1, INTEGER bn, REAL lambda, REAL *d, REAL *l, REAL *ld, REAL *lld, REAL pivmin, REAL gaptol, REAL *z, INTEGER wantnc, INTEGER *negcnt, REAL *ztz, REAL *mingma, INTEGER *r, INTEGER *isuppz, REAL *nrminv, REAL *resid, REAL *rqcorr, REAL *work);
void Clar1v(INTEGER n, INTEGER b1, INTEGER bn, REAL lambda, REAL *d, REAL *l, REAL *ld, REAL *lld, REAL pivmin, REAL gaptol, COMPLEX *z, INTEGER wantnc, INTEGER *negcnt, REAL *ztz, REAL *mingma, INTEGER *r, INTEGER *isuppz, REAL *nrminv, REAL *resid, REAL *rqcorr, REAL *work);
void Rlar2v(INTEGER n, REAL *x, REAL *y, REAL *z, INTEGER incx, REAL *c, REAL *s, INTEGER incc);
void Clar2v(INTEGER n, COMPLEX *x, COMPLEX *y, COMPLEX *z, INTEGER incx, REAL *c, COMPLEX *s, INTEGER incc);
void Rlarfx(const char *side, INTEGER m, INTEGER n, REAL *v, REAL tau, REAL *c, INTEGER ldc, REAL *work);
void Clarfx(const char *side, INTEGER m, INTEGER n, COMPLEX *v, COMPLEX tau, COMPLEX *c, INTEGER ldc, COMPLEX *work);
void Rlargv(INTEGER n, REAL *x, INTEGER incx, REAL *y, INTEGER incy, REAL *c, INTEGER incc);
void Clargv(INTEGER n, COMPLEX *x, INTEGER incx, COMPLEX *y, INTEGER incy, REAL *c, INTEGER incc);
void Rlarnv(INTEGER idist, INTEGER *iseed, INTEGER n, REAL *x);
void Clarnv(INTEGER idist, INTEGER *iseed, INTEGER n, COMPLEX *x);
INTEGER Rlaneg(INTEGER n, REAL *d, REAL *lld, REAL sigma, REAL pivmin, INTEGER r);
void Rlarra(INTEGER n, REAL *d, REAL *e, REAL *e2, REAL spltol, REAL tnrm, INTEGER *nsplit, INTEGER *isplit, INTEGER *info);
void Rlarrb(INTEGER n, REAL *d, REAL *lld, INTEGER ifirst, INTEGER ilast, REAL rtol1, REAL rtol2, INTEGER offset, REAL *w, REAL *wgap, REAL *werr, REAL *work, INTEGER *iwork, REAL pivmin, REAL spdiam, INTEGER twist, INTEGER *info);
void Rlarrc(const char *jobt, INTEGER n, REAL vl, REAL vu, REAL *d, REAL *e, REAL pivmin, INTEGER *eigcnt, INTEGER *lcnt, INTEGER *rcnt, INTEGER *info);
void Rlarrd(const char *range, const char *order, INTEGER n, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL *gers, REAL reltol, REAL *d, REAL *e, REAL *e2, REAL pivmin, INTEGER nsplit, INTEGER *isplit, INTEGER *m, REAL *w, REAL *werr, REAL *wl, REAL *wu, INTEGER *iblock, INTEGER *indexw, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlarre(const char *range, INTEGER n, REAL *vl, REAL *vu, INTEGER il, INTEGER iu, REAL *d, REAL *e, REAL *e2, REAL rtol1, REAL rtol2, REAL spltol, INTEGER *nsplit, INTEGER *isplit, INTEGER *m, REAL *w, REAL *werr, REAL *wgap, INTEGER *iblock, INTEGER *indexw, REAL *gers, REAL *pivmin, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlarrf(INTEGER n, REAL *d, REAL *l, REAL *ld, INTEGER clstrt, INTEGER clend, REAL *w, REAL *wgap, REAL *werr, REAL spdiam, REAL clgapl, REAL clgapr, REAL pivmin, REAL *sigma, REAL *dplus, REAL *lplus, REAL *work, INTEGER *info);
void Rlarrj(INTEGER n, REAL *d, REAL *e2, INTEGER ifirst, INTEGER ilast, REAL rtol, INTEGER offset, REAL *w, REAL *werr, REAL *work, INTEGER *iwork, REAL pivmin, REAL spdiam, INTEGER *info);
void Rlarrk(INTEGER n, INTEGER iw, REAL gl, REAL gu, REAL *d, REAL *e2, REAL pivmin, REAL reltol, REAL *w, REAL *werr, INTEGER *info);
void Rlarrr(INTEGER n, REAL *d, REAL *e, INTEGER *info);
void Rlartv(INTEGER n, REAL *x, INTEGER incx, REAL *y, INTEGER incy, REAL *c, REAL *s, INTEGER incc);
void Clartv(INTEGER n, COMPLEX *x, INTEGER incx, COMPLEX *y, INTEGER incy, REAL *c, COMPLEX *s, INTEGER incc);
void Rlarrv(INTEGER n, REAL vl, REAL vu, REAL *d, REAL *l, REAL pivmin, INTEGER *isplit, INTEGER m, INTEGER dol, INTEGER dou, REAL minrgp, REAL rtol1, REAL rtol2, REAL *w, REAL *werr, REAL *wgap, INTEGER *iblock, INTEGER *indexw, REAL *gers, REAL *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER *iwork, INTEGER *info);
void Clarrv(INTEGER n, REAL vl, REAL vu, REAL *d, REAL *l, REAL pivmin, INTEGER *isplit, INTEGER m, INTEGER dol, INTEGER dou, REAL minrgp, REAL rtol1, REAL rtol2, REAL *w, REAL *werr, REAL *wgap, INTEGER *iblock, INTEGER *indexw, REAL *gers, COMPLEX *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlaruv(INTEGER *iseed, INTEGER n, REAL *x);
void Rlarz(const char *side, INTEGER m, INTEGER n, INTEGER l, REAL *v, INTEGER incv, REAL tau, REAL *C, INTEGER ldc, REAL *work);
void Clarz(const char *side, INTEGER m, INTEGER n, INTEGER l, COMPLEX *v, INTEGER incv, COMPLEX tau, COMPLEX *c, INTEGER ldc, COMPLEX *work);
void Rlarzb(const char *side, const char *trans, const char *direct, const char *storev, INTEGER m, INTEGER n, INTEGER k, INTEGER l, REAL *v, INTEGER ldv, REAL *t, INTEGER ldt, REAL *c, INTEGER ldc, REAL *work, INTEGER ldwork);
void Clarzb(const char *side, const char *trans, const char *direct, const char *storev, INTEGER m, INTEGER n, INTEGER k, INTEGER l, COMPLEX *v, INTEGER ldv, COMPLEX *t, INTEGER ldt, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER ldwork);
void Rlarzt(const char *direct, const char *storev, INTEGER n, INTEGER k, REAL *v, INTEGER ldv, REAL *tau, REAL *t, INTEGER ldt);
void Clarzt(const char *direct, const char *storev, INTEGER n, INTEGER k, COMPLEX *v, INTEGER ldv, COMPLEX *tau, COMPLEX *t, INTEGER ldt);
void Rlas2(REAL f, REAL g, REAL h, REAL *ssmin, REAL *ssmax);
void Rlasd0(INTEGER n, INTEGER sqre, REAL *d, REAL *e, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, INTEGER smlsiz, INTEGER *iwork, REAL *work, INTEGER *info);
void Rlasd1(INTEGER nl, INTEGER nr, INTEGER *sqre, REAL *d, REAL *alpha, REAL *beta, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, INTEGER *idxq, INTEGER *iwork, REAL *work, INTEGER *info);
void Rlasd2(INTEGER nl, INTEGER nr, INTEGER sqre, INTEGER *k, REAL *d, REAL *z, REAL alpha, REAL beta, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, REAL *dsigma, REAL *u2, INTEGER ldu2, REAL *vt2, INTEGER ldvt2, INTEGER *idxp, INTEGER *idx, INTEGER *idxc, INTEGER *idxq, INTEGER *coltyp, INTEGER *info);
void Rlasd3(INTEGER nl, INTEGER nr, INTEGER sqre, INTEGER k, REAL *d, REAL *q, INTEGER ldq, REAL *dsigma, REAL *u, INTEGER ldu, REAL *u2, INTEGER ldu2, REAL *vt, INTEGER ldvt, REAL *vt2, INTEGER ldvt2, INTEGER *idxc, INTEGER *ctot, REAL *z, INTEGER *info);
void Rlasd4(INTEGER n, INTEGER i, REAL *d, REAL *z, REAL *delta, REAL rho, REAL *sigma, REAL *work, INTEGER *info);
void Rlasd5(INTEGER i, REAL *d, REAL *z, REAL *delta, REAL rho, REAL *dsigma, REAL *work);
void Rlasd6(INTEGER icompq, INTEGER nl, INTEGER nr, INTEGER sqre, REAL *d, REAL *vf, REAL *vl, REAL *alpha, REAL *beta, INTEGER *idxq, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, INTEGER ldgcol, REAL *givnum, INTEGER ldgnum, REAL *poles, REAL *difl, REAL *difr, REAL *z, INTEGER k, REAL *c, REAL *s, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlasd7(INTEGER icompq, INTEGER nl, INTEGER nr, INTEGER sqre, INTEGER k, REAL *d, REAL *z, REAL *zw, REAL *vf, REAL *vfw, REAL *vl, REAL *vlw, REAL alpha, REAL beta, REAL *dsigma, INTEGER *idx, INTEGER *idxp, INTEGER *idxq, INTEGER *perm, INTEGER *givptr, INTEGER *givcol, INTEGER ldgcol, REAL *givnum, INTEGER ldgnum, REAL *c, REAL *s, INTEGER *info);
void Rlasd8(INTEGER icompq, INTEGER k, REAL *d, REAL *z, REAL *vf, REAL *vl, REAL *difl, REAL *difr, INTEGER lddifr, REAL *dsigma, REAL *work, INTEGER *info);
void Rlasda(INTEGER icompq, INTEGER smlsiz, INTEGER n, INTEGER sqre, REAL *d, REAL *e, REAL *u, INTEGER ldu, REAL *vt, INTEGER *k, REAL *difl, REAL *difr, REAL *z, REAL *poles, INTEGER *givptr, INTEGER *givcol, INTEGER ldgcol, INTEGER *perm, REAL *givnum, REAL *c, REAL *s, REAL *work, INTEGER *iwork, INTEGER *info);
void Rlasdq(const char *uplo, INTEGER sqre, INTEGER n, INTEGER ncvt, INTEGER nru, INTEGER ncc, REAL *d, REAL *e, REAL *vt, INTEGER ldvt, REAL *u, INTEGER ldu, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Rlasdt(INTEGER n, INTEGER lvl, INTEGER nd, INTEGER *inode, INTEGER *ndiml, INTEGER *ndimr, INTEGER msub);
void Rlasq1(INTEGER n, REAL *d, REAL *e, REAL *work, INTEGER *info);
void Rlasq2(INTEGER n, REAL *z, INTEGER *info);
void Rlasq3(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, REAL *dmin, REAL *sigma, REAL *desig, REAL qmax, INTEGER *nfail, INTEGER *iter, INTEGER *ndiv, INTEGER ieee);
void Rlasq4(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, INTEGER n0in, REAL dmin, REAL dmin1, REAL dmin2, REAL dn, REAL dn1, REAL dn2, REAL *tau, INTEGER *ttype);
void Rlasq5(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, REAL tau, REAL *dmin, REAL *dmin1, REAL *dmin2, REAL *dn, REAL *dnm1, REAL *dnm2, INTEGER ieee);
void Rlasq6(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, REAL *dmin, REAL *dmin1, REAL *dmin2, REAL *dn, REAL *dnm1, REAL *dnm2);
void Rlasv2(REAL f, REAL g, REAL h, REAL *ssmin, REAL *ssmax, REAL *snr, REAL *csr, REAL *snl, REAL *csl);
void Rlasy2(INTEGER ltranl, INTEGER ltranr, INTEGER isgn, INTEGER n1, INTEGER n2, REAL *tl, INTEGER ldtl, REAL *tr, INTEGER ldtr, REAL *B, INTEGER ldb, REAL *scale, REAL *x, INTEGER ldx, REAL *xnorm, INTEGER *info);
void Rlatbs(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *x, REAL *scale, REAL *cnorm, INTEGER *info);
void Clatbs(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, COMPLEX *x, REAL *scale, REAL *cnorm, INTEGER *info);
void Rlatdf(INTEGER ijob, INTEGER n, REAL *z, INTEGER ldz, REAL *rhs, REAL *rdsum, REAL *rdscal, INTEGER *ipiv, INTEGER *jpiv);
void Clatdf(INTEGER ijob, INTEGER n, COMPLEX *z, INTEGER ldz, COMPLEX *rhs, REAL *rdsum, REAL *rdscal, INTEGER *ipiv, INTEGER *jpiv);
void Rlatps(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, REAL *ap, REAL *x, REAL *scale, REAL *cnorm, INTEGER *info);
void Clatps(const char *uplo, const char *trans, const char *diag, const char *normin, INTEGER n, COMPLEX *ap, COMPLEX *x, REAL *scale, REAL *cnorm, INTEGER *info);
void Rlauu2(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Clauu2(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rlauum(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Clauum(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rlatrz(INTEGER m, INTEGER n, INTEGER l, REAL *A, INTEGER lda, REAL *tau, REAL *work);
void Clatrz(INTEGER m, INTEGER n, INTEGER l, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work);
void Rorgl2(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cungl2(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rorgr2(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER *info);
void Cungr2(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rorm2l(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cunm2l(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rorm2r(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cunm2r(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rorml2(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cunml2(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rormr2(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *C, INTEGER ldc, REAL *work, INTEGER *info);
void Cunmr2(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rormr3(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, INTEGER l, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cunmr3(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, INTEGER l, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rpbtf2(const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, INTEGER *info);
void Cpbtf2(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, INTEGER *info);
void Rptts2(INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *b, INTEGER ldb);
void Cptts2(INTEGER iuplo, INTEGER n, INTEGER nrhs, REAL *d, COMPLEX *e, COMPLEX *B, INTEGER ldb);
void Rrscl(INTEGER n, REAL sa, REAL *sx, INTEGER incx);
void CRrscl(INTEGER n, REAL sa, COMPLEX *sx, INTEGER incx);
void Rsygs2(INTEGER itype, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *info);
void Chegs2(INTEGER itype, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rsytf2(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Csytf2(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Chetf2(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, INTEGER *info);
void Rtgex2(INTEGER wantq, INTEGER wantz, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *q, INTEGER ldq, REAL *z, INTEGER ldz, INTEGER j1, INTEGER n1, INTEGER n2, REAL *work, INTEGER lwork, INTEGER *info);
void Ctgex2(INTEGER wantq, INTEGER wantz, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *q, INTEGER ldq, COMPLEX *z, INTEGER ldz, INTEGER j1, INTEGER *info);
void Rtgsy2(const char *trans, INTEGER ijob, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *c, INTEGER ldc, REAL *d, INTEGER ldd, REAL *e, INTEGER lde, REAL *f, INTEGER ldf, REAL *scale, REAL *rdsum, REAL *rdscal, INTEGER *iwork, INTEGER *pq, INTEGER *info);
void Ctgsy2(const char *trans, INTEGER ijob, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *C, INTEGER ldc, COMPLEX *d, INTEGER ldd, COMPLEX *e, INTEGER lde, COMPLEX *f, INTEGER ldf, REAL *scale, REAL *rdsum, REAL *rdscal, INTEGER *info);
void Rlazq3(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, REAL *dmin, REAL *sigma, REAL *desig, REAL qmax, INTEGER *nfail, INTEGER *iter, INTEGER *ndiv, INTEGER *ieee, INTEGER *ttype, REAL *dmin1, REAL *dmin2, REAL *dn, REAL *dn1, REAL *dn2, REAL *tau);
void Rlazq4(INTEGER i0, INTEGER n0, REAL *z, INTEGER pp, INTEGER n0in, REAL dmin, REAL dmin1, REAL dmin2, REAL dn, REAL dn1, REAL dn2, REAL *tau, INTEGER *ttype, REAL *g);
void Rlaqr0(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *h, INTEGER ldh, REAL *wr, REAL *wi, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *info);
void Claqr0(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *h, INTEGER ldh, COMPLEX *w, INTEGER *iloz, INTEGER *ihiz, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rlaqr1(INTEGER n, REAL *h, INTEGER ldh, REAL sr1, REAL si1, REAL sr2, REAL si2, REAL *v);
void Claqr1(INTEGER n, COMPLEX *h, INTEGER ldh, COMPLEX s1, COMPLEX s2, COMPLEX *v);
void Rlaqr2(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nw, REAL *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, INTEGER *ns, INTEGER *nd, REAL *sr, REAL *si, REAL *v, INTEGER ldv, INTEGER nh, REAL *t, INTEGER ldt, INTEGER nv, REAL *wv, INTEGER ldwv, REAL *work, INTEGER lwork);
void Claqr2(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nw, COMPLEX *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, COMPLEX *z, INTEGER ldz, INTEGER *ns, INTEGER *nd, COMPLEX *sh, COMPLEX *v, INTEGER ldv, INTEGER nh, COMPLEX *t, INTEGER ldt, INTEGER nv, COMPLEX *wv, INTEGER ldwv, COMPLEX *work, INTEGER lwork);
void Rlaqr3(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nw, REAL *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, INTEGER ns, INTEGER nd, REAL *sr, REAL *si, REAL *v, INTEGER ldv, INTEGER nh, REAL *t, INTEGER ldt, INTEGER nv, REAL *wv, INTEGER ldwv, REAL *work, INTEGER lwork);
void Claqr3(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nw, COMPLEX *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, COMPLEX *z, INTEGER ldz, INTEGER *ns, INTEGER *nd, COMPLEX *sh, COMPLEX *v, INTEGER ldv, INTEGER nh, COMPLEX *t, INTEGER ldt, INTEGER nv, COMPLEX *wv, INTEGER ldwv, COMPLEX *work, INTEGER lwork);
void Rlaqr4(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *h, INTEGER ldh, REAL *wr, REAL *wi, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *info);
void Claqr4(LOGICAL wantt, LOGICAL wantz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *h, INTEGER ldh, COMPLEX *w, INTEGER iloz, INTEGER ihiz, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rlaqr5(LOGICAL wantt, LOGICAL wantz, INTEGER kac22, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nshfts, REAL *sr, REAL *si, REAL *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, REAL *z, INTEGER ldz, REAL *v, INTEGER ldv, REAL *u, INTEGER ldu, INTEGER nv, REAL *wv, INTEGER ldwv, INTEGER nh, REAL *wh, INTEGER ldwh);
void Claqr5(LOGICAL wantt, LOGICAL wantz, INTEGER kacc22, INTEGER n, INTEGER ktop, INTEGER kbot, INTEGER nshfts, COMPLEX *s, COMPLEX *h, INTEGER ldh, INTEGER iloz, INTEGER ihiz, COMPLEX *z, INTEGER ldz, COMPLEX *v, INTEGER ldv, COMPLEX *u, INTEGER ldu, INTEGER nv, COMPLEX *wv, INTEGER ldwv, INTEGER nh, COMPLEX *wh, INTEGER ldwh);
void Rlatzm(const char *side, INTEGER m, INTEGER n, REAL *v, INTEGER incv, REAL *tau, REAL *c1, REAL *c2, INTEGER ldc, REAL *work);
void Clatzm(const char *side, INTEGER m, INTEGER n, COMPLEX *v, INTEGER incv, COMPLEX *tau, COMPLEX *c1, COMPLEX *c2, INTEGER ldc, COMPLEX *work);
void Clacp2(const char *uplo, INTEGER m, INTEGER n, REAL *A, INTEGER lda, COMPLEX *B, INTEGER ldb);
INTEGER Risnan(REAL din);

/* not yet done ... driver and computational routines */
void Rbdsdc(const char *uplo, const char *compq, INTEGER n, REAL *d, REAL *e, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, REAL *q, INTEGER *iq, REAL *work, INTEGER *iwork, INTEGER *info);
void Rbdsqr(const char *uplo, INTEGER n, INTEGER ncvt, INTEGER nru, INTEGER ncc, REAL *d, REAL *e, REAL *vt, INTEGER ldvt, REAL *u, INTEGER ldu, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cbdsqr(const char *uplo, INTEGER n, INTEGER ncvt, INTEGER nru, INTEGER ncc, REAL *d, REAL *e, COMPLEX *vt, INTEGER ldvt, COMPLEX *u, INTEGER ldu, COMPLEX *c, INTEGER ldc, REAL *rwork, INTEGER *info);
void Rdisna(const char *job, INTEGER m, INTEGER n, REAL *d, REAL *sep, INTEGER *info);
void Rgbbrd(const char *vect, INTEGER m, INTEGER n, INTEGER ncc, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, REAL *d, REAL *e, REAL *q, INTEGER ldq, REAL *pt, INTEGER ldpt, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cgbbrd(const char *vect, INTEGER m, INTEGER n, INTEGER ncc, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, REAL *d, REAL *e, COMPLEX *q, INTEGER ldq, COMPLEX *pt, INTEGER ldpt, COMPLEX *c, INTEGER ldc, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgbcon(const char *norm, INTEGER n, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, INTEGER *ipiv, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgbcon(const char *norm, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgbequ(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, REAL *r, REAL *c, REAL *rowcnd, REAL *colcnd, REAL *amax, INTEGER *info);
void Cgbequ(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *AB, INTEGER ldab, REAL *r, REAL *c, REAL *rowcnd, REAL *colcnd, REAL *amax, INTEGER *info);
void Rgbrfs(const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *afb, INTEGER ldafb, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgbrfs(const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *afb, INTEGER ldafb, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgbsv(INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, REAL *AB, INTEGER ldab, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cgbsv(INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, COMPLEX *ab, INTEGER ldab, INTEGER *ipiv, COMPLEX *b, INTEGER ldb, INTEGER *info);
void Rgbsvx(const char *fact, const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *afb, INTEGER ldafb, INTEGER *ipiv, char *equed, REAL *r, REAL *c, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgbsvx(const char *fact, const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *afb, INTEGER ldafb, INTEGER *ipiv, char *equed, REAL *r, REAL *c, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgbtrf(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, REAL *AB, INTEGER ldab, INTEGER *ipiv, INTEGER *info);
void Cgbtrf(INTEGER m, INTEGER n, INTEGER kl, INTEGER ku, COMPLEX *ab, INTEGER ldab, INTEGER *ipiv, INTEGER *info);
void Rgbtrs(const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, REAL *AB, INTEGER ldab, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cgbtrs(const char *trans, INTEGER n, INTEGER kl, INTEGER ku, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rgebak(const char *job, const char *side, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *scale, INTEGER m, REAL *v, INTEGER ldv, INTEGER *info);
void Cgebak(const char *job, const char *side, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *scale, INTEGER m, COMPLEX *v, INTEGER ldv, INTEGER *info);
void Rgebal(const char *job, INTEGER n, REAL *A, INTEGER lda, INTEGER *ilo, INTEGER *ihi, REAL *scale, INTEGER *info);
void Cgebal(const char *job, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ilo, INTEGER *ihi, REAL *scale, INTEGER *info);
void Rgebrd(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *d, REAL *e, REAL *tauq, REAL *taup, REAL *work, INTEGER lwork, INTEGER *info);
void Cgebrd(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *d, REAL *e, COMPLEX *tauq, COMPLEX *taup, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgecon(const char *norm, INTEGER n, REAL *A, INTEGER lda, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgecon(const char *norm, INTEGER n, COMPLEX *A, INTEGER lda, REAL anorm, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgeequ(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *r, REAL *c, REAL *rowcnd, REAL *colcnd, REAL *amax, INTEGER *info);
void Cgeequ(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *r, REAL *c, REAL *rowcnd, REAL *colcnd, REAL *amax, INTEGER *info);
void Rgees(const char *jobvs, const char *sort, LFP select, INTEGER n, REAL *A, INTEGER lda, INTEGER *sdim, REAL *wr, REAL *wi, REAL *vs, INTEGER ldvs, REAL *work, INTEGER lwork, LOGICAL *bwork, INTEGER *info);
void Cgees(const char *jobvs, const char *sort, LFP select, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *sdim, COMPLEX *w, COMPLEX *vs, INTEGER ldvs, COMPLEX *work, INTEGER lwork, REAL *rwork, LOGICAL *bwork, INTEGER *info);
void Rgeesx(const char *jobvs, const char *sort, LFP select, const char *sense, INTEGER n, REAL *A, INTEGER lda, INTEGER *sdim, REAL *wr, REAL *wi, REAL *vs, INTEGER ldvs, REAL *rconde, REAL *rcondv, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, LOGICAL *bwork, INTEGER *info);
void Cgeesx(const char *jobvs, const char *sort, LFP select, const char *sense, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *sdim, COMPLEX *w, COMPLEX *vs, INTEGER ldvs, REAL *rconde, REAL *rcondv, COMPLEX *work, INTEGER lwork, REAL *rwork, LOGICAL *bwork, INTEGER *info);
void Rgeev(const char *jobvl, const char *jobvr, INTEGER n, REAL *A, INTEGER lda, REAL *wr, REAL *wi, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, REAL *work, INTEGER lwork, INTEGER *info);
void Cgeev(const char *jobvl, const char *jobvr, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *w, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, INTEGER n, REAL *A, INTEGER lda, REAL *wr, REAL *wi, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, INTEGER *ilo, INTEGER *ihi, REAL *scale, REAL *abnrm, REAL *rconde, REAL *rcondv, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Cgeevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *w, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, INTEGER *ilo, INTEGER *ihi, REAL *scale, REAL *abnrm, REAL *rconde, REAL *rcondv, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Cgehrd(INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgehrd(INTEGER n, INTEGER ilo, INTEGER ihi, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Rgelqf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cgelqf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgels(const char *trans, INTEGER m, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *work, INTEGER lwork, INTEGER *info);
void Cgels(const char *trans, INTEGER m, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgelsx(INTEGER m, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *jpvt, REAL rcond, INTEGER *rank, REAL *work, INTEGER *info);
void Cgelsx(INTEGER m, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *jpvt, REAL rcond, INTEGER *rank, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgelsd(INTEGER m, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *s, REAL *rcond, INTEGER *rank, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Cgelsd(INTEGER m, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL *s, REAL rcond, INTEGER *rank, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rgelss(INTEGER m, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *s, REAL rcond, INTEGER *rank, REAL *work, INTEGER lwork, INTEGER *info);
void Cgelss(INTEGER m, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL *s, REAL rcond, INTEGER *rank, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgelsy(INTEGER m, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *jpvt, REAL rcond, INTEGER *rank, REAL *work, INTEGER lwork, INTEGER *info);
void Cgelsy(INTEGER m, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *jpvt, REAL rcond, INTEGER *rank, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgeqlf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cgeqlf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgeqpf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, INTEGER *jpvt, REAL *tau, REAL *work, INTEGER *info);
void Cgeqpf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *jpvt, COMPLEX *tau, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgeqp3(INTEGER m, INTEGER n, REAL *A, INTEGER lda, INTEGER *jpvt, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cgeqp3(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *jpvt, COMPLEX *tau, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgeqrf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cgeqrf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgerfs(const char *trans, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgerfs(const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgerqf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cgerqf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgesdd(const char *jobz, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *s, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Cgesdd(const char *jobz, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *s, COMPLEX *u, INTEGER ldu, COMPLEX *vt, INTEGER ldvt, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rgesvd(const char *jobu, const char *jobvt, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *s, REAL *u, INTEGER ldu, REAL *vt, INTEGER ldvt, REAL *work, INTEGER lwork, INTEGER *info);
void Cgesvd(const char *jobu, const char *jobvt, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, REAL *s, COMPLEX *u, INTEGER ldu, COMPLEX *vt, INTEGER ldvt, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgesvx(const char *fact, const char *trans, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, INTEGER *ipiv, char *equed, REAL *r, REAL *c, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgesvx(const char *fact, const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, char *equed, REAL *r, REAL *c, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rggbak(const char *job, const char *side, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *lscale, REAL *rscale, INTEGER m, REAL *v, INTEGER ldv, INTEGER *info);
void Cggbak(const char *job, const char *side, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *lscale, REAL *rscale, INTEGER m, COMPLEX *v, INTEGER ldv, INTEGER *info);
void Rggbal(const char *job, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *ilo, INTEGER *ihi, REAL *lscale, REAL *rscale, REAL *work, INTEGER *info);
void Cggbal(const char *job, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *ilo, INTEGER *ihi, REAL *lscale, REAL *rscale, REAL *work, INTEGER *info);
void Rgges(const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *sdim, REAL *alphar, REAL *alphai, REAL *beta, REAL *vsl, INTEGER ldvsl, REAL *vsr, INTEGER ldvsr, REAL *work, INTEGER lwork, LOGICAL *bwork, INTEGER *info);
void Cgges(const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *sdim, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vsl, INTEGER ldvsl, COMPLEX *vsr, INTEGER ldvsr, COMPLEX *work, INTEGER lwork, REAL *rwork, LOGICAL *bwork, INTEGER *info);
void Rgegs(const char *jobvsl, const char *jobvsr, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *vsl, INTEGER ldvsl, REAL *vsr, INTEGER ldvsr, REAL *work, INTEGER lwork, INTEGER *info);
void Cgegs(const char *jobvsl, const char *jobvsr, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vsl, INTEGER ldvsl, COMPLEX *vsr, INTEGER ldvsr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rggesx(const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *sdim, REAL *alphar, REAL *alphai, REAL *beta, REAL *vsl, INTEGER ldvsl, REAL *vsr, INTEGER ldvsr, REAL *rconde, REAL *rcondv, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, LOGICAL *bwork, INTEGER *info);
void Cggesx(const char *jobvsl, const char *jobvsr, const char *sort, LFP selctg, const char *sense, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *sdim, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vsl, INTEGER ldvsl, COMPLEX *vsr, INTEGER ldvsr, REAL *rconde, REAL *rcondv, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, INTEGER liwork, LOGICAL *bwork, INTEGER *info);
void Rggev(const char *jobvl, const char *jobvr, INTEGER n, REAL *A, INTEGER lda, REAL *b, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, REAL *work, INTEGER lwork, INTEGER *info);
void Cggev(const char *jobvl, const char *jobvr, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rgegv(const char *jobvl, const char *jobvr, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, REAL *work, INTEGER lwork, INTEGER *info);
void Cgegv(const char *jobvl, const char *jobvr, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, INTEGER *ilo, INTEGER *ihi, REAL *lscale, REAL *rscale, REAL *abnrm, REAL *bbnrm, REAL *rconde, REAL *rcondv, REAL *work, INTEGER lwork, INTEGER *iwork, LOGICAL *bwork, INTEGER *info);
void Cggevx(const char *balanc, const char *jobvl, const char *jobvr, const char *sense, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *alpha, COMPLEX *beta, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, INTEGER *ilo, INTEGER *ihi, REAL *lscale, REAL *rscale, REAL *abnrm, REAL *bbnrm, REAL *rconde, REAL *rcondv, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, LOGICAL *bwork, INTEGER *info);
void Rggglm(INTEGER n, INTEGER m, INTEGER p, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *d, REAL *x, REAL *y, REAL *work, INTEGER lwork, INTEGER *info);
void Cggglm(INTEGER n, INTEGER m, INTEGER p, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *d, COMPLEX *x, COMPLEX *y, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rgghrd(const char *compq, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *q, INTEGER ldq, REAL *z, INTEGER ldz, INTEGER *info);
void Cgghrd(const char *compq, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *q, INTEGER ldq, COMPLEX *z, INTEGER ldz, INTEGER *info);
void Rgglse(INTEGER m, INTEGER n, INTEGER p, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *c, REAL *d, REAL *x, REAL *work, INTEGER lwork, INTEGER *info);
void Cgglse(INTEGER m, INTEGER n, INTEGER p, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *c, COMPLEX *d, COMPLEX *x, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rggqrf(INTEGER n, INTEGER m, INTEGER p, REAL *A, INTEGER lda, REAL *taua, REAL *B, INTEGER ldb, REAL *taub, REAL *work, INTEGER lwork, INTEGER *info);
void Cggqrf(INTEGER n, INTEGER m, INTEGER p, COMPLEX *A, INTEGER lda, COMPLEX *taua, COMPLEX *B, INTEGER ldb, COMPLEX *taub, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rggrqf(INTEGER m, INTEGER p, INTEGER n, REAL *A, INTEGER lda, REAL *taua, REAL *B, INTEGER ldb, REAL *taub, REAL *work, INTEGER lwork, INTEGER *info);
void Cggrqf(INTEGER m, INTEGER p, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *taua, COMPLEX *B, INTEGER ldb, COMPLEX *taub, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rggsvd(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER n, INTEGER p, INTEGER *k, INTEGER *l, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alpha, REAL *beta, REAL *u, INTEGER ldu, REAL *v, INTEGER ldv, REAL *q, INTEGER ldq, REAL *work, INTEGER *iwork, INTEGER *info);
void Cggsvd(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER n, INTEGER p, INTEGER *k, INTEGER *l, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL *alpha, REAL *beta, COMPLEX *u, INTEGER ldu, COMPLEX *v, INTEGER ldv, COMPLEX *q, INTEGER ldq, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *info);
void Rggsvp(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER p, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL tola, REAL tolb, INTEGER *k, INTEGER *l, REAL *u, INTEGER ldu, REAL *v, INTEGER ldv, REAL *q, INTEGER ldq, INTEGER *iwork, REAL *tau, REAL *work, INTEGER *info);
void Cggsvp(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER p, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL tola, REAL tolb, INTEGER *k, INTEGER *l, COMPLEX *u, INTEGER ldu, COMPLEX *v, INTEGER ldv, COMPLEX *q, INTEGER ldq, INTEGER *iwork, REAL *rwork, COMPLEX *tau, COMPLEX *work, INTEGER *info);
void Rgtcon(const char *norm, INTEGER n, REAL *dl, REAL *d, REAL *du, REAL *du2, INTEGER *ipiv, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgtcon(const char *norm, INTEGER n, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *du2, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, INTEGER *info);
void Rgtrfs(const char *trans, INTEGER n, INTEGER nrhs, REAL *dl, REAL *d, REAL *du, REAL *dlf, REAL *df, REAL *duf, REAL *du2, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgtrfs(const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *dlf, COMPLEX *df, COMPLEX *duf, COMPLEX *du2, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgtsv(INTEGER n, INTEGER nrhs, REAL *dl, REAL *d, REAL *du, REAL *B, INTEGER ldb, INTEGER *info);
void Cgtsv(INTEGER n, INTEGER nrhs, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rgtsvx(const char *fact, const char *trans, INTEGER n, INTEGER nrhs, REAL *dl, REAL *d, REAL *du, REAL *dlf, REAL *df, REAL *duf, REAL *du2, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cgtsvx(const char *fact, const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *dlf, COMPLEX *df, COMPLEX *duf, COMPLEX *du2, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rgttrf(INTEGER n, REAL *dl, REAL *d, REAL *du, REAL *du2, INTEGER *ipiv, INTEGER *info);
void Cgttrf(INTEGER n, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *du2, INTEGER *ipiv, INTEGER *info);
void Rgttrs(const char *trans, INTEGER n, INTEGER nrhs, REAL *dl, REAL *d, REAL *du, REAL *du2, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cgttrs(const char *trans, INTEGER n, INTEGER nrhs, COMPLEX *dl, COMPLEX *d, COMPLEX *du, COMPLEX *du2, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rhgeqz(const char *job, const char *compq, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *h, INTEGER ldh, REAL *t, INTEGER ldt, REAL *alphar, REAL *alphai, REAL *beta, REAL *q, INTEGER ldq, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *info);
void Chgeqz(const char *job, const char *compq, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *h, INTEGER ldh, COMPLEX *t, INTEGER ldt, COMPLEX *alpha, COMPLEX *beta, COMPLEX *q, INTEGER ldq, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rhsein(const char *side, const char *eigsrc, const char *initv, LOGICAL *select, INTEGER n, REAL *h, INTEGER ldh, REAL *wr, REAL *wi, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, INTEGER mm, INTEGER m, REAL *work, INTEGER *ifaill, INTEGER *ifailr, INTEGER *info);
void Chsein(const char *side, const char *eigsrc, const char *initv, LOGICAL *select, INTEGER n, COMPLEX *h, INTEGER ldh, COMPLEX *w, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, INTEGER mm, INTEGER *m, COMPLEX *work, REAL *rwork, INTEGER *ifaill, INTEGER *ifailr, INTEGER *info);
void Rhseqr(const char *job, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *h, INTEGER ldh, REAL *wr, REAL *wi, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *info);
void Chseqr(const char *job, const char *compz, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *h, INTEGER ldh, COMPLEX *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Ropgtr(const char *uplo, INTEGER n, REAL *ap, REAL *tau, REAL *q, INTEGER ldq, REAL *work, INTEGER *info);
void Cupgtr(const char *uplo, INTEGER n, COMPLEX *ap, COMPLEX *tau, COMPLEX *q, INTEGER ldq, COMPLEX *work, INTEGER *info);
void Ropmtr(const char *side, const char *uplo, const char *trans, INTEGER m, INTEGER n, REAL *ap, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER *info);
void Cupmtr(const char *side, const char *uplo, const char *trans, INTEGER m, INTEGER n, COMPLEX *ap, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER *info);
void Rorgbr(const char *vect, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cungbr(const char *vect, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rorghr(INTEGER n, INTEGER ilo, INTEGER ihi, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cunghr(INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rorglq(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cunglq(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rorgrq(INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Cungrq(INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormbr(const char *vect, const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmbr(const char *vect, const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormhr(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER ilo, INTEGER ihi, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmhr(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER ilo, INTEGER ihi, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormlq(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmlq(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormql(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmql(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormqr(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmqr(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormrq(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmrq(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormrz(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, INTEGER l, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmrz(const char *side, const char *trans, INTEGER m, INTEGER n, INTEGER k, INTEGER l, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rormtr(const char *side, const char *uplo, const char *trans, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *c, INTEGER ldc, REAL *work, INTEGER lwork, INTEGER *info);
void Cunmtr(const char *side, const char *uplo, const char *trans, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *c, INTEGER ldc, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rpbcon(const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cpbcon(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL anorm, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpbequ(const char *uplo, INTEGER n, INTEGER kd, REAL *ab, INTEGER ldab, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Cpbequ(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Rpbrfs(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *afb, INTEGER ldafb, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cpbrfs(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *afb, INTEGER ldafb, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpbstf(const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, INTEGER *info);
void Cpbstf(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, INTEGER *info);
void Rpbsv(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *B, INTEGER ldb, INTEGER *info);
void Cpbsv(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *ab, INTEGER ldab, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rpbsvx(const char *fact, const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *afb, INTEGER ldafb, char *equed, REAL *s, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cpbsvx(const char *fact, const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *afb, INTEGER ldafb, char *equed, REAL *s, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpbtrf(const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, INTEGER *info);
void Cpbtrf(const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, INTEGER *info);
void Rpbtrs(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *ab, INTEGER ldab, REAL *B, INTEGER ldb, INTEGER *info);
void Cpbtrs(const char *uplo, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rpocon(const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cpocon(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL anorm, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpoequ(INTEGER n, REAL *A, INTEGER lda, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Cpoequ(INTEGER n, COMPLEX *A, INTEGER lda, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Rporfs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cporfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rposv(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *info);
void Cposv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rposvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, char *equed, REAL *s, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cposvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, char *equed, REAL *s, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpotri(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *info);
void Cpotri(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *info);
void Rpotrs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *info);
void Cpotrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rppcon(const char *uplo, INTEGER n, REAL *ap, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cppcon(const char *uplo, INTEGER n, COMPLEX *ap, REAL *anorm, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rppequ(const char *uplo, INTEGER n, REAL *ap, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Cppequ(const char *uplo, INTEGER n, COMPLEX *ap, REAL *s, REAL *scond, REAL *amax, INTEGER *info);
void Rpptrf(const char *uplo, INTEGER n, REAL *ap, INTEGER *info);
void Cpptrf(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *info);
void Rpptri(const char *uplo, INTEGER n, REAL *ap, INTEGER *info);
void Cpptri(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *info);
void Rpptrs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *B, INTEGER ldb, INTEGER *info);
void Cpptrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rpprfs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *afp, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cpprfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rppsv(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *B, INTEGER ldb, INTEGER *info);
void Cppsv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rppsvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *afp, char *equed, REAL *s, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cppsvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, char *equed, REAL *s, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rptcon(INTEGER n, REAL *d, REAL *e, REAL anorm, REAL *rcond, REAL *work, INTEGER *info);
void Cptcon(INTEGER n, REAL *d, COMPLEX *e, REAL anorm, REAL *rcond, REAL *rwork, INTEGER *info);
void Rpteqr(const char *compz, INTEGER n, REAL *d, REAL *e, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Cpteqr(const char *compz, INTEGER n, REAL *d, REAL *e, COMPLEX *z, INTEGER ldz, REAL *work, INTEGER *info);
void Rptrfs(INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *df, REAL *ef, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *info);
void Cptrfs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *d, COMPLEX *e, REAL *df, COMPLEX *ef, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rptsv(INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *B, INTEGER ldb, INTEGER *info);
void Cptsv(INTEGER n, INTEGER nrhs, REAL *d, COMPLEX *e, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rptsvx(const char *fact, INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *df, REAL *ef, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *info);
void Cptsvx(const char *fact, INTEGER n, INTEGER nrhs, REAL *d, COMPLEX *e, REAL *df, COMPLEX *ef, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rpttrf(INTEGER n, REAL *d, REAL *e, INTEGER *info);
void Cpttrf(INTEGER n, REAL *d, COMPLEX *e, INTEGER *info);
void Rpttrs(INTEGER n, INTEGER nrhs, REAL *d, REAL *e, REAL *B, INTEGER ldb, INTEGER *info);
void Cpttrs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *d, COMPLEX *e, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rsbev(const char *jobz, const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Chbev(const char *jobz, const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rsbevd(const char *jobz, const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Chbevd(const char *jobz, const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsbevx(const char *jobz, const char *range, const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *q, INTEGER ldq, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Chbevx(const char *jobz, const char *range, const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, COMPLEX *q, INTEGER ldq, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rsbgst(const char *vect, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, REAL *AB, INTEGER ldab, REAL *bb, INTEGER ldbb, REAL *x, INTEGER ldx, REAL *work, INTEGER *info);
void Chbgst(const char *vect, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, COMPLEX *AB, INTEGER ldab, COMPLEX *bb, INTEGER ldbb, COMPLEX *x, INTEGER ldx, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rsbgv(const char *jobz, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, REAL *AB, INTEGER ldab, REAL *bb, INTEGER ldbb, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Chbgv(const char *jobz, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, COMPLEX *AB, INTEGER ldab, COMPLEX *bb, INTEGER ldbb, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rsbgvd(const char *jobz, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, REAL *AB, INTEGER ldab, REAL *BB, INTEGER ldbb, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Chbgvd(const char *jobz, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, COMPLEX *AB, INTEGER ldab, COMPLEX *BB, INTEGER ldbb, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsbgvx(const char *jobz, const char *range, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, REAL *AB, INTEGER ldab, REAL *BB, INTEGER ldbb, REAL *q, INTEGER ldq, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Chbgvx(const char *jobz, const char *range, const char *uplo, INTEGER n, INTEGER ka, INTEGER kb, COMPLEX *ab, INTEGER ldab, COMPLEX *bb, INTEGER ldbb, COMPLEX *q, INTEGER ldq, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rsbtrd(const char *vect, const char *uplo, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *d, REAL *e, REAL *q, INTEGER ldq, REAL *work, INTEGER *info);
void Chbtrd(const char *vect, const char *uplo, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *d, REAL *e, COMPLEX *q, INTEGER ldq, COMPLEX *work, INTEGER *info);
void Rspcon(const char *uplo, INTEGER n, REAL *ap, INTEGER *ipiv, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Cspcon(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, INTEGER *info);
void Chpcon(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, INTEGER *info);
void Rspev(const char *jobz, const char *uplo, INTEGER n, REAL *ap, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Chpev(const char *jobz, const char *uplo, INTEGER n, COMPLEX *ap, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rspevd(const char *jobz, const char *uplo, INTEGER n, REAL *ap, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Chpevd(const char *jobz, const char *uplo, INTEGER n, COMPLEX *ap, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rspevx(const char *jobz, const char *range, const char *uplo, INTEGER n, REAL *ap, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Chpevx(const char *jobz, const char *range, const char *uplo, INTEGER n, COMPLEX *ap, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rspgst(INTEGER itype, const char *uplo, INTEGER n, REAL *ap, REAL *bp, INTEGER *info);
void Chpgst(INTEGER *itype, const char *uplo, INTEGER n, COMPLEX *ap, COMPLEX *bp, INTEGER *info);
void Rspgv(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, REAL *ap, REAL *bp, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Chpgv(INTEGER *itype, const char *jobz, const char *uplo, INTEGER n, COMPLEX *ap, COMPLEX *bp, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rspgvd(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, REAL *ap, REAL *bp, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Chpgvd(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, COMPLEX *ap, COMPLEX *bp, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rspgvx(INTEGER itype, const char *jobz, const char *range, const char *uplo, INTEGER n, REAL *ap, REAL *bp, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Chpgvx(INTEGER itype, const char *jobz, char *range, const char *uplo, INTEGER n, COMPLEX *ap, COMPLEX *bp, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rsprfs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *afp, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Csprfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Chprfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rspsv(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Cspsv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Chpsv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rspsvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, REAL *afp, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Cspsvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Chpsvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *afp, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rsptrd(const char *uplo, INTEGER n, REAL *ap, REAL *d, REAL *e, REAL *tau, INTEGER *info);
void Chptrd(const char *uplo, INTEGER n, COMPLEX *ap, REAL *d, REAL *e, COMPLEX *tau, INTEGER *info);
void Rsptrf(const char *uplo, INTEGER n, REAL *ap, INTEGER *ipiv, INTEGER *info);
void Csptrf(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, INTEGER *info);
void Chptrf(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, INTEGER *info);
void Rsptri(const char *uplo, INTEGER n, REAL *ap, INTEGER *ipiv, REAL *work, INTEGER *info);
void Csptri(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, COMPLEX *work, INTEGER *info);
void Chptri(const char *uplo, INTEGER n, COMPLEX *ap, INTEGER *ipiv, COMPLEX *work, INTEGER *info);
void Rsptrs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *ap, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Csptrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Chptrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *ap, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rstebz(const char *range, const char *order, INTEGER n, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, REAL *d, REAL *e, INTEGER *m, INTEGER *nsplit, REAL *w, INTEGER *iblock, INTEGER *isplit, REAL *work, INTEGER *iwork, INTEGER *info);
void Rstedc(const char *compz, INTEGER n, REAL *d, REAL *e, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Cstedc(const char *compz, INTEGER n, REAL *d, REAL *e, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rstegr(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Cstegr(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL *vl, REAL *vu, INTEGER *il, INTEGER *iu, REAL *abstol, INTEGER m, REAL *w, COMPLEX *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rstein(INTEGER n, REAL *d, REAL *e, INTEGER m, REAL *w, INTEGER *iblock, INTEGER *isplit, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Cstein(INTEGER n, REAL *d, REAL *e, INTEGER m, REAL *w, INTEGER *iblock, INTEGER *isplit, COMPLEX *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rstev(const char *jobz, INTEGER n, REAL *d, REAL *e, REAL *z, INTEGER ldz, REAL *work, INTEGER *info);
void Rstevd(const char *jobz, INTEGER n, REAL *d, REAL *e, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rstevr(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rstevx(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rstemr(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL vl, REAL vu, INTEGER il, INTEGER iu, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, INTEGER nzc, INTEGER *isuppz, LOGICAL *tryrac, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Cstemr(const char *jobz, const char *range, INTEGER n, REAL *d, REAL *e, REAL vl, REAL vu, INTEGER il, INTEGER iu, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, INTEGER nzc, INTEGER *isuppz, LOGICAL *tryrac, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsycon(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, REAL anorm, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Csycon(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, INTEGER *info);
void Checon(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, REAL anorm, REAL *rcond, COMPLEX *work, INTEGER *info);
void Rsyevd(const char *jobz, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *w, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Cheevd(const char *jobz, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL *w, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsyevr(const char *jobz, const char *range, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, INTEGER *isuppz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Cheevr(const char *jobz, const char *range, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, INTEGER *isuppz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsyevx(const char *jobz, const char *range, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Cheevx(const char *jobz, const char *range, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rsygst(INTEGER itype, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, INTEGER *info);
void Chegst(INTEGER itype, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rsygv(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *w, REAL *work, INTEGER lwork, INTEGER *info);
void Chegv(INTEGER *itype, const char *jobz, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL *w, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rsygvd(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *w, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Chegvd(INTEGER itype, const char *jobz, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL *w, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER lrwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rsygvx(INTEGER itype, const char *jobz, const char *range, const char *uplo, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, REAL *z, INTEGER ldz, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Chegvx(INTEGER itype, const char *jobz, const char *range, const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL vl, REAL vu, INTEGER il, INTEGER iu, REAL abstol, INTEGER *m, REAL *w, COMPLEX *z, INTEGER ldz, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *iwork, INTEGER *ifail, INTEGER *info);
void Rsyrfs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Csyrfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Cherfs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rsysv(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *work, INTEGER lwork, INTEGER *info);
void Csysv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Chesv(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rsysvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *af, INTEGER ldaf, INTEGER *ipiv, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Csysvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Chesvx(const char *fact, const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *af, INTEGER ldaf, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *rcond, REAL *ferr, REAL *berr, COMPLEX *work, INTEGER lwork, REAL *rwork, INTEGER *info);
void Rsytrf(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *work, INTEGER lwork, INTEGER *info);
void Csytrf(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Chetrf(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rsytri(const char *uplo, INTEGER n, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *work, INTEGER *info);
void Csytri(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *work, INTEGER *info);
void Chetri(const char *uplo, INTEGER n, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *work, INTEGER *info);
void Rsytrs(const char *uplo, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, INTEGER *ipiv, REAL *B, INTEGER ldb, INTEGER *info);
void Csytrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Chetrs(const char *uplo, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, INTEGER *ipiv, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rtbcon(const char *norm, const char *uplo, const char *diag, INTEGER n, INTEGER kd, REAL *AB, INTEGER ldab, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctbcon(const char *norm, const char *uplo, const char *diag, INTEGER n, INTEGER kd, COMPLEX *AB, INTEGER ldab, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtbrfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *AB, INTEGER ldab, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctbrfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *AB, INTEGER ldab, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtbtrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER kd, INTEGER nrhs, REAL *ab, INTEGER ldab, REAL *B, INTEGER ldb, INTEGER *info);
void Ctbtrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER kd, INTEGER nrhs, COMPLEX *ab, INTEGER ldab, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rtgevc(const char *side, const char *howmny, LOGICAL *select, INTEGER n, REAL *s, INTEGER lds, REAL *p, INTEGER ldp, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, INTEGER mm, INTEGER *m, REAL *work, INTEGER *info);
void Ctgevc(const char *side, const char *howmny, LOGICAL *select, INTEGER n, COMPLEX *s, INTEGER lds, COMPLEX *p, INTEGER ldp, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, INTEGER mm, INTEGER *m, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtgexc(LOGICAL wantq, LOGICAL wantz, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *q, INTEGER ldq, REAL *z, INTEGER ldz, INTEGER *ifst, INTEGER *ilst, REAL *work, INTEGER lwork, INTEGER *info);
void Ctgexc(LOGICAL wantq, LOGICAL wantz, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *q, INTEGER ldq, COMPLEX *z, INTEGER ldz, INTEGER ifst, INTEGER *ilst, INTEGER *info);
void Rtgsen(INTEGER ijob, LOGICAL wantq, LOGICAL wantz, LOGICAL *select, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *alphar, REAL *alphai, REAL *beta, REAL *q, INTEGER ldq, REAL *z, INTEGER ldz, INTEGER *m, REAL *pl, REAL *pr, REAL *dif, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Ctgsen(INTEGER ijob, LOGICAL wantq, LOGICAL wantz, LOGICAL *select, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *alpha, COMPLEX *beta, COMPLEX *q, INTEGER ldq, COMPLEX *z, INTEGER ldz, INTEGER *m, REAL *pl, REAL *pr, REAL *dif, COMPLEX *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Rtgsja(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER p, INTEGER n, INTEGER k, INTEGER l, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL tola, REAL tolb, REAL *alpha, REAL *beta, REAL *u, INTEGER ldu, REAL *v, INTEGER ldv, REAL *q, INTEGER ldq, REAL *work, INTEGER ncycle, INTEGER *info);
void Ctgsja(const char *jobu, const char *jobv, const char *jobq, INTEGER m, INTEGER p, INTEGER n, INTEGER k, INTEGER l, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, REAL tola, REAL tolb, REAL *alpha, REAL *beta, COMPLEX *u, INTEGER ldu, COMPLEX *v, INTEGER ldv, COMPLEX *q, INTEGER ldq, COMPLEX *work, INTEGER *ncycle, INTEGER *info);
void Rtgsna(const char *job, const char *howmny, LOGICAL *select, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, REAL *s, REAL *dif, INTEGER mm, INTEGER *m, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Ctgsna(const char *job, const char *howmny, LOGICAL *select, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, REAL *s, REAL *dif, INTEGER mm, INTEGER *m, COMPLEX *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Rtgsyl(const char *trans, INTEGER ijob, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *c, INTEGER ldc, REAL *d, INTEGER ldd, REAL *e, INTEGER lde, REAL *f, INTEGER ldf, REAL *scale, REAL *dif, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Ctgsyl(const char *trans, INTEGER ijob, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *c, INTEGER ldc, COMPLEX *d, INTEGER ldd, COMPLEX *e, INTEGER lde, COMPLEX *f, INTEGER ldf, REAL *scale, REAL *dif, COMPLEX *work, INTEGER lwork, INTEGER *iwork, INTEGER *info);
void Rtpcon(const char *norm, const char *uplo, const char *diag, INTEGER n, REAL *ap, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctpcon(const char *norm, const char *uplo, const char *diag, INTEGER n, COMPLEX *ap, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtprfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, REAL *ap, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctprfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtptri(const char *uplo, const char *diag, INTEGER n, REAL *ap, INTEGER *info);
void Ctptri(const char *uplo, const char *diag, INTEGER n, COMPLEX *ap, INTEGER *info);
void Rtptrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, REAL *ap, REAL *B, INTEGER ldb, INTEGER *info);
void Ctptrs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, COMPLEX *ap, COMPLEX *B, INTEGER ldb, INTEGER *info);
void Rtrcon(const char *norm, const char *uplo, const char *diag, INTEGER n, REAL *A, INTEGER lda, REAL *rcond, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctrcon(const char *norm, const char *uplo, const char *diag, INTEGER n, COMPLEX *A, INTEGER lda, REAL *rcond, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtrevc(const char *side, const char *howmny, LOGICAL *select, INTEGER n, REAL *t, INTEGER ldt, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, INTEGER mm, INTEGER *m, REAL *work, INTEGER *info);
void Ctrevc(const char *side, const char *howmny, LOGICAL *select, INTEGER n, COMPLEX *t, INTEGER ldt, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, INTEGER mm, INTEGER *m, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtrexc(const char *compq, INTEGER n, REAL *t, INTEGER ldt, REAL *q, INTEGER ldq, INTEGER *ifst, INTEGER *ilst, REAL *work, INTEGER *info);
void Ctrexc(const char *compq, INTEGER n, COMPLEX *t, INTEGER ldt, COMPLEX *q, INTEGER ldq, INTEGER ifst, INTEGER ilst, INTEGER *info);
void Rtrrfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *x, INTEGER ldx, REAL *ferr, REAL *berr, REAL *work, INTEGER *iwork, INTEGER *info);
void Ctrrfs(const char *uplo, const char *trans, const char *diag, INTEGER n, INTEGER nrhs, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *x, INTEGER ldx, REAL *ferr, REAL *berr, COMPLEX *work, REAL *rwork, INTEGER *info);
void Rtrsen(const char *job, const char *compq, LOGICAL *select, INTEGER n, REAL *t, INTEGER ldt, REAL *q, INTEGER ldq, REAL *wr, REAL *wi, INTEGER m, REAL *s, REAL *sep, REAL *work, INTEGER lwork, INTEGER *iwork, INTEGER liwork, INTEGER *info);
void Ctrsen(const char *job, const char *compq, LOGICAL *select, INTEGER n, COMPLEX *t, INTEGER ldt, COMPLEX *q, INTEGER ldq, COMPLEX *w, INTEGER m, REAL *s, REAL *sep, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rtrsna(const char *job, const char *howmny, LOGICAL *select, INTEGER n, REAL *t, INTEGER ldt, REAL *vl, INTEGER ldvl, REAL *vr, INTEGER ldvr, REAL *s, REAL *sep, INTEGER mm, INTEGER *m, REAL *work, INTEGER ldwork, INTEGER *iwork, INTEGER *info);
void Ctrsna(const char *job, const char *howmny, LOGICAL *select, INTEGER n, COMPLEX *t, INTEGER ldt, COMPLEX *vl, INTEGER ldvl, COMPLEX *vr, INTEGER ldvr, REAL *s, REAL *sep, INTEGER mm, INTEGER *m, COMPLEX *work, INTEGER ldwork, REAL *rwork, INTEGER *info);
void Rtrsyl(const char *trana, const char *tranb, INTEGER isgn, INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *B, INTEGER ldb, REAL *c, INTEGER ldc, REAL *scale, INTEGER *info);
void Ctrsyl(const char *trana, const char *tranb, INTEGER isgn, INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *B, INTEGER ldb, COMPLEX *c, INTEGER ldc, REAL *scale, INTEGER *info);
void Rtzrzf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, REAL *work, INTEGER lwork, INTEGER *info);
void Ctzrzf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, COMPLEX *work, INTEGER lwork, INTEGER *info);
void Rtzrqf(INTEGER m, INTEGER n, REAL *A, INTEGER lda, REAL *tau, INTEGER *info);
void Ctzrqf(INTEGER m, INTEGER n, COMPLEX *A, INTEGER lda, COMPLEX *tau, INTEGER *info);

#endif
