/*
 * Copyright (c) 2008-2022
 *	Nakata, Maho
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef _MPLAPACK_EIG_QD_H_
#define _MPLAPACK_EIG_QD_H_

#include "mplapack_config.h"
#include <qd/qd_real.h>
#include "qd_complex.h"

bool Clctes(qd_complex const z, qd_complex const d);
bool Clctsx(qd_complex const, qd_complex const);
bool Cslect(qd_complex const z);
bool Rlctes(qd_real const zr, qd_real const zi, qd_real const d);
bool Rlctsx(qd_real const, qd_real const, qd_real const);
bool Rslect(qd_real const zr, qd_real const zi);
mplapackint iMlaenv2stage_qd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
mplapackint iMlaenv_qd(mplapackint ispec, const char *name, const char *opts, mplapackint n1, mplapackint n2, mplapackint n3, mplapackint n4);
qd_real Rlamch_qd(const char *cmach);
qd_real Rsxt1(mplapackint const ijob, qd_real *d1, mplapackint const n1, qd_real *d2, mplapackint const n2, qd_real const abstol, qd_real const ulp, qd_real const unfl);
void Alahdg(mplapackint const iounit, const char *path);
void Alareq(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alarqg(const char *path, mplapackint const nmats, bool *dotype, mplapackint const ntypes, mplapackint const nin, mplapackint const nout);
void Alasmg(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasum(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Alasvm(const char *type, mplapackint const nout, mplapackint const nfail, mplapackint const nrun, mplapackint const nerrs);
void Cbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, qd_complex *a, mplapackint const lda, qd_complex *q, mplapackint const ldq, qd_real *d, qd_real *e, qd_complex *pt, mplapackint const ldpt, qd_complex *work, qd_real *rwork, qd_real &resid);
void Cbdt02(mplapackint const m, mplapackint const n, qd_complex *b, mplapackint const ldb, qd_complex *c, mplapackint const ldc, qd_complex *u, mplapackint const ldu, qd_complex *work, qd_real *rwork, qd_real &resid);
void Cbdt03(const char *uplo, mplapackint const n, mplapackint const kd, qd_real *d, qd_real *e, qd_complex *u, mplapackint const ldu, qd_real *s, qd_complex *vt, mplapackint const ldvt, qd_complex *work, qd_real &resid);
void Cbdt05(mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda, qd_real *s, mplapackint const ns, qd_complex *u, mplapackint const ldu, qd_complex *vt, mplapackint const ldvt, qd_complex *work, qd_real &resid);
void Cchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *ab, mplapackint const ldab, qd_real *bd, qd_real *be, qd_complex *q, mplapackint const ldq, qd_complex *p, mplapackint const ldp, qd_complex *c, mplapackint const ldc, qd_complex *cc, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, mplapackint &info);
void Cchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, qd_real const thresh, qd_complex *a, mplapackint const lda, qd_real *bd, qd_real *be, qd_real *s1, qd_real *s2, qd_complex *x, mplapackint const ldx, qd_complex *y, qd_complex *z, qd_complex *q, mplapackint const ldq, qd_complex *pt, mplapackint const ldpt, qd_complex *u, qd_complex *vt, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint const nout, mplapackint &info);
void Cchkbk(mplapackint const nin, mplapackint const nout);
void Cchkbl(mplapackint const nin, mplapackint const nout);
void Cchkec(qd_real const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Cchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, bool const tstdif, qd_real const thrshn, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *h, qd_complex *t, qd_complex *s1, qd_complex *s2, qd_complex *p1, qd_complex *p2, qd_complex *u, mplapackint const ldu, qd_complex *v, qd_complex *q, qd_complex *z, qd_complex *alpha1, qd_complex *beta1, qd_complex *alpha3, qd_complex *beta3, qd_complex *evectl, qd_complex *evectr, qd_complex *work, mplapackint const lwork, qd_real *rwork, bool *llwork, qd_real *result, mplapackint &info);
void Cchkgk(mplapackint const nin, mplapackint const nout);
void Cchkgl(mplapackint const nin, mplapackint const nout);
void Cchkhb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_real *sd, qd_real *se, qd_complex *u, mplapackint const ldu, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, mplapackint &info);
void Cchkhb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_complex *u, mplapackint const ldu, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, mplapackint &info);
void Cchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *t1, qd_complex *t2, qd_complex *u, mplapackint const ldu, qd_complex *z, qd_complex *uz, qd_complex *w1, qd_complex *w3, qd_complex *evectl, qd_complex *evectr, qd_complex *evecty, qd_complex *evectx, qd_complex *uu, qd_complex *tau, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint *iwork, bool *select, qd_real *result, mplapackint &info);
void Cchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *ap, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *d5, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *wr, qd_complex *u, mplapackint const ldu, qd_complex *v, qd_complex *vp, qd_complex *tau, qd_complex *z, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *ap, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *d5, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *wr, qd_complex *u, mplapackint const ldu, qd_complex *v, qd_complex *vp, qd_complex *tau, qd_complex *z, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const mmax, qd_complex *x, qd_complex *xf, qd_complex *u1, qd_complex *u2, qd_complex *v1t, qd_complex *v2t, qd_real *theta, mplapackint *iwork, qd_complex *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckglm(mplapackint const nn, mplapackint *nval, mplapackint *mval, mplapackint *pval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *b, qd_complex *bf, qd_complex *x, qd_complex *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *aq, qd_complex *ar, qd_complex *taua, qd_complex *b, qd_complex *bf, qd_complex *bz, qd_complex *bt, qd_complex *bwk, qd_complex *taub, qd_complex *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Cckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *b, qd_complex *bf, qd_complex *u, qd_complex *v, qd_complex *q, qd_real *alpha, qd_real *beta, qd_complex *r, mplapackint *iwork, qd_complex *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_complex *a, qd_complex *af, qd_complex *b, qd_complex *bf, qd_complex *x, qd_complex *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Ccsdts(mplapackint const m, mplapackint const p, mplapackint const q, qd_complex *x, qd_complex *xf, mplapackint const ldx, qd_complex *u1, mplapackint const ldu1, qd_complex *u2, mplapackint const ldu2, qd_complex *v1t, mplapackint const ldv1t, qd_complex *v2t, mplapackint const ldv2t, qd_real *theta, mplapackint *iwork, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *s, qd_complex *t, qd_complex *q, mplapackint const ldq, qd_complex *z, qd_complex *alpha, qd_complex *beta, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, bool *bwork, mplapackint &info);
void Cdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *s, qd_complex *t, qd_complex *q, mplapackint const ldq, qd_complex *z, qd_complex *alpha, qd_complex *beta, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, bool *bwork, mplapackint &info);
void Cdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *s, qd_complex *t, qd_complex *q, mplapackint const ldq, qd_complex *z, qd_complex *qe, mplapackint const ldqe, qd_complex *alpha, qd_complex *beta, qd_complex *alpha1, qd_complex *beta1, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, mplapackint &info);
void Cdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *s, qd_complex *t, qd_complex *q, mplapackint const ldq, qd_complex *z, qd_complex *qe, mplapackint const ldqe, qd_complex *alpha, qd_complex *beta, qd_complex *alpha1, qd_complex *beta1, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result, mplapackint &info);
void Cdrgsx(mplapackint const nsize, mplapackint const ncmax, qd_real const thresh, mplapackint const nin, mplapackint const nout, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *ai, qd_complex *bi, qd_complex *z, qd_complex *q, qd_complex *alpha, qd_complex *beta, qd_complex *c, mplapackint const ldc, qd_real *s, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Cdrgvx(mplapackint const nsize, qd_real const thresh, mplapackint const nin, mplapackint const nout, qd_complex *a, mplapackint const lda, qd_complex *b, qd_complex *ai, qd_complex *bi, qd_complex *alpha, qd_complex *beta, qd_complex *vl, qd_complex *vr, mplapackint &ilo, mplapackint &ihi, qd_real *lscale, qd_real *rscale, qd_real *s, qd_real *dtru, qd_real *dif, qd_real *diftru, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, bool *bwork, mplapackint &info);
void Cdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, qd_complex *a, mplapackint const lda, qd_complex *u, mplapackint const ldu, qd_complex *vt, mplapackint const ldvt, qd_complex *asav, qd_complex *usav, qd_complex *vtsav, qd_real *s, qd_real *ssav, qd_real *e, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint *iwork, mplapackint const nounit, mplapackint &info);
void Cdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *ht, qd_complex *w, qd_complex *wt, qd_complex *vs, mplapackint const ldvs, qd_real *result, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Cdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *w, qd_complex *w1, qd_complex *vl, mplapackint const ldvl, qd_complex *vr, mplapackint const ldvr, qd_complex *lre, mplapackint const ldlre, qd_real *result, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint *iwork, mplapackint &info);
void Cdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_real *d, qd_complex *z, mplapackint const ldz, qd_complex *ab, qd_complex *bb, qd_complex *ap, qd_complex *bp, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_real *d, qd_real *d2, qd_complex *z, mplapackint const ldz, qd_complex *ab, qd_complex *bb, qd_complex *ap, qd_complex *bp, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_complex *u, mplapackint const ldu, qd_complex *v, qd_complex *tau, qd_complex *z, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_complex *u, mplapackint const ldu, qd_complex *v, qd_complex *tau, qd_complex *z, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint const lrwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Cdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const niunit, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *ht, qd_complex *w, qd_complex *wt, qd_complex *wtmp, qd_complex *vs, mplapackint const ldvs, qd_complex *vs1, qd_real *result, qd_complex *work, mplapackint const lwork, qd_real *rwork, bool *bwork, mplapackint &info);
void Cdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const niunit, mplapackint const nounit, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *w, qd_complex *w1, qd_complex *vl, mplapackint const ldvl, qd_complex *vr, mplapackint const ldvr, qd_complex *lre, mplapackint const ldlre, qd_real *rcondv, qd_real *rcndv1, qd_real *rcdvin, qd_real *rconde, qd_real *rcnde1, qd_real *rcdein, qd_real *scale, qd_real *scale1, qd_real *result, qd_complex *work, mplapackint const nwork, qd_real *rwork, mplapackint &info);
void Cerrbd(const char *path, mplapackint const nunit);
void Cerrec(const char *path, mplapackint const nunit);
void Cerred(const char *path, mplapackint const nunit);
void Cerrgg(const char *path, mplapackint const nunit);
void Cerrhs(const char *path, mplapackint const nunit);
void Cerrst(const char *path, mplapackint const nunit);
void Cget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Cget10(mplapackint const m, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *work, qd_real *rwork, qd_real &result);
void Cget22(const char *transa, const char *transe, const char *transw, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *e, mplapackint const lde, qd_complex *w, qd_complex *work, qd_real *rwork, qd_real *result);
void Cget23(bool const comp, mplapackint const isrt, const char *balanc, mplapackint const jtype, qd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *w, qd_complex *w1, qd_complex *vl, mplapackint const ldvl, qd_complex *vr, mplapackint const ldvr, qd_complex *lre, mplapackint const ldlre, qd_real *rcondv, qd_real *rcndv1, qd_real *rcdvin, qd_real *rconde, qd_real *rcnde1, qd_real *rcdein, qd_real *scale, qd_real *scale1, qd_real *result, qd_complex *work, mplapackint const lwork, qd_real *rwork, mplapackint &info);
void Cget24(bool const comp, mplapackint const jtype, qd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *h, qd_complex *ht, qd_complex *w, qd_complex *wt, qd_complex *wtmp, qd_complex *vs, mplapackint const ldvs, qd_complex *vs1, qd_real const rcdein, qd_real const rcdvin, mplapackint const nslct, mplapackint *islct, mplapackint const isrt, qd_real *result, qd_complex *work, mplapackint const lwork, qd_real *rwork, bool *bwork, mplapackint &info);
void Cget35(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget36(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt, mplapackint const nin);
void Cget37(qd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget38(qd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Cget51(mplapackint const itype, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *u, mplapackint const ldu, qd_complex *v, mplapackint const ldv, qd_complex *work, qd_real *rwork, qd_real &result);
void Cget52(bool const left, mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *e, mplapackint const lde, qd_complex *alpha, qd_complex *beta, qd_complex *work, qd_real *rwork, qd_real *result);
void Cget54(mplapackint const n, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *s, mplapackint const lds, qd_complex *t, mplapackint const ldt, qd_complex *u, mplapackint const ldu, qd_complex *v, mplapackint const ldv, qd_complex *work, qd_real &result);
void Cglmts(mplapackint const n, mplapackint const m, mplapackint const p, qd_complex *a, qd_complex *af, mplapackint const lda, qd_complex *b, qd_complex *bf, mplapackint const ldb, qd_complex *d, qd_complex *df, qd_complex *x, qd_complex *u, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real &result);
void Cgqrts(mplapackint const n, mplapackint const m, mplapackint const p, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *taua, qd_complex *b, qd_complex *bf, qd_complex *z, qd_complex *t, qd_complex *bwk, mplapackint const ldb, qd_complex *taub, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cgrqts(mplapackint const m, mplapackint const p, mplapackint const n, qd_complex *a, qd_complex *af, qd_complex *q, qd_complex *r, mplapackint const lda, qd_complex *taua, qd_complex *b, qd_complex *bf, qd_complex *z, qd_complex *t, qd_complex *bwk, mplapackint const ldb, qd_complex *taub, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Cgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, qd_complex *a, qd_complex *af, mplapackint const lda, qd_complex *b, qd_complex *bf, mplapackint const ldb, qd_complex *u, mplapackint const ldu, qd_complex *v, mplapackint const ldv, qd_complex *q, mplapackint const ldq, qd_real *alpha, qd_real *beta, qd_complex *r, mplapackint const ldr, mplapackint *iwork, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Chbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, qd_complex *a, mplapackint const lda, qd_real *d, qd_real *e, qd_complex *u, mplapackint const ldu, qd_complex *work, qd_real *rwork, qd_real *result);
void Chet21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, qd_complex *a, mplapackint const lda, qd_real *d, qd_real *e, qd_complex *u, mplapackint const ldu, qd_complex *v, mplapackint const ldv, qd_complex *tau, qd_complex *work, qd_real *rwork, qd_real *result);
void Chet22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, qd_complex *a, mplapackint const lda, qd_real *d, qd_real *e, qd_complex *u, mplapackint const ldu, qd_complex *, mplapackint const ldv, qd_complex *, qd_complex *work, qd_real *rwork, qd_real *result);
void Chpt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, qd_complex *ap, qd_real *d, qd_real *e, qd_complex *u, mplapackint const ldu, qd_complex *vp, qd_complex *tau, qd_complex *work, qd_real *rwork, qd_real *result);
void Chst01(mplapackint const n, mplapackint const, mplapackint const, qd_complex *a, mplapackint const lda, qd_complex *h, mplapackint const ldh, qd_complex *q, mplapackint const ldq, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Clacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, qd_real *theta, mplapackint *iseed, qd_complex *x, mplapackint const &ldx, qd_complex *work);
void Clarfy(const char *uplo, mplapackint const n, qd_complex *v, mplapackint const incv, qd_complex const tau, qd_complex *c, mplapackint const ldc, qd_complex *work);
void Clarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const ldx, qd_complex *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Clatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, bool const rsign, qd_real const amagn, qd_real const rcond, qd_real const triang, mplapackint const idist, mplapackint *iseed, qd_complex *a, mplapackint const lda);
void Clsets(mplapackint const m, mplapackint const p, mplapackint const n, qd_complex *a, qd_complex *af, mplapackint const lda, qd_complex *b, qd_complex *bf, mplapackint const ldb, qd_complex *c, qd_complex *cf, qd_complex *d, qd_complex *df, qd_complex *x, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Csbmv(const char *uplo, mplapackint const n, mplapackint const k, qd_complex const alpha, qd_complex *a, mplapackint const lda, qd_complex *x, mplapackint const incx, qd_complex const beta, qd_complex *y, mplapackint const incy);
void Csgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, qd_complex *a, mplapackint const lda, qd_complex *b, mplapackint const ldb, qd_complex *z, mplapackint const ldz, qd_real *d, qd_complex *work, qd_real *rwork, qd_real *result);
void Cstt21(mplapackint const n, mplapackint const kband, qd_real *ad, qd_real *ae, qd_real *sd, qd_real *se, qd_complex *u, mplapackint const ldu, qd_complex *work, qd_real *rwork, qd_real *result);
void Cstt22(mplapackint const n, mplapackint const m, mplapackint const kband, qd_real *ad, qd_real *ae, qd_real *sd, qd_real *se, qd_complex *u, mplapackint const ldu, qd_complex *work, mplapackint const ldwork, qd_real *rwork, qd_real *result);
void Cunt01(const char *rowcol, mplapackint const m, mplapackint const n, qd_complex *u, mplapackint const ldu, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real &resid);
void Cunt03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, qd_complex *u, mplapackint const ldu, qd_complex *v, mplapackint const ldv, qd_complex *work, mplapackint const lwork, qd_real *rwork, qd_real &result, mplapackint &info);
void Mxerbla_qd(const char *srname, int info);
void Rbdt01(mplapackint const m, mplapackint const n, mplapackint const kd, qd_real *a, mplapackint const lda, qd_real *q, mplapackint const ldq, qd_real *d, qd_real *e, qd_real *pt, mplapackint const ldpt, qd_real *work, qd_real &resid);
void Rbdt02(mplapackint const m, mplapackint const n, qd_real *b, mplapackint const ldb, qd_real *c, mplapackint const ldc, qd_real *u, mplapackint const ldu, qd_real *work, qd_real &resid);
void Rbdt03(const char *uplo, mplapackint const n, mplapackint const kd, qd_real *d, qd_real *e, qd_real *u, mplapackint const ldu, qd_real *s, qd_real *vt, mplapackint const ldvt, qd_real *work, qd_real &resid);
void Rbdt04(const char *uplo, mplapackint const n, qd_real *d, qd_real *e, qd_real *s, mplapackint const ns, qd_real *u, mplapackint const ldu, qd_real *vt, mplapackint const ldvt, qd_real *work, qd_real &resid);
void Rbdt05(mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *s, mplapackint const ns, qd_real *u, mplapackint const ldu, qd_real *vt, mplapackint const ldvt, qd_real *work, qd_real &resid);
void Rchkbb(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *ab, mplapackint const ldab, qd_real *bd, qd_real *be, qd_real *q, mplapackint const ldq, qd_real *p, mplapackint const ldp, qd_real *c, mplapackint const ldc, qd_real *cc, qd_real *work, mplapackint const lwork, qd_real *result, mplapackint &info);
void Rchkbd(mplapackint const nsizes, mplapackint *mval, mplapackint *nval, mplapackint const ntypes, bool *dotype, mplapackint const nrhs, mplapackint *iseed, qd_real const thresh, qd_real *a, mplapackint const lda, qd_real *bd, qd_real *be, qd_real *s1, qd_real *s2, qd_real *x, mplapackint const ldx, qd_real *y, qd_real *z, qd_real *q, mplapackint const ldq, qd_real *pt, mplapackint const ldpt, qd_real *u, qd_real *vt, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rchkbk(mplapackint const nin, mplapackint const nout);
void Rchkbl(mplapackint const nin, mplapackint const nout);
void Rchkec(qd_real const thresh, bool const tsterr, mplapackint const nin, mplapackint const nout);
void Rchkgg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, bool const tstdif, qd_real const thrshn, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, qd_real *h, qd_real *t, qd_real *s1, qd_real *s2, qd_real *p1, qd_real *p2, qd_real *u, mplapackint const ldu, qd_real *v, qd_real *q, qd_real *z, qd_real *alphr1, qd_real *alphi1, qd_real *beta1, qd_real *alphr3, qd_real *alphi3, qd_real *beta3, qd_real *evectl, qd_real *evectr, qd_real *work, mplapackint const lwork, bool *llwork, qd_real *result, mplapackint &info);
void Rchkgk(mplapackint const nin, mplapackint const nout);
void Rchkgl(mplapackint const nin, mplapackint const nout);
void Rchkhs(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *h, qd_real *t1, qd_real *t2, qd_real *u, mplapackint const ldu, qd_real *z, qd_real *uz, qd_real *wr1, qd_real *wi1, qd_real *wr2, qd_real *wi2, qd_real *wr3, qd_real *wi3, qd_real *evectl, qd_real *evectr, qd_real *evecty, qd_real *evectx, qd_real *uu, qd_real *tau, qd_real *work, mplapackint const nwork, mplapackint *iwork, bool *select, qd_real *result, mplapackint &info);
void Rchksb(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *sd, qd_real *se, qd_real *u, mplapackint const ldu, qd_real *work, mplapackint const lwork, qd_real *result, mplapackint &info);
void Rchksb2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const nwdths, mplapackint *kk, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *u, mplapackint const ldu, qd_real *work, mplapackint const lwork, qd_real *result, mplapackint &info);
void Rchkst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *ap, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *d5, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *wr, qd_real *u, mplapackint const ldu, qd_real *v, qd_real *vp, qd_real *tau, qd_real *z, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rchkst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *ap, qd_real *sd, qd_real *se, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *d5, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *wr, qd_real *u, mplapackint const ldu, qd_real *v, qd_real *vp, qd_real *tau, qd_real *z, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rckcsd(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *qval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const mmax, qd_real *x, qd_real *xf, qd_real *u1, qd_real *u2, qd_real *v1t, qd_real *v2t, qd_real *theta, mplapackint *iwork, qd_real *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckglm(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *b, qd_real *bf, qd_real *x, qd_real *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgqr(mplapackint const nm, mplapackint *mval, mplapackint const np, mplapackint *pval, mplapackint const nn, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *aq, qd_real *ar, qd_real *taua, qd_real *b, qd_real *bf, qd_real *bz, qd_real *bt, qd_real *bwk, qd_real *taub, qd_real *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rckgsv(mplapackint const nm, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *b, qd_real *bf, qd_real *u, qd_real *v, qd_real *q, qd_real *alpha, qd_real *beta, qd_real *r, mplapackint *iwork, qd_real *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcklse(mplapackint const nn, mplapackint *mval, mplapackint *pval, mplapackint *nval, mplapackint const nmats, mplapackint *iseed, qd_real const thresh, mplapackint const nmax, qd_real *a, qd_real *af, qd_real *b, qd_real *bf, qd_real *x, qd_real *work, qd_real *rwork, mplapackint const nin, mplapackint const nout, mplapackint &info);
void Rcsdts(mplapackint const m, mplapackint const p, mplapackint const q, qd_real *x, qd_real *xf, mplapackint const ldx, qd_real *u1, mplapackint const ldu1, qd_real *u2, mplapackint const ldu2, qd_real *v1t, mplapackint const ldv1t, qd_real *v2t, mplapackint const ldv2t, qd_real *theta, mplapackint *iwork, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rdrges(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, qd_real *s, qd_real *t, qd_real *q, mplapackint const ldq, qd_real *z, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *work, mplapackint const lwork, qd_real *result, bool *bwork, mplapackint &info);
void Rdrges3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, qd_real *s, qd_real *t, qd_real *q, mplapackint const ldq, qd_real *z, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *work, mplapackint const lwork, qd_real *result, bool *bwork, mplapackint &info);
void Rdrgev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, qd_real *s, qd_real *t, qd_real *q, mplapackint const ldq, qd_real *z, qd_real *qe, mplapackint const ldqe, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *alphr1, qd_real *alphi1, qd_real *beta1, qd_real *work, mplapackint const lwork, qd_real *result, mplapackint &info);
void Rdrgev3(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, qd_real *s, qd_real *t, qd_real *q, mplapackint const ldq, qd_real *z, qd_real *qe, mplapackint const ldqe, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *alphr1, qd_real *alphi1, qd_real *beta1, qd_real *work, mplapackint const lwork, qd_real *result, mplapackint &info);
void Rdrgsx(mplapackint const nsize, mplapackint const ncmax, qd_real const thresh, mplapackint const nin, mplapackint const nout, qd_real *a, mplapackint const lda, qd_real *b, qd_real *ai, qd_real *bi, qd_real *z, qd_real *q, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *c, mplapackint const ldc, qd_real *s, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, bool *bwork, mplapackint &info);
void Rdrgvx(mplapackint const nsize, qd_real const thresh, mplapackint const nin, mplapackint const nout, qd_real *a, mplapackint const lda, qd_real *b, qd_real *ai, qd_real *bi, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *vl, qd_real *vr, mplapackint const ilo, mplapackint const ihi, qd_real *lscale, qd_real *rscale, qd_real *s, qd_real *dtru, qd_real *dif, qd_real *diftru, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, bool *bwork, mplapackint &info);
void Rdrvbd(mplapackint const nsizes, mplapackint *mm, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, qd_real *a, mplapackint const lda, qd_real *u, mplapackint const ldu, qd_real *vt, mplapackint const ldvt, qd_real *asav, qd_real *usav, qd_real *vtsav, qd_real *s, qd_real *ssav, qd_real *e, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const nout, mplapackint &info);
void Rdrves(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *h, qd_real *ht, qd_real *wr, qd_real *wi, qd_real *wrt, qd_real *wit, qd_real *vs, mplapackint const ldvs, qd_real *result, qd_real *work, mplapackint const nwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvev(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *h, qd_real *wr, qd_real *wi, qd_real *wr1, qd_real *wi1, qd_real *vl, mplapackint const ldvl, qd_real *vr, mplapackint const ldvr, qd_real *lre, mplapackint const ldlre, qd_real *result, qd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rdrvsg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *d, qd_real *z, mplapackint const ldz, qd_real *ab, qd_real *bb, qd_real *ap, qd_real *bp, qd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rdrvsg2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *d, qd_real *d2, qd_real *z, mplapackint const ldz, qd_real *ab, qd_real *bb, qd_real *ap, qd_real *bp, qd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rdrvst(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *eveigs, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *u, mplapackint const ldu, qd_real *v, qd_real *tau, qd_real *z, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rdrvst2stg(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *d1, qd_real *d2, qd_real *d3, qd_real *d4, qd_real *eveigs, qd_real *wa1, qd_real *wa2, qd_real *wa3, qd_real *u, mplapackint const ldu, qd_real *v, qd_real *tau, qd_real *z, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint const liwork, qd_real *result, mplapackint &info);
void Rdrvsx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const niunit, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *h, qd_real *ht, qd_real *wr, qd_real *wi, qd_real *wrt, qd_real *wit, qd_real *wrtmp, qd_real *witmp, qd_real *vs, mplapackint const ldvs, qd_real *vs1, qd_real *result, qd_real *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rdrvvx(mplapackint const nsizes, mplapackint *nn, mplapackint const ntypes, bool *dotype, mplapackint *iseed, qd_real const thresh, mplapackint const niunit, mplapackint const nounit, qd_real *a, mplapackint const lda, qd_real *h, qd_real *wr, qd_real *wi, qd_real *wr1, qd_real *wi1, qd_real *vl, mplapackint const ldvl, qd_real *vr, mplapackint const ldvr, qd_real *lre, mplapackint const ldlre, qd_real *rcondv, qd_real *rcndv1, qd_real *rcdvin, qd_real *rconde, qd_real *rcnde1, qd_real *rcdein, qd_real *scale, qd_real *scale1, qd_real *result, qd_real *work, mplapackint const nwork, mplapackint *iwork, mplapackint &info);
void Rerrbd(const char *path, mplapackint const nunit);
void Rerrec(const char *path, mplapackint const nunit);
void Rerred(const char *path, mplapackint const nunit);
void Rerrgg(const char *path, mplapackint const nunit);
void Rerrhs(const char *path, mplapackint const nunit);
void Rerrst(const char *path, mplapackint const nunit);
void Rget02(const char *trans, mplapackint const m, mplapackint const n, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, qd_real *rwork, qd_real &resid);
void Rget10(mplapackint const m, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *work, qd_real &result);
void Rget22(const char *transa, const char *transe, const char *transw, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *e, mplapackint const lde, qd_real *wr, qd_real *wi, qd_real *work, qd_real *result);
void Rget23(bool const comp, const char *balanc, mplapackint const jtype, qd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *h, qd_real *wr, qd_real *wi, qd_real *wr1, qd_real *wi1, qd_real *vl, mplapackint const ldvl, qd_real *vr, mplapackint const ldvr, qd_real *lre, mplapackint const ldlre, qd_real *rcondv, qd_real *rcndv1, qd_real *rcdvin, qd_real *rconde, qd_real *rcnde1, qd_real *rcdein, qd_real *scale, qd_real *scale1, qd_real *result, qd_real *work, mplapackint const lwork, mplapackint *iwork, mplapackint &info);
void Rget24(bool const comp, mplapackint const jtype, qd_real const thresh, mplapackint *iseed, mplapackint const nounit, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *h, qd_real *ht, qd_real *wr, qd_real *wi, qd_real *wrt, qd_real *wit, qd_real *wrtmp, qd_real *witmp, qd_real *vs, mplapackint const ldvs, qd_real *vs1, qd_real const rcdein, qd_real const rcdvin, mplapackint const nslct, mplapackint *islct, qd_real *result, qd_real *work, mplapackint const lwork, mplapackint *iwork, bool *bwork, mplapackint &info);
void Rget31(qd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget32(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget33(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget34(qd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt);
void Rget35(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget36(qd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget37(qd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget38(qd_real *rmax, mplapackint *lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget39(qd_real &rmax, mplapackint &lmax, mplapackint &ninfo, mplapackint &knt);
void Rget40(qd_real &rmax, mplapackint &lmax, mplapackint *ninfo, mplapackint &knt, mplapackint const nin);
void Rget51(mplapackint const itype, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *u, mplapackint const ldu, qd_real *v, mplapackint const ldv, qd_real *work, qd_real &result);
void Rget52(bool const left, mplapackint const n, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *e, mplapackint const lde, qd_real *alphar, qd_real *alphai, qd_real *beta, qd_real *work, qd_real *result);
void Rget53(qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real const scale, qd_real const wr, qd_real const wi, qd_real &result, mplapackint &info);
void Rget54(mplapackint const n, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *s, mplapackint const lds, qd_real *t, mplapackint const ldt, qd_real *u, mplapackint const ldu, qd_real *v, mplapackint const ldv, qd_real *work, qd_real &result);
void Rglmts(mplapackint const n, mplapackint const m, mplapackint const p, qd_real *a, qd_real *af, mplapackint const lda, qd_real *b, qd_real *bf, mplapackint const ldb, qd_real *d, qd_real *df, qd_real *x, qd_real *u, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real &result);
void Rgqrts(mplapackint const n, mplapackint const m, mplapackint const p, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *taua, qd_real *b, qd_real *bf, qd_real *z, qd_real *t, qd_real *bwk, mplapackint const ldb, qd_real *taub, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rgrqts(mplapackint const m, mplapackint const p, mplapackint const n, qd_real *a, qd_real *af, qd_real *q, qd_real *r, mplapackint const lda, qd_real *taua, qd_real *b, qd_real *bf, qd_real *z, qd_real *t, qd_real *bwk, mplapackint const ldb, qd_real *taub, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rgsvts3(mplapackint const m, mplapackint const p, mplapackint const n, qd_real *a, qd_real *af, mplapackint const lda, qd_real *b, qd_real *bf, mplapackint const ldb, qd_real *u, mplapackint const ldu, qd_real *v, mplapackint const ldv, qd_real *q, mplapackint const ldq, qd_real *alpha, qd_real *beta, qd_real *r, mplapackint const ldr, mplapackint *iwork, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rhst01(mplapackint const n, mplapackint const, mplapackint const, qd_real *a, mplapackint const lda, qd_real *h, mplapackint const ldh, qd_real *q, mplapackint const ldq, qd_real *work, mplapackint const lwork, qd_real *result);
void Rlacsg(mplapackint const &m, mplapackint const &p, mplapackint const &q, qd_real *theta, mplapackint *iseed, qd_real *x, mplapackint const &ldx, qd_real *work);
void Rlafts(const char *type, mplapackint const m, mplapackint const n, mplapackint const imat, mplapackint const ntests, qd_real *result, mplapackint *iseed, qd_real const thresh, mplapackint const iounit, mplapackint &ie);
void Rlahd2(mplapackint const iounit, const char *path);
void Rlarfy(const char *uplo, mplapackint const n, qd_real *v, mplapackint const incv, qd_real const tau, qd_real *c, mplapackint const ldc, qd_real *work);
void Rlarhs(const char *path, const char *xtype, const char *uplo, const char *trans, mplapackint const m, mplapackint const n, mplapackint const kl, mplapackint const ku, mplapackint const nrhs, qd_real *a, mplapackint const lda, qd_real *x, mplapackint const ldx, qd_real *b, mplapackint const ldb, mplapackint *iseed, mplapackint &info);
void Rlasum(const char *type, mplapackint const iounit, mplapackint const ie, mplapackint const nrun);
void Rlatb9(const char *path, mplapackint const imat, mplapackint const m, mplapackint const p, mplapackint const n, char *type, mplapackint &kla, mplapackint &kua, mplapackint &klb, mplapackint &kub, qd_real &anorm, qd_real &bnorm, mplapackint &modea, mplapackint &modeb, qd_real &cndnma, qd_real &cndnmb, char *dista, char *distb);
void Rlatm4(mplapackint const itype, mplapackint const n, mplapackint const nz1, mplapackint const nz2, mplapackint const isign, qd_real const amagn, qd_real const rcond, qd_real const triang, mplapackint const idist, mplapackint *iseed, qd_real *a, mplapackint const lda);
void Rlsets(mplapackint const m, mplapackint const p, mplapackint const n, qd_real *a, qd_real *af, mplapackint const lda, qd_real *b, qd_real *bf, mplapackint const ldb, qd_real *c, qd_real *cf, qd_real *d, qd_real *df, qd_real *x, qd_real *work, mplapackint const lwork, qd_real *rwork, qd_real *result);
void Rort01(const char *rowcol, mplapackint const m, mplapackint const n, qd_real *u, mplapackint const ldu, qd_real *work, mplapackint const lwork, qd_real &resid);
void Rort03(const char *rc, mplapackint const mu, mplapackint const mv, mplapackint const n, mplapackint const k, qd_real *u, mplapackint const ldu, qd_real *v, mplapackint const ldv, qd_real *work, mplapackint const lwork, qd_real &result, mplapackint &info);
void Rsbt21(const char *uplo, mplapackint const n, mplapackint const ka, mplapackint const ks, qd_real *a, mplapackint const lda, qd_real *d, qd_real *e, qd_real *u, mplapackint const ldu, qd_real *work, qd_real *result);
void Rsgt01(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, qd_real *a, mplapackint const lda, qd_real *b, mplapackint const ldb, qd_real *z, mplapackint const ldz, qd_real *d, qd_real *work, qd_real *result);
void Rspt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, qd_real *ap, qd_real *d, qd_real *e, qd_real *u, mplapackint const ldu, qd_real *vp, qd_real *tau, qd_real *work, qd_real *result);
void Rstech(mplapackint const n, qd_real *a, qd_real *b, qd_real *eig, qd_real const tol, qd_real *work, mplapackint &info);
void Rstect(mplapackint const n, qd_real *a, qd_real *b, qd_real const shift, mplapackint &num);
void Rstt21(mplapackint const n, mplapackint const kband, qd_real *ad, qd_real *ae, qd_real *sd, qd_real *se, qd_real *u, mplapackint const ldu, qd_real *work, qd_real *result);
void Rstt22(mplapackint const n, mplapackint const m, mplapackint const kband, qd_real *ad, qd_real *ae, qd_real *sd, qd_real *se, qd_real *u, mplapackint const ldu, qd_real *work, mplapackint const ldwork, qd_real *result);
void Rsvdch(mplapackint const n, qd_real *s, qd_real *e, qd_real *svd, qd_real const tol, mplapackint &info);
void Rsvdct(mplapackint const n, qd_real *s, qd_real *e, qd_real const shift, mplapackint &num);
void Rsyt21(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const kband, qd_real *a, mplapackint const lda, qd_real *d, qd_real *e, qd_real *u, mplapackint const ldu, qd_real *v, mplapackint const ldv, qd_real *tau, qd_real *work, qd_real *result);
void Rsyt22(mplapackint const itype, const char *uplo, mplapackint const n, mplapackint const m, mplapackint const kband, qd_real *a, mplapackint const lda, qd_real *d, qd_real *e, qd_real *u, mplapackint const ldu, qd_real *, mplapackint const ldv, qd_real *, qd_real *work, qd_real *result);
void chkxer(const char *srnamt, mplapackint const &infot, mplapackint const &nout, bool &lerr, bool &ok);
void xlaenv(mplapackint const &ispec, mplapackint const &nvalue);
#endif
